/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.component;

import com.jstatcom.component.SwingWorker;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JLabel;

public class JHelpAction
extends AbstractAction {
    private static String helpSetName = null;
    private static final ActionEvent cshAction = new ActionEvent(new JLabel(), 1001, null);
    private static HelpBroker helpBroker = null;
    private static WorkerHelpset worker = null;

    private JHelpAction() {
    }

    protected JHelpAction(String string) {
        super(string);
    }

    protected JHelpAction(String string, Icon icon) {
        super(string, icon);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JHelpAction.showHelp();
    }

    public static JHelpAction getFocusInstance(String string) {
        return new JHelpAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                1.showHelpFromFocus();
            }
        };
    }

    public static JHelpAction getFocusInstance(String string, Icon icon) {
        return new JHelpAction(string, icon){

            public void actionPerformed(ActionEvent actionEvent) {
                2.showHelpFromFocus();
            }
        };
    }

    private static HelpBroker getHelpBroker() {
        Object object;
        if (helpSetName == null) {
            throw new IllegalStateException("Name of helpset has not yet been set.");
        }
        if (helpBroker == null && (object = worker.get()) instanceof HelpBroker) {
            helpBroker = (HelpBroker)object;
        }
        if (helpBroker == null) {
            throw new IllegalStateException("helpBroker has not been created.");
        }
        return helpBroker;
    }

    public static JHelpAction getShowHelpInstance(String string) {
        return new JHelpAction(string);
    }

    public static JHelpAction getShowHelpInstance(String string, Icon icon) {
        return new JHelpAction(string, icon);
    }

    public static JHelpAction getShowIDInstance(String string, final String string2) {
        return new JHelpAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                3.showHelp(string2);
            }
        };
    }

    public static JHelpAction getShowIDInstance(String string, Icon icon, final String string2) {
        return new JHelpAction(string, icon){

            public void actionPerformed(ActionEvent actionEvent) {
                4.showHelp(string2);
            }
        };
    }

    public static JHelpAction getTrackInstance(String string) {
        return new JHelpAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                5.trackFieldHelp();
            }
        };
    }

    public static JHelpAction getTrackInstance(String string, Icon icon) {
        return new JHelpAction(string, icon){

            public void actionPerformed(ActionEvent actionEvent) {
                6.trackFieldHelp();
            }
        };
    }

    public static void showHelp() {
        if (helpBroker == null) {
            if (JHelpAction.getHelpBroker() != null) {
                new CSH.DisplayHelpFromSource(helpBroker).actionPerformed(cshAction);
            }
        } else {
            helpBroker.setDisplayed(true);
        }
    }

    public static void showHelp(String string) {
        JHelpAction.showHelp();
        if (string != null) {
            try {
                if (JHelpAction.getHelpBroker() != null) {
                    JHelpAction.getHelpBroker().setCurrentID(Map.ID.create((String)string, (HelpSet)helpBroker.getHelpSet()));
                }
            }
            catch (InvalidHelpSetContextException invalidHelpSetContextException) {
                System.out.println(invalidHelpSetContextException.getMessage());
            }
        }
    }

    public static void showHelpFromFocus() {
        if (JHelpAction.getHelpBroker() != null) {
            new CSH.DisplayHelpFromFocus(helpBroker).actionPerformed(cshAction);
        }
    }

    public static void startHelpWorker(String string) {
        helpSetName = string;
        worker = new WorkerHelpset(helpSetName);
        worker.start();
    }

    public static void trackFieldHelp() {
        if (JHelpAction.getHelpBroker() != null) {
            new CSH.DisplayHelpAfterTracking(helpBroker).actionPerformed(cshAction);
        }
    }

    private static class WorkerHelpset
    extends SwingWorker {
        private static Point loc = new Point(220, 0);
        private static Dimension dimension = new Dimension(700, 600);
        private final String helpSetName;
        private HelpBroker mainHelpBroker = null;

        public WorkerHelpset(String string) {
            this.helpSetName = string;
        }

        private WorkerHelpset() {
            this(null);
        }

        public synchronized Object construct() {
            if (this.mainHelpBroker == null) {
                try {
                    URL uRL = HelpSet.findHelpSet((ClassLoader)this.getClass().getClassLoader(), (String)this.helpSetName);
                    HelpSet helpSet = new HelpSet(null, uRL);
                    if (helpSet != null) {
                        this.mainHelpBroker = helpSet.createHelpBroker();
                    }
                }
                catch (Throwable throwable) {
                    System.out.println("\nHelpSet " + this.helpSetName + " not created.\n" + throwable.getMessage());
                    return null;
                }
                this.mainHelpBroker.setLocation(loc);
                this.mainHelpBroker.setSize(dimension);
            }
            return this.mainHelpBroker;
        }

        public Object get() {
            return this.construct();
        }
    }
}

