/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ui.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ui.AssistanceIconPanel;
import org.fife.rsta.ui.MaxWidthComboBox;
import org.fife.rsta.ui.ResizableFrameContentPane;
import org.fife.rsta.ui.UIUtil;
import org.fife.rsta.ui.search.AbstractFindReplaceDialog;
import org.fife.rsta.ui.search.AbstractSearchDialog;
import org.fife.rsta.ui.search.RegexAwareComboBox;
import org.fife.rsta.ui.search.SearchDialogSearchContext;

public class ReplaceDialog
extends AbstractFindReplaceDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton replaceButton;
    private JButton replaceAllButton;
    private JLabel replaceFieldLabel;
    private MaxWidthComboBox replaceWithCombo;
    private String lastSearchString;
    private String lastReplaceString;

    public ReplaceDialog(Dialog owner, ActionListener listener) {
        super(owner);
        this.init(listener);
    }

    public ReplaceDialog(Frame owner, ActionListener listener) {
        super(owner);
        this.init(listener);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("Replace".equals(command) || "ReplaceAll".equals(command)) {
            String replaceText;
            this.context.setSearchFor(this.getSearchString());
            this.context.setReplaceWith((String)this.replaceWithCombo.getSelectedItem());
            this.findTextCombo.addItem(ReplaceDialog.getTextComponent(this.findTextCombo).getText());
            if (this.findTextCombo.getSelectedIndex() > 0) {
                Object item = this.findTextCombo.getSelectedItem();
                this.findTextCombo.removeItem(item);
                this.findTextCombo.insertItemAt(item, 0);
                this.findTextCombo.setSelectedIndex(0);
            }
            if (!(replaceText = ReplaceDialog.getTextComponent(this.replaceWithCombo).getText()).equals("")) {
                this.replaceWithCombo.addItem(replaceText);
            }
            if (this.replaceWithCombo.getSelectedIndex() > 0) {
                Object item = this.replaceWithCombo.getSelectedItem();
                this.replaceWithCombo.removeItem(item);
                this.replaceWithCombo.insertItemAt(item, 0);
                this.replaceWithCombo.setSelectedIndex(0);
            }
            this.fireActionPerformed(e);
        } else {
            super.actionPerformed(e);
        }
    }

    protected void escapePressed() {
        RegexAwareComboBox racb;
        if (this.replaceWithCombo instanceof RegexAwareComboBox && (racb = (RegexAwareComboBox)this.replaceWithCombo).hideAutoCompletePopups()) {
            return;
        }
        super.escapePressed();
    }

    public final String getReplaceButtonText() {
        return this.replaceButton.getText();
    }

    public final String getReplaceAllButtonText() {
        return this.replaceAllButton.getText();
    }

    public String getReplaceString() {
        String text = (String)this.replaceWithCombo.getSelectedItem();
        if (text == null) {
            text = "";
        }
        return text;
    }

    public final String getReplaceWithLabelText() {
        return this.replaceFieldLabel.getText();
    }

    protected void handleRegExCheckBoxClicked() {
        super.handleRegExCheckBoxClicked();
        boolean b = this.regExpCheckBox.isSelected();
        if (this.replaceWithCombo instanceof RegexAwareComboBox) {
            RegexAwareComboBox racb = (RegexAwareComboBox)this.replaceWithCombo;
            racb.setAutoCompleteEnabled(b);
        }
    }

    protected AbstractSearchDialog.EnableResult handleToggleButtons() {
        AbstractSearchDialog.EnableResult er = super.handleToggleButtons();
        this.replaceButton.setEnabled(er.getEnable());
        this.replaceAllButton.setEnabled(er.getEnable());
        return er;
    }

    private void init(ActionListener listener) {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        JPanel searchPanel = new JPanel(new SpringLayout());
        ReplaceFocusAdapter replaceFocusAdapter = new ReplaceFocusAdapter();
        ReplaceKeyListener replaceKeyListener = new ReplaceKeyListener();
        ReplaceDocumentListener replaceDocumentListener = new ReplaceDocumentListener();
        JTextComponent textField = ReplaceDialog.getTextComponent(this.findTextCombo);
        textField.addFocusListener(replaceFocusAdapter);
        textField.addKeyListener(replaceKeyListener);
        textField.getDocument().addDocumentListener(replaceDocumentListener);
        this.replaceWithCombo = this.createSearchComboBox(true);
        textField = ReplaceDialog.getTextComponent(this.replaceWithCombo);
        textField.addFocusListener(replaceFocusAdapter);
        textField.addKeyListener(replaceKeyListener);
        textField.getDocument().addDocumentListener(replaceDocumentListener);
        this.replaceFieldLabel = UIUtil.newLabel(this.getBundle(), "ReplaceWith", this.replaceWithCombo);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add(this.findTextCombo);
        AssistanceIconPanel aip = new AssistanceIconPanel(this.findTextCombo);
        temp.add((Component)aip, "Before");
        JPanel temp2 = new JPanel(new BorderLayout());
        temp2.add(this.replaceWithCombo);
        AssistanceIconPanel aip2 = new AssistanceIconPanel(this.replaceWithCombo);
        temp2.add((Component)aip2, "Before");
        if (orientation.isLeftToRight()) {
            searchPanel.add(this.findFieldLabel);
            searchPanel.add(temp);
            searchPanel.add(this.replaceFieldLabel);
            searchPanel.add(temp2);
        } else {
            searchPanel.add(temp);
            searchPanel.add(this.findFieldLabel);
            searchPanel.add(temp2);
            searchPanel.add(this.replaceFieldLabel);
        }
        UIUtil.makeSpringCompactGrid(searchPanel, 2, 2, 0, 0, 6, 6);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        temp = new JPanel(new BorderLayout());
        bottomPanel.setBorder(UIUtil.getEmpty5Border());
        temp.add((Component)this.searchConditionsPanel, "Before");
        temp.add(this.dirPanel);
        bottomPanel.add((Component)temp, "Before");
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        leftPanel.add(searchPanel);
        leftPanel.add(bottomPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(4, 1, 5, 5));
        ResourceBundle msg = this.getBundle();
        this.replaceButton = UIUtil.newButton(msg, "Replace");
        this.replaceButton.setActionCommand("Replace");
        this.replaceButton.addActionListener(this);
        this.replaceButton.setEnabled(false);
        this.replaceButton.setIcon(null);
        this.replaceButton.setToolTipText(null);
        this.replaceAllButton = UIUtil.newButton(msg, "ReplaceAll");
        this.replaceAllButton.setActionCommand("ReplaceAll");
        this.replaceAllButton.addActionListener(this);
        this.replaceAllButton.setEnabled(false);
        this.replaceAllButton.setIcon(null);
        this.replaceAllButton.setToolTipText(null);
        buttonPanel.add(this.findNextButton);
        buttonPanel.add(this.replaceButton);
        buttonPanel.add(this.replaceAllButton);
        buttonPanel.add(this.cancelButton);
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add((Component)buttonPanel, "North");
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        contentPane.add(leftPanel);
        contentPane.add((Component)rightPanel, "After");
        temp = new ResizableFrameContentPane(new BorderLayout());
        temp.add((Component)contentPane, "North");
        this.setContentPane(temp);
        this.getRootPane().setDefaultButton(this.findNextButton);
        this.setTitle(ReplaceDialog.getString("ReplaceDialogTitle"));
        this.setResizable(true);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setSearchContext(new SearchDialogSearchContext());
        this.addActionListener(listener);
        this.applyComponentOrientation(orientation);
    }

    public final void setReplaceButtonText(String text) {
        this.replaceButton.setText(text);
    }

    public final void setReplaceAllButtonText(String text) {
        this.replaceAllButton.setText(text);
    }

    public final void setReplaceWithLabelText(String text) {
        this.replaceFieldLabel.setText(text);
    }

    public void setReplaceString(String newReplaceString) {
        this.replaceWithCombo.addItem(newReplaceString);
        this.replaceWithCombo.setSelectedIndex(0);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            String selectedItem;
            if (visible) {
                boolean regexEnabled = this.regExpCheckBox.isSelected();
                if (this.replaceWithCombo instanceof RegexAwareComboBox) {
                    RegexAwareComboBox racb = (RegexAwareComboBox)this.replaceWithCombo;
                    racb.setAutoCompleteEnabled(regexEnabled);
                }
            }
            if ((selectedItem = (String)this.findTextCombo.getSelectedItem()) == null) {
                this.findNextButton.setEnabled(false);
                this.replaceButton.setEnabled(false);
                this.replaceAllButton.setEnabled(false);
            } else {
                this.handleToggleButtons();
            }
            super.setVisible(true);
            JTextComponent textField = ReplaceDialog.getTextComponent(this.findTextCombo);
            textField.requestFocusInWindow();
            textField.selectAll();
        } else {
            super.setVisible(false);
        }
    }

    public void updateUI() {
        ReplaceFocusAdapter replaceFocusAdapter = new ReplaceFocusAdapter();
        ReplaceKeyListener replaceKeyListener = new ReplaceKeyListener();
        ReplaceDocumentListener replaceDocumentListener = new ReplaceDocumentListener();
        JTextComponent textField = ReplaceDialog.getTextComponent(this.findTextCombo);
        textField.addFocusListener(replaceFocusAdapter);
        textField.addKeyListener(replaceKeyListener);
        textField.getDocument().addDocumentListener(replaceDocumentListener);
        textField = ReplaceDialog.getTextComponent(this.replaceWithCombo);
        textField.addFocusListener(replaceFocusAdapter);
        textField.addKeyListener(replaceKeyListener);
        textField.getDocument().addDocumentListener(replaceDocumentListener);
    }

    private class ReplaceKeyListener
    extends KeyAdapter {
        private ReplaceKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10 && AbstractSearchDialog.isPreJava6JRE()) {
                if (e.getSource() == AbstractSearchDialog.getTextComponent(ReplaceDialog.this.findTextCombo)) {
                    String replaceString = (String)ReplaceDialog.this.replaceWithCombo.getSelectedItem();
                    ReplaceDialog.this.lastReplaceString = replaceString;
                    String searchString = (String)ReplaceDialog.this.findTextCombo.getSelectedItem();
                    if (!searchString.equals(ReplaceDialog.this.lastSearchString)) {
                        ReplaceDialog.this.findNextButton.doClick(0);
                        ReplaceDialog.this.lastSearchString = searchString;
                        AbstractSearchDialog.getTextComponent(ReplaceDialog.this.findTextCombo).selectAll();
                    }
                } else {
                    String searchString = (String)ReplaceDialog.this.findTextCombo.getSelectedItem();
                    ReplaceDialog.this.lastSearchString = searchString;
                    String replaceString = (String)ReplaceDialog.this.replaceWithCombo.getSelectedItem();
                    if (!replaceString.equals(ReplaceDialog.this.lastReplaceString)) {
                        ReplaceDialog.this.findNextButton.doClick(0);
                        ReplaceDialog.this.lastReplaceString = replaceString;
                        AbstractSearchDialog.getTextComponent(ReplaceDialog.this.replaceWithCombo).selectAll();
                    }
                }
            }
        }
    }

    private class ReplaceFocusAdapter
    extends FocusAdapter {
        private ReplaceFocusAdapter() {
        }

        public void focusGained(FocusEvent e) {
            JTextComponent textField = (JTextComponent)e.getSource();
            textField.selectAll();
            if (textField == AbstractSearchDialog.getTextComponent(ReplaceDialog.this.findTextCombo)) {
                ReplaceDialog.this.lastSearchString = (String)ReplaceDialog.this.findTextCombo.getSelectedItem();
            } else {
                ReplaceDialog.this.lastReplaceString = (String)ReplaceDialog.this.replaceWithCombo.getSelectedItem();
            }
        }
    }

    private class ReplaceDocumentListener
    implements DocumentListener {
        private ReplaceDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            JTextComponent findWhatTextField = AbstractSearchDialog.getTextComponent(ReplaceDialog.this.findTextCombo);
            if (e.getDocument().equals(findWhatTextField.getDocument())) {
                ReplaceDialog.this.handleToggleButtons();
            }
        }

        public void removeUpdate(DocumentEvent e) {
            JTextComponent findWhatTextField = AbstractSearchDialog.getTextComponent(ReplaceDialog.this.findTextCombo);
            if (e.getDocument().equals(findWhatTextField.getDocument()) && e.getDocument().getLength() == 0) {
                ReplaceDialog.this.findNextButton.setEnabled(false);
                ReplaceDialog.this.replaceButton.setEnabled(false);
                ReplaceDialog.this.replaceAllButton.setEnabled(false);
            } else {
                ReplaceDialog.this.handleToggleButtons();
            }
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }
}

