/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.TokenTypes;

public class Token
implements TokenTypes {
    public char[] text = null;
    public int textOffset = -1;
    public int textCount = -1;
    public int offset = -1;
    public int type = 0;
    private boolean hyperlink = false;
    private Token nextToken = null;
    private int languageIndex;

    public Token() {
    }

    public Token(Segment line, int beg, int end, int startOffset, int type) {
        this(line.array, beg, end, startOffset, type);
    }

    public Token(char[] line, int beg, int end, int startOffset, int type) {
        this();
        this.set(line, beg, end, startOffset, type);
    }

    public Token(Token t2) {
        this();
        this.copyFrom(t2);
    }

    public StringBuffer appendHTMLRepresentation(StringBuffer sb, RSyntaxTextArea textArea, boolean fontFamily) {
        return this.appendHTMLRepresentation(sb, textArea, fontFamily, false);
    }

    public StringBuffer appendHTMLRepresentation(StringBuffer sb, RSyntaxTextArea textArea, boolean fontFamily, boolean tabsToSpaces) {
        SyntaxScheme colorScheme = textArea.getSyntaxScheme();
        Style scheme = colorScheme.getStyle(this.type);
        Font font = textArea.getFontForTokenType(this.type);
        if (font.isBold()) {
            sb.append("<b>");
        }
        if (font.isItalic()) {
            sb.append("<em>");
        }
        if (scheme.underline || this.isHyperlink()) {
            sb.append("<u>");
        }
        sb.append("<font");
        if (fontFamily) {
            sb.append(" face=\"").append(font.getFamily()).append("\"");
        }
        sb.append(" color=\"").append(Token.getHTMLFormatForColor(scheme.foreground)).append("\">");
        this.appendHtmlLexeme(textArea, sb, tabsToSpaces);
        sb.append("</font>");
        if (scheme.underline || this.isHyperlink()) {
            sb.append("</u>");
        }
        if (font.isItalic()) {
            sb.append("</em>");
        }
        if (font.isBold()) {
            sb.append("</b>");
        }
        return sb;
    }

    private final StringBuffer appendHtmlLexeme(RSyntaxTextArea textArea, StringBuffer sb, boolean tabsToSpaces) {
        int i;
        boolean lastWasSpace = false;
        int lastI = i = this.textOffset;
        String tabStr = null;
        while (i < this.textOffset + this.textCount) {
            char ch = this.text[i];
            switch (ch) {
                case ' ': {
                    sb.append(this.text, lastI, i - lastI);
                    lastI = i + 1;
                    sb.append(lastWasSpace ? "&nbsp;" : " ");
                    lastWasSpace = true;
                    break;
                }
                case '\t': {
                    sb.append(this.text, lastI, i - lastI);
                    lastI = i + 1;
                    if (tabsToSpaces && tabStr == null) {
                        tabStr = "";
                        for (int j = 0; j < textArea.getTabSize(); ++j) {
                            tabStr = tabStr + "&nbsp;";
                        }
                    }
                    sb.append(tabsToSpaces ? tabStr : "&#09;");
                    lastWasSpace = false;
                    break;
                }
                case '<': {
                    sb.append(this.text, lastI, i - lastI);
                    lastI = i + 1;
                    sb.append("&lt;");
                    lastWasSpace = false;
                    break;
                }
                case '>': {
                    sb.append(this.text, lastI, i - lastI);
                    lastI = i + 1;
                    sb.append("&gt;");
                    lastWasSpace = false;
                    break;
                }
                default: {
                    lastWasSpace = false;
                }
            }
            ++i;
        }
        if (lastI < this.textOffset + this.textCount) {
            sb.append(this.text, lastI, this.textOffset + this.textCount - lastI);
        }
        return sb;
    }

    public boolean containsPosition(int pos) {
        return pos >= this.offset && pos < this.offset + this.textCount;
    }

    public void copyFrom(Token t2) {
        this.text = t2.text;
        this.textOffset = t2.textOffset;
        this.textCount = t2.textCount;
        this.offset = t2.offset;
        this.type = t2.type;
        this.hyperlink = t2.hyperlink;
        this.languageIndex = t2.languageIndex;
        this.nextToken = t2.nextToken;
    }

    public int documentToToken(int pos) {
        return pos + (this.textOffset - this.offset);
    }

    public boolean endsWith(char[] ch) {
        if (ch == null || ch.length > this.textCount) {
            return false;
        }
        int start = this.textOffset + this.textCount - ch.length;
        for (int i = 0; i < ch.length; ++i) {
            if (this.text[start + i] == ch[i]) continue;
            return false;
        }
        return true;
    }

    private static final String getHTMLFormatForColor(Color color) {
        String hexBlue;
        String hexGreen;
        if (color == null) {
            return "black";
        }
        String hexRed = Integer.toHexString(color.getRed());
        if (hexRed.length() == 1) {
            hexRed = "0" + hexRed;
        }
        if ((hexGreen = Integer.toHexString(color.getGreen())).length() == 1) {
            hexGreen = "0" + hexGreen;
        }
        if ((hexBlue = Integer.toHexString(color.getBlue())).length() == 1) {
            hexBlue = "0" + hexBlue;
        }
        return "#" + hexRed + hexGreen + hexBlue;
    }

    public String getHTMLRepresentation(RSyntaxTextArea textArea) {
        StringBuffer buf = new StringBuffer();
        this.appendHTMLRepresentation(buf, textArea, true);
        return buf.toString();
    }

    public int getLanguageIndex() {
        return this.languageIndex;
    }

    public Token getLastNonCommentNonWhitespaceToken() {
        Token last = null;
        Token t = this;
        while (t != null && t.isPaintable()) {
            switch (t.type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 21: {
                    break;
                }
                default: {
                    last = t;
                }
            }
            t = t.nextToken;
        }
        return last;
    }

    public Token getLastPaintableToken() {
        Token t = this;
        while (t.isPaintable()) {
            if (t.nextToken == null || !t.nextToken.isPaintable()) {
                return t;
            }
            t = t.nextToken;
        }
        return null;
    }

    public String getLexeme() {
        return new String(this.text, this.textOffset, this.textCount);
    }

    public int getListOffset(RSyntaxTextArea textArea, TabExpander e, float x0, float x) {
        if (x0 >= x) {
            return this.offset;
        }
        float currX = x0;
        float nextX = x0;
        float stableX = x0;
        int last = this.offset;
        FontMetrics fm = null;
        for (Token token = this; token != null && token.isPaintable(); token = token.getNextToken()) {
            fm = textArea.getFontMetricsForTokenType(token.type);
            char[] text = token.text;
            int start = token.textOffset;
            int end = start + token.textCount;
            for (int i = start; i < end; ++i) {
                currX = nextX;
                if (text[i] == '\t') {
                    stableX = nextX = e.nextTabStop(nextX, 0);
                    start = i + 1;
                } else {
                    nextX = stableX + (float)fm.charsWidth(text, start, i - start + 1);
                }
                if (!(x >= currX) || !(x < nextX)) continue;
                if (x - currX < nextX - x) {
                    return last + i - token.textOffset;
                }
                return last + i + 1 - token.textOffset;
            }
            stableX = nextX;
            last += token.textCount;
        }
        return last;
    }

    public Token getNextToken() {
        return this.nextToken;
    }

    public int getOffsetBeforeX(RSyntaxTextArea textArea, TabExpander e, float startX, float endBeforeX) {
        int i;
        FontMetrics fm = textArea.getFontMetricsForTokenType(this.type);
        int stop = i + this.textCount;
        float x = startX;
        for (i = this.textOffset; i < stop; ++i) {
            x = this.text[i] == '\t' ? e.nextTabStop(x, 0) : (x += (float)fm.charWidth(this.text[i]));
            if (!(x > endBeforeX)) continue;
            int intoToken = Math.max(i - this.textOffset, 1);
            return this.offset + intoToken;
        }
        return this.offset + this.textCount - 1;
    }

    public float getWidth(RSyntaxTextArea textArea, TabExpander e, float x0) {
        return this.getWidthUpTo(this.textCount, textArea, e, x0);
    }

    public float getWidthUpTo(int numChars, RSyntaxTextArea textArea, TabExpander e, float x0) {
        float width = x0;
        FontMetrics fm = textArea.getFontMetricsForTokenType(this.type);
        if (fm != null) {
            int w;
            int currentStart = this.textOffset;
            int endBefore = this.textOffset + numChars;
            for (int i = currentStart; i < endBefore; ++i) {
                if (this.text[i] != '\t') continue;
                w = i - currentStart;
                if (w > 0) {
                    width += (float)fm.charsWidth(this.text, currentStart, w);
                }
                currentStart = i + 1;
                width = e.nextTabStop(width, 0);
            }
            w = endBefore - currentStart;
            width += (float)fm.charsWidth(this.text, currentStart, w);
        }
        return width - x0;
    }

    public boolean is(char[] lexeme) {
        if (this.textCount == lexeme.length) {
            for (int i = 0; i < this.textCount; ++i) {
                if (this.text[this.textOffset + i] == lexeme[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean is(int type, char[] lexeme) {
        if (this.type == type && this.textCount == lexeme.length) {
            for (int i = 0; i < this.textCount; ++i) {
                if (this.text[this.textOffset + i] == lexeme[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean is(int type, String lexeme) {
        return this.type == type && this.textCount == lexeme.length() && lexeme.equals(this.getLexeme());
    }

    public boolean isComment() {
        return this.type >= 1 && this.type <= 5;
    }

    public boolean isCommentOrWhitespace() {
        return this.isComment() || this.isWhitespace();
    }

    public boolean isHyperlink() {
        return this.hyperlink;
    }

    public boolean isIdentifier() {
        return this.type == 20;
    }

    public boolean isLeftCurly() {
        return this.type == 22 && this.isSingleChar('{');
    }

    public boolean isRightCurly() {
        return this.type == 22 && this.isSingleChar('}');
    }

    public boolean isPaintable() {
        return this.type > 0;
    }

    public boolean isSingleChar(char ch) {
        return this.textCount == 1 && this.text[this.textOffset] == ch;
    }

    public boolean isSingleChar(int type, char ch) {
        return this.type == type && this.isSingleChar(ch);
    }

    public boolean isWhitespace() {
        return this.type == 21;
    }

    public Rectangle listOffsetToView(RSyntaxTextArea textArea, TabExpander e, int pos, int x0, Rectangle rect) {
        int stableX = x0;
        FontMetrics fm = null;
        Segment s = new Segment();
        for (Token token = this; token != null && token.isPaintable(); token = token.getNextToken()) {
            fm = textArea.getFontMetricsForTokenType(token.type);
            if (fm == null) {
                return rect;
            }
            char[] text = token.text;
            int start = token.textOffset;
            int end = start + token.textCount;
            if (token.containsPosition(pos)) {
                s.array = token.text;
                s.offset = token.textOffset;
                s.count = pos - token.offset;
                int w = Utilities.getTabbedTextWidth(s, fm, stableX, e, token.offset);
                rect.x = stableX + w;
                end = token.documentToToken(pos);
                rect.width = text[end] == '\t' ? fm.charWidth(' ') : fm.charWidth(text[end]);
                return rect;
            }
            s.array = token.text;
            s.offset = token.textOffset;
            s.count = token.textCount;
            stableX += Utilities.getTabbedTextWidth(s, fm, stableX, e, token.offset);
        }
        rect.x = stableX;
        rect.width = 1;
        return rect;
    }

    public void makeStartAt(int pos) {
        if (pos < this.offset || pos >= this.offset + this.textCount) {
            throw new IllegalArgumentException("pos " + pos + " is not in range " + this.offset + "-" + (this.offset + this.textCount - 1));
        }
        int shift = pos - this.offset;
        this.offset = pos;
        this.textOffset += shift;
        this.textCount -= shift;
    }

    public void moveOffset(int amt) {
        if (amt < 0 || amt > this.textCount) {
            throw new IllegalArgumentException("amt " + amt + " is not in range 0-" + this.textCount);
        }
        this.offset += amt;
        this.textOffset += amt;
        this.textCount -= amt;
    }

    public void set(char[] line, int beg, int end, int offset, int type) {
        this.text = line;
        this.textOffset = beg;
        this.textCount = end - beg + 1;
        this.type = type;
        this.offset = offset;
        this.nextToken = null;
    }

    public void setHyperlink(boolean hyperlink) {
        this.hyperlink = hyperlink;
    }

    public void setLanguageIndex(int languageIndex) {
        this.languageIndex = languageIndex;
    }

    public void setNextToken(Token nextToken) {
        this.nextToken = nextToken;
    }

    public boolean startsWith(char[] chars) {
        if (chars.length <= this.textCount) {
            for (int i = 0; i < chars.length; ++i) {
                if (this.text[this.textOffset + i] == chars[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int tokenToDocument(int pos) {
        return pos + (this.offset - this.textOffset);
    }

    public String toString() {
        return "[Token: " + (this.type == 0 ? "<null token>" : "text: '" + (this.text == null ? "<null>" : this.getLexeme() + "'; " + "offset: " + this.offset + "; type: " + this.type + "; " + "isPaintable: " + this.isPaintable() + "; nextToken==null: " + (this.nextToken == null))) + "]";
    }
}

