/*
 * Decompiled with CFR 0.152.
 */
package Game.Habitaciones;

import Game.CargadorImagenes;
import Universo.Mundo;
import auxiliares.Func;
import estancia.Estancia;
import parser.Comando;
import parser.Orden;
import propiedades.Accion;

public class BusES
extends Estancia {
    public BusES(String nombre) {
        super(nombre);
    }

    @Override
    public void init() {
    }

    @Override
    public void descripciones() {
        String s1 = "\n{color%red% << BUS ENTRADA/SALIDA >>}\n";
        String s = "En el Bus de E/S hay un flujo continuo de electrones a causa de la electricidad est\u00e1tica que entran por los puertos de entrada y salida. En el bus de entrada y salida est\u00e1n los puertos:\n - {color%resaltado%RS232}; direcci\u00f3n 1.\n - {color%resaltado%RS485}; direcci\u00f3n 2.\n - {color%resaltado%USB}; direcci\u00f3n 4\n\nDesde este bus solo hay acceso al {color%resaltado%controlador de entrada y salida}.";
        this.setDescripcion(String.valueOf(s1) + s);
        this.imagen(CargadorImagenes.nombreImagen());
        BusES.playAudio("cambio room.wav");
    }

    @Override
    public void salidas() {
        this.nuevaSalida("controlador", Mundo.habitacion("controladorES"));
        this.nuevaSalida("bus", Mundo.habitacion("bus ES"));
    }

    @Override
    public boolean antesDeSalir() {
        if (Estancia.getHabitacionSiguiente().equals(Estancia.getHabitacionActual())) {
            Mundo.writeln("Es donde est\u00e1s ahora.");
            return false;
        }
        return super.antesDeSalir();
    }

    @Override
    public void entrar() {
        super.entrar();
    }

    @Override
    public Accion parseCommand(Orden orden) {
        String puerto = "puerto puertos";
        if (orden.getComando() == Comando.LOOK && Func.textosExactos(orden.cDirecto(), puerto)) {
            Mundo.writeln(this.getDescripcion());
            return this.end();
        }
        if ((orden.verbo().equals("abrir") || orden.verbo().equals("cerrar")) && Func.textosExactos(orden.cDirecto(), puerto)) {
            Mundo.writeln("Los puertos de E/S se abren desde el controlador de entrada y salida.");
            return Accion.END;
        }
        return super.parseCommand(orden);
    }
}

