/*
 * Decompiled with CFR 0.152.
 */
package Game.Habitaciones;

import Game.CargadorImagenes;
import Universo.Mundo;
import auxiliares.Func;
import estancia.Estancia;
import parser.Comando;
import parser.Orden;
import propiedades.Accion;

public class MapaMem
extends Estancia {
    public MapaMem(String nombre) {
        super(nombre);
    }

    @Override
    public void init() {
    }

    @Override
    public void descripciones() {
        String s1 = "\n{color%red% << ZONA MAPA DE MEMORIA >>}\n\n";
        String s = "Aqu\u00ed esta todo el {color%resaltado%direccionamiento de la RAM} que est\u00e1 actualmente en uso. Es imprescindible conocer el mapa de memoria para poder moverte por la RAM. Si corrompes datos de la zona de memoria donde est\u00e1 alojado el programa actual en ejecuci\u00f3n, el antivirus {color%red%BadBear} te aniquilar\u00eda.\nSi modificas la zona de datos de la RAM y estos datos son los que est\u00e1 usando el programa actual en ejecuci\u00f3n, provocar\u00edas bugs continuos en el programa, {color%red%KillBug} en ese caso acabar\u00eda contigo.\nLa \u00fanica zona de memoria RAM que puedes modificar sin ser detectado por {color%red%BadBear} o {color%red%KillBug}, es la zona de memoria que est\u00e1 libre y s\u00f3lo si es a trav\u00e9s de tu equipo CDL.";
        this.setDescripcion(String.valueOf(s1) + s);
        this.imagen(CargadorImagenes.nombreImagen());
        MapaMem.playAudio("cambio room.wav");
    }

    @Override
    public void salidas() {
        this.nuevaSalida("cpu", Mundo.habitacion("cpu"));
        this.nuevaSalida("microprocesador", Mundo.habitacion("cpu"));
        this.nuevaSalida("micro", Mundo.habitacion("cpu"));
        this.nuevaSalida("mapa", Mundo.habitacion("mapa de memoria"));
        this.nuevaSalida("zona", Mundo.habitacion("mapa de memoria"));
        this.nuevaSalida("memoria", Mundo.habitacion("mapa de memoria"));
    }

    @Override
    public void entrar() {
        super.entrar();
    }

    @Override
    public boolean antesDeSalir() {
        if (Estancia.getHabitacionSiguiente().equals(Estancia.getHabitacionActual())) {
            Mundo.writeln("Es donde est\u00e1s ahora.");
            return false;
        }
        return super.antesDeSalir();
    }

    @Override
    public Accion parseCommand(Orden orden) {
        String bus = "bus";
        String cpu = "cpu microprocesador microcontrolador";
        String memo = "zona mapa memoria mem ram direccionamiento direccion direcciones";
        String badbear = "badbear killbug bug antivirus antiviru bugs";
        if (orden.getComando() == Comando.LOOK) {
            if (Func.textosExactos(orden.cDirecto(), bus)) {
                Mundo.writeln("Por el bus de datos circulan datos que van y vienen entre la cpu y la memoria. Tambi\u00e9n los datos que son enviados a los dispositivos de entrada/salidas previo paso por el bus de entrada y salida. Por el bus de direcciones las direcciones que van a ser consultadas por la cpu.");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), cpu)) {
                Mundo.writeln("El cerebro de esta m\u00e1quina...");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), memo)) {
                Mundo.writeln("Aqu\u00ed puedes saber como est\u00e1 se distribuye la memoria actualmente en uso de la cpu.");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), badbear)) {
                Mundo.writeln("BadBear es el antivirus instalado en el sistema. Ante cualquier comportamiento sospechoso en la zona de memoria donde est\u00e1 el programa en ejecuci\u00f3n, actuar\u00eda y te aniquilar\u00eda.\nKillBug te atacar\u00eda si te mueves por la zona de memoria de datos. Tu presencia provocar\u00eda una distorsi\u00f3n en los datos, por lo que la ejecuci\u00f3n del programa ser\u00eda an\u00f3mala.");
                return this.end();
            }
            return super.parseCommand(orden);
        }
        return super.parseCommand(orden);
    }
}

