/*
 * Decompiled with CFR 0.152.
 */
package Game.Habitaciones;

import Game.CargadorImagenes;
import Game.Memoria;
import Game.Player;
import Universo.Mundo;
import auxiliares.Func;
import estancia.Estancia;
import java.awt.Color;
import parser.Comando;
import parser.Orden;
import propiedades.Accion;

public class Ram
extends Estancia {
    public Ram(String nombre) {
        super(nombre);
    }

    @Override
    public void init() {
        this.set("direccion actual", "");
        this.set("dato", 0);
        this.set("datoH", "");
        this.set("movimientos", 1);
        this.set("visitado", false);
    }

    @Override
    public void descripciones() {
        String contenido = Memoria.memoria.get(Memoria.hex2decimal(this.getPropiedadString("direccion actual")));
        String s = "\n{color%red% >> MEMORIA RAM <<}\n";
        String s2 = "Para moverte por la memoria ram: {color%resaltado%ir XXX} (XXX direcci\u00f3n v\u00e1lida).\nPara salir de la ram, el \u00fanico camino es el {color%resaltado%bus de datos}.";
        String s1 = "\nMemoria RAM, direcci\u00f3n actual: " + this.getPropiedadString("direccion actual");
        s1 = String.valueOf(s1) + "\nContenido: " + contenido;
        String s3 = "\nAqu\u00ed hay una copia del c\u00f3digo m\u00e1quina de Digitaly.";
        if (!this.getPropiedadBoolean("visitado")) {
            s = String.valueOf(s) + s2 + s1;
            this.set("visitado", true);
        } else {
            s = String.valueOf(s) + s1;
        }
        if (contenido.equals("F4D3")) {
            s = String.valueOf(s) + s3;
        }
        this.setDescripcion(s);
        this.imagen(CargadorImagenes.nombreImagen());
        Ram.playAudio("cambio room.wav");
    }

    @Override
    public void salidas() {
        this.nuevaSalida("bus", Mundo.habitacion("bus de datos"));
    }

    @Override
    public boolean antesDeSalir() {
        if (Estancia.getHabitacionSiguiente().equals(Estancia.getHabitacionActual())) {
            Mundo.writeln("Es donde est\u00e1s ahora.");
            return false;
        }
        return super.antesDeSalir();
    }

    @Override
    public void post_descripcion() {
    }

    @Override
    public Accion parseCommand(Orden orden) {
        String memoria = "memoria ram direccion dato instruccion instruciones datos direcciones";
        int dir_valida = -1;
        int dat_valido = -1;
        String dir = null;
        String dat = null;
        if ((orden.verbo().equals("ir") || orden.verbo().equals("cargar")) && orden.cDyArgs().length() == 0) {
            Mundo.writelnColor("Direcci\u00f3n incorrecta.", Color.red);
            return Accion.NEXT;
        }
        if (orden.verbo().equals("ir") && !orden.cDyArgs().contains("bus")) {
            if (orden.cDirecto().length() > 0 && Memoria.comprobarDireccion(orden.cDirecto())) {
                dir_valida = Memoria.hex2decimal(orden.cDirecto());
                dir = orden.cDirecto();
            } else if (orden.args().length() > 0 && Memoria.comprobarDireccion(orden.args())) {
                dir_valida = Memoria.hex2decimal(orden.args());
                dir = orden.args();
            }
            if (dir_valida == -1) {
                Mundo.writelnColor("Direcci\u00f3n incorrecta.", Color.red);
                return Accion.NEXT;
            }
            this.set("direccion actual", dir.trim().toUpperCase());
            this.mostrarEstancia();
            return Accion.END;
        }
        if (orden.verbo().equals("cargar")) {
            if (orden.cDirecto().length() > 0 && Memoria.comprobarDato(orden.cDirecto())) {
                dat_valido = Memoria.hex2decimal(orden.cDirecto());
                dat = orden.cDirecto();
            } else if (orden.args().length() > 0 && Memoria.comprobarDato(orden.args())) {
                dat_valido = Memoria.hex2decimal(orden.args());
                dat = orden.args();
            }
            if (dat_valido == -1) {
                Mundo.writelnColor("Dato incorrecto. Tama\u00f1o palabra de memoria 2 bytes.", Color.red);
                return Accion.END;
            }
            Mundo.writeln("Cargando dato en memoria.");
            String aux = this.getPropiedadString("direccion actual");
            if (Memoria.memoriaDatos(aux) || Memoria.memoriaLibre(aux)) {
                ((Player)Mundo.getJugador()).escenaFinal(false, 2);
            }
            if (Memoria.memoriaPrograma(aux)) {
                ((Player)Mundo.getJugador()).escenaFinal(false, 3);
            }
            return Accion.END;
        }
        if (orden.getComando() == Comando.LOOK && Func.textosExactos(orden.cDirecto(), memoria)) {
            Mundo.writeln(this.getDescripcion());
            return this.end();
        }
        return super.parseCommand(orden);
    }

    public int getDato(String direccion) {
        String dato = Memoria.memoria.get(Memoria.hex2decimal(direccion));
        return Memoria.hex2decimal(dato);
    }

    public String getDatoHex(String direccion) {
        return Memoria.memoria.get(Memoria.hex2decimal(direccion));
    }

    public int setDato(int pos, String dato) {
        int resultado = 0;
        String dir_hex = this.getPropiedadString("direccion actual");
        if (this.getDatoHex(dir_hex).equals("F4D3")) {
            Mundo.writeln("Se ha modificado la direcci\u00f3n de memoria donde se encontraba una copia de Digitaly...");
        }
        if (!Memoria.memoriaLibre(pos) && Memoria.hex2decimal(dato) >= 0) {
            if (Memoria.memoriaDatos(pos)) {
                resultado = 1;
            } else if (Memoria.memoriaPrograma(pos)) {
                resultado = 2;
            }
        }
        if (Memoria.hex2decimal(dato) >= 0) {
            Memoria.memoria.set(pos, dato.toUpperCase());
        }
        return resultado;
    }

    public int setDato(String dato) {
        int resultado = 0;
        String dir_hex = this.getPropiedadString("direccion actual");
        int dir_dec = Memoria.hex2decimal(dir_hex);
        int i = 0;
        while (i < dato.length()) {
            String aux = dato.substring(i, i + 4);
            if (this.getDatoHex(dir_hex).equals("F4D3")) {
                Mundo.writeln("Se ha modificado la direcci\u00f3n de memoria donde se encontraba una copia de Digitaly...");
            }
            if (!Memoria.memoriaLibre(dir_dec) && Memoria.hex2decimal(aux) >= 0) {
                if (Memoria.memoriaDatos(dir_dec)) {
                    resultado = 1;
                } else if (Memoria.memoriaPrograma(dir_dec)) {
                    resultado = 2;
                }
            }
            if (Memoria.hex2decimal(aux) >= 0) {
                Memoria.memoria.set(dir_dec, aux.toUpperCase());
            }
            ++dir_dec;
            i += 4;
        }
        return resultado;
    }
}

