/*
 * Decompiled with CFR 0.152.
 */
package Game.Habitaciones;

import Game.CargadorImagenes;
import Game.Memoria;
import Universo.Mundo;
import auxiliares.Func;
import estancia.Estancia;
import java.awt.Color;
import parser.Comando;
import parser.Orden;
import propiedades.Accion;

public class ServicioInterrupcion
extends Estancia {
    public ServicioInterrupcion(String nombre) {
        super(nombre);
    }

    @Override
    public void init() {
    }

    @Override
    public void descripciones() {
        String s1 = "\n{color%red% << SALA SERVICIO DE INTERRUPCIONES >>}\n\n";
        String s = "Esta sala es consultada por la cpu tras cada ciclo de instrucci\u00f3n, si se encuentra activo el {color%resaltado%bit del servicio de interrupci\u00f3n} y una direcci\u00f3n cargada en la {color%resaltado%zona de direccionamiento},  la cpu ejecutar\u00e1 el programa del servicio de interrupciones con origen en la direcci\u00f3n de memoria que indica la zona de direccionamiento.\nIMPORTANTE: El programa de interrupci\u00f3n se ejecutar\u00e1 despu\u00e9s de ejecutarse la instrucci\u00f3n que se encuentra en el registro IN.";
        String s2 = String.valueOf(Mundo.entidad("bitInterrupcion").getDescripcion()) + ".";
        s2 = String.valueOf(s2) + "\n" + Mundo.entidad("direccionInterrupcion").getDescripcion() + ".";
        this.setDescripcion(String.valueOf(s1) + s + "\n" + s2);
        this.imagen(CargadorImagenes.nombreImagen());
        ServicioInterrupcion.playAudio("cambio room.wav");
    }

    @Override
    public void salidas() {
        this.nuevaSalida("cpu", Mundo.habitacion("cpu"));
        this.nuevaSalida("microprocesador", Mundo.habitacion("cpu"));
        this.nuevaSalida("micro", Mundo.habitacion("cpu"));
        this.nuevaSalida("interrupcion", Mundo.habitacion("interrupciones"));
        this.nuevaSalida("interrupciones", Mundo.habitacion("interrupciones"));
        this.nuevaSalida("servicio", Mundo.habitacion("interrupciones"));
    }

    @Override
    public void entrar() {
        super.entrar();
    }

    @Override
    public boolean antesDeSalir() {
        if (Estancia.getHabitacionSiguiente().equals(Estancia.getHabitacionActual())) {
            Mundo.writeln("Es donde est\u00e1s ahora.");
            return false;
        }
        return super.antesDeSalir();
    }

    @Override
    public Accion parseCommand(Orden orden) {
        String bus = "bus";
        String cpu = "cpu microprocesador microcontrolador";
        String interrup = "sala interrupciones interrupcion servicio";
        if (orden.getComando() == Comando.LOOK) {
            if (Func.textosExactos(orden.cDirecto(), bus)) {
                Mundo.writeln("Por el bus de datos circulan datos que van y vienen entre la cpu y la memoria. Tambi\u00e9n los datos que son enviados a los dispositivos de entrada/salidas previo paso por el bus de entrada y salida. Por el bus de direcciones las direcciones que van a ser consultadas por la cpu.");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), cpu)) {
                Mundo.writeln("El cerebro de esta m\u00e1quina...");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), interrup)) {
                Mundo.writeln("Es donde est\u00e1s ahora, puede 'mirar'");
                return this.end();
            }
            return super.parseCommand(orden);
        }
        int dir_valida = -1;
        String dir = null;
        if (orden.verbo().equals("cargar")) {
            if (orden.cDirecto().length() > 0 && Memoria.comprobarDireccion(orden.cDirecto())) {
                dir_valida = Memoria.hex2decimal(orden.cDirecto());
                dir = orden.cDirecto();
            } else if (orden.args().length() > 0 && Memoria.comprobarDireccion(orden.args())) {
                dir_valida = Memoria.hex2decimal(orden.args());
                dir = orden.args();
            }
            if (dir_valida == -1) {
                Mundo.writelnColor("Direcci\u00f3n incorrecta.", Color.red);
                return Accion.END;
            }
            Mundo.writeln("Direcci\u00f3n cargada en servicio de interrupci\u00f3n.");
            Mundo.entidad("direccionInterrupcion").set("direccion", dir);
            return Accion.END;
        }
        return super.parseCommand(orden);
    }
}

