/*
 * Decompiled with CFR 0.152.
 */
package Game.Habitaciones;

import Game.CargadorImagenes;
import Universo.Mundo;
import auxiliares.Func;
import estancia.Estancia;
import parser.Comando;
import parser.Orden;
import propiedades.Accion;

public class VectorMemoria1
extends Estancia {
    public VectorMemoria1(String nombre) {
        super(nombre);
    }

    @Override
    public void init() {
    }

    @Override
    public void descripciones() {
        String s = "\n{color%red% >> VECTOR DE MEMORIA DE DATOS <<}\n";
        String s1 = "\nLa entrada a la {color%resaltado%RAM} est\u00e1 protegida por el vector de memoria. Este acceso a la RAM es s\u00f3lo de entrada y salida de datos. No eres un dato. Los datos van y vienen desde el registro acumulador de la CPU a una posici\u00f3n de memoria y viceversa.";
        this.setDescripcion(String.valueOf(s) + s1);
        this.imagen(CargadorImagenes.nombreImagen());
        VectorMemoria1.playAudio("cambio room.wav");
    }

    @Override
    public void salidas() {
        this.nuevaSalida("bus", Mundo.habitacion("bus de datos"));
        this.nuevaSalida("vector", Mundo.habitacion("vectorMemoria1"));
    }

    @Override
    public boolean antesDeSalir() {
        if (Estancia.getHabitacionSiguiente().equals(Estancia.getHabitacionActual())) {
            Mundo.writeln("Es donde est\u00e1s ahora.");
            return false;
        }
        return super.antesDeSalir();
    }

    @Override
    public void entrar() {
        super.entrar();
    }

    @Override
    public Accion parseCommand(Orden orden) {
        String mem = "memoria ram";
        String bus = "bus";
        String cpu = "cpu microprocesador microcontrolador micro";
        String vector = "vector";
        String datos = "datos dato";
        if (orden.verbo().equals("ir") && Func.textosExactos(orden.cDirecto(), mem)) {
            Mundo.writeln("No puedes entrar en la ram por el bus de datos. No eres un dato. Los datos van y vienen desde el registro acumulador de la CPU a una posici\u00f3n de memoria y viceversa.");
            return this.end();
        }
        if (orden.getComando() == Comando.LOOK) {
            if (Func.textosExactos(orden.cDirecto(), bus)) {
                Mundo.writeln("Por el bus de datos circulan datos que van y vienen entre la cpu y la memoria. Tambi\u00e9n los datos que son enviados a los dispositivos de entrada/salidas previo paso por el bus de entrada y salida.");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), cpu)) {
                Mundo.writeln("El cerebro de esta m\u00e1quina...");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), mem)) {
                Mundo.writeln("En la memoria Ram se encuentra el programa que est\u00e1 en ejecuci\u00f3n, as\u00ed como los datos que est\u00e1 usando el programa. La ram se comunica con el bus de datos a trav\u00e9s del vector de salida de la ram.");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), vector)) {
                Mundo.writeln("Es donde est\u00e1s ahora.");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), datos)) {
                Mundo.writeln("Electrones que fluyen por el bus de datos.");
                return this.end();
            }
            return super.parseCommand(orden);
        }
        return super.parseCommand(orden);
    }
}

