/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.CargadorImagenes;
import Game.Habitaciones.BusDatos;
import Game.Habitaciones.BusDireccion;
import Game.Habitaciones.BusES;
import Game.Habitaciones.ControladorES;
import Game.Habitaciones.Cpu;
import Game.Habitaciones.Limbo;
import Game.Habitaciones.MapaMem;
import Game.Habitaciones.Ram;
import Game.Habitaciones.ServicioInterrupcion;
import Game.Habitaciones.VectorMemoria1;
import Game.Habitaciones.VectorMemoria2;
import Game.Memoria;
import Game.Objetos.Ac;
import Game.Objetos.Bit1;
import Game.Objetos.Bit2;
import Game.Objetos.Bit3;
import Game.Objetos.BitInterrupcion;
import Game.Objetos.Cdl;
import Game.Objetos.Digitaly;
import Game.Objetos.DireccionInterrupcion;
import Game.Objetos.In;
import Game.Objetos.MapaMemoria;
import Game.Objetos.Pc;
import Game.Objetos.PuertaTriEstado;
import Game.Objetos.Rs232;
import Game.Objetos.Rs485;
import Game.Objetos.Usb;
import Game.Player;
import Universo.Mundo;
import Universo.Universo;
import auxiliares.Func;
import auxiliares.SaveAndLoad;
import estancia.Estancia;
import interfazConJuego.LoadLog;
import interfazConJuego.TheGame;
import interfazConJuego.WorldCreated;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.IOException;
import parser.Comando;
import parser.Orden;
import parser.Palabra;
import propiedades.Accion;

public class MyGame
implements WorldCreated,
LoadLog {
    TheGame newGame = new TheGame(this, false);
    public static final String versionGame = " --300520161955 -- ";

    @Override
    public void createRooms() {
        Memoria.crearMemoria();
        if (!SaveAndLoad.onLoad()) {
            Memoria.rellenarMemoria();
            Memoria.crearMemoriaLibre();
            Memoria.buscarPC();
            Memoria.crearIn();
        }
        new BusDatos("bus de datos");
        new VectorMemoria1("vectorMemoria1");
        new VectorMemoria2("vectorMemoria2");
        new BusES("bus ES");
        new Cpu("cpu");
        new BusDireccion("bus de direcciones");
        new ServicioInterrupcion("interrupciones");
        new MapaMem("mapa de memoria");
        new Ram("ram");
        new Limbo("limbo");
        new ControladorES("controladorES");
    }

    @Override
    public void createPlayer() {
        new Player("El h\u00e9roe");
    }

    @Override
    public void createItems() {
        new Cdl("cdl");
        new PuertaTriEstado("puerta");
        new Pc("pc");
        new In("ir");
        new Ac("ac");
        new Digitaly("digitaly");
        new BitInterrupcion("bitInterrupcion");
        new DireccionInterrupcion("direccionInterrupcion");
        new MapaMemoria("mapa memoria");
        new Rs232("rs232");
        new Rs485("rs485");
        new Usb("usb");
        new Bit1("bit1");
        new Bit2("bit2");
        new Bit3("bit3");
    }

    @Override
    public void intro() {
        Color cFondo = new Color(51, 51, 51);
        Color cFuente = new Color(204, 204, 255);
        File url = new File("recursos/fuente/digital.ttf");
        Font fuente = null;
        try {
            fuente = Font.createFont(0, url);
            fuente = fuente.deriveFont(0, 18.0f);
        }
        catch (FontFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Universo.atributosTexto(cFuente, 18, fuente);
        Universo.setColorFondo(Color.BLACK);
        Universo.setTitulo("Universo Digital.");
        Universo.setColorTagAccion(Color.blue);
        Universo.setColorTextoResaltado(Color.green);
        this._ayuda();
        Universo.nuevoVerbo("prg");
        Universo.nuevoVerbo("inf");
        Universo.nuevoVerbo("ins");
        Universo.nuevoVerbo("ers");
        Universo.cls();
        this._creditos();
        String s = "Bienvenido al Universo Digital.\nMientras la m\u00e1quina zumba quedamente, miras a tu alrededor...\nPasando por la puerta triestado has llegado a un ancho bus. \nTu misi\u00f3n consiste en encontrar el c\u00f3digo m\u00e1quina de Digitaly y ponerlo a salvo. \nDeber\u00e1s rescatarlo y salir junto con \u00e9l por un puerto de salida. \u00bfPero de cu\u00e1l?\n\n";
        Mundo.writeln(s);
        Universo.centrarTexto(true);
        Universo.centrarTexto(false);
        Universo.playAudio("inicio.wav");
        CargadorImagenes.cargarImagenes();
    }

    @Override
    public Accion parseCommand(Orden command) {
        String brujula = "norte sur este oeste fuera dentro arriba abajo";
        String busES = "entrada salida";
        String busDR = "direcciones direccion";
        String busDT = "datos dato";
        if (command.getComando() == Comando.GO && command.cDirecto() != null && command.args() != null) {
            if (Func.comparaTexto(command.cDirecto(), brujula)) {
                Mundo.writeln("As\u00ed no puedes orientarte. S\u00ed sabes tu destino teclea \"Ir a [destino].\"");
                return Accion.END;
            }
            if (command.cDirecto().equals("bus") && Func.textosExactos(command.args(), busES) && Estancia.getHabitacionActual().equals(Mundo.habitacion("bus de datos"))) {
                if (!Mundo.entidad("puerta").getPropiedadBoolean("abierta")) {
                    Mundo.writeln("La puerta triestado comunica el bus de datos y la cpu con el bus de entrada y salida. No puedes pasar por la puerta triestado, solo podr\u00e1s pasar cuando se ejecute la instrucci\u00f3n correspondiente en la CPU.");
                    return Accion.END;
                }
                Estancia.setHabitacionSiguiente(Mundo.habitacion("bus ES"));
                Estancia.getHabitacionActual().cambiaDeEstancia(Mundo.habitacion("bus ES"));
                return Accion.END;
            }
            if (command.cDirecto().equals("bus") && Func.textosExactos(command.args(), busDR)) {
                if (Estancia.getHabitacionActual().equals(Mundo.habitacion("cpu"))) {
                    command.setcDirecto(new Palabra("busdireccion", command.getcDirecto().getPosicion()));
                } else if (Estancia.getHabitacionActual().equals(Mundo.habitacion("bus de datos"))) {
                    Mundo.writeln("Desde aqu\u00ed no puedes llegar la bus de direcciones, antes debes pasar por la cpu.");
                    return Accion.END;
                }
            }
            if (command.cDirecto().equals("bus") && Func.textosExactos(command.args(), busDT)) {
                if (Estancia.getHabitacionActual().equals(Mundo.habitacion("cpu"))) {
                    command.setcDirecto(new Palabra("busdatos", command.getcDirecto().getPosicion()));
                } else if (Estancia.getHabitacionActual().equals(Mundo.habitacion("bus de direcciones"))) {
                    Mundo.writeln("Desde aqu\u00ed no puedes llegar la bus de datos, antes debes pasar por la cpu.");
                    return Accion.END;
                }
            }
            if (command.cDirecto().equals("bus") && Estancia.getHabitacionActual().equals(Mundo.habitacion("cpu"))) {
                Mundo.writeln("Desde la cpu puedes llegar la bus de datos o el bus de direcciones, \u00bfa cu\u00e1l deseas ir?");
                return Accion.END;
            }
        }
        if (command.getComando() == Comando.GET || command.getComando() == Comando.DROP || command.getComando() == Comando.TAKEOUT || command.getComando() == Comando.TAKEOUT) {
            Mundo.writeln("No puedes coger/sacar ni dejar/meter nada. Lo \u00fanica opci\u00f3n que tienes es {color%green%CARGAR} o {color%green%DESCARGAR} datos / programas de tu CDL");
            return Accion.END;
        }
        if (command.verbo().equals("cargar") || command.verbo().equals("descargar")) {
            if (command.cDirecto() == null || command.args() == null) {
                Mundo.writeln("\u00bfEl qu\u00e9?");
                return Accion.END;
            }
            if (command.cDirecto().equals("cdl")) {
                Mundo.writeln("Revisa la informaci\u00f3n cargada en tu CDL para saber como cargar/descargar datos del mismo.");
                return Accion.END;
            }
            Mundo.writeln("No entend\u00ed que quieres cargar/descargar.");
            return Accion.END;
        }
        return Accion.NEXT;
    }

    @Override
    public String preprocessCommand(String inputText) {
        if (inputText.toLowerCase().indexOf("versi\u00f3n") >= 0 || inputText.toLowerCase().indexOf("version") >= 0) {
            Mundo.writeln("{color%cyan%Versi\u00f3n de la aventura:}\n --300520161955 -- \n{color%cyan%\nVersi\u00f3n del motor:}");
        }
        if (inputText.toLowerCase().indexOf("creditos") >= 0 || inputText.toLowerCase().indexOf("cr\u00e9ditos") >= 0 || inputText.toLowerCase().indexOf("credito") >= 0 || inputText.toLowerCase().indexOf("credito") >= 0) {
            Mundo.writeln(Universo.getCreditos());
            return "";
        }
        return this.newGame.preprocessCommand(inputText);
    }

    private void _creditos() {
        String s = " -- Universo Digital --\nGui\u00f3n edlobez.\nColaborando en el desarrollo de la idea dddddd.\nProgramaci\u00f3n edlobez.\nGr\u00e1ficos KMBR\nEsta obra se puede distribuir libremente bajo la siguientes licencia:\nReconocimiento-NoComercial-SinObraDerivada 4.0 (by-nc-nd).\nM\u00e1s informaci\u00f3n sobre Creative Commons en:http://es.creativecommons.org/licencia/\nVersi\u00f3n de la aventura:\n --300520161955 -- \nVersi\u00f3n del motor:\n -- 160320161305 -- ";
        Universo.setCreditos(s);
    }

    private void _ayuda() {
        String s = "\n -- {color%green%Instrucciones} --\nTe encuentras dentro de un Universo Digital. Tu misi\u00f3n es rescatar a Digitaly, c\u00f3digo de 16 bits, {color%resaltado%F4D3}, los suficientes como para hacer que te hayas adentrado en esta aventura.\nDigitaly ha sido secuestrado por la m\u00e1quina donde te encuentras. Deber\u00e1s localizar una copia de su c\u00f3digo m\u00e1quina y ponerlo a salvo haci\u00e9ndolo salir por el bus de entrada y salida.\nLa CPU de universo digital ir\u00e1 ejecutando instrucciones del programa cargado en memoria y que est\u00e1 en ejecuci\u00f3n. Cada vez que se ejecuta una instrucci\u00f3n tu CDL te lo notificar\u00e1.";
        Universo.setAyuda(s);
    }

    @Override
    public void postLoadLog() {
    }

    @Override
    public void preLoadLog() {
        Mundo.entidad("pc").init();
        Mundo.entidad("ir").init();
    }
}

