/*
 * Decompiled with CFR 0.152.
 */
package Game.Objetos;

import Game.Memoria;
import Universo.Mundo;
import entidad.Entidad;
import java.awt.Color;
import java.util.ArrayList;
import objeto.Objeto;
import parser.Comando;
import parser.Orden;
import propiedades.Accion;

public class DireccionInterrupcion
extends Objeto {
    public DireccionInterrupcion(String nombre) {
        super(nombre);
        this.setVisible(false);
        this.setEstatico(true);
        this.setEstancia(Mundo.habitacion("interrupciones"));
    }

    @Override
    public void init() {
        this.set("direccion", "ninguna");
    }

    @Override
    public void descripcion() {
        String s = "{color%resaltado%Zona de direccionamiento} del servicio de interrupci\u00f3n, direcci\u00f3n cargada: ";
        s = String.valueOf(s) + this.getPropiedadString("direccion");
        this.setDescripcion(s);
    }

    @Override
    public void nombreReferencia() {
        this.nuevoNombreDeReferencia("direccionamiento", 1);
        this.nuevoNombreDeReferencia("zona", 1);
        this.nuevoNombreDeReferencia("direccion", 1);
    }

    @Override
    public void nombreParaMostrar() {
        this.setNombreParaMostrar("Zona de direccionamiento", 1);
    }

    @Override
    public Accion parseCommand(Orden command, ArrayList<Entidad> entitys) {
        int dir_valida = -1;
        String dir = null;
        if (command.verbo().equals("cargar")) {
            if (command.cDirecto().length() > 0 && Memoria.comprobarDireccion(command.cDirecto())) {
                dir_valida = Memoria.hex2decimal(command.cDirecto());
                dir = command.cDirecto();
            } else if (command.args().length() > 0 && Memoria.comprobarDireccion(command.args())) {
                dir_valida = Memoria.hex2decimal(command.args());
                dir = command.args();
            }
            if (dir_valida == -1) {
                Mundo.writelnColor("Direcci\u00f3n incorrecta.", Color.red);
                return Accion.END;
            }
            this.set("direccion", dir);
            Mundo.writeln("Direcci\u00f3n cargada en servicio de interrupci\u00f3n.");
            return Accion.END;
        }
        if (command.verbo().equals("descargar")) {
            if (!this.getPropiedadString("direccion").equals("ninguna")) {
                this.set("direccion", "ninguna");
                Mundo.writeln("Direcci\u00f3n descargada.");
                return Accion.END;
            }
            Mundo.writeln("No hab\u00eda direcci\u00f3n cargada. No se realiza ninguna acci\u00f3n.\n");
            return Accion.END;
        }
        if (command.getComando() != Comando.LOOK) {
            Mundo.writeln("Zona de direcci\u00f3n de programa de interrupcion:\n- Para cargar una direcci\u00f3n: \"{color%resaltado%CARGAR DIRECCION xxx}\" (xxx direcci\u00f3n en hexadecimal).\n- Para descagar una direcci\u00f3n: \"{color%resaltado%DESCARGAR DIRECCION}\"");
            return Accion.END;
        }
        if (command.getComando() == Comando.LOOK) {
            Mundo.writeln("Zona de direcci\u00f3n de programa de interrupcion:\n- Para cargar una direcci\u00f3n: \"{color%resaltado%CARGAR DIRECCION xxx}\" (xxx direcci\u00f3n en hexadecimal).\n- Para descagar una direcci\u00f3n: \"{color%resaltado%DESCARGAR DIRECCION}\"");
            Mundo.writeln(this.getDescripcion());
            return Accion.END;
        }
        return super.parseCommand(command, entitys);
    }
}

