/*
 * Decompiled with CFR 0.152.
 */
package Universo;

import Universo.ComandoAnterior;
import Universo.ControlDeTurnos;
import Universo.HistoricoDeOrdenes;
import Universo.Jugador;
import Universo.Persona;
import Universo.ProcesarTag;
import Universo.Universo;
import auxiliares.Debug;
import auxiliares.Func;
import auxiliares.SaveAndLoad;
import componentes.Cargador;
import componentes.CuadrosDialogo;
import entidad.Entidad;
import estancia.Estancia;
import interfazConJuego.TheGame;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import objeto.Objeto;
import parser.Articulos;
import parser.Comando;
import parser.Orden;
import parser.Palabra;
import propiedades.Accion;

public class Mundo
extends Universo {
    private static ArrayList<Estancia> estancias;
    private static ArrayList<Entidad> entidades;
    private static Jugador jugador;
    private static HistoricoDeOrdenes historicoOrdenes;
    private static ControlDeTurnos turnos;
    private boolean respt_mundo;

    public Mundo(boolean reinicio) {
        estancias = new ArrayList();
        entidades = new ArrayList();
        historicoOrdenes = new HistoricoDeOrdenes();
        turnos = new ControlDeTurnos();
        if (!reinicio) {
            this.crearUniverso(this);
        }
    }

    public static void nuevaEstancia(Estancia estancia) {
        estancias.add(estancia);
    }

    public static ArrayList<Estancia> getListaEstancias() {
        return estancias;
    }

    public static Estancia habitacion(String nombre) {
        for (Estancia unaEstancia : estancias) {
            if (!unaEstancia.getNombreUnico().equals(nombre)) continue;
            return unaEstancia;
        }
        return null;
    }

    public static void nuevaEntidad(Entidad entity) {
        entidades.add(entity);
    }

    public static Entidad entidad(String nombre) {
        for (Entidad oneEntidad : entidades) {
            if (!oneEntidad.getNombre().equals(nombre)) continue;
            return oneEntidad;
        }
        return null;
    }

    public static Entidad buscarEntidad(String nombre) {
        for (Entidad unaEntidad : entidades) {
            if (!unaEntidad.matchNombreOk(nombre)) continue;
            return unaEntidad;
        }
        return null;
    }

    public static ArrayList<Entidad> getListaEntidades() {
        return entidades;
    }

    public static ArrayList<Objeto> getListaObjetos() {
        ArrayList<Objeto> out = new ArrayList<Objeto>();
        for (Entidad oneEntidad : entidades) {
            if (!(oneEntidad instanceof Objeto)) continue;
            out.add((Objeto)oneEntidad);
        }
        return out;
    }

    public static ArrayList<Persona> getListaPersona() {
        ArrayList<Persona> out = new ArrayList<Persona>();
        for (Entidad oneEntidad : entidades) {
            if (!(oneEntidad instanceof Persona)) continue;
            out.add((Persona)oneEntidad);
        }
        return out;
    }

    public static Jugador getJugador() {
        return jugador;
    }

    public static void setJugador(Jugador elJugador) {
        jugador = elJugador;
    }

    public static void writeln(String txt) {
        txt = String.valueOf(txt) + "\n";
        Mundo.getGui().addAtText(ProcesarTag.processTags(Func.formateoSalida(txt)));
    }

    public static void write(String txt) {
        Mundo.getGui().addAtText(ProcesarTag.processTags(Func.formateoSalida(txt)));
    }

    public static void writelnColor(String txt, Color color) {
        Color color_aux = Mundo.getColorFuente();
        Mundo.setColorFuente(color);
        Mundo.writeln(txt);
        Mundo.setColorFuente(color_aux);
    }

    public static void writeColor(String txt, Color color) {
        Color color_aux = Mundo.getColorFuente();
        Mundo.setColorFuente(color);
        Mundo.write(txt);
        Mundo.setColorFuente(color_aux);
    }

    public boolean mundoOK() {
        if (jugador == null) {
            System.out.println("No existe jugador creado.");
            return false;
        }
        if (estancias.size() == 0) {
            System.out.println("Debe existir al menos una habitaci\u00f3n.");
            return false;
        }
        return true;
    }

    public void start() {
        Estancia.setHabitacionActual(estancias.get(0));
        Estancia.setHabitacionAnterior(estancias.get(0));
        Estancia.getHabitacionActual().mostrarEstancia();
        inputListener.setFoco();
    }

    public static void teclaEspecial(int keyCode) {
        Orden aux = null;
        if (keyCode == 38 && (aux = historicoOrdenes.ordenAnterior()) != null) {
            Mundo.getInput().setText(aux.getInputLine());
        }
        if (keyCode == 40 && (aux = historicoOrdenes.ordenSiguiente()) != null) {
            Mundo.getInput().setText(aux.getInputLine());
        }
    }

    public void _command(ArrayList<Orden> comandos) {
        Accion finished = Accion.NEXT;
        ComandoAnterior.nuevaListaDeObjetos();
        ArrayList<Entidad> winEntity = null;
        for (Orden command : comandos) {
            finished = Accion.NEXT;
            this.respt_mundo = false;
            if (command.getComando() != Comando.LOAD && command.getComando() != Comando.SAVE && command.getComando() != Comando.RESTART) {
                historicoOrdenes.setNuevaOrden(command);
            }
            if ((winEntity = this.matchEntity(command)).size() == 0) {
                finished = jugador.parseCommand(command);
                if (finished == Accion.NEXT) {
                    finished = Estancia.getHabitacionActual().parseCommand(command);
                }
                if (finished == Accion.NEXT) {
                    finished = TheGame.game.parseCommand(command);
                }
                if (finished == Accion.NEXT) {
                    finished = this.parseCommand(command);
                }
            }
            int i = 0;
            while (i < winEntity.size() && finished != Accion.STOP) {
                Debug.writeDebug(this, "Buscando resultado del pC de entity: " + winEntity.get(i).getNombreActualDeReferencia());
                finished = jugador.parseCommand(command, winEntity);
                if (finished == Accion.NEXT) {
                    finished = winEntity.get(i).parseCommand(command, winEntity);
                }
                Debug.writeDebug(this, "Resultado de finished: " + finished);
                ++i;
            }
            if (finished == Accion.NEXT) {
                finished = TheGame.game.parseCommand(command);
            }
            if (finished == Accion.NEXT) {
                finished = this.parseCommand(command);
            } else {
                if (finished == Accion.RESTART) {
                    comandos = null;
                    if (!CuadrosDialogo.confirmacion("Reiniciar")) break;
                    Mundo.writeln("Reiniciando juego...");
                    Entidad.pararTodosLosTiempos();
                    new TheGame(TheGame.game, true);
                    break;
                }
                if (finished == Accion.LOAD) {
                    Mundo.writeln("Cargando juego...");
                    String fileName = Cargador.load();
                    if (fileName != null) {
                        SaveAndLoad.setOnLoad(true, fileName);
                        Entidad.pararTodosLosTiempos();
                        new TheGame(TheGame.game, true);
                        break;
                    }
                    Mundo.writelnColor(" -- Error nombre de fichero --", Color.red);
                    break;
                }
                if (finished == Accion.END_GAME) {
                    if (!CuadrosDialogo.confirmacion("Salir")) break;
                    System.exit(0);
                    break;
                }
                if (finished != Accion.END && finished != Accion.STOP) {
                    Mundo.writeln(Accion.printMessage(command));
                }
            }
            turnos.avanceTurno();
        }
    }

    public void forceCommand(String comando) {
        Mundo.getGui().addOrden(String.valueOf(comando) + "\n");
        this._command(this.getParser().getComando(comando));
    }

    public void forceCommandNoEco(String comando) {
        this._command(this.getParser().getComando(comando));
    }

    public Accion parseCommand(Orden command) {
        if (this.respt_mundo) {
            return Accion.NEXT;
        }
        return this.processCommand(command);
    }

    private Accion processCommand(Orden orden) {
        Comando comando = orden.getComando();
        Debug.writeDebug(this, "En mundo la orden: " + orden.verbo() + " " + orden.cDirecto() + " " + orden.args());
        if (comando == Comando.HELP) {
            String s = Universo.getAyuda();
            if (s == null || s.length() == 0) {
                Mundo.writeln("No hay disponible ninguna ayuda.");
            } else {
                Mundo.writeln(s);
            }
            return Accion.END;
        }
        if (comando == Comando.LOOK) {
            if (Func.textosExactos(orden.args(), "techo cielo")) {
                Mundo.writeln("No ves nada especial al mirar hacia arriba.");
                return this.end();
            }
            if (Func.textosExactos(orden.args(), "suelo")) {
                Mundo.writeln("No ves nada especial al mirar hacia abajo.");
                return this.end();
            }
            if (orden.getcDirecto() != null) {
                Mundo.writeln(Accion.printCondition(Accion.LOOK_NO_OK, new Entidad[0]));
                return Accion.END;
            }
            Accion.execute(Accion.LOOK_OK);
            Estancia.getHabitacionActual().mostrarEstancia();
            return Accion.END;
        }
        if (comando == Comando.GO) {
            if (orden.getcDirecto() != null) {
                Debug.writeDebug(this, "Quieres ir a: " + orden.cDirecto());
                Estancia newEstancia = Estancia.getHabitacionActual().getCaminos().getSalida(orden.cDirecto());
                if (newEstancia == null) {
                    Mundo.writeln("No encuentro ese camino.");
                } else if (newEstancia.getNombreUnico().equals(Estancia.getHabitacionActual().getNombreUnico())) {
                    Mundo.writeln("Es donde est\u00e1s ahora.");
                } else if (Estancia.getHabitacionActual().cambiarEstancia(newEstancia)) {
                    Estancia.getHabitacionActual().cambiaDeEstancia(newEstancia);
                }
            } else {
                Mundo.writeln("\u00bfIr d\u00f3nde?");
            }
            return Accion.END;
        }
        if (comando == Comando.RESTART) {
            return Accion.RESTART;
        }
        if (comando == Comando.SAVE) {
            String fileName = Cargador.save();
            if (fileName != null) {
                SaveAndLoad.save(historicoOrdenes.getHistorico(), fileName);
                Mundo.writeln("Partida grabada correctamente.");
            } else {
                Mundo.writelnColor(" -- Error al guardar la partida --", Color.red);
            }
            return Accion.END;
        }
        if (comando == Comando.LOAD) {
            return Accion.LOAD;
        }
        if (comando == Comando.QUIT) {
            return Accion.END_GAME;
        }
        if (comando == Comando.INVENTORY) {
            jugador.mostrarInventario();
            return Accion.END;
        }
        if (orden.getVerbo() != null) {
            Mundo.writeln(Accion.printMessage(orden));
            return this.end();
        }
        if (comando == Comando.UNKNOWN) {
            Mundo.writeln("Lo siento no te entiendo...");
            return Accion.END;
        }
        return Accion.NEXT;
    }

    private ArrayList<Entidad> matchEntity(Orden command) {
        String[] posNewCommand;
        Debug.writeDebug(this, "Orden en matchEntity: " + command.toString());
        ArrayList<Entidad> matchItems = new ArrayList<Entidad>();
        ArrayList<Entidad> winEntity = new ArrayList<Entidad>();
        if (Articulos.buscarArticulos(command.cDirecto()) && (posNewCommand = this.sustituirPronombre(command.cDirecto()).split(" ")).length > 0) {
            command.setcDirecto(new Palabra(posNewCommand[0], command.getcDirecto().getPosicion()));
        }
        for (Entidad unItem : entidades) {
            if (unItem.matchAdjetivoOk(command.cDyArgs().split(" ")) != null) {
                unItem.setNombreActualDeReferencia(unItem.getMejorNombreDeReferenciaYGenero());
                matchItems.add(unItem);
                Debug.writeDebug(this, "Seleccionado item con nombre: " + unItem.getNombre() + " adjetivo: " + unItem.getMejorAdjetivo());
            }
            String[] stringArray = (String.valueOf(command.cDirecto()) + " " + command.args()).split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                if (unItem.matchNombreOk(word)) {
                    if (!matchItems.contains(unItem)) {
                        unItem.setNombreActualDeReferencia(unItem.getWordAngGen(word));
                        unItem.setAdjetivoActualDeReferencia(null);
                        matchItems.add(unItem);
                    } else {
                        unItem.setNombreActualDeReferencia(unItem.getWordAngGen(word));
                    }
                }
                ++n2;
            }
        }
        if (matchItems.size() == 0) {
            Debug.writeDebug(this, "No hay ning\u00fan candidato.");
        }
        if (matchItems.size() == 1) {
            Debug.writeDebug(this, "S\u00f3lo hay un candidato.");
            if (matchItems.get(0) instanceof Jugador || ((Entidad)matchItems.get(0)).presente()) {
                winEntity.add((Entidad)matchItems.get(0));
            }
        }
        if (matchItems.size() > 1) {
            Debug.writeDebug(this, "Hay m\u00e1s de un candidato.");
            int i = 0;
            while (i < matchItems.size()) {
                Debug.writeDebug(this, "Candidatos: " + ((Entidad)matchItems.get(i)).getNombre());
                ArrayList<Entidad> secondmatchItems = new ArrayList<Entidad>();
                boolean newItem = false;
                Entidad auxItem = (Entidad)matchItems.get(i);
                int j = i + 1;
                while (j < matchItems.size()) {
                    Debug.writeDebug(this, "Comparando: " + auxItem + " nombre: " + auxItem.getNombreActualDeReferencia());
                    Debug.writeDebug(this, "Con " + matchItems.get(j) + " nombre: " + ((Entidad)matchItems.get(j)).getNombreActualDeReferencia());
                    Debug.writeDebug(this, "Guardando adjetivos.");
                    if (auxItem.matchAdjetivoOk(command.listaArgs()) != null) {
                        auxItem.setAdjetivoActualDeReferencia(auxItem.matchAdjetivoOk(command.listaArgs()));
                        Debug.writeDebug(this, "Guardando adjetivo: " + auxItem.matchAdjetivoOk(command.listaArgs()));
                    }
                    if (((Entidad)matchItems.get(j)).matchAdjetivoOk(command.listaArgs()) != null) {
                        ((Entidad)matchItems.get(j)).setAdjetivoActualDeReferencia(((Entidad)matchItems.get(j)).matchAdjetivoOk(command.listaArgs()));
                        Debug.writeDebug(this, "Guardando adjetivo: " + ((Entidad)matchItems.get(j)).matchAdjetivoOk(command.listaArgs()));
                    }
                    if (auxItem.getNombreActualDeReferencia().equals(((Entidad)matchItems.get(j)).getNombreActualDeReferencia())) {
                        Debug.writeDebug(this, "Son iguales en nombre.");
                        Debug.writeDebug(this, "Comparando adjetivo para item " + auxItem);
                        if (auxItem.getAdjetivoActualDeReferencia() != null) {
                            secondmatchItems.add(auxItem);
                            if (((Entidad)matchItems.get(j)).getAdjetivoActualDeReferencia() == null) {
                                matchItems.remove(j);
                            }
                        } else if (((Entidad)matchItems.get(j)).getAdjetivoActualDeReferencia() != null) {
                            secondmatchItems.add((Entidad)matchItems.get(j));
                        }
                        if (secondmatchItems.size() > 0) {
                            newItem = true;
                            Debug.writeDebug(this, "Second match candidatos: " + secondmatchItems.toString());
                            Debug.writeDebug(this, "A\u00f1andiendo: " + secondmatchItems);
                            winEntity.add((Entidad)secondmatchItems.get(0));
                        }
                    }
                    ++j;
                }
                if (!winEntity.contains(auxItem) && !newItem && ((Objeto)auxItem).presente()) {
                    Debug.writeDebug(this, "A\u00f1adiendo " + auxItem);
                    winEntity.add(auxItem);
                }
                ++i;
            }
        }
        Debug.writeDebug(this, "Items candidatos: " + matchItems.toString());
        Debug.writeDebug(this, "El item mejor candidato: " + winEntity.toString());
        if (winEntity.size() > 1) {
            winEntity = this.eleccionItem(winEntity);
        }
        if (command.getComando() != Comando.UNKNOWN) {
            ComandoAnterior.setUltimaOrden(command);
        }
        if (winEntity != null && winEntity.size() > 0) {
            ComandoAnterior.setUltimoObjeto(winEntity.get(0));
            int i = 0;
            while (i < winEntity.size()) {
                ComandoAnterior.nuevoEnUltimosObjetos(winEntity.get(i));
                ++i;
            }
        }
        return winEntity;
    }

    private ArrayList<Entidad> eleccionItem(ArrayList<Entidad> entitys) {
        ArrayList<Entidad> singular = new ArrayList<Entidad>();
        ArrayList<Entidad> plural = new ArrayList<Entidad>();
        HashSet<Entidad> singularRepetido = new HashSet<Entidad>();
        for (Entidad unaEntidad : entitys) {
            if (unaEntidad.getnombreActualDeReferenciaYGenero().getNumero() == 13) {
                singular.add(unaEntidad);
                continue;
            }
            plural.add(unaEntidad);
        }
        int i = 0;
        while (i < singular.size()) {
            boolean repetido = false;
            int j = 0;
            while (j < singular.size()) {
                if (i != j && singular.get(i).getNombreActualDeReferencia().equals(singular.get(j).getNombreActualDeReferencia())) {
                    repetido = true;
                    singularRepetido.add(singular.get(i));
                    singularRepetido.add(singular.get(j));
                }
                ++j;
            }
            if (!repetido) {
                plural.add(singular.get(i));
            }
            ++i;
        }
        if (singularRepetido.size() > 1) {
            singular.clear();
            singular.addAll(singularRepetido);
            this.preguntarEleccionItem(singular);
        }
        return plural;
    }

    private void preguntarEleccionItem(ArrayList<Entidad> entitys) {
        String out = "\u00bfCu\u00e1l";
        if (entitys.size() == 2) {
            out = String.valueOf(out) + " " + ((Objeto)entitys.get(0)).elNombre() + " o " + ((Objeto)entitys.get(1)).elNombre() + "?";
        } else {
            int aux = entitys.size();
            int i = 0;
            while (i < aux) {
                out = String.valueOf(out) + " " + ((Objeto)entitys.get(i)).elNombre();
                if (i == aux - 2) {
                    out = String.valueOf(out) + " o";
                } else if (i < aux - 2) {
                    out = String.valueOf(out) + ",";
                }
                ++i;
            }
            out = String.valueOf(out) + "?";
        }
        this.respt_mundo = true;
        Mundo.writeln(out);
    }

    private String sustituirPronombre(String pronombre) {
        String out;
        block23: {
            out = pronombre.trim();
            if (ComandoAnterior.getUltimoObjeto() == null && !out.equals("te") && !out.equals("me")) break block23;
            switch (pronombre) {
                case "las": {
                    if (ComandoAnterior.getUltimoObjeto().esMasculino() || ComandoAnterior.getUltimoObjeto().getnombreActualDeReferenciaYGenero().getNumero() != 12) break;
                    out = String.valueOf(ComandoAnterior.getUltimoObjeto().getNombreActualDeReferencia()) + " " + ComandoAnterior.getUltimoObjeto().getMejorAdjetivo();
                    break;
                }
                case "la": {
                    Debug.writeDebug(this, "Seguido del art\u00edculo la.");
                    if (ComandoAnterior.getUltimoObjeto().esMasculino()) break;
                    Debug.writeDebug(this, "Hay item anterior v\u00e1lido: " + ComandoAnterior.getUltimoObjeto().getNombre());
                    out = String.valueOf(ComandoAnterior.getUltimoObjeto().getNombreActualDeReferencia()) + " " + ComandoAnterior.getUltimoObjeto().getMejorAdjetivo();
                    break;
                }
                case "los": {
                    if (!ComandoAnterior.getUltimoObjeto().esMasculino() || ComandoAnterior.getUltimoObjeto().getnombreActualDeReferenciaYGenero().getNumero() != 12) break;
                    out = String.valueOf(ComandoAnterior.getUltimoObjeto().getNombreActualDeReferencia()) + " " + ComandoAnterior.getUltimoObjeto().getMejorAdjetivo();
                    break;
                }
                case "lo": {
                    Debug.writeDebug(this, "Seguido del art\u00edculo lo.");
                    if (!ComandoAnterior.getUltimoObjeto().esMasculino()) break;
                    Debug.writeDebug(this, "Hay item anterior v\u00e1lido: " + ComandoAnterior.getUltimoObjeto().getNombre());
                    out = String.valueOf(ComandoAnterior.getUltimoObjeto().getNombreActualDeReferencia()) + " " + ComandoAnterior.getUltimoObjeto().getMejorAdjetivo();
                    break;
                }
                case "me": 
                case "se": 
                case "te": {
                    out = Mundo.getJugador().getNombreActualDeReferencia();
                }
            }
        }
        return out.trim();
    }

    public String preprocessCommand(String inputText) {
        if (inputText.toLowerCase().indexOf("versi\u00f3n") >= 0 || inputText.toLowerCase().indexOf("version") >= 0) {
            Mundo.writeln(" -- 160320161305 -- ");
            return "";
        }
        return inputText;
    }
}

