/*
 * Decompiled with CFR 0.152.
 */
package Universo;

import Universo.Mundo;
import Universo.TagAccion;
import Universo.Universo;
import componentes.EntradaTexto;
import componentes.PanelTexto;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;

public class ProcesarTag {
    private static PanelTexto panel;
    private EntradaTexto input;
    private boolean slide;
    private static ArrayList<TagAccion> misTags;

    static {
        misTags = new ArrayList();
    }

    public ProcesarTag() {
        MyMouseListener mlst = new MyMouseListener();
        panel = Universo.getGui().getAreaText();
        MyMouseMotionListener mmlst = new MyMouseMotionListener();
        panel.addMouseListener(mlst);
        panel.addMouseMotionListener(mmlst);
        this.slide = false;
        this.input = Universo.getGui().getInputText();
    }

    public static String processTags(String text) {
        if (text.indexOf(123) == -1) {
            return text;
        }
        if (text.indexOf(125) == -1 || text.indexOf(125) < text.indexOf(123)) {
            return text;
        }
        String pre = text.substring(0, text.indexOf(123));
        int openbracketcont = 1;
        int pointer = text.indexOf(123) + 1;
        String innerTag = "";
        while (openbracketcont > 0) {
            if (text.charAt(pointer) == '{') {
                ++openbracketcont;
            }
            if (text.charAt(pointer) == '}') {
                --openbracketcont;
            }
            innerTag = String.valueOf(innerTag) + text.charAt(pointer);
            ++pointer;
        }
        innerTag = innerTag.substring(0, innerTag.length() - 1);
        String post = text.substring(pointer);
        Mundo.write(pre);
        ProcesarTag.implementTag(innerTag);
        Mundo.write(post);
        return null;
    }

    public static void implementTag(String tag) {
        String[] tagparams = tag.split("%");
        int i = 0;
        while (i < tagparams.length) {
            tagparams[i] = tagparams[i].trim();
            ++i;
        }
        if (tagparams.length == 0) {
            Mundo.writeln(tag);
        }
        switch (tagparams[0].toUpperCase()) {
            case "COLOR": {
                if (tagparams.length < 3) {
                    Mundo.write(tag);
                    break;
                }
                if (tagparams[1].equals("red")) {
                    Mundo.writeColor(tagparams[2], Color.red);
                }
                if (tagparams[1].equals("blue")) {
                    Mundo.writeColor(tagparams[2], Color.blue);
                }
                if (tagparams[1].equals("green")) {
                    Mundo.writeColor(tagparams[2], Color.green);
                }
                if (tagparams[1].equals("yellow")) {
                    Mundo.writeColor(tagparams[2], Color.yellow);
                }
                if (tagparams[1].equals("cyan")) {
                    Mundo.writeColor(tagparams[2], Color.cyan);
                }
                if (!tagparams[1].equals("resaltado")) break;
                Mundo.writeColor(tagparams[2], Universo.getColorTextoResaltado());
                break;
            }
            case "ACCION": {
                if (tagparams.length < 3) {
                    Mundo.write(tag);
                    break;
                }
                TagAccion tagAccion = new TagAccion(tagparams[2], tagparams[1]);
                tagAccion.setStartCaret(panel.getCaretPosition());
                tagAccion.setEndCaret(panel.getCaretPosition() + tagparams[2].length());
                misTags.add(tagAccion);
                Mundo.setUnderlineText(true);
                if (tagAccion.getColor() == null) {
                    Mundo.writeColor(tagAccion.getText(), Universo.getColorTagAccion());
                } else {
                    Mundo.writeColor(tagAccion.getText(), tagAccion.getColor());
                }
                Mundo.setUnderlineText(false);
                break;
            }
            default: {
                Mundo.write(tag);
            }
        }
    }

    public static ArrayList<TagAccion> misTags() {
        return misTags;
    }

    public static void borrarTags() {
        misTags.clear();
    }

    public class MyMouseListener
    implements MouseListener {
        @Override
        public void mouseClicked(MouseEvent me) {
            for (TagAccion unTag : misTags) {
                if (!unTag.matchCaret(panel.getCaretPosition())) continue;
                ProcesarTag.this.input.setText(String.valueOf(unTag.getAccion()) + " " + unTag.getText());
                ProcesarTag.this.input.requestFocus();
                Robot robot = null;
                try {
                    robot = new Robot();
                    robot.keyPress(10);
                    robot.keyRelease(10);
                }
                catch (AWTException e) {
                    e.printStackTrace();
                }
                break;
            }
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }

    public class MyMouseMotionListener
    implements MouseMotionListener {
        @Override
        public void mouseDragged(MouseEvent arg0) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (misTags == null || misTags.size() == 0) {
                return;
            }
            for (TagAccion unTag : misTags) {
                if (unTag.matchCaret(panel.viewToModel(new Point(x, y)))) {
                    Universo.getGui().getAreaText().setCursor(new Cursor(12));
                    ProcesarTag.this.input.setText(String.valueOf(unTag.getAccion()) + " " + unTag.getText());
                    ProcesarTag.this.slide = true;
                    break;
                }
                if (ProcesarTag.this.slide) {
                    ProcesarTag.this.input.setText("");
                    ProcesarTag.this.slide = false;
                }
                Universo.getGui().getAreaText().setCursor(new Cursor(0));
            }
        }
    }
}

