/*
 * Decompiled with CFR 0.152.
 */
package Universo;

import Universo.Mundo;
import Universo.ProcesarTag;
import audio.Sonido;
import auxiliares.SaveAndLoad;
import componentes.EntradaTexto;
import componentes.VentanaGrafica;
import escuchadores.InputListener;
import gui.Gui;
import gui.GuiIF;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import parser.Parser;
import parser.Verbos;
import propiedades.Accion;
import propiedades.Propiedades;
import propiedades.Temporizador;

public abstract class Universo {
    public static final int MS = 1;
    public static final int MP = 2;
    public static final int IMS = 3;
    public static final int IMP = 4;
    public static final int FS = 5;
    public static final int FP = 6;
    public static final int IFS = 7;
    public static final int IFP = 8;
    public static final int NO = 9;
    public static boolean SONIDO_ACTIVO = true;
    public static final String version = " -- 160320161305 -- ";
    private static String creditos;
    private static String ayuda;
    private Parser parser;
    private static Mundo mundo;
    private static GuiIF gui;
    private static Color colorTag;
    private static Color colorTextoResaltado;
    protected static InputListener inputListener;
    private ProcesarTag tags;
    private Propiedades<Boolean> propBool = new Propiedades();
    private Propiedades<Integer> propInt = new Propiedades();
    private Propiedades<String> propString = new Propiedades();
    private Propiedades<Object> propGenerica = new Propiedades();
    private static Map<String, Temporizador> temporizadores;

    static {
        temporizadores = new HashMap<String, Temporizador>();
    }

    public Universo() {
        temporizadores = new HashMap<String, Temporizador>();
    }

    public void crearUniverso(Mundo mundo) {
        this.parser = new Parser();
        Universo.mundo = mundo;
        Accion.makeResponseTable();
    }

    public void crearVentanaGrafica() {
        gui = new Gui();
        Universo.atributosTexto(Color.WHITE, 14, "serif");
        this.tags = new ProcesarTag();
        inputListener = new InputListener(gui, mundo);
    }

    public void set(String nombre, Object valor) {
        if (valor instanceof Boolean) {
            this.propBool.set(nombre, (boolean)((Boolean)valor));
        } else if (valor instanceof Integer) {
            this.propInt.set(nombre, (Integer)valor);
        } else if (valor instanceof String) {
            this.propString.set(nombre, (String)valor);
        } else {
            this.propGenerica.set(nombre, valor);
        }
    }

    public void setTiempo(String nombre, Long val) {
    }

    public void pararTiempo(String nombre) {
    }

    public static void pararTodosLosTiempos() {
        for (Temporizador temp : temporizadores.values()) {
            temp.stop();
        }
    }

    public Object get(String nombre) {
        if (this.propGenerica.get(nombre) == null) {
            return null;
        }
        return this.propGenerica.get(nombre);
    }

    public boolean getPropiedadBoolean(String nombre) {
        if (this.propBool.get(nombre) == null) {
            return false;
        }
        return this.propBool.get(nombre);
    }

    public String getPropiedadString(String nombre) {
        if (this.propString.get(nombre) == null) {
            return "";
        }
        return this.propString.get(nombre);
    }

    public Integer getPropiedadInt(String nombre) {
        return this.propInt.get(nombre);
    }

    public void incrementarPropiedad(String nombre) {
        this.propInt.set(nombre, this.propInt.get(nombre) + 1);
    }

    public void decrementarPropiedad(String nombre) {
        this.propInt.set(nombre, this.propInt.get(nombre) - 1);
    }

    public static VentanaGrafica getVentanaGrafica() {
        return Gui.getVentanaGrafica();
    }

    public static GuiIF getGui() {
        return gui;
    }

    public Parser getParser() {
        return this.parser;
    }

    public static Mundo getMundo() {
        return mundo;
    }

    public static void setTitulo(String titulo) {
        gui.setTitulo(titulo);
    }

    public static void atributosTexto(Color color, int tam, String fuente) {
        gui.getAreaText().atributosTexto(color, tam, fuente);
    }

    public static void atributosTexto(Color color, int tam, Font fuente) {
        gui.getAreaText().atributosTexto(color, tam, fuente);
        gui.getPromt().setFont(fuente);
        gui.getInputText().setFont(fuente);
    }

    public static void setFuente(Font f) {
        gui.getInputText().setFont(f);
        gui.getAreaText().setFuente(f);
        gui.getPromt().setFont(f);
    }

    public static void setColorFuente(Color color) {
        gui.getAreaText().setColorTexto(color);
    }

    public static Color getColorFuente() {
        return gui.getAreaText().getColorTexto();
    }

    public static void setTamFuente(int t) {
        gui.getAreaText().setFontSize(t);
    }

    public static int getTamFuente() {
        return gui.getAreaText().getFontSize();
    }

    public static void setColorFondo(Color color) {
        gui.getAreaText().setColorFondo(color);
    }

    public static void setUnderlineText(boolean und) {
        gui.getAreaText().setUnderline(und);
    }

    public static void setItalic(boolean itl) {
        gui.getAreaText().setItalic(itl);
    }

    public static void centrarTexto(boolean c) {
        gui.getAreaText().centrarTexto(c);
    }

    public static void cls() {
        gui.getAreaText().cls();
    }

    public static EntradaTexto getInput() {
        return gui.getInputText();
    }

    public static void setColorTagAccion(Color color) {
        colorTag = color;
    }

    public static Color getColorTagAccion() {
        if (colorTag == null) {
            return gui.getAreaText().getColorTexto();
        }
        return colorTag;
    }

    public static void setColorTextoResaltado(Color color) {
        colorTextoResaltado = color;
    }

    public static Color getColorTextoResaltado() {
        if (colorTextoResaltado == null) {
            return gui.getAreaText().getColorTexto();
        }
        return colorTextoResaltado;
    }

    public static void playAudio(String fileName) {
        if (!SaveAndLoad.onLoad() && SONIDO_ACTIVO) {
            Sonido._playAudio(fileName);
        }
    }

    public static void playAudio(String fileName, int loop) {
        if (!SaveAndLoad.onLoad() && SONIDO_ACTIVO) {
            Sonido._playAudio(fileName, loop);
        }
    }

    public static void actDesSonido(boolean e) {
        SONIDO_ACTIVO = e;
        if (e) {
            Mundo.writeln("-- Activando sistema de audio --");
        } else {
            Mundo.writeln("-- Desactivando sistema de audio --");
        }
    }

    public static void nuevoVerbo(String verb) {
        Verbos.crearVerboUnico(verb);
    }

    public static void setCreditos(String credit) {
        creditos = credit;
    }

    public static String getCreditos() {
        return creditos;
    }

    public static void setAyuda(String help) {
        ayuda = help;
    }

    public static String getAyuda() {
        return ayuda;
    }

    public Accion end() {
        return Accion.END;
    }
}

