/*
 * Decompiled with CFR 0.152.
 */
package componentes;

import Universo.Universo;
import auxiliares.Transcript;
import componentes.Cargador;
import componentes.CuadrosDialogo;
import componentes.VentanaGrafica;
import gui.GuiIF;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class BarraMenu {
    private VentanaGrafica frame;
    private GuiIF gui;

    public BarraMenu(VentanaGrafica frame, GuiIF gui) {
        this.frame = frame;
        this.gui = gui;
        this.crearBarraMenu();
    }

    private void crearBarraMenu() {
        JMenuBar barraDeMenu = new JMenuBar();
        this.frame.setJMenuBar(barraDeMenu);
        JMenu archivo = new JMenu("Archivo");
        barraDeMenu.add(archivo);
        JMenuItem abrir = new JMenuItem("Cargar partida");
        abrir.addActionListener(new AbrirListener());
        archivo.add(abrir);
        JMenuItem guardar = new JMenuItem("Salvar partida");
        guardar.addActionListener(new GuardarListener());
        archivo.add(guardar);
        JMenuItem transcript = new JMenuItem("Guardar texto");
        transcript.addActionListener(new GuardarTrans());
        archivo.add(transcript);
        JMenuItem reiniciar = new JMenuItem("Reiniciar");
        reiniciar.addActionListener(new ReiniciarListener());
        archivo.add(reiniciar);
        JMenuItem fin = new JMenuItem("Fin");
        fin.addActionListener(new FinListener());
        archivo.add(fin);
        JMenu apariencia = new JMenu("Apariencia");
        barraDeMenu.add(apariencia);
        JMenuItem colorFuente = new JMenuItem("Color de fuente");
        colorFuente.addActionListener(new ColorFuenteListener());
        apariencia.add(colorFuente);
        JMenuItem tamFuenteMas = new JMenuItem("Agrandar fuente");
        tamFuenteMas.addActionListener(new TamFuenteListener());
        apariencia.add(tamFuenteMas);
        JMenuItem tamFuenteMenos = new JMenuItem("Disminuir fuente");
        tamFuenteMenos.addActionListener(new TamFuenteListener());
        apariencia.add(tamFuenteMenos);
        JMenuItem colorLinks = new JMenuItem("Color de enlaces");
        colorLinks.addActionListener(new ColorLinksListener());
        apariencia.add(colorLinks);
        JMenuItem colorTextoResaltado = new JMenuItem("Color de texto resaltado");
        colorTextoResaltado.addActionListener(new ColorTextoResaltado());
        apariencia.add(colorTextoResaltado);
        JMenuItem colorFondo = new JMenuItem("Color de fondo");
        colorFondo.addActionListener(new ColorFondoListener());
        apariencia.add(colorFondo);
        JMenuItem fuenteEstandar = new JMenuItem("Cambiar a fuente estandar");
        fuenteEstandar.addActionListener(new CambioTipoFuente());
        apariencia.add(fuenteEstandar);
        JMenu sonido = new JMenu("Sonido");
        barraDeMenu.add(sonido);
        JMenuItem activarSonido = new JMenuItem("Activar sonido");
        activarSonido.addActionListener(new Sonido());
        sonido.add(activarSonido);
        JMenuItem desactivarSonido = new JMenuItem("Desactivar sonido");
        desactivarSonido.addActionListener(new Sonido());
        sonido.add(desactivarSonido);
        JMenu ayuda = new JMenu("Ayuda");
        barraDeMenu.add(ayuda);
        JMenuItem help = new JMenuItem("Instrucciones");
        help.addActionListener(new HelpListener());
        ayuda.add(help);
        JMenuItem acercade = new JMenuItem("Acerca de...");
        acercade.addActionListener(new AcercaDeListener());
        ayuda.add(acercade);
    }

    class AbrirListener
    implements ActionListener {
        AbrirListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Universo.getMundo().forceCommandNoEco("load");
        }
    }

    class AcercaDeListener
    implements ActionListener {
        AcercaDeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            CuadrosDialogo.mensaje(Universo.getCreditos(), "Cr\u00e9ditos");
        }
    }

    class CambioTipoFuente
    implements ActionListener {
        CambioTipoFuente() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Universo.setFuente(new Font("arial", 0, Universo.getGui().getAreaText().getFontSize()));
        }
    }

    class ColorFondoListener
    implements ActionListener {
        ColorFondoListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Color color = CuadrosDialogo.colores();
            BarraMenu.this.gui.getAreaText().setColorFondo(color);
            BarraMenu.this.gui.getLayout().setColorFondo(color);
        }
    }

    class ColorFuenteListener
    implements ActionListener {
        ColorFuenteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Color color = CuadrosDialogo.colores();
            BarraMenu.this.gui.getAreaText().setColorTexto(color);
        }
    }

    class ColorLinksListener
    implements ActionListener {
        ColorLinksListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Color color = CuadrosDialogo.colores();
        }
    }

    class ColorTextoResaltado
    implements ActionListener {
        ColorTextoResaltado() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Color color = CuadrosDialogo.colores();
            if (color != null) {
                Universo.setColorTextoResaltado(color);
            }
        }
    }

    class FinListener
    implements ActionListener {
        FinListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Universo.getMundo().forceCommandNoEco("fin");
        }
    }

    class GuardarListener
    implements ActionListener {
        GuardarListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Universo.getMundo().forceCommandNoEco("save");
        }
    }

    class GuardarTrans
    implements ActionListener {
        GuardarTrans() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            String fileName = Cargador.save();
            if (fileName != null) {
                if (fileName.endsWith(".edf")) {
                    fileName = String.valueOf(fileName.substring(0, fileName.length() - 4)) + ".txt";
                }
                Transcript.escribirFichero(fileName, BarraMenu.this.gui.getAreaText().getText());
            }
        }
    }

    class HelpListener
    implements ActionListener {
        HelpListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Universo.getMundo().forceCommandNoEco("ayuda");
        }
    }

    class ReiniciarListener
    implements ActionListener {
        ReiniciarListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Universo.getMundo().forceCommandNoEco("reiniciar");
        }
    }

    class Sonido
    implements ActionListener {
        Sonido() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getActionCommand().equals("Activar sonido")) {
                Universo.actDesSonido(true);
            }
            if (arg0.getActionCommand().equals("Desactivar sonido")) {
                Universo.actDesSonido(false);
            }
        }
    }

    class TamFuenteListener
    implements ActionListener {
        TamFuenteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getActionCommand().equals("Agrandar fuente") && BarraMenu.this.gui.getAreaText().getFontSize() < 36) {
                BarraMenu.this.gui.getAreaText().setFontSize(BarraMenu.this.gui.getAreaText().getFontSize() + 2);
            }
            if (arg0.getActionCommand().equals("Disminuir fuente") && BarraMenu.this.gui.getAreaText().getFontSize() > 8) {
                BarraMenu.this.gui.getAreaText().setFontSize(BarraMenu.this.gui.getAreaText().getFontSize() - 2);
            }
        }
    }
}

