/*
 * Decompiled with CFR 0.152.
 */
package componentes;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class PanelTexto
extends JTextPane
implements ActionListener {
    private Border border = BorderFactory.createLineBorder(Color.YELLOW);
    private Color color;
    private int tam;
    private String fuente;
    private Font tipoFuente;
    private Style styleText;
    private DefaultStyledDocument doc;
    private SimpleAttributeSet attrs;
    private JScrollPane scrollPane;

    public PanelTexto() {
        this.setEditable(false);
        this.setBackground(Color.BLACK);
        this.setBorder(BorderFactory.createCompoundBorder(this.border, BorderFactory.createEmptyBorder(20, 20, 20, 20)));
        StyleContext sc = new StyleContext();
        this.doc = new DefaultStyledDocument(sc);
        this.styleText = sc.addStyle("", null);
        this.styleText.addAttribute(StyleConstants.Foreground, Color.WHITE);
        this.color = Color.white;
        this.styleText.addAttribute(StyleConstants.Bold, new Boolean(false));
        this.scrollPane = new JScrollPane(this, 20, 31);
    }

    public JScrollPane getScrollPanel() {
        return this.scrollPane;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }

    public void atributosTexto(Color color, int tam, String font) {
        this.setColorTexto(color);
        this.setFontSize(tam);
        this.setFont(font);
    }

    public void atributosTexto(Color color, int tam, Font font) {
        super.setFont(font);
        this.tipoFuente = font;
        this.setColorTexto(color);
        this.setFontSize(tam);
    }

    public void setColorTexto(Color color) {
        this.color = color;
        this.styleText.addAttribute(StyleConstants.Foreground, color);
    }

    public Color getColorTexto() {
        return this.color;
    }

    public void setColorFondo(Color color) {
        this.setBackground(color);
    }

    public void setFontSize(int tam) {
        this.tam = tam;
        if (this.tipoFuente != null) {
            this.setFont(this.getFont().deriveFont((float)tam));
        }
        this.styleText.addAttribute(StyleConstants.FontSize, new Integer(tam));
    }

    public int getFontSize() {
        return this.tam;
    }

    public void setFont(String font) {
        this.fuente = font;
        this.styleText.addAttribute(StyleConstants.FontFamily, font);
    }

    public void setFuente(Font f) {
        this.setFont(f);
    }

    public String getFuente() {
        return this.fuente;
    }

    public void setUnderline(boolean und) {
        this.styleText.addAttribute(StyleConstants.Underline, und);
    }

    public void setItalic(boolean itl) {
        this.styleText.addAttribute(StyleConstants.Italic, itl);
    }

    public void centrarTexto(boolean c) {
        StyledDocument doc = this.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        if (c) {
            StyleConstants.setAlignment(center, 1);
            doc.setParagraphAttributes(0, this.getText().length(), center, false);
        } else {
            StyleConstants.setAlignment(center, 0);
            doc.setParagraphAttributes(this.getText().length(), doc.getLength(), center, false);
        }
    }

    public void cls() {
        this.setText("");
        this.setCaretPosition(this.getDocument().getLength());
    }

    public void addAtText(String txt) {
        try {
            this.getStyledDocument().insertString(this.getStyledDocument().getLength(), txt, this.styleText);
            this.setCaretPosition(this.getDocument().getLength());
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void append(String s) {
        SimpleAttributeSet red = new SimpleAttributeSet();
        StyleConstants.setForeground(red, Color.red);
        SimpleAttributeSet bold = new SimpleAttributeSet();
        StyleConstants.setBold(red, true);
        SimpleAttributeSet italic = new SimpleAttributeSet();
        StyleConstants.setItalic(red, true);
        StyleConstants.setForeground(italic, this.getColorTexto());
        Document d = this.getDocument();
        try {
            d.insertString(d.getLength(), s, italic);
            this.setCaretPosition(this.getDocument().getLength());
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

