/*
 * Decompiled with CFR 0.152.
 */
package entidad;

import Universo.Mundo;
import Universo.Universo;
import entidad.EntidadIF;
import estancia.Estancia;
import java.util.ArrayList;
import java.util.List;
import parser.Orden;
import parser.PalYGen;
import parser.Palabra;
import propiedades.Accion;
import propiedades.Temporizador;

public class Entidad
extends Universo
implements EntidadIF {
    private String nombreUnico;
    private String descripcion;
    private PalYGen sNombre;
    private boolean nombrePersonal;
    private boolean masculino;
    private boolean visible;
    private List<PalYGen> nombresDeReferencia;
    private PalYGen nombreActualDeReferencia;
    private List<String> adjetivos;
    private String adjetivoActualDeReferencia;
    private Estancia estancia;

    public Entidad(String nombre) {
        if (Mundo.entidad(nombre) != null) {
            System.out.println(" -- Error -- entidades con nombre \u00fanico repetido.");
            throw new IllegalStateException("Entidades con nombre \u00fanico repetido.");
        }
        this.nombreUnico = nombre;
        this.sNombre = new PalYGen(nombre, 1);
        this.visible = true;
        this.nombrePersonal = false;
        this.nombresDeReferencia = new ArrayList<PalYGen>();
        this.adjetivos = new ArrayList<String>();
        this.nombreActualDeReferencia = null;
        this.adjetivoActualDeReferencia = null;
        Mundo.nuevaEntidad(this);
    }

    public Accion parseCommand(Orden orden, ArrayList<Entidad> entidades) {
        return Accion.NEXT;
    }

    public void setNombrePersonal(boolean pN) {
        this.nombrePersonal = pN;
    }

    public boolean getNombrePersonal() {
        return this.nombrePersonal;
    }

    public void setNombreParaMostrar(String sNombre, int gen) {
        PalYGen word;
        if (!PalYGen.generoValido(gen)) {
            gen = 1;
        }
        this.sNombre = word = new PalYGen(sNombre, gen);
    }

    public void setNombreParaMostrar(PalYGen sNombre) {
        this.sNombre = sNombre;
    }

    public String getNombreParaMostrar() {
        this.asignarGenero(this.sNombre);
        return this.sNombre.palabra();
    }

    public PalYGen getShowNameAndGen() {
        return this.sNombre;
    }

    public String getDescripcion() {
        this.descripcion();
        return this.descripcion;
    }

    public boolean esVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public void nuevoNombreDeReferencia(String rfrNombre, int gen) {
        if (!PalYGen.generoValido(gen)) {
            gen = 1;
        }
        PalYGen word = new PalYGen(rfrNombre, gen);
        this.nombresDeReferencia.add(word);
    }

    public void nuevoNombreDeReferencia(PalYGen rfrNombre) {
        this.nombresDeReferencia.add(rfrNombre);
    }

    public String getNombreActualDeReferencia() {
        if (this.nombreActualDeReferencia != null) {
            return this.nombreActualDeReferencia.palabra();
        }
        return null;
    }

    public String getMejorNombreDeReferencia() {
        if (this.nombresDeReferencia.size() > 0) {
            return this.nombresDeReferencia.get(0).palabra();
        }
        return null;
    }

    public PalYGen getMejorNombreDeReferenciaYGenero() {
        if (this.nombresDeReferencia.size() > 0) {
            return this.nombresDeReferencia.get(0);
        }
        return null;
    }

    public PalYGen getnombreActualDeReferenciaYGenero() {
        return this.nombreActualDeReferencia;
    }

    public void setNombreActualDeReferencia(PalYGen nombreRef) {
        this.nombreActualDeReferencia = nombreRef;
    }

    public String getAdjetivoActualDeReferencia() {
        return this.adjetivoActualDeReferencia;
    }

    public void setAdjetivoActualDeReferencia(String rfrAdj) {
        this.adjetivoActualDeReferencia = rfrAdj;
    }

    public String getMejorAdjetivo() {
        if (this.adjetivos.size() > 0) {
            return this.adjetivos.get(0);
        }
        return "";
    }

    public void nuevoAdjetivo(String adj) {
        this.adjetivos.add(adj);
    }

    public boolean matchNombreOk(String byName) {
        byName = byName.trim();
        String[] words = byName.split(" ");
        int i = 0;
        while (i < words.length) {
            words[i] = words[i].trim();
            for (PalYGen aName : this.nombresDeReferencia) {
                if (!aName.palabra().equals(words[i])) continue;
                this.asignarGenero(aName);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean matchNombreOk(ArrayList<Palabra> words) {
        return false;
    }

    public PalYGen getWordAngGen(String word) {
        for (PalYGen aName : this.nombresDeReferencia) {
            if (!aName.palabra().equals(word)) continue;
            return aName;
        }
        return null;
    }

    public String matchAdjetivoOk(String[] byAdj) {
        String[] stringArray = byAdj;
        int n = byAdj.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (this.adjetivos.contains(word)) {
                return word;
            }
            ++n2;
        }
        return null;
    }

    private void asignarGenero(PalYGen pal) {
        if (pal.getGenero() == 11) {
            this.setMasculino(false);
        } else {
            this.setMasculino(true);
        }
    }

    public String getNombre() {
        return this.nombreUnico;
    }

    public Estancia getEstancia() {
        return this.estancia;
    }

    public void setEstancia(Object loc) {
        if (loc instanceof Estancia) {
            this.estancia = (Estancia)loc;
            this.estancia.getInventario().nuevoObjeto(this);
        } else if (loc == null) {
            if (this.estancia != null) {
                this.estancia.getInventario().quitarObjeto(this);
            }
            this.estancia = null;
        }
    }

    public void moverA(Estancia estancia) {
        this.setEstancia(null);
        estancia.anadirObjetoInventario(this);
    }

    public boolean esMasculino() {
        return this.masculino;
    }

    public void setMasculino(boolean male) {
        this.masculino = male;
    }

    public boolean presenteYvisible() {
        return Estancia.getHabitacionActual().tieneAlaVista(this) || Mundo.getJugador().tieneAlaVista(this);
    }

    public boolean presente() {
        return Estancia.getHabitacionActual().tiene(this) || Mundo.getJugador().tiene(this);
    }

    public String toString() {
        return this.getNombreActualDeReferencia();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void descripcion() {
    }

    @Override
    public void post_descripcion() {
    }

    @Override
    public void nombreReferencia() {
    }

    @Override
    public void nombreParaMostrar() {
    }

    @Override
    public void init() {
    }

    @Override
    public void update(Temporizador temp) {
    }
}

