/*
 * Decompiled with CFR 0.152.
 */
package gui;

import componentes.BarraMenu;
import componentes.EntradaTexto;
import componentes.Grafico;
import componentes.Grid;
import componentes.Layout;
import componentes.PanelTexto;
import componentes.Promt;
import componentes.VentanaGrafica;
import exceptions.ErrorEnComponente;
import gui.GuiIF;

public class Gui
implements GuiIF {
    private static VentanaGrafica ventanaPrincipal;
    private Layout layout;
    private PanelTexto panelTexto;
    private Promt promt;
    private EntradaTexto input;
    private Grafico grafico;

    public Gui() {
        ventanaPrincipal = null;
        this.layout = null;
        this.panelTexto = null;
        this.promt = null;
        this.input = null;
        this.crearInterface();
    }

    private void crearInterface() {
        this.crearVentanaGrafica();
        this.crearMenu();
        this.crearAreaTexto();
        this.crearInputText();
        this.crearPromt();
        this.crearZonaGrafica();
        this.crearLayout();
        ventanaPrincipal.getContentPane().add(this.layout);
        ventanaPrincipal.setExtendedState(6);
        ventanaPrincipal.pack();
        ventanaPrincipal.setVisible(true);
    }

    @Override
    public void crearVentanaGrafica() {
        ventanaPrincipal = new VentanaGrafica();
    }

    @Override
    public void crearMenu() {
        new BarraMenu(ventanaPrincipal, this);
    }

    public static VentanaGrafica getVentanaGrafica() {
        return ventanaPrincipal;
    }

    @Override
    public void setTitulo(String nombre) {
        ventanaPrincipal.setTitle(nombre);
    }

    @Override
    public void crearLayout() {
        if (ventanaPrincipal == null) {
            throw new ErrorEnComponente(0);
        }
        this.layout = new Layout();
        new Grid().crearGrid(this.layout, this.panelTexto.getScrollPanel(), this.promt, this.input, this.grafico);
        this.layout.remove(this.grafico);
        ventanaPrincipal.setExtendedState(6);
        ventanaPrincipal.pack();
    }

    @Override
    public Layout getLayout() {
        if (this.layout == null) {
            throw new ErrorEnComponente(1);
        }
        return this.layout;
    }

    @Override
    public void crearAreaTexto() {
        this.panelTexto = new PanelTexto();
    }

    @Override
    public PanelTexto getAreaText() {
        return this.panelTexto;
    }

    @Override
    public void crearInputText() {
        this.input = new EntradaTexto();
    }

    @Override
    public EntradaTexto getInputText() {
        if (this.input == null) {
            throw new ErrorEnComponente(3);
        }
        return this.input;
    }

    @Override
    public void crearZonaGrafica() {
        this.grafico = new Grafico();
    }

    @Override
    public Grafico getZonaGrafica() {
        if (this.grafico == null) {
            throw new ErrorEnComponente(4);
        }
        return this.grafico;
    }

    @Override
    public void setGrafico(String nombre) {
        if (this.grafico == null) {
            throw new ErrorEnComponente(4);
        }
        if (nombre != null && nombre.length() > 0) {
            this.grafico.setImagen(nombre);
            new Grid().crearGrid(this.layout, this.panelTexto.getScrollPanel(), this.promt, this.input, this.grafico);
        } else {
            new Grid().crearGrid(this.layout, this.panelTexto.getScrollPanel(), this.promt, this.input, this.grafico);
            this.layout.remove(this.grafico);
        }
        ventanaPrincipal.setExtendedState(6);
        ventanaPrincipal.setVisible(true);
    }

    @Override
    public void setAlturaGrafico(int alt) {
        double altura = 1.0;
        if (altura < 100.0) {
            altura = (double)alt * 1.0 / 100.0;
        }
        Grid.setAlturaGrafico(altura);
    }

    @Override
    public void crearPromt() {
        this.promt = new Promt();
    }

    @Override
    public Promt getPromt() {
        if (this.promt == null) {
            throw new ErrorEnComponente(2);
        }
        return this.promt;
    }

    @Override
    public void addOrden(String orden) {
        if (this.panelTexto != null) {
            if (this.promt != null) {
                orden = String.valueOf(this.promt.getEcoPromt()) + orden;
            }
            this.addAtText(String.valueOf(orden) + "\n");
            this.input.setText("");
        }
    }

    @Override
    public void addAtText(String orden) {
        this.panelTexto.append(orden);
        this.input.setText("");
    }
}

