/*
 * Decompiled with CFR 0.152.
 */
package objeto;

import Universo.Mundo;
import entidad.Entidad;
import java.util.ArrayList;
import objeto.Objeto;
import parser.Comando;
import parser.Orden;
import propiedades.Accion;

public abstract class ObjetoAbrible
extends Objeto {
    private boolean abierto = true;
    private boolean abrible = true;
    private boolean necesario_llave = false;
    private Objeto llave;
    private boolean cerrado_con_llave;
    private Entidad other;

    public ObjetoAbrible(String name) {
        super(name);
    }

    public boolean necesarioLlave() {
        return this.necesario_llave;
    }

    public void setNecesarioLlave(boolean needKey) {
        this.necesario_llave = needKey;
    }

    public Objeto getLlave() {
        return this.llave;
    }

    public void setLlave(Objeto key) {
        this.llave = key;
    }

    public boolean estaAbierto() {
        return this.abierto;
    }

    public boolean cerradoConLlave() {
        return this.cerrado_con_llave;
    }

    public void setCerradoConLlave(boolean st) {
        this.cerrado_con_llave = st;
    }

    public void setAbierto(boolean open) {
        this.abierto = open;
    }

    public boolean esAbrible() {
        return this.abrible;
    }

    public void setAbrible(boolean openeable) {
        this.abrible = openeable;
    }

    @Override
    public String getDescripcion() {
        char gen = 'o';
        if (!this.esMasculino()) {
            gen = 'a';
        }
        String out = "Est\u00e1 cerrad" + gen + ".";
        if (this.estaAbierto()) {
            out = "Est\u00e1 abiert" + gen + ".";
        } else if (this.necesarioLlave() && this.cerradoConLlave()) {
            out = "Est\u00e1 cerrad" + gen + " y con la llave echada.";
        }
        if (this.esAbrible()) {
            return String.valueOf(super.getDescripcion()) + " " + out;
        }
        return super.getDescripcion();
    }

    @Override
    public Accion parseCommand(Orden command, ArrayList<Entidad> entitys) {
        Accion theResult = this.proccesCommand(command, entitys);
        if (theResult == Accion.NEXT) {
            theResult = super.parseCommand(command, entitys);
        }
        return theResult;
    }

    private Accion proccesCommand(Orden command, ArrayList<Entidad> entitys) {
        if (command.getComando() == Comando.OPEN) {
            Accion action = this.openConditions(command, entitys);
            Accion.execute(action);
            if (action == Accion.OPEN_OK || action == Accion.OPEN_OK_WITH_KEY || action == Accion.ALREADY_OPEN) {
                this.setAbierto(true);
                Mundo.writeln(Accion.printCondition(action, this, this.other));
                return Accion.STOP;
            }
            if (action == Accion.NO_RIGHT_KEY) {
                Mundo.writeln(Accion.printCondition(action, this.other));
                return Accion.STOP;
            }
            return action;
        }
        if (command.getComando() == Comando.CLOSED) {
            Accion action = this.closedConditions(command, entitys);
            Accion.execute(action);
            if (action == Accion.CLOSED_OK || action == Accion.CLOSED_OK_WITH_KEY || action == Accion.ALREADY_CLOSED) {
                this.setAbierto(false);
                Mundo.writeln(Accion.printCondition(action, this, this.other));
                return Accion.STOP;
            }
            return action;
        }
        return Accion.NEXT;
    }

    private Accion openConditions(Orden command, ArrayList<Entidad> entitys) {
        if (this.presenteYvisible() && this.esAbrible()) {
            if (this.estaAbierto()) {
                return Accion.ALREADY_OPEN;
            }
            if (this.necesarioLlave() && this.cerradoConLlave()) {
                if (this.preCondicionLlave(command, entitys)) {
                    this.setCerradoConLlave(false);
                    return Accion.OPEN_OK_WITH_KEY;
                }
                if (entitys.size() > 1) {
                    for (Entidad unaEntidad : entitys) {
                        if (unaEntidad.equals(this)) continue;
                        this.other = unaEntidad;
                        break;
                    }
                    return Accion.NO_RIGHT_KEY;
                }
                return Accion.OPEN_NO_OK_WITH_KEY;
            }
            return Accion.OPEN_OK;
        }
        return Accion.LOOK_NO_OK;
    }

    private Accion closedConditions(Orden command, ArrayList<Entidad> entitys) {
        if (this.presenteYvisible() && this.esAbrible()) {
            if (!this.estaAbierto()) {
                if (this.necesarioLlave() && !this.cerradoConLlave() && this.preCondicionLlave(command, entitys)) {
                    this.setCerradoConLlave(true);
                    return Accion.CLOSED_OK_WITH_KEY;
                }
                if (this.necesarioLlave() && !this.preCondicionLlave(command, entitys) && !this.cerradoConLlave()) {
                    Mundo.writeln(Accion.printCondition(Accion.CLOSED_NO_OK_WITH_KEY, new Entidad[0]));
                }
                return Accion.ALREADY_CLOSED;
            }
            if (this.preCondicionLlave(command, entitys)) {
                this.setCerradoConLlave(true);
                return Accion.CLOSED_OK_WITH_KEY;
            }
            return Accion.CLOSED_OK;
        }
        return Accion.LOOK_NO_OK;
    }

    private boolean preCondicionLlave(Orden orden, ArrayList<Entidad> entidades) {
        if (entidades.contains(this.llave)) {
            if (!Mundo.getJugador().tieneAlaVista(this.llave)) {
                return false;
            }
            this.other = this.llave;
            return true;
        }
        if (Mundo.getJugador().tieneAlaVista(this.llave)) {
            this.other = this.llave;
            return true;
        }
        return false;
    }
}

