/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.ArrayList;
import java.util.HashMap;
import parser.Comando;
import parser.Palabra;

public class Comandos {
    private static HashMap<String, Comando> validCommands;

    public static void crearComandos() {
        validCommands = new HashMap();
        Comando[] comandoArray = Comando.values();
        int n = comandoArray.length;
        int n2 = 0;
        while (n2 < n) {
            Comando command = comandoArray[n2];
            if (command != Comando.UNKNOWN) {
                validCommands.put(command.toString(), command);
            }
            ++n2;
        }
    }

    public static Comando getComando(String commandWord) {
        Comando command = validCommands.get(commandWord);
        if (command != null) {
            return command;
        }
        return Comando.UNKNOWN;
    }

    public static boolean esComando(String aString) {
        if (validCommands == null) {
            return false;
        }
        return validCommands.containsKey(aString);
    }

    public static boolean buscarComandoValido(ArrayList<Palabra> words) {
        for (Palabra unaPalabra : words) {
            if (!Comandos.esComando(unaPalabra.palabra())) continue;
            return true;
        }
        return false;
    }

    public static void showAll() {
        for (String command : validCommands.keySet()) {
            System.out.print(String.valueOf(command) + "  ");
        }
        System.out.println();
    }
}

