/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.ArrayList;
import java.util.StringTokenizer;
import parser.Palabra;

public class SeparadorPorPalabras {
    private ArrayList<Palabra> fraseSeparada = new ArrayList();

    public void separarYguardar(String Intext) {
        Intext = Intext.toLowerCase();
        int i = 0;
        StringTokenizer st = new StringTokenizer(Intext);
        while (st.hasMoreTokens()) {
            String aux_s = st.nextToken();
            Palabra aux = new Palabra(aux_s);
            aux.setPosicion(i);
            this.fraseSeparada.add(aux);
            ++i;
        }
    }

    public void imprimir() {
        System.out.println("La frase separada:");
        for (Palabra palabras : this.fraseSeparada) {
            System.out.println(" - " + palabras);
        }
    }

    public ArrayList<Palabra> getFraseSeparada() {
        return this.fraseSeparada;
    }

    public static ArrayList<Palabra> listarFraseEnPalabras(String inText) {
        SeparadorPorPalabras frase = new SeparadorPorPalabras();
        frase.separarYguardar(inText);
        return frase.getFraseSeparada();
    }

    public static int posicionPalabra(String word, String inText) {
        int out = -1;
        SeparadorPorPalabras frase = new SeparadorPorPalabras();
        frase.separarYguardar(inText);
        boolean encontrado = false;
        int i = 0;
        while (!encontrado && i < frase.getFraseSeparada().size()) {
            if (frase.getFraseSeparada().get(i).palabra().equals(word)) {
                out = frase.getFraseSeparada().get(i).getPosicion();
                encontrado = true;
            }
            ++i;
        }
        return out;
    }

    public static Palabra palabraPorPosicion(ArrayList<Palabra> frase, int pos) {
        for (Palabra unaPalabra : frase) {
            if (unaPalabra.getPosicion() != pos) continue;
            return unaPalabra;
        }
        return null;
    }

    public static ArrayList<Palabra> eliminarPalabra(ArrayList<Palabra> in, Palabra pal) {
        boolean auxRestarPosicion = false;
        ArrayList<Palabra> resultado = new ArrayList<Palabra>();
        for (Palabra unaPalabra : in) {
            if (unaPalabra.equals(pal)) {
                auxRestarPosicion = true;
                continue;
            }
            if (auxRestarPosicion) {
                unaPalabra.setPosicion(unaPalabra.getPosicion() - 1);
            }
            resultado.add(unaPalabra);
        }
        return resultado;
    }

    public static ArrayList<Palabra> eliminarPalabra(ArrayList<Palabra> in, ArrayList<Palabra> pal) {
        ArrayList<Palabra> out = new ArrayList<Palabra>();
        for (Palabra unaPalabra : in) {
            boolean iguales = false;
            for (Palabra otraPalabra : pal) {
                if (!unaPalabra.igual(otraPalabra)) continue;
                iguales = true;
            }
            if (iguales) continue;
            out.add(unaPalabra);
        }
        return out;
    }

    public static String eliminarPalabraDeCadena(String inText, String frase) {
        String output = "";
        String[] words = frase.split(" ");
        int i = 0;
        while (i < words.length) {
            words[i] = words[i].trim();
            if (words[i].equals(inText)) {
                words[i] = " ";
                break;
            }
            ++i;
        }
        i = 0;
        while (i < words.length) {
            output = String.valueOf(output) + words[i] + " ";
            ++i;
        }
        return output.trim();
    }
}

