/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.ArrayList;
import java.util.HashMap;
import parser.Castellano;
import parser.ErrorAlCrearVerbo;
import parser.Palabra;
import parser.Verbo;

public class Verbos
extends Verbo
implements Castellano {
    private boolean irregular;
    private String conjugacion;
    private String infinitivo;
    private String raiz;
    private HashMap<String, String> verbosEnUnTiempo;
    private HashMap<String, HashMap<String, String>> tiemposVerbalesConjugados;
    private ArrayList<String[]> morfemas;
    private static ArrayList<String> listaInfinitivos = new ArrayList();
    private static ArrayList<Verbos> listaVerbos = new ArrayList();

    public Verbos(String infinitivo, String raiz, String conjugacion, boolean irregular) {
        super(infinitivo);
        super.nuevoVerbo(infinitivo);
        this.rellenarMormefa(conjugacion);
        this.tiemposVerbalesConjugados = new HashMap();
        this.conjugacion = conjugacion;
        this.infinitivo = infinitivo.toLowerCase().trim();
        this.raiz = raiz.toLowerCase().trim();
        this.irregular = irregular;
        this.compruebaDatosConstructor(this.infinitivo, this.raiz, this.conjugacion);
        listaInfinitivos.add(infinitivo);
        this.conjugarVerbo();
        listaVerbos.add(this);
    }

    public Verbos(String infinitivo) {
        super(infinitivo);
        super.nuevoVerbo(infinitivo);
        this.tiemposVerbalesConjugados = new HashMap();
        this.infinitivo = infinitivo.toLowerCase().trim();
        this.conjugacion = "UNICA";
        this.raiz = infinitivo.toLowerCase().trim();
        this.irregular = true;
        listaInfinitivos.add(infinitivo);
        this.conjugarVerbo();
        listaVerbos.add(this);
    }

    private void compruebaDatosConstructor(String infinitivo, String raiz, String conjugacion) {
        boolean conjugacion_ok = (conjugacion.equals("PRIMERA") || conjugacion.equals("SEGUNDA") || conjugacion.equals("TERCERA")) && conjugacion.length() != 0;
        boolean infinitivo_ok = infinitivo.length() != 0 ? this.textoSoloConLetras(infinitivo) : false;
        boolean raiz_ok = raiz.length() != 0 && infinitivo.startsWith(raiz) ? this.textoSoloConLetras(raiz) : false;
        if (!(conjugacion_ok && infinitivo_ok && raiz_ok)) {
            throw new ErrorAlCrearVerbo(infinitivo_ok, raiz_ok, conjugacion_ok);
        }
    }

    private boolean compruebaTiempoVerbal(String tiempo_verbal) {
        boolean aux = false;
        String[] stringArray = tiemposVerbales;
        int n = tiemposVerbales.length;
        int n2 = 0;
        while (n2 < n) {
            String unTiempo = stringArray[n2];
            if (unTiempo.equals(tiempo_verbal)) {
                aux = true;
            }
            ++n2;
        }
        return aux;
    }

    private boolean compruebaPersona(String unaPersona) {
        int i = 0;
        while (i < persona.length) {
            if (persona[i].equals(unaPersona)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean textoSoloConLetras(String inText) {
        boolean resultado = true;
        int i = 0;
        while (i < inText.length() && resultado) {
            int c = inText.codePointAt(i);
            if (c >= 65 && c <= 90 || c >= 97 && c <= 122) {
                ++i;
                continue;
            }
            resultado = false;
        }
        return resultado;
    }

    private void rellenarMormefa(String conjugacion) {
        this.morfemas = new ArrayList();
        if (conjugacion.equals("PRIMERA")) {
            String[][] stringArray = AR;
            int n = AR.length;
            int n2 = 0;
            while (n2 < n) {
                String[] morfemasPrimera = stringArray[n2];
                this.morfemas.add(morfemasPrimera);
                ++n2;
            }
        } else if (conjugacion.equals("SEGUNDA")) {
            String[][] stringArray = ER;
            int n = ER.length;
            int n3 = 0;
            while (n3 < n) {
                String[] morfemasSegunda = stringArray[n3];
                this.morfemas.add(morfemasSegunda);
                ++n3;
            }
        } else if (conjugacion.equals("TERCERA")) {
            String[][] stringArray = IR;
            int n = IR.length;
            int n4 = 0;
            while (n4 < n) {
                String[] morfemasTercera = stringArray[n4];
                this.morfemas.add(morfemasTercera);
                ++n4;
            }
        }
        if (!conjugacion.equals("UNICA") && this.morfemas.size() != tiemposVerbales.length) {
            throw new IllegalStateException("Longitud de lista de morfemas no coincide con la cantidad de tiempos verbales.");
        }
    }

    private void conjugarVerbo() {
        int j = 0;
        while (j < tiemposVerbales.length) {
            this.verbosEnUnTiempo = new HashMap();
            int i = 0;
            while (i < persona.length) {
                if (this.conjugacion.equals("UNICA")) {
                    this.verbosEnUnTiempo.put(persona[i], this.raiz);
                } else {
                    this.verbosEnUnTiempo.put(persona[i], String.valueOf(this.raiz) + this.morfemas.get(j)[i]);
                }
                ++i;
            }
            this.tiemposVerbalesConjugados.put(tiemposVerbales[j], this.verbosEnUnTiempo);
            ++j;
        }
    }

    private String imprimiblePersona(String unaPersona) {
        if (persona[0].equals(unaPersona)) {
            return "yo";
        }
        if (persona[1].equals(unaPersona)) {
            return "t\u00fa";
        }
        if (persona[2].equals(unaPersona)) {
            return "\u00e9l";
        }
        if (persona[3].equals(unaPersona)) {
            return "nosotros";
        }
        if (persona[4].equals(unaPersona)) {
            return "vosotros";
        }
        if (persona[5].equals(unaPersona)) {
            return "ellos";
        }
        return null;
    }

    public String getInfinitivo() {
        return this.infinitivo;
    }

    public String getRaiz() {
        return this.raiz;
    }

    public boolean getIrregular() {
        return this.irregular;
    }

    public String getConjugacion() {
        return this.conjugacion;
    }

    public boolean esUnico() {
        return this.conjugacion.equals("UNICA");
    }

    public HashMap<String, String> getConjugados(String tiempo_verbal) {
        if (!this.compruebaTiempoVerbal(tiempo_verbal)) {
            throw new IllegalStateException("El tiempo verbal para conjugar el verbo no es correcto.");
        }
        return this.tiemposVerbalesConjugados.get(tiempo_verbal);
    }

    public String getVerboConjugado(String tiempo_verbal, String persona) {
        if (!this.compruebaTiempoVerbal(tiempo_verbal)) {
            throw new IllegalStateException("El tiempo verbal para conjugar el verbo no es correcto.");
        }
        if (!this.compruebaPersona(persona)) {
            throw new IllegalStateException("La persona para conjugar el verbo no es correcto.");
        }
        return this.tiemposVerbalesConjugados.get(tiempo_verbal).get(persona);
    }

    public boolean buscarVerbo(String elVerbo) {
        String[] stringArray = tiemposVerbales;
        int n = tiemposVerbales.length;
        int n2 = 0;
        while (n2 < n) {
            String unTiempo = stringArray[n2];
            HashMap<String, String> auxHash = this.tiemposVerbalesConjugados.get(unTiempo);
            if (auxHash.containsValue(elVerbo)) {
                return true;
            }
            if (elVerbo.equals(this.infinitivo)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public ArrayList<String> buscarPersona(String elVerbo) {
        ArrayList<String> resultado = new ArrayList<String>();
        String[] stringArray = tiemposVerbales;
        int n = tiemposVerbales.length;
        int n2 = 0;
        while (n2 < n) {
            String unTiempo = stringArray[n2];
            HashMap<String, String> auxHash = this.tiemposVerbalesConjugados.get(unTiempo);
            String[] stringArray2 = persona;
            int n3 = persona.length;
            int n4 = 0;
            while (n4 < n3) {
                String unaPersona = stringArray2[n4];
                if (elVerbo.equals(auxHash.get(unaPersona))) {
                    resultado.add(this.imprimiblePersona(unaPersona));
                }
                ++n4;
            }
            ++n2;
        }
        return resultado;
    }

    public String buscarTiempo(String elVerbo) {
        String[] stringArray = tiemposVerbales;
        int n = tiemposVerbales.length;
        int n2 = 0;
        while (n2 < n) {
            String unTiempo = stringArray[n2];
            HashMap<String, String> auxHash = this.tiemposVerbalesConjugados.get(unTiempo);
            String[] stringArray2 = persona;
            int n3 = persona.length;
            int n4 = 0;
            while (n4 < n3) {
                String unaPersona = stringArray2[n4];
                if (elVerbo.equals(auxHash.get(unaPersona))) {
                    return unTiempo;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public void setConjugadoIrregular(String persona, String verbo, String tiempo_verbal) {
        if (!this.compruebaTiempoVerbal(tiempo_verbal)) {
            throw new IllegalStateException("El tiempo verbal para conjugar el verbo no es correcto.");
        }
        if (!this.compruebaPersona(persona)) {
            throw new IllegalStateException("La persona para conjugar el verbo no es correcto.");
        }
        HashMap<String, String> auxHash = this.tiemposVerbalesConjugados.get(tiempo_verbal);
        auxHash.put(persona, verbo);
        this.tiemposVerbalesConjugados.put(tiempo_verbal, auxHash);
    }

    public static ArrayList<String> listaInfinitivos() {
        return listaInfinitivos;
    }

    public static ArrayList<Verbos> listaDeVerbos() {
        return listaVerbos;
    }

    public static void borrarLista() {
        listaInfinitivos.clear();
        listaVerbos.clear();
    }

    public static void crearVerbo(String infinitivo, String raiz, String conjugacion, boolean irregular) {
        try {
            if (Verbos.buscarUnVerbo(infinitivo) != null) {
                return;
            }
            new Verbos(infinitivo, raiz, conjugacion, irregular);
        }
        catch (Exception e) {
            System.out.println("Creando el verbo " + infinitivo);
            System.out.println(e);
        }
    }

    public static void crearVerboUnico(String infinitivo) {
        if (Verbos.buscarUnVerbo(infinitivo) != null) {
            return;
        }
        new Verbos(infinitivo);
    }

    public static void anadirFormaVerbal(String infinitivo, String persona, String tiempo_verbal, String verbo) {
        for (Verbos unVerbo : listaVerbos) {
            if (!unVerbo.buscarVerbo(infinitivo)) continue;
            unVerbo.setConjugadoIrregular(persona, verbo, tiempo_verbal);
        }
    }

    public static ArrayList<Palabra> buscarTodosLosVerbos(ArrayList<Palabra> inText) {
        ArrayList<Palabra> laLista = new ArrayList<Palabra>();
        for (Palabra unaPalabra : inText) {
            for (Verbos unVerbo : Verbos.listaDeVerbos()) {
                if (!unVerbo.buscarVerbo(unaPalabra.palabra()) || laLista.contains(unVerbo)) continue;
                laLista.add(unVerbo);
            }
        }
        return laLista;
    }

    public static Palabra buscarUnVerbo(ArrayList<Palabra> inText) {
        for (Palabra unaPalabra : inText) {
            for (Verbos unVerbo : Verbos.listaDeVerbos()) {
                if (unaPalabra == null || !unVerbo.buscarVerbo(unaPalabra.palabra())) continue;
                return unaPalabra;
            }
        }
        return null;
    }

    public static String buscarUnVerbo(String inText) {
        String terminacion = "";
        for (Verbos unVerbo : Verbos.listaDeVerbos()) {
            if (!unVerbo.buscarVerbo(inText)) continue;
            return (String.valueOf(unVerbo.getInfinitivo()) + terminacion).trim();
        }
        if (inText.length() > 2 && (inText.endsWith("la") || inText.endsWith("lo") || inText.endsWith("me") || inText.endsWith("te") || inText.endsWith("se"))) {
            terminacion = inText.substring(inText.length() - 2, inText.length());
            inText = inText.substring(0, inText.length() - 2);
        } else if (inText.length() > 3 && (inText.endsWith("las") || inText.endsWith("los"))) {
            terminacion = inText.substring(inText.length() - 3, inText.length());
            inText = inText.substring(0, inText.length() - 3);
        }
        for (Verbos unVerbo : Verbos.listaDeVerbos()) {
            if (!unVerbo.buscarVerbo(inText)) continue;
            return (String.valueOf(unVerbo.getInfinitivo()) + terminacion).trim();
        }
        return null;
    }
}

