/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class Utility {
    public static final String room_preffix = "10";
    public static final String mobile_preffix = "20";
    public static final String item_preffix = "30";
    public static final int room_summand = 10000000;
    public static final int mobile_summand = 20000000;
    public static final int item_summand = 30000000;

    public static InputStreamReader getBestInputStreamReader(InputStream inputStream) {
        InputStreamReader inputStreamReader;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("PELIGRO: Codificaci\u00f3n de caracteres ISO-8859-1 no soportada por la VM. Pueden verse mal algunos caracteres.\n");
            inputStreamReader = new InputStreamReader(inputStream);
        }
        return inputStreamReader;
    }

    public static OutputStreamWriter getBestOutputStreamWriter(OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter;
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("PELIGRO: Codificaci\u00f3n de caracteres ISO-8859-1 no soportada por la VM. Pueden verse mal algunos caracteres.\n");
            outputStreamWriter = new OutputStreamWriter(outputStream);
        }
        return outputStreamWriter;
    }

    public static int completeRoomID(int n2) {
        return n2 > 10000000 ? n2 : n2 + 10000000;
    }

    public static int completeItemID(int n2) {
        return n2 > 30000000 ? n2 : n2 + 30000000;
    }

    public static int completeMobileID(int n2) {
        return n2 > 20000000 ? n2 : n2 + 20000000;
    }

    public static String completeWithZeroes(int n2, int n3) {
        String string = String.valueOf(n2);
        while (string.length() < n3) {
            string = "0" + string;
        }
        return string;
    }

    public static String roomFile(World world, int n2) {
        String string = Utility.completeWithZeroes(n2, 6);
        return world.getWorldDir() + "objects" + File.separatorChar + room_preffix + string + ".ae";
    }

    public static String itemFile(World world, int n2) {
        String string = Utility.completeWithZeroes(n2, 6);
        return world.getWorldDir() + "objects" + File.separatorChar + item_preffix + string + ".ae";
    }

    public static String playerFile(World world) {
        return world.getWorldDir() + "objects" + File.separatorChar + mobile_preffix + "000000" + ".ae";
    }

    public static String mobFile(World world, int n2) {
        String string = Utility.completeWithZeroes(n2, 6);
        return world.getWorldDir() + "objects" + File.separatorChar + mobile_preffix + string + ".ae";
    }

    public static l[] loadDescriptionListFromString(String string) {
        if (string == null) {
            return new l[0];
        }
        if (string.indexOf(38) < 0) {
            l[] lArray = new l[]{new l(string, 0L, 0L)};
            return lArray;
        }
        l[] lArray = new l[StringMethods.numToks(string, '&') / 3];
        int n2 = 0;
        while (n2 + 3 <= StringMethods.numToks(string, '&')) {
            String string2 = StringMethods.getTok(string, n2 + 3, '&');
            long l2 = Long.valueOf(StringMethods.getTok(string, n2 + 1, '&'));
            long l3 = Long.valueOf(StringMethods.getTok(string, n2 + 2, '&'));
            lArray[n2 / 3] = new l(StringMethods.textualSubstitution(string2, "\\n", "\n"), l2, l3);
            n2 += 3;
        }
        return lArray;
    }
}

