/*
 * Decompiled with CFR 0.152.
 */
package bsh.util;

import bsh.ConsoleInterface;
import bsh.Interpreter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.peer.TextComponentPeer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Vector;

public class AWTConsole
extends TextArea
implements ConsoleInterface,
Runnable,
KeyListener {
    private OutputStream outPipe;
    private InputStream inPipe;
    private InputStream in;
    private PrintStream out;
    private StringBuffer line = new StringBuffer();
    private String startedLine;
    private int textLength = 0;
    private Vector history = new Vector();
    private int histLine = 0;

    public Reader getIn() {
        return new InputStreamReader(this.in);
    }

    public PrintStream getOut() {
        return this.out;
    }

    public PrintStream getErr() {
        return this.out;
    }

    public AWTConsole(int n2, int n3, InputStream inputStream, OutputStream outputStream) {
        super(n2, n3);
        this.setFont(new Font("Monospaced", 0, 14));
        this.setEditable(false);
        this.addKeyListener(this);
        this.outPipe = outputStream;
        if (this.outPipe == null) {
            this.outPipe = new PipedOutputStream();
            try {
                this.in = new PipedInputStream((PipedOutputStream)this.outPipe);
            }
            catch (IOException iOException) {
                this.print("Console internal error...");
            }
        }
        this.inPipe = inputStream;
        new Thread(this).start();
        this.requestFocus();
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.type(keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getModifiers());
        keyEvent.consume();
    }

    public AWTConsole() {
        this(12, 80, null, null);
    }

    public AWTConsole(InputStream inputStream, OutputStream outputStream) {
        this(12, 80, inputStream, outputStream);
    }

    public void type(int n2, char c2, int n3) {
        switch (n2) {
            case 8: {
                if (this.line.length() <= 0) break;
                this.line.setLength(this.line.length() - 1);
                this.replaceRange("", this.textLength - 1, this.textLength);
                --this.textLength;
                break;
            }
            case 10: {
                this.enter();
                break;
            }
            case 85: {
                if ((n3 & 2) > 0) {
                    int n4 = this.line.length();
                    this.replaceRange("", this.textLength - n4, this.textLength);
                    this.line.setLength(0);
                    this.histLine = 0;
                    this.textLength = this.getText().length();
                    break;
                }
                this.doChar(c2);
                break;
            }
            case 38: {
                this.historyUp();
                break;
            }
            case 40: {
                this.historyDown();
                break;
            }
            case 9: {
                this.line.append("    ");
                this.append("    ");
                this.textLength += 4;
                break;
            }
            case 67: {
                if ((n3 & 2) > 0) {
                    this.line.append("^C");
                    this.append("^C");
                    this.textLength += 2;
                    break;
                }
                this.doChar(c2);
                break;
            }
            default: {
                this.doChar(c2);
            }
        }
    }

    private void doChar(char c2) {
        if (c2 >= ' ' && c2 <= '~') {
            this.line.append(c2);
            this.append(String.valueOf(c2));
            ++this.textLength;
        }
    }

    private void enter() {
        String string;
        if (this.line.length() == 0) {
            string = ";\n";
        } else {
            string = this.line + "\n";
            this.history.addElement(this.line.toString());
        }
        this.line.setLength(0);
        this.histLine = 0;
        this.append("\n");
        this.textLength = this.getText().length();
        this.acceptLine(string);
        this.setCaretPosition(this.textLength);
    }

    public void setCaretPosition(int n2) {
        ((TextComponentPeer)this.getPeer()).setCaretPosition(n2 + this.countNLs());
    }

    private int countNLs() {
        String string = this.getText();
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            if (string.charAt(n3) == '\n') {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    private void historyUp() {
        if (this.history.size() == 0) {
            return;
        }
        if (this.histLine == 0) {
            this.startedLine = this.line.toString();
        }
        if (this.histLine < this.history.size()) {
            ++this.histLine;
            this.showHistoryLine();
        }
    }

    private void historyDown() {
        if (this.histLine == 0) {
            return;
        }
        --this.histLine;
        this.showHistoryLine();
    }

    private void showHistoryLine() {
        String string = this.histLine == 0 ? this.startedLine : (String)this.history.elementAt(this.history.size() - this.histLine);
        this.replaceRange(string, this.textLength - this.line.length(), this.textLength);
        this.line = new StringBuffer(string);
        this.textLength = this.getText().length();
    }

    private void acceptLine(String string) {
        if (this.outPipe == null) {
            this.print("Console internal error...");
        } else {
            try {
                this.outPipe.write(string.getBytes());
                this.outPipe.flush();
            }
            catch (IOException iOException) {
                this.outPipe = null;
                throw new RuntimeException("Console pipe broken...");
            }
        }
    }

    public void println(String string) {
        this.print(string + "\n");
    }

    public void error(String string) {
        this.print(string, Color.red);
    }

    public void print(String string, Color color) {
        this.print("*** " + string);
    }

    public synchronized void print(String string) {
        this.append(string);
        this.textLength = this.getText().length();
    }

    private void inPipeWatcher() throws IOException {
        int n2;
        Object object;
        if (this.inPipe == null) {
            object = new PipedOutputStream();
            this.out = new PrintStream((OutputStream)object);
            this.inPipe = new PipedInputStream((PipedOutputStream)object);
        }
        object = new byte[256];
        while ((n2 = this.inPipe.read((byte[])object)) != -1) {
            this.print(new String((byte[])object, 0, n2));
        }
        this.println("Console: Input closed...");
    }

    public void run() {
        try {
            this.inPipeWatcher();
        }
        catch (IOException iOException) {
            this.println("Console: I/O Error...");
        }
    }

    public static void main(String[] stringArray) {
        AWTConsole aWTConsole = new AWTConsole();
        final Frame frame = new Frame("Bsh Console");
        frame.add((Component)aWTConsole, "Center");
        frame.pack();
        frame.show();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                frame.dispose();
            }
        });
        Interpreter interpreter = new Interpreter(aWTConsole);
        interpreter.run();
    }

    public String toString() {
        return "BeanShell AWTConsole";
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

