/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ui;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ui.DecorativeIconPanel;
import org.fife.rsta.ui.search.AbstractSearchDialog;

public class AssistanceIconPanel
extends DecorativeIconPanel
implements FocusListener,
PropertyChangeListener {
    private static String ASSISTANCE_AVAILABLE;

    public AssistanceIconPanel(JComponent comp) {
        if (comp != null) {
            if (comp instanceof JComboBox) {
                JComboBox combo = (JComboBox)comp;
                Component c = combo.getEditor().getEditorComponent();
                if (c instanceof JTextComponent) {
                    JTextComponent tc = (JTextComponent)c;
                    tc.addFocusListener(this);
                }
            } else {
                comp.addFocusListener(this);
            }
            comp.addPropertyChangeListener("AssistanceImage", this);
        }
    }

    public void focusGained(FocusEvent e) {
        this.setShowIcon(true);
    }

    public void focusLost(FocusEvent e) {
        this.setShowIcon(false);
    }

    static String getAssistanceAvailableText() {
        if (ASSISTANCE_AVAILABLE == null) {
            ASSISTANCE_AVAILABLE = AbstractSearchDialog.getString("ContentAssistAvailable");
        }
        return ASSISTANCE_AVAILABLE;
    }

    public void propertyChange(PropertyChangeEvent e) {
        Image img = (Image)e.getNewValue();
        this.setAssistanceEnabled(img);
    }

    public void setAssistanceEnabled(Image img) {
        if (img == null && this.getIcon() != EMPTY_ICON) {
            this.setIcon((Icon)EMPTY_ICON);
            this.setToolTipText(null);
        } else {
            this.setIcon(new ImageIcon(img));
            this.setToolTipText(AssistanceIconPanel.getAssistanceAvailableText());
        }
    }
}

