/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ui.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ui.UIUtil;
import org.fife.rsta.ui.search.AbstractSearchDialog;

public abstract class AbstractFindReplaceDialog
extends AbstractSearchDialog
implements ActionListener {
    public static final String ACTION_FIND = "FindNext";
    public static final String ACTION_REPLACE = "Replace";
    public static final String ACTION_REPLACE_ALL = "ReplaceAll";
    public static final String MARK_ALL_PROPERTY = "SearchDialog.MarkAll";
    public static final String SEARCH_DOWNWARD_PROPERTY = "SearchDialog.SearchDownward";
    protected JRadioButton upButton;
    protected JRadioButton downButton;
    protected JPanel dirPanel;
    private String dirPanelTitle;
    protected JLabel findFieldLabel;
    protected JButton findNextButton;
    protected JCheckBox markAllCheckBox;
    private EventListenerList listenerList;

    public AbstractFindReplaceDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    public AbstractFindReplaceDialog(Frame owner) {
        super(owner);
        this.init();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("UpRadioButtonClicked".equals(command)) {
            this.context.setSearchForward(false);
            this.firePropertyChange(SEARCH_DOWNWARD_PROPERTY, true, false);
        } else if ("DownRadioButtonClicked".equals(command)) {
            this.context.setSearchForward(true);
            this.firePropertyChange(SEARCH_DOWNWARD_PROPERTY, false, true);
        } else if ("MarkAll".equals(command)) {
            boolean checked = this.markAllCheckBox.isSelected();
            this.context.setMarkAll(checked);
            this.firePropertyChange(MARK_ALL_PROPERTY, !checked, checked);
        } else if (ACTION_FIND.equals(command)) {
            this.findTextCombo.addItem(AbstractFindReplaceDialog.getTextComponent(this.findTextCombo).getText());
            this.context.setSearchFor(this.getSearchString());
            if (this.findTextCombo.getSelectedIndex() > 0) {
                Object item = this.findTextCombo.getSelectedItem();
                this.findTextCombo.removeItem(item);
                this.findTextCombo.insertItemAt(item, 0);
                this.findTextCombo.setSelectedIndex(0);
            }
            this.fireActionPerformed(e);
        } else {
            super.actionPerformed(e);
        }
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void changeActionListener(ActionListener fromPanel, ActionListener toPanel) {
        this.removeActionListener(fromPanel);
        this.addActionListener(toPanel);
    }

    protected void fireActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$java$awt$event$ActionListener == null ? AbstractFindReplaceDialog.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            if (e == null) {
                String command = event.getActionCommand();
                e = new ActionEvent(this, 1001, command, event.getWhen(), event.getModifiers());
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public final String getDownRadioButtonText() {
        return this.downButton.getText();
    }

    public final String getFindButtonText() {
        return this.findNextButton.getText();
    }

    public final String getFindWhatLabelText() {
        return this.findFieldLabel.getText();
    }

    public final String getSearchButtonsBorderText() {
        return this.dirPanelTitle;
    }

    public final String getUpRadioButtonText() {
        return this.upButton.getText();
    }

    protected AbstractSearchDialog.EnableResult handleToggleButtons() {
        AbstractSearchDialog.EnableResult er = super.handleToggleButtons();
        boolean enable = er.getEnable();
        this.findNextButton.setEnabled(enable);
        JTextComponent tc = AbstractFindReplaceDialog.getTextComponent(this.findTextCombo);
        tc.setForeground(enable ? UIManager.getColor("TextField.foreground") : Color.RED);
        String tooltip = er.getToolTip();
        if (tooltip != null && tooltip.indexOf(10) > -1) {
            tooltip = tooltip.replaceFirst("\\\n", "</b><br><pre>");
            tooltip = "<html><b>" + tooltip;
        }
        tc.setToolTipText(tooltip);
        return er;
    }

    private void init() {
        this.listenerList = new EventListenerList();
        this.dirPanel = new JPanel();
        this.dirPanel.setLayout(new BoxLayout(this.dirPanel, 2));
        this.setSearchButtonsBorderText(AbstractFindReplaceDialog.getString("Direction"));
        ButtonGroup bg = new ButtonGroup();
        this.upButton = new JRadioButton(AbstractFindReplaceDialog.getString("Up"), false);
        this.upButton.setMnemonic((int)AbstractFindReplaceDialog.getString("UpMnemonic").charAt(0));
        this.downButton = new JRadioButton(AbstractFindReplaceDialog.getString("Down"), true);
        this.downButton.setMnemonic((int)AbstractFindReplaceDialog.getString("DownMnemonic").charAt(0));
        this.upButton.setActionCommand("UpRadioButtonClicked");
        this.upButton.addActionListener(this);
        this.downButton.setActionCommand("DownRadioButtonClicked");
        this.downButton.addActionListener(this);
        bg.add(this.upButton);
        bg.add(this.downButton);
        this.dirPanel.add(this.upButton);
        this.dirPanel.add(this.downButton);
        this.markAllCheckBox = new JCheckBox(AbstractFindReplaceDialog.getString("MarkAll"));
        this.markAllCheckBox.setMnemonic((int)AbstractFindReplaceDialog.getString("MarkAllMnemonic").charAt(0));
        this.markAllCheckBox.setActionCommand("MarkAll");
        this.markAllCheckBox.addActionListener(this);
        this.searchConditionsPanel.removeAll();
        this.searchConditionsPanel.setLayout(new BorderLayout());
        JPanel temp = new JPanel();
        temp.setLayout(new BoxLayout(temp, 3));
        temp.add(this.caseCheckBox);
        temp.add(this.wholeWordCheckBox);
        this.searchConditionsPanel.add((Component)temp, "Before");
        temp = new JPanel();
        temp.setLayout(new BoxLayout(temp, 3));
        temp.add(this.regExpCheckBox);
        temp.add(this.markAllCheckBox);
        this.searchConditionsPanel.add((Component)temp, "After");
        this.findFieldLabel = UIUtil.newLabel(this.getBundle(), "FindWhat", this.findTextCombo);
        this.findNextButton = UIUtil.newButton(this.getBundle(), "Find");
        this.findNextButton.setActionCommand(ACTION_FIND);
        this.findNextButton.addActionListener(this);
        this.findNextButton.setDefaultCapable(true);
        this.findNextButton.setEnabled(false);
        this.installKeyboardActions();
    }

    private void installKeyboardActions() {
        JRootPane rootPane = this.getRootPane();
        InputMap im = rootPane.getInputMap(1);
        ActionMap am = rootPane.getActionMap();
        int modifier = this.getToolkit().getMenuShortcutKeyMask();
        KeyStroke ctrlF = KeyStroke.getKeyStroke(70, modifier);
        im.put(ctrlF, "focusSearchForField");
        am.put("focusSearchForField", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AbstractFindReplaceDialog.this.requestFocus();
            }
        });
    }

    protected void refreshUIFromContext() {
        super.refreshUIFromContext();
        this.markAllCheckBox.setSelected(this.context.getMarkAll());
        boolean searchForward = this.context.getSearchForward();
        this.upButton.setSelected(!searchForward);
        this.downButton.setSelected(searchForward);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public void setDownRadioButtonText(String text) {
        this.downButton.setText(text);
    }

    public final void setFindButtonText(String text) {
        this.findNextButton.setText(text);
    }

    public void setFindWhatLabelText(String text) {
        this.findFieldLabel.setText(text);
    }

    public final void setSearchButtonsBorderText(String text) {
        this.dirPanelTitle = text;
        this.dirPanel.setBorder(this.createTitledBorder(this.dirPanelTitle));
    }

    public void setUpRadioButtonText(String text) {
        this.upButton.setText(text);
    }
}

