/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenFactory;

class DefaultTokenFactory
implements TokenFactory {
    private int size;
    private int increment;
    private Token[] tokenList;
    private int currentFreeToken;
    protected static final int DEFAULT_START_SIZE = 30;
    protected static final int DEFAULT_INCREMENT = 10;

    public DefaultTokenFactory() {
        this(30, 10);
    }

    public DefaultTokenFactory(int size, int increment) {
        this.size = size;
        this.increment = increment;
        this.currentFreeToken = 0;
        this.tokenList = new Token[size];
        for (int i = 0; i < size; ++i) {
            this.tokenList[i] = new Token();
        }
    }

    private final void augmentTokenList() {
        Token[] temp = new Token[this.size + this.increment];
        System.arraycopy(this.tokenList, 0, temp, 0, this.size);
        this.size += this.increment;
        this.tokenList = temp;
        for (int i = 0; i < this.increment; ++i) {
            this.tokenList[this.size - i - 1] = new Token();
        }
    }

    public Token createToken() {
        Token token = this.tokenList[this.currentFreeToken];
        token.text = null;
        token.type = 0;
        token.offset = -1;
        token.setNextToken(null);
        ++this.currentFreeToken;
        if (this.currentFreeToken == this.size) {
            this.augmentTokenList();
        }
        return token;
    }

    public Token createToken(Segment line, int beg, int end, int startOffset, int type) {
        return this.createToken(line.array, beg, end, startOffset, type);
    }

    public Token createToken(char[] line, int beg, int end, int startOffset, int type) {
        Token token = this.tokenList[this.currentFreeToken];
        token.set(line, beg, end, startOffset, type);
        ++this.currentFreeToken;
        if (this.currentFreeToken == this.size) {
            this.augmentTokenList();
        }
        return token;
    }

    public void resetAllTokens() {
        this.currentFreeToken = 0;
    }
}

