/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.actions.DefaultSyntaxAction;
import jsyntaxpane.actions.gui.ComboCompletionDialog;
import jsyntaxpane.util.JarServiceProvider;

public class ComboCompletionAction
extends DefaultSyntaxAction {
    Map<String, String> completions;
    ComboCompletionDialog dlg;
    private List<String> items;

    public ComboCompletionAction() {
        super("COMBO_COMPLETION");
    }

    @Override
    public void actionPerformed(JTextComponent target, SyntaxDocument sdoc, int dot, ActionEvent e) {
        if (sdoc == null) {
            return;
        }
        Token token = sdoc.getTokenAt(dot);
        String abbrev = "";
        if (token != null) {
            abbrev = token.getString(sdoc);
            target.select(token.start, token.end());
        }
        if (this.dlg == null) {
            this.dlg = new ComboCompletionDialog(target);
        }
        this.dlg.displayFor(abbrev, this.items);
    }

    public void setItemsURL(String value) {
        this.items = JarServiceProvider.readLines(value);
    }

    public List<String> getItems() {
        return this.items;
    }

    public void setItems(List<String> items) {
        this.items = items;
    }
}

