/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.DefaultSyntaxAction;

public class SmartHomeAction
extends DefaultSyntaxAction {
    public SmartHomeAction() {
        super("smart-home");
    }

    @Override
    public void actionPerformed(JTextComponent target, SyntaxDocument sDoc, int dot, ActionEvent e) {
        try {
            target.setCaretPosition(SmartHomeAction.getSmartHomeOffset(target, sDoc, dot));
        }
        catch (BadLocationException ex) {
            Logger.getLogger(SmartHomeAction.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static int getSmartHomeOffset(JTextComponent target, SyntaxDocument sDoc, int dot) throws BadLocationException {
        Element el = sDoc.getParagraphElement(dot);
        Segment seg = new Segment();
        sDoc.getText(el.getStartOffset(), el.getEndOffset() - el.getStartOffset() - 1, seg);
        int homeOffset = 0;
        int dotLineOffset = dot - el.getStartOffset();
        boolean inText = false;
        for (int i = 0; i < dotLineOffset; ++i) {
            if (Character.isWhitespace(seg.charAt(i))) continue;
            inText = true;
            break;
        }
        if (dotLineOffset == 0 || inText) {
            char ch = seg.first();
            while (ch != '\uffff' && Character.isWhitespace(ch)) {
                ++homeOffset;
                ch = seg.next();
            }
        }
        return el.getStartOffset() + homeOffset;
    }
}

