/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.AGESoundClientProxy;
import eu.irreality.age.ARSPConstants;
import eu.irreality.age.MultimediaInputOutputClient;
import eu.irreality.age.Player;
import eu.irreality.age.SoundClient;
import eu.irreality.age.StringMethods;
import eu.irreality.age.World;
import eu.irreality.age.XMLtoWorldException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;

public class AGEClientProxy
implements MultimediaInputOutputClient,
ARSPConstants {
    private Hashtable colorCodesTable = new Hashtable();
    boolean opt_sound = false;
    boolean opt_images = false;
    boolean opt_color = false;
    boolean opt_title = false;
    private World mundo;
    private Thread asyncModeThread;
    private SoundClient sh;
    boolean clientHasDisconnected = false;
    private Socket sock;
    private InputStream is;
    private OutputStream os;
    private PrintWriter pw;
    private BufferedReader br;
    private boolean asynchronous;
    private LinkedList inputQueue;

    public String getColorCode(String colorType) {
        String code = (String)this.colorCodesTable.get(colorType);
        System.out.println("CLPROXY CODEGET" + code);
        if (code == null) {
            return "";
        }
        return code;
    }

    public boolean isColorEnabled() {
        return this.opt_color;
    }

    public boolean isLoggingEnabled() {
        return true;
    }

    public boolean isMemoryEnabled() {
        return false;
    }

    public boolean isTitleEnabled() {
        return this.opt_title;
    }

    public void borrarPantalla() {
        this.pw.println("clear_screen");
        this.pw.flush();
    }

    public synchronized void escribir(String s) {
        this.write(s);
    }

    public synchronized void write(String s) {
        this.pw.println("w " + StringMethods.textualSubstitution(s, "\n", "\\n"));
        System.out.println("WROTE: w " + StringMethods.textualSubstitution(s, "\n", "\\n"));
        this.pw.flush();
    }

    public void escribirTitulo(String s) {
        this.writeTitle(s);
    }

    public void writeTitle(String s) {
        this.pw.println("w_title " + s);
        this.pw.flush();
    }

    public void escribirTitulo(String s, int pos) {
        this.writeTitle(s, pos);
    }

    public void writeTitle(String s, int pos) {
        this.pw.println("w_title " + s + " " + pos);
        this.pw.flush();
    }

    public void forzarEntrada(String s, boolean output_enabled) {
        this.forceInput(s, output_enabled);
    }

    public void forceInput(String s, boolean output_enabled) {
        this.pw.println("force_input " + output_enabled + s);
        this.pw.flush();
    }

    public boolean isDisconnected() {
        return this.clientHasDisconnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInput(Player p) {
        this.setSynchronousMode();
        this.pw.println("g");
        System.out.println("WROTE: g");
        this.pw.flush();
        try {
            while (true) {
                String str;
                AGEClientProxy aGEClientProxy = this;
                synchronized (aGEClientProxy) {
                    System.out.println("Gonna read.");
                    str = this.br.readLine();
                }
                System.out.println("Line read is " + str);
                if (str == null) {
                    this.clientHasDisconnected = true;
                    return null;
                }
                StringTokenizer st = new StringTokenizer(str);
                if (!st.hasMoreTokens()) {
                    System.out.println("EMPTY CMD");
                    continue;
                }
                String cmd = st.nextToken();
                if (cmd.equalsIgnoreCase("gr")) {
                    String args = st.hasMoreTokens() ? st.nextToken("").trim() : "";
                    System.out.println("INPUT GOTTEN: " + args);
                    return args;
                }
                this.parseRequest(str);
            }
        }
        catch (IOException ioe) {
            System.out.println("Uh oh, an IOException!!\n");
            this.clientHasDisconnected = true;
            return null;
        }
    }

    public String getRealTimeInput(Player p) {
        this.setAsynchronousMode();
        this.pw.println("g");
        System.out.println("WROTE: g");
        this.pw.flush();
        if (this.inputQueue.isEmpty()) {
            return null;
        }
        String str = (String)this.inputQueue.removeFirst();
        return str;
    }

    public void waitKeyPress() {
        this.setSynchronousMode();
        this.pw.println("wait_key_press");
        System.out.println("WROTE: wait_key_press");
        this.pw.flush();
        boolean terminamos = false;
        try {
            while (!terminamos) {
                String linea = this.br.readLine();
                StringTokenizer st = new StringTokenizer(linea);
                String t = st.nextToken();
                if (t.equalsIgnoreCase("key_pressed")) {
                    terminamos = true;
                    continue;
                }
                this.parseRequest(linea);
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
        }
    }

    public SoundClient getSoundClient() {
        return this.sh;
    }

    public void insertCenteredIcon(String fname) {
        this.pw.println("icon centered " + fname);
        this.pw.flush();
    }

    public void insertIcon(String fname) {
        this.pw.println("icon " + fname);
        this.pw.flush();
    }

    public boolean isGraphicsEnabled() {
        return this.opt_images;
    }

    public boolean isSoundEnabled() {
        return this.opt_sound;
    }

    public AGEClientProxy(Socket s) {
        try {
            this.sh = new AGESoundClientProxy(s);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.sock = s;
        try {
            if (s != null) {
                this.is = new BufferedInputStream(this.sock.getInputStream(), 100000);
                this.br = new BufferedReader(new InputStreamReader(this.is));
                this.os = new BufferedOutputStream(this.sock.getOutputStream(), 100000);
                this.pw = new PrintWriter(new OutputStreamWriter(this.os)){

                    public void println(String linea) {
                        this.print(linea);
                        this.print("\r\n");
                    }
                };
            }
            System.out.println("Calling getClientType()");
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            System.out.println("Now really calling it");
            this.getClientType();
            System.out.println("Returning from proxy constructor.");
        }
        catch (Exception e) {
            System.out.println("Error: " + e);
            e.printStackTrace();
        }
    }

    public void getClientType() throws IOException {
        System.out.println("Sending client type request.\n");
        this.pw.println("client_type_request");
        this.pw.println("");
        this.pw.flush();
        String linea = this.br.readLine();
        StringTokenizer st = new StringTokenizer(linea);
        String tok1 = st.hasMoreTokens() ? st.nextToken() : "";
        if (tok1.equalsIgnoreCase("client_type_reply")) {
            StringTokenizer st2 = new StringTokenizer(st.nextToken("").trim(), ":");
            String optionString = st2.nextToken();
            String nameString = st2.nextToken("").trim();
            StringTokenizer optionTokenizer = new StringTokenizer(optionString, " ");
            while (optionTokenizer.hasMoreTokens()) {
                String optionToken = optionTokenizer.nextToken();
                if (optionToken.equalsIgnoreCase("sound")) {
                    this.opt_sound = true;
                    continue;
                }
                if (optionToken.equalsIgnoreCase("nosound")) {
                    this.opt_sound = false;
                    continue;
                }
                if (optionToken.equalsIgnoreCase("images")) {
                    this.opt_images = true;
                    continue;
                }
                if (optionToken.equalsIgnoreCase("noimages")) {
                    this.opt_images = false;
                    continue;
                }
                if (optionToken.equalsIgnoreCase("color")) {
                    this.opt_color = true;
                    continue;
                }
                if (optionToken.equalsIgnoreCase("nocolor")) {
                    this.opt_color = false;
                    continue;
                }
                if (optionToken.equalsIgnoreCase("title")) {
                    this.opt_title = true;
                    continue;
                }
                if (!optionToken.equalsIgnoreCase("notitle")) continue;
                this.opt_title = false;
            }
        }
    }

    public void getColorCodesFromClient() throws IOException {
        this.pw.println("colorcode_request");
        this.pw.flush();
        String tok1 = "";
        while (!tok1.equalsIgnoreCase("colorcode_info_begin")) {
            String linea = this.br.readLine();
            StringTokenizer st = new StringTokenizer(linea);
            tok1 = st.hasMoreTokens() ? st.nextToken() : "";
            if (tok1.equalsIgnoreCase("colorcode_info_begin")) {
                while (!tok1.equalsIgnoreCase("colorcode_info_end")) {
                    linea = this.br.readLine();
                    st = new StringTokenizer(linea);
                    tok1 = st.hasMoreTokens() ? st.nextToken() : "";
                    if (tok1.equalsIgnoreCase("colorcode_info_line")) {
                        if (st.hasMoreTokens()) {
                            String tok2 = st.nextToken();
                            if (st.hasMoreTokens()) {
                                String tok3 = st.nextToken();
                                this.colorCodesTable.put(tok2.toLowerCase(), tok3);
                                System.out.println("To hashtable: " + tok2.toLowerCase());
                                continue;
                            }
                            this.pw.println("unrecognized_format " + linea);
                            this.pw.println("server_state expecting colorcode_info_line, colorcode_info_end");
                            this.pw.flush();
                            continue;
                        }
                        this.pw.println("unrecognized_format " + linea);
                        this.pw.println("server_state expecting colorcode_info_line, colorcode_info_end");
                        this.pw.flush();
                        continue;
                    }
                    if (tok1.equalsIgnoreCase("colorcode_info_end")) continue;
                    System.out.println("I'm the ClientProxy and I can't recognize " + linea);
                    this.pw.println("unrecognized_message " + linea);
                    this.pw.println("server_state expecting colorcode_info_line, colorcode_info_end");
                    this.pw.flush();
                }
                System.out.println("Colorcode info end marker received.");
                return;
            }
            if (tok1.equalsIgnoreCase("unrecognized_message")) {
                System.out.println("Protocol error! " + tok1);
                continue;
            }
            this.pw.println("unrecognized_message " + linea);
            this.pw.println("server_state expecting colorcode_info_begin");
            this.pw.flush();
        }
    }

    public void bindToWorld(World mundo) {
        this.mundo = mundo;
        try {
            System.out.println("Sending visconf.");
            try {
                this.pw.println("world_dir " + mundo.getWorldDir());
                Document d = null;
                DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                d = db.newDocument();
                System.out.println("Mundo: " + mundo);
                System.out.println("VisCo: " + mundo.getVisualConfiguration());
                String elXML = mundo.getVisualConfiguration().getXMLRepresentation(d).toString();
                StringTokenizer st = new StringTokenizer(elXML, "\n");
                this.pw.println("visualconf_init_begin");
                while (st.hasMoreTokens()) {
                    String tok = st.nextToken();
                    this.pw.println("visualconf_init_line " + tok);
                    System.out.println("Sending line: visualconf_init_line " + tok);
                }
                this.pw.println("visualconf_init_end");
                this.pw.flush();
                try {
                    System.out.println("Gonna get color codes...\n");
                    this.getColorCodesFromClient();
                    System.out.println("Color codes succ'flly gotten.\n");
                }
                catch (IOException ioe) {
                    System.out.println(ioe);
                    ioe.printStackTrace();
                }
            }
            catch (ParserConfigurationException pce) {
                System.out.println(pce);
            }
            List l = mundo.getFileList();
            if (l != null && l.size() > 0) {
                this.pw.println("file_list_begin");
                for (int k = 0; k < l.size(); ++k) {
                    this.pw.println("file_list_line " + l.get(k) + " " + new File((String)l.get(k)).length());
                }
                this.pw.println("file_list_end");
                this.pw.flush();
            }
            this.write("Welcome to denebola [port " + this.sock.getLocalPort() + "] running the Aetheria Game Engine.\n");
            mundo.addNewPlayerASAP(this);
            System.out.println("Welcoming and adding player.\n");
        }
        catch (XMLtoWorldException e) {
            System.out.println("Couldn't: XMLtoWorldException " + e);
        }
    }

    private synchronized void setSynchronousMode() {
        if (this.asyncModeThread != null) {
            this.asynchronous = false;
            while (this.asyncModeThread.isAlive()) {
                System.out.println("Die, thread! Die!");
                try {
                    this.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.asynchronous = false;
    }

    private void setAsynchronousMode() {
        if (!this.asynchronous) {
            this.asynchronous = true;
            this.inputQueue = new LinkedList();
            this.asyncModeThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        while (true) {
                            String str;
                            if (!AGEClientProxy.this.asynchronous) {
                                return;
                            }
                            2 var2_3 = this;
                            synchronized (var2_3) {
                                str = AGEClientProxy.this.br.readLine();
                            }
                            if (str == null) {
                                AGEClientProxy.this.clientHasDisconnected = true;
                                break;
                            }
                            StringTokenizer st = new StringTokenizer(str);
                            String cmd = st.nextToken();
                            String args = st.hasMoreTokens() ? st.nextToken("").trim() : "";
                            if (cmd.equalsIgnoreCase("gr")) {
                                System.out.println("INPUT GOTTEN: " + args);
                                System.out.println("Adding 2 Que: " + args);
                                AGEClientProxy.this.inputQueue.addLast(args);
                                continue;
                            }
                            AGEClientProxy.this.parseRequest(str);
                        }
                    }
                    catch (IOException ioe) {
                        AGEClientProxy.this.clientHasDisconnected = true;
                        System.out.println("IO Exception.\n");
                    }
                }
            };
            this.asyncModeThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseRequest(String request) {
        StringTokenizer st = new StringTokenizer(request);
        String tok = st.nextToken();
        if (tok.equalsIgnoreCase("GET_FILE")) {
            String fileName = st.nextToken();
            List l = this.mundo.getFileList();
            if (l.contains(fileName)) {
                int k = l.indexOf(fileName);
                File f = new File((String)l.get(k));
                try {
                    FileInputStream fis = new FileInputStream(f);
                    byte[] barr = new byte[(int)f.length()];
                    System.out.println("Reading file from file input stream.");
                    System.out.println("To read " + barr.length + " bytes from input stream.");
                    for (int lei = 0; lei < barr.length; lei += fis.read(barr, lei, barr.length - lei)) {
                        System.out.println("Currently read " + lei + " bytes.");
                    }
                    AGEClientProxy aGEClientProxy = this;
                    synchronized (aGEClientProxy) {
                        this.pw.println("file_header_line " + l.get(k) + " " + f.length());
                        System.out.println("WROTE: file_header_line " + l.get(k) + " " + f.length());
                        this.pw.flush();
                        System.out.println("Writing length " + barr.length + " data to socket stream.");
                        System.out.println("Socket buffer sizes are " + this.sock.getSendBufferSize() + " and " + this.sock.getReceiveBufferSize());
                        this.os.write(barr);
                        this.os.flush();
                        System.out.println("WROTE: " + new String(barr));
                    }
                }
                catch (IOException ioe) {
                    System.out.println(ioe);
                    ioe.printStackTrace();
                }
            }
        }
    }
}

