/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.ARSPConstants;
import eu.irreality.age.PartidaEnCurso;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.List;
import java.util.StringTokenizer;

class AGEClientSelector
implements ARSPConstants {
    private InputStream is;
    private OutputStream os;
    private BufferedReader in;
    private PrintWriter out;
    private Socket incoming;
    private int id;

    public AGEClientSelector(Socket s, int id) {
        this.incoming = s;
        this.id = id;
        try {
            if (this.incoming != null) {
                this.is = this.incoming.getInputStream();
                this.in = new BufferedReader(new InputStreamReader(this.is));
                this.os = this.incoming.getOutputStream();
                this.out = new PrintWriter(new OutputStreamWriter(this.os)){

                    public void println(String linea) {
                        this.print(linea);
                        this.print("\r\n");
                    }
                };
            }
        }
        catch (Exception e) {
            System.out.println("Error: " + e);
        }
    }

    public void escribir(String s) {
        if (this.out != null) {
            System.out.print("Systemoutprinting:" + s);
            this.out.print(s);
            this.out.flush();
        }
    }

    public String getInput() {
        try {
            String str = this.in.readLine();
            System.out.println("INPUT GOTTEN: " + str);
            return str;
        }
        catch (IOException ioe) {
            System.out.println("Oh yeppie, en \u00c1i Ou Excepxen.\n");
            return null;
        }
    }

    public PartidaEnCurso getPartidaSelection(List partidas) {
        String str;
        try {
            str = this.in.readLine();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
            return null;
        }
        StringTokenizer st = new StringTokenizer(str);
        String head = st.nextToken();
        if (head.equalsIgnoreCase("protocol_version_statement")) {
            System.out.println("Version stated.");
            String tail = st.nextToken("").trim();
            System.out.println("Cola: " + tail);
            if (!tail.equalsIgnoreCase("1.0")) {
                this.out.println("protocol_version_ack NOK");
                return null;
            }
        } else {
            this.out.println("unrecognized_message" + str);
            this.out.println("server_state expecting protocol_version_statement");
            return null;
        }
        this.out.println("protocol_version_ack OK");
        this.out.flush();
        boolean terminamos = false;
        while (!terminamos) {
            try {
                str = this.in.readLine();
                if (str == null) {
                    new Exception("Received null input.").printStackTrace();
                    return null;
                }
            }
            catch (IOException ioe) {
                System.out.println(ioe);
                ioe.printStackTrace();
                return null;
            }
            st = new StringTokenizer(str);
            String cmd = null;
            if (st.hasMoreTokens()) {
                cmd = st.nextToken();
            }
            String args = null;
            if (st.hasMoreTokens()) {
                args = st.nextToken("").trim();
            }
            if (cmd == null) continue;
            if (cmd.equalsIgnoreCase("goodbye")) {
                this.out.println("goodbye");
                return null;
            }
            if (cmd.equalsIgnoreCase("service_list_request")) {
                this.out.println("service_list_begin");
                this.out.println("service_list_line gamelist");
                this.out.println("service_list_line gamejoin");
                this.out.println("service_list_end");
            } else if (cmd.equalsIgnoreCase("call_service")) {
                StringTokenizer st2 = new StringTokenizer(args);
                String servName = st2.nextToken();
                if (servName.equalsIgnoreCase("gamelist")) {
                    this.out.println("game_list_begin");
                    for (int i = 0; i < partidas.size(); ++i) {
                        PartidaEnCurso pec = (PartidaEnCurso)partidas.get(i);
                        this.out.println("game_list_line " + (i + 1) + ". " + pec.getNombre() + " " + "(" + pec.getPlayers() + "/" + pec.getMaxPlayers() + ")");
                    }
                    this.out.println("game_list_end");
                } else if (servName.equalsIgnoreCase("gamejoin")) {
                    String id = st2.nextToken();
                    int part = -1;
                    try {
                        part = Integer.valueOf(id);
                        System.out.println("Part: " + part);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    if (part > 0 && part <= partidas.size()) {
                        PartidaEnCurso p = (PartidaEnCurso)partidas.get(part - 1);
                        if (p.getPlayers() < p.getMaxPlayers()) {
                            System.out.println("Returning game.");
                            return p;
                        }
                        this.out.println("errormsg Esa partida ha alcanzado su n\u00famero m\u00e1ximo de usuarios, no puedes entrar.\n");
                    } else {
                        this.out.println("errormsg ID incorrecta");
                    }
                } else {
                    this.out.println("unsupported_service " + servName);
                }
            } else {
                this.out.println("unrecognized_message " + str);
            }
            this.out.flush();
        }
        return null;
    }
}

