/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.InputOutputClient;
import eu.irreality.age.Player;
import eu.irreality.age.SwingAetheriaGameLoader;
import eu.irreality.age.SwingAetheriaGameLoaderInterface;
import eu.irreality.age.SwingMenuAetheria;
import eu.irreality.age.SwingTextAreaListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

class ClassicalColoredSwingClient
implements InputOutputClient {
    private JTextPane elAreaTexto;
    private JScrollPane elScrolling;
    private Vector gameLog;
    private SwingAetheriaGameLoader laVentana;
    private Document doc;
    private MutableAttributeSet atributos = new SimpleAttributeSet();
    private Hashtable colorCodesTable = new Hashtable();
    private String currentInput;
    private Stack back = new Stack();
    private Stack forward = new Stack();
    private SwingTextAreaListener elEscuchador;

    public String getColorCode(String colorType) {
        String code = (String)this.colorCodesTable.get(colorType.toLowerCase());
        if (code == null) {
            return "";
        }
        return "%" + code + "%";
    }

    public void setDefaultConfiguration() {
        this.colorCodesTable.put("description", "00CC00");
        this.colorCodesTable.put("important", "FFFF00");
        this.colorCodesTable.put("information", "FFFF00");
        this.colorCodesTable.put("action", "9999FF");
        this.colorCodesTable.put("denial", "CC0000");
        this.colorCodesTable.put("error", "FF0000");
        this.colorCodesTable.put("story", "FFFFFF");
        this.colorCodesTable.put("default", "FFFFFF");
        this.colorCodesTable.put("input", "AAAAAA");
        this.colorCodesTable.put("reset", " ");
        this.elAreaTexto.setBackground(Color.black);
        this.elAreaTexto.setForeground(Color.white);
        StyleConstants.setForeground(this.atributos, Color.black);
        this.elAreaTexto.repaint();
    }

    public boolean isDisconnected() {
        return false;
    }

    public void setPergaminoConfiguration() {
        this.colorCodesTable.put("description", "00CC00");
        this.colorCodesTable.put("important", "FFFF00");
        this.colorCodesTable.put("information", "FFFF00");
        this.colorCodesTable.put("action", "9999FF");
        this.colorCodesTable.put("denial", "CC0000");
        this.colorCodesTable.put("error", "FF0000");
        this.colorCodesTable.put("story", "FFFFFF");
        this.colorCodesTable.put("default", "FFFFFF");
        this.colorCodesTable.put("input", "AAAAAA");
        this.elAreaTexto.setBackground(Color.yellow);
        this.elAreaTexto.setForeground(Color.black);
        this.elAreaTexto.repaint();
    }

    public String getCommandText() {
        String s = this.elAreaTexto.getText();
        StringTokenizer st = new StringTokenizer(s, "\n", true);
        String tok = "";
        String tokant = "";
        while (st.hasMoreTokens()) {
            tokant = tok;
            tok = st.nextToken();
        }
        if (tok.indexOf("\n") >= 0) {
            System.out.println("Barraene found, toklen " + tok.length() + " antlen " + tokant.length());
            return tokant;
        }
        return tok;
    }

    public void setCommandText(String s) {
        try {
            this.doc.remove(this.elAreaTexto.getText().length() - this.getCommandText().length(), this.getCommandText().length());
            this.doc.insertString(this.elAreaTexto.getText().length(), s, this.atributos);
        }
        catch (BadLocationException ble) {
            System.out.println(ble);
        }
    }

    public void addToBackStack(String s) {
        if (this.back.isEmpty() || !s.equalsIgnoreCase((String)this.back.peek())) {
            this.back.push(s);
        }
    }

    public void addToForwardStack(String s) {
        if (this.forward.isEmpty() || !s.equalsIgnoreCase((String)this.back.peek())) {
            this.forward.push(s);
        }
    }

    public void forwardStackIntoBackStack() {
        while (!this.forward.isEmpty()) {
            Object o = this.forward.pop();
            if (o.equals("")) continue;
            this.back.push(o);
        }
    }

    public void goBack() {
        if (!this.back.isEmpty()) {
            this.addToForwardStack(this.getCommandText());
            this.setCommandText((String)this.back.pop());
        }
    }

    public void goForward() {
        if (!this.forward.isEmpty()) {
            this.addToBackStack(this.getCommandText());
            this.setCommandText((String)this.forward.pop());
        }
    }

    public void escribirTitulo(String s) {
        this.writeTitle(s);
    }

    public void writeTitle(String s) {
        this.laVentana.setTitle(s);
    }

    public void escribirTitulo(String s, int pos) {
        this.writeTitle(s, pos);
    }

    public void writeTitle(String s, int pos) {
        String titAct = this.laVentana.getTitle();
        StringTokenizer st = new StringTokenizer(titAct, "-");
        int npos = 1;
        String result = "";
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            result = npos == pos ? result + s : result + tok.trim();
            ++npos;
            if (!st.hasMoreTokens()) continue;
            result = result + " - ";
        }
        if (npos == pos) {
            result = result + " - " + s;
        }
        this.laVentana.setTitle(result);
    }

    public boolean isColorEnabled() {
        return true;
    }

    public boolean isMemoryEnabled() {
        return true;
    }

    public boolean isLoggingEnabled() {
        return true;
    }

    public boolean isTitleEnabled() {
        return true;
    }

    public ClassicalColoredSwingClient(SwingAetheriaGameLoader window, JScrollPane scrolling, JTextPane nArea, Vector gameLog) {
        this.laVentana = window;
        this.elAreaTexto = nArea;
        this.elScrolling = scrolling;
        this.gameLog = gameLog;
        this.elEscuchador = new SwingTextAreaListener(this.elAreaTexto, gameLog, this);
        this.elAreaTexto.addKeyListener(this.elEscuchador);
        this.doc = this.elAreaTexto.getDocument();
        this.setDefaultConfiguration();
    }

    public ClassicalColoredSwingClient(SwingAetheriaGameLoader window, Vector gameLog) {
        this.laVentana = window;
        this.gameLog = gameLog;
        window.getMainPanel().setLayout(new BorderLayout());
        window.update(window.getGraphics());
        window.repaint();
        window.updateNow();
        Thread.yield();
        this.elAreaTexto = new JTextPane();
        window.updateNow();
        this.elScrolling = new JScrollPane(this.elAreaTexto);
        this.elScrolling.setVerticalScrollBarPolicy(22);
        this.elAreaTexto.setForeground(Color.white);
        this.elAreaTexto.setBackground(Color.black);
        this.elAreaTexto.setFont(SwingAetheriaGameLoaderInterface.font);
        this.elAreaTexto.setVisible(true);
        this.elScrolling.setVisible(true);
        window.getMainPanel().add((Component)this.elScrolling, "Center");
        window.setJMenuBar(new SwingMenuAetheria(window));
        window.setVisible(true);
        window.repaint();
        window.updateNow();
        Thread.yield();
        this.elEscuchador = new SwingTextAreaListener(this.elAreaTexto, gameLog, this);
        this.elAreaTexto.addKeyListener(this.elEscuchador);
        this.elAreaTexto.setText("--");
        this.doc = this.elAreaTexto.getDocument();
        this.setDefaultConfiguration();
    }

    public static Color stringToColor(String colorString) {
        try {
            String colorClean = colorString.length() > 0 && colorString.charAt(0) == '#' ? colorString.substring(1) : colorString;
            int ncolor = Integer.parseInt(colorClean, 16);
            return new Color(ncolor);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static String colorToString(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        return Integer.toString(red, 16) + Integer.toString(green, 16) + Integer.toString(blue, 16);
    }

    public void escribir(String s) {
        this.write(s);
    }

    public void write(final String s) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ClassicalColoredSwingClient.this.doWrite(s);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.doWrite(s);
        }
    }

    public void doWrite(String s) {
        boolean iscode;
        StringTokenizer st = new StringTokenizer(s, "%");
        boolean bl = iscode = s.length() > 0 && s.charAt(0) == '%';
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (iscode) {
                if (tok.equalsIgnoreCase("red")) {
                    StyleConstants.setForeground(this.atributos, Color.red);
                } else if (tok.equalsIgnoreCase("green")) {
                    StyleConstants.setForeground(this.atributos, Color.green);
                } else if (tok.equalsIgnoreCase("white")) {
                    StyleConstants.setForeground(this.atributos, Color.white);
                } else if (tok.equalsIgnoreCase("blue")) {
                    StyleConstants.setForeground(this.atributos, Color.blue);
                } else if (tok.equalsIgnoreCase("yellow")) {
                    StyleConstants.setForeground(this.atributos, Color.blue);
                } else if (tok.equalsIgnoreCase("lightgray")) {
                    StyleConstants.setForeground(this.atributos, Color.blue);
                } else if (tok.equalsIgnoreCase("magenta")) {
                    StyleConstants.setForeground(this.atributos, Color.blue);
                } else if (tok.trim().equalsIgnoreCase("")) {
                    StyleConstants.setForeground(this.atributos, ClassicalColoredSwingClient.stringToColor(this.getColorCode("default")));
                } else {
                    try {
                        String colortok = tok.length() > 0 && tok.charAt(0) == '#' ? tok.substring(1) : tok;
                        int ncolor = Integer.parseInt(colortok, 16);
                        StyleConstants.setForeground(this.atributos, new Color(ncolor));
                    }
                    catch (NumberFormatException nfe) {}
                }
            } else {
                try {
                    this.doc.insertString(this.elAreaTexto.getText().length(), tok, this.atributos);
                }
                catch (BadLocationException ble) {
                    System.out.println(ble);
                }
            }
            iscode = !iscode;
        }
        this.elAreaTexto.setCaretColor(Color.red);
        this.elAreaTexto.moveCaretPosition(this.elAreaTexto.getText().length());
        this.elAreaTexto.setVisible(true);
        this.elAreaTexto.setSelectionStart(this.elAreaTexto.getText().length());
        this.elAreaTexto.setSelectionEnd(this.elAreaTexto.getText().length());
    }

    public void loguear(String s) {
        this.gameLog.addElement(s);
    }

    public void forzarEntrada(String s, boolean output_enabled) {
        this.forceInput(s, output_enabled);
    }

    public void forceInput(String s, boolean output_enabled) {
        this.gameLog.addElement(s);
        this.elEscuchador.countCommand();
        if (output_enabled) {
            this.write("\n");
            this.write(this.getColorCode("input") + " > " + s.trim() + this.getColorCode("reset"));
        }
    }

    public synchronized void waitKeyPress() {
        System.out.println("Keywait");
        this.elEscuchador.setPressAnyKeyState(true);
        try {
            System.out.println("Keywait I said");
            this.wait();
        }
        catch (InterruptedException intex) {
            System.out.println(intex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInput(Player pl) {
        ClassicalColoredSwingClient classicalColoredSwingClient = this;
        synchronized (classicalColoredSwingClient) {
            try {
                this.wait();
            }
            catch (InterruptedException intex) {
                System.out.println(intex);
            }
            String temp = this.currentInput;
            this.currentInput = null;
            return temp;
        }
    }

    public synchronized String getRealTimeInput(Player pl) {
        String temp = this.currentInput;
        this.currentInput = null;
        if (temp == null) {
            this.loguear("");
        }
        return temp;
    }

    public synchronized void setInputString(String s) {
        this.currentInput = s;
        this.notify();
    }

    public void borrarPantalla() {
        this.elAreaTexto.setText("");
    }
}

