/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import bsh.TargetError;
import eu.irreality.age.EVASemanticException;
import eu.irreality.age.Player;
import eu.irreality.age.SwingAetheriaGameLoader;
import eu.irreality.age.World;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;

public class GameEngineThread
extends Thread {
    public static long DEFAULT_REAL_TIME_QUANTUM = 1500L;
    protected static long timeCount;
    protected static boolean exitFlag;
    World theWorld;
    JInternalFrame ventana;
    boolean realTimeEnabled;
    long realTimeQuantum;
    private JMenu serverConfigurationMenu;

    public static String getVersion() {
        return "Aetheria Game Engine v 0.6.6d (Beta altamente inestable)";
    }

    public GameEngineThread(World theWorld, JInternalFrame ventana, boolean realTimeEnabled) {
        this.theWorld = theWorld;
        this.ventana = ventana;
        this.realTimeEnabled = realTimeEnabled;
        this.initServerMenu(ventana);
        ventana.repaint();
    }

    public void setRealTimeQuantum(long quantum) {
        this.realTimeQuantum = quantum;
    }

    public boolean isRealTimeEnabled() {
        return this.realTimeEnabled;
    }

    public void setRealTimeEnabled(boolean b) {
        this.realTimeEnabled = b;
    }

    public void initServerMenu(final JInternalFrame window) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doInitServerMenu(window);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        GameEngineThread.this.doInitServerMenu(window);
                        window.repaint();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void uninitServerMenu(final JInternalFrame window) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUninitServerMenu(window);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        GameEngineThread.this.doUninitServerMenu(window);
                        window.repaint();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void doInitServerMenu(JInternalFrame window) {
        this.doInitServerMenu(window, "Servidor");
    }

    public void doUninitServerMenu(JInternalFrame window) {
        JMenuBar menubar = window instanceof SwingAetheriaGameLoader ? ((SwingAetheriaGameLoader)window).getTheJMenuBar() : window.getJMenuBar();
        menubar.remove(this.serverConfigurationMenu);
    }

    private void setJMenuBarAsNeeded(JInternalFrame window, JMenuBar mb) {
        if (window instanceof SwingAetheriaGameLoader) {
            ((SwingAetheriaGameLoader)window).setTheJMenuBar(mb);
        } else {
            window.setJMenuBar(mb);
        }
    }

    private JMenuBar getJMenuBarAsNeeded(JInternalFrame window) {
        if (window instanceof SwingAetheriaGameLoader) {
            return ((SwingAetheriaGameLoader)window).getTheJMenuBar();
        }
        return window.getJMenuBar();
    }

    public void doInitServerMenu(final JInternalFrame window, String menuName) {
        this.serverConfigurationMenu = new JMenu(menuName);
        JMenu timeConfigurationMenu = new JMenu("Modo de juego");
        JMenuBar mb = this.getJMenuBarAsNeeded(window);
        if (mb == null) {
            mb = new JMenuBar();
            this.setJMenuBarAsNeeded(window, mb);
        }
        this.serverConfigurationMenu.add(timeConfigurationMenu);
        JRadioButtonMenuItem itemTurns = new JRadioButtonMenuItem("Turnos", true);
        JRadioButtonMenuItem itemRealTime = new JRadioButtonMenuItem("Tiempo real", false);
        ButtonGroup bg = new ButtonGroup();
        bg.add(itemTurns);
        bg.add(itemRealTime);
        itemTurns.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GameEngineThread.this.setRealTimeEnabled(false);
            }
        });
        itemRealTime.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GameEngineThread.this.setRealTimeEnabled(true);
                GameEngineThread.this.setRealTimeQuantum(DEFAULT_REAL_TIME_QUANTUM);
            }
        });
        timeConfigurationMenu.add(itemTurns);
        timeConfigurationMenu.add(itemRealTime);
        if (window instanceof SwingAetheriaGameLoader) {
            JMenuItem reinitItem = new JMenuItem("Reiniciar juego");
            reinitItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ((SwingAetheriaGameLoader)window).reinit();
                }
            });
            this.serverConfigurationMenu.add(reinitItem);
        }
        mb.add(this.serverConfigurationMenu);
        window.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int timeCount = 0;
        exitFlag = false;
        try {
            System.out.println("I'm singing in the rain...");
            this.theWorld.execCode("serverintro", "");
            System.out.println("Just singing in the rain...");
            this.theWorld.execCode("serverintro", new Object[0]);
            System.out.println("BSH script code should have been exec'd just before THIS LINE");
        }
        catch (EVASemanticException esm) {
            this.theWorld.write("EVASemanticException found at serverintro routine");
        }
        catch (TargetError bshte) {
            this.theWorld.write("bsh.TargetError found at serverintro routine");
            this.theWorld.write(bshte.printTargetError((Throwable)bshte) + bshte.inNativeCode());
            System.out.println(bshte.printTargetError(bshte.getTarget()));
            this.theWorld.write(bshte.printTargetError(bshte.getTarget()));
            bshte.printStackTrace();
        }
        finally {
            System.out.println("Gonna notify.");
            Object esm = this.theWorld.serverIntroSyncObject;
            synchronized (esm) {
                this.theWorld.serverIntroExeccedFlag = true;
                this.theWorld.serverIntroSyncObject.notifyAll();
            }
            System.out.println("Notified.");
        }
        try {
            System.out.println("Gonna exec player intros.");
            List l = this.theWorld.getPlayerList();
            System.out.println("List gotten: " + l);
            if (l != null) {
                for (int i = 0; i < l.size(); ++i) {
                    System.out.println("Intro " + i);
                    Player p = (Player)l.get(i);
                    this.theWorld.execCode("intro", "");
                    this.theWorld.execCode("intro", new Object[]{p});
                }
            }
            System.out.println("Player intros execced.");
        }
        catch (EVASemanticException esm) {
            this.theWorld.write("EVASemanticException found at intro routine");
        }
        catch (TargetError bshte) {
            this.theWorld.write("bsh.TargetError found at intro routine");
            bshte.printStackTrace();
        }
        while (!exitFlag) {
            ++timeCount;
            System.out.println("A world cycle.");
            this.theWorld.update();
            if (this.realTimeEnabled) {
                this.esperarCuanto();
            }
            if (this.theWorld.getNumberOfConnectedPlayers() <= 0) {
                try {
                    GameEngineThread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            System.out.println("Flag = " + exitFlag);
        }
    }

    public synchronized void esperarCuanto() {
        try {
            this.wait(this.realTimeQuantum);
        }
        catch (InterruptedException intex) {
            System.out.println(intex);
        }
    }

    public void exitNow() {
        System.out.println("Gonna x-it.");
        if (this.ventana instanceof SwingAetheriaGameLoader) {
            ((SwingAetheriaGameLoader)this.ventana).saveAndFreeResources();
        }
        exitFlag = true;
        System.out.println("Flag set.");
    }

    public void exitForReinit() {
        System.out.println("Gonna x-it.");
        exitFlag = true;
        System.out.println("Flag set.");
    }
}

