/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.Entity;
import eu.irreality.age.EntityList;
import eu.irreality.age.Mobile;
import eu.irreality.age.World;
import eu.irreality.age.XMLtoWorldException;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MobileList
extends EntityList {
    public void addElement(Mobile o) {
        this.laLista.addElement(o);
    }

    public void addMobile(Mobile m) {
        this.addElement(m);
    }

    public boolean removeElement(Mobile o) {
        return this.laLista.removeElement(o);
    }

    public int size() {
        return this.laLista.size();
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Entity viewer) {
        int j;
        int i = 0;
        String cadena = "";
        boolean[] considerados = new boolean[this.size()];
        boolean vacio = true;
        int nconsiderados = 0;
        for (j = 0; j < this.size(); ++j) {
            considerados[j] = false;
        }
        while (i < this.size()) {
            int numeroitems = 1;
            for (int k = i + 1; k < this.size(); ++k) {
                if (!this.elementAt(k).isSame(this.elementAt(i))) continue;
                ++numeroitems;
            }
            if (this.elementAt(i).isInvisible(viewer)) {
                considerados[i] = true;
                ++nconsiderados;
            }
            ++i;
        }
        i = 0;
        j = 0;
        while (i < this.size()) {
            if (!considerados[i]) {
                considerados[i] = true;
                ++nconsiderados;
                int numeroitems = 1;
                for (int k = i + 1; k < this.size(); ++k) {
                    if (!this.elementAt(k).isSame(this.elementAt(i))) continue;
                    considerados[k] = true;
                    ++nconsiderados;
                    ++numeroitems;
                }
                if (this.elementAt(i).isInvisible(viewer)) {
                    ++i;
                    continue;
                }
                vacio = false;
                if (j != 0) {
                    cadena = nconsiderados < this.size() ? cadena + ", " : cadena + " y ";
                }
                cadena = cadena + this.elementAt(i).constructName(numeroitems, viewer);
                ++j;
            }
            ++i;
        }
        if (vacio) {
            return "nada.";
        }
        return cadena + ".";
    }

    public MobileList() {
        this.laLista = new Vector();
    }

    public MobileList(int initSize) {
        this.laLista = new Vector(initSize);
    }

    public void incrementSize(int increment) {
        if (increment > 0) {
            this.laLista.setSize(this.laLista.size() + increment);
        }
    }

    public boolean isEmpty() {
        return this.laLista.isEmpty();
    }

    public Mobile elementAt(int i) {
        return (Mobile)this.laLista.elementAt(i);
    }

    public void setElementAt(Mobile nuevo, int i) {
        this.laLista.setElementAt(nuevo, i);
    }

    public boolean contains(Mobile m) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.elementAt(i) == null || !this.elementAt(i).equals(m)) continue;
            return true;
        }
        return false;
    }

    public Node getXMLRepresentation(Document doc) {
        Element suElemento = doc.createElement("MobileList");
        for (int i = 0; i < this.size(); ++i) {
            Element nuevoElemento = doc.createElement("MobRef");
            Mobile nuestroMob = (Mobile)this.laLista.elementAt(i);
            nuevoElemento.setAttribute("id", String.valueOf(nuestroMob.getID()));
            suElemento.appendChild(nuevoElemento);
        }
        return suElemento;
    }

    public MobileList(World mundo, Node n) throws XMLtoWorldException {
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("MobileList node not Element");
        }
        Element e = (Element)n;
        this.laLista = new Vector();
        NodeList nl = n.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node hijo = nl.item(i);
            if (!(hijo instanceof Element)) continue;
            Element h = (Element)hijo;
            System.out.println("Mob List Element: " + hijo);
            System.out.println("Its Mobile: " + mundo.getMob(h.getAttribute("id")));
            this.addMobile(mundo.getMob(h.getAttribute("id")));
        }
    }

    public Object clone() {
        MobileList inv = new MobileList();
        inv.laLista = new Vector(this.laLista.size());
        for (int i = 0; i < this.laLista.size(); ++i) {
            inv.addMobile((Mobile)this.laLista.get(i));
        }
        return inv;
    }
}

