/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import bsh.BshMethod;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import eu.irreality.age.BSHCodeExecutedOKException;
import eu.irreality.age.CodeRunner;
import eu.irreality.age.EVASemanticException;
import eu.irreality.age.EVASyntaxException;
import eu.irreality.age.Entity;
import eu.irreality.age.PropertyEntry;
import eu.irreality.age.ReturnValue;
import eu.irreality.age.World;
import eu.irreality.age.XMLtoWorldException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ObjectCode {
    private String codeVersion;
    private String theCode;
    private World theWorld;
    boolean permanent = true;
    Interpreter permanentInterpreter = null;

    public static String getInterpreterVersion() {
        return "EVA 0.2, Beanshell 1.2 beta 6";
    }

    public String toString() {
        return this.theCode;
    }

    public Object clone() {
        ObjectCode oc = new ObjectCode(this.theCode, this.codeVersion, this.theWorld);
        oc.permanent = this.permanent;
        oc.permanentInterpreter = null;
        return oc;
    }

    public ObjectCode cloneIfNecessary() {
        if (this.permanent) {
            return (ObjectCode)this.clone();
        }
        return this;
    }

    public ObjectCode(String code, String version, World world) {
        this.theCode = code;
        this.codeVersion = version;
        this.theWorld = world;
    }

    void resetPermanentInterpreter() {
        this.permanentInterpreter = null;
    }

    public boolean run(String aroutine) throws EVASemanticException {
        if (!this.codeVersion.equalsIgnoreCase("EVA")) {
            return false;
        }
        try {
            CodeRunner maquina = new CodeRunner(this.theCode, this.theWorld);
            return maquina.runCode(this.theCode, aroutine);
        }
        catch (EVASyntaxException syn) {
            this.theWorld.write("Error de sintaxis en el c\u00f3digo EVA.\n");
            this.theWorld.write("En concreto: " + syn.getMessage() + "\n");
            return false;
        }
    }

    public boolean run(String aroutine, String dataSegment) throws EVASemanticException {
        if (!this.codeVersion.equalsIgnoreCase("EVA")) {
            return false;
        }
        try {
            CodeRunner maquina = new CodeRunner(this.theCode, this.theWorld);
            return maquina.runCode(this.theCode, aroutine, dataSegment);
        }
        catch (EVASyntaxException syn) {
            this.theWorld.write("Error de sintaxis en el c\u00f3digo EVA.\n");
            this.theWorld.write("En concreto: " + syn.getMessage() + "\n");
            return false;
        }
    }

    public boolean run(String aroutine, Object theCaller, Object[] theArguments) throws TargetError {
        if (!this.codeVersion.equalsIgnoreCase("BeanShell")) {
            return false;
        }
        try {
            Interpreter i;
            if (this.permanent && this.permanentInterpreter != null) {
                i = this.permanentInterpreter;
            } else {
                this.permanentInterpreter = i = new Interpreter();
                try {
                    i.source("stdfunct.bsh");
                }
                catch (FileNotFoundException fnfe) {
                    System.out.println("Warning: BeanShell standard function library stdfunct.bsh not found!");
                }
                catch (IOException fnfe) {
                    System.out.println("Warning: BeanShell standard function library stdfunct.bsh couldn't be read!");
                }
                Entity context = null;
                if (theCaller instanceof Entity) {
                    context = (Entity)theCaller;
                }
                if (context != null) {
                    List pList = context.getProperties();
                    for (int k = 0; k < pList.size(); ++k) {
                        PropertyEntry pe = (PropertyEntry)pList.get(k);
                        i.set(pe.getName(), pe.getValueAsBoolean());
                    }
                }
                i.set("obj", theCaller);
                i.set("self", theCaller);
                i.set("world", (Object)this.theWorld);
                i.eval(this.theCode);
                if (aroutine == null) {
                    return false;
                }
                i.set("obj", theCaller);
                i.set("self", theCaller);
                i.set("world", (Object)this.theWorld);
            }
            if (!this.existsMethod(i, aroutine, theArguments)) {
                return false;
            }
            String argString = " ";
            for (int k = 0; k < theArguments.length; ++k) {
                i.set("arg" + k, theArguments[k]);
                argString = argString + (k > 0 ? ", arg" : "arg") + k;
            }
            i.eval(aroutine + "(" + argString + ")");
        }
        catch (TargetError te) {
            Throwable lastExcNode = te;
            while (lastExcNode instanceof TargetError) {
                lastExcNode = lastExcNode.getTarget();
            }
            if (lastExcNode instanceof BSHCodeExecutedOKException) {
                return true;
            }
            throw te;
        }
        catch (EvalError pe) {
            this.theWorld.write("Error de sintaxis en el c\u00f3digo BeanShell.\n");
            this.theWorld.write("En concreto: " + (Object)((Object)pe));
            System.out.println(pe.getMessage());
            pe.printStackTrace();
            this.theWorld.write("Informaci\u00f3n adicional BSH:");
            this.theWorld.write("Rutina: " + aroutine + "\n");
            this.theWorld.write("Llamador: " + theCaller + "\n");
            this.theWorld.write("Argumentos: ");
            for (int i = 0; i < theArguments.length; ++i) {
                this.theWorld.write(theArguments[i] + " ");
            }
            this.theWorld.write("\n");
        }
        return false;
    }

    public boolean run(String aroutine, Object theCaller, Object[] theArguments, ReturnValue retval) throws TargetError {
        if (!this.codeVersion.equalsIgnoreCase("BeanShell")) {
            return false;
        }
        try {
            Interpreter i;
            if (this.permanent && this.permanentInterpreter != null) {
                i = this.permanentInterpreter;
            } else {
                this.permanentInterpreter = i = new Interpreter();
                try {
                    i.source("stdfunct.bsh");
                }
                catch (FileNotFoundException fnfe) {
                    System.out.println("Warning: BeanShell standard function library stdfunct.bsh not found!");
                }
                catch (IOException fnfe) {
                    System.out.println("Warning: BeanShell standard function library stdfunct.bsh couldn't be read!");
                }
                System.out.println("stdfunct sourced");
                Entity context = null;
                if (theCaller instanceof Entity) {
                    context = (Entity)theCaller;
                }
                if (context != null) {
                    List pList = context.getProperties();
                    for (int k = 0; k < pList.size(); ++k) {
                        PropertyEntry pe = (PropertyEntry)pList.get(k);
                        i.set(pe.getName(), pe.getValueAsBoolean());
                    }
                }
                System.out.println("context set");
                i.set("obj", theCaller);
                i.set("self", theCaller);
                i.set("world", (Object)this.theWorld);
                if (aroutine == null) {
                    retval.setRetVal(i.eval(this.theCode));
                    return false;
                }
                System.out.println("evaluating code");
                try {
                    System.out.println("Thread: " + Thread.currentThread());
                    System.out.println("try begin");
                    i.eval(this.theCode);
                    System.out.println("try end");
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                System.out.println("done");
                System.out.println("code evaluated");
                i.set("obj", theCaller);
                i.set("self", theCaller);
                i.set("world", (Object)this.theWorld);
            }
            System.out.println("exploring methods");
            if (!this.existsMethod(i, aroutine, theArguments)) {
                return false;
            }
            String argString = " ";
            for (int k = 0; k < theArguments.length; ++k) {
                i.set("arg" + k, theArguments[k]);
                argString = argString + (k > 0 ? ", arg" : "arg") + k;
            }
            retval.setRetVal(i.eval(aroutine + "(" + argString + ")"));
        }
        catch (TargetError te) {
            Throwable lastExcNode = te;
            while (lastExcNode instanceof TargetError) {
                lastExcNode = lastExcNode.getTarget();
            }
            if (lastExcNode instanceof BSHCodeExecutedOKException) {
                return true;
            }
            throw te;
        }
        catch (EvalError pe) {
            this.theWorld.write("Error de sintaxis en el c\u00f3digo BeanShell.\n");
            this.theWorld.write("En concreto: " + (Object)((Object)pe));
            System.out.println(pe.getMessage());
            pe.printStackTrace();
            this.theWorld.write("Error de sintaxis en el c\u00f3digo BeanShell.\n");
            this.theWorld.write("En concreto: " + (Object)((Object)pe));
            System.out.println(pe.getMessage());
            pe.printStackTrace();
            this.theWorld.write("Informaci\u00f3n adicional BSH:");
            this.theWorld.write("Rutina: " + aroutine + "\n");
            this.theWorld.write("Llamador: " + theCaller + "\n");
            this.theWorld.write("Argumentos: ");
            for (int i = 0; i < theArguments.length; ++i) {
                this.theWorld.write(theArguments[i] + " ");
            }
            this.theWorld.write("\n");
        }
        return false;
    }

    public boolean run(String aroutine, Object theCaller, Object[] theArguments, ReturnValue retval, Object[][] initializations) throws TargetError {
        if (!this.codeVersion.equalsIgnoreCase("BeanShell")) {
            return false;
        }
        try {
            Interpreter i;
            if (this.permanent && this.permanentInterpreter != null) {
                i = this.permanentInterpreter;
            } else {
                this.permanentInterpreter = i = new Interpreter();
                try {
                    i.source("stdfunct.bsh");
                }
                catch (FileNotFoundException fnfe) {
                    System.out.println("Warning: BeanShell standard function library stdfunct.bsh not found!");
                }
                catch (IOException fnfe) {
                    System.out.println("Warning: BeanShell standard function library stdfunct.bsh couldn't be read!");
                }
                Entity context = null;
                if (theCaller instanceof Entity) {
                    context = (Entity)theCaller;
                }
                if (context != null) {
                    List pList = context.getProperties();
                    for (int k = 0; k < pList.size(); ++k) {
                        PropertyEntry pe = (PropertyEntry)pList.get(k);
                        i.set(pe.getName(), pe.getValueAsBoolean());
                    }
                }
                i.set("obj", theCaller);
                i.set("self", theCaller);
                i.set("world", (Object)this.theWorld);
            }
            for (int w = 0; w < initializations.length; ++w) {
                Object[] curInit = initializations[w];
                if (curInit.length < 2) continue;
                i.set((String)curInit[0], curInit[1]);
            }
            if (aroutine == null) {
                retval.setRetVal(i.eval(this.theCode));
                return false;
            }
            i.eval(this.theCode);
            i.set("obj", theCaller);
            i.set("self", theCaller);
            i.set("world", (Object)this.theWorld);
            if (!this.existsMethod(i, aroutine, theArguments)) {
                return false;
            }
            String argString = " ";
            for (int k = 0; k < theArguments.length; ++k) {
                i.set("arg" + k, theArguments[k]);
                argString = argString + (k > 0 ? ", arg" : "arg") + k;
            }
            retval.setRetVal(i.eval(aroutine + "(" + argString + ")"));
        }
        catch (TargetError te) {
            Throwable lastExcNode = te;
            while (lastExcNode instanceof TargetError) {
                lastExcNode = lastExcNode.getTarget();
            }
            if (lastExcNode instanceof BSHCodeExecutedOKException) {
                return true;
            }
            throw te;
        }
        catch (EvalError pe) {
            this.theWorld.write("Error de sintaxis en el c\u00f3digo BeanShell.\n");
            this.theWorld.write("En concreto: " + (Object)((Object)pe));
            System.out.println(pe.getMessage());
            pe.printStackTrace();
            this.theWorld.write("Error de sintaxis en el c\u00f3digo BeanShell.\n");
            this.theWorld.write("En concreto: " + (Object)((Object)pe));
            System.out.println(pe.getMessage());
            pe.printStackTrace();
            this.theWorld.write("Informaci\u00f3n adicional BSH:");
            this.theWorld.write("Rutina: " + aroutine + "\n");
            this.theWorld.write("Llamador: " + theCaller + "\n");
            this.theWorld.write("Argumentos: ");
            for (int i = 0; i < theArguments.length; ++i) {
                this.theWorld.write(theArguments[i] + " ");
            }
            this.theWorld.write("\n");
        }
        return false;
    }

    public Node getXMLRepresentation(Document doc) {
        return this.getXMLRepresentation(doc, "Code");
    }

    public Node getXMLRepresentation(Document doc, String tagName) {
        Element suElemento = doc.createElement(tagName);
        Text t = doc.createTextNode(this.theCode);
        suElemento.appendChild(t);
        suElemento.setAttribute("language", String.valueOf(this.codeVersion));
        return suElemento;
    }

    public ObjectCode(World mundo, Node n) throws XMLtoWorldException {
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("Code node not Element");
        }
        Element e = (Element)n;
        if (!e.hasAttribute("language")) {
            throw new XMLtoWorldException("Code node lacks language attribute");
        }
        this.codeVersion = e.getAttribute("language");
        this.theCode = e.getFirstChild().getNodeValue();
        this.theWorld = mundo;
    }

    private boolean existsMethod(Interpreter i, String methodName, Object[] arguments) {
        int m;
        BshMethod[] metodos = i.getNameSpace().getMethods();
        for (m = 0; m < metodos.length; ++m) {
            BshMethod method = metodos[m];
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != arguments.length) continue;
            boolean correct = true;
            for (int k = 0; k < arguments.length; ++k) {
                if (arguments[k] == null || method.getParameterTypes()[k].isAssignableFrom(arguments[k].getClass())) continue;
                correct = false;
            }
            if (correct) break;
        }
        return m < metodos.length;
    }
}

