/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.InputOutputClient;
import eu.irreality.age.Player;
import eu.irreality.age.StringMethods;
import eu.irreality.age.TelnetConstants;
import eu.irreality.age.World;
import eu.irreality.age.XMLtoWorldException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.LinkedList;
import java.util.Vector;

public class SimpleTelnetClientProxy
implements InputOutputClient,
TelnetConstants {
    private Socket incoming;
    private int id;
    private InputStream is;
    private OutputStream os;
    private BufferedReader in;
    private PrintWriter out;
    private boolean asynchronous;
    private LinkedList inputQueue = new LinkedList();
    private Vector gameLog = new Vector();
    private boolean clientHasDisconnected = false;

    public boolean isDisconnected() {
        return this.clientHasDisconnected;
    }

    public boolean checkForANSISupport() throws IOException {
        boolean terminamos = false;
        int tries = 10;
        this.os.write(255);
        this.os.write(253);
        this.os.write(36);
        while (!terminamos) {
            System.out.println("Iteration.");
            int abyte = this.is.read();
            if (tries == 0) {
                terminamos = true;
            }
            if (abyte == -1) break;
            if (abyte != 255) continue;
            System.out.println("IAC.");
            int bbyte = this.is.read();
            switch (bbyte) {
                case 251: {
                    System.out.println("WILL.");
                    int cbyte = this.is.read();
                    if (cbyte != 36) break;
                    this.os.write(255);
                    this.os.write(250);
                    this.os.write(36);
                    this.os.write(1);
                    this.os.write(255);
                    this.os.write(240);
                    break;
                }
                case 252: {
                    System.out.println("WONT.");
                    int cbyte2 = this.is.read();
                    if (cbyte2 != 36) break;
                    System.out.println("TELOPT_TTYPE.");
                    this.write("Your telnet client refuses negotiating terminal types.\n");
                    terminamos = true;
                    break;
                }
                case 250: {
                    int c;
                    System.out.println("SB.");
                    int cbyte3 = this.is.read();
                    if (cbyte3 != 36) break;
                    byte[] buf = new byte[100];
                    this.is.skip(1L);
                    for (int i = 0; (c = this.is.read()) != 255 && i < 99; ++i) {
                        buf[i] = (byte)c;
                    }
                    buf[i] = 0;
                    String termTypeString = new String(buf);
                    System.out.println("TERMTYPESTRING:" + termTypeString + "\n");
                    if (termTypeString.equalsIgnoreCase("ansi") || termTypeString.equalsIgnoreCase("vt100") || termTypeString.equalsIgnoreCase("xterm") || termTypeString.equalsIgnoreCase("vt320") || termTypeString.equalsIgnoreCase("mushclient") || termTypeString.equalsIgnoreCase("zmud")) {
                        this.write("ANSI support detected (" + termTypeString + ")\n");
                        return true;
                    }
                    this.os.write(255);
                    this.os.write(250);
                    this.os.write(36);
                    this.os.write(1);
                    this.os.write(255);
                    this.os.write(240);
                    --tries;
                }
            }
        }
        return false;
    }

    public SimpleTelnetClientProxy(Socket s, int id, World mundo) {
        this.incoming = s;
        this.id = id;
        try {
            if (this.incoming != null) {
                this.is = this.incoming.getInputStream();
                this.in = new BufferedReader(new InputStreamReader(this.is));
                this.os = this.incoming.getOutputStream();
                this.out = new PrintWriter(new OutputStreamWriter(this.os));
            }
        }
        catch (Exception e) {
            System.out.println("Error: " + e);
        }
        try {
            boolean ANSIsupport = this.checkForANSISupport();
            this.write("Welcome to denebola [port " + s.getLocalPort() + "] running the Aetheria Game Engine.\n");
            this.write("Your client ID is " + id + ".\n");
            mundo.addNewPlayerASAP(this);
        }
        catch (XMLtoWorldException e) {
            System.out.println("Couldn't: XMLtoWorldException " + e);
        }
        catch (IOException e) {
            System.out.println("I/O Exception: " + e);
        }
    }

    public boolean isColorEnabled() {
        return false;
    }

    public boolean isMemoryEnabled() {
        return false;
    }

    public boolean isLoggingEnabled() {
        return true;
    }

    public boolean isTitleEnabled() {
        return false;
    }

    private void setSynchronousMode() {
        this.asynchronous = false;
    }

    private void setAsynchronousMode() {
        if (!this.asynchronous) {
            this.asynchronous = true;
            this.inputQueue = new LinkedList();
            Thread t = new Thread(){

                public void run() {
                    try {
                        while (true) {
                            String str;
                            if ((str = SimpleTelnetClientProxy.this.in.readLine()) == null) {
                                System.out.println("Nullified input.\n");
                                SimpleTelnetClientProxy.this.clientHasDisconnected = true;
                                break;
                            }
                            System.out.println("Adding 2 Que: " + str);
                            SimpleTelnetClientProxy.this.inputQueue.addLast(str);
                        }
                    }
                    catch (IOException ioe) {
                        SimpleTelnetClientProxy.this.clientHasDisconnected = true;
                        System.out.println("IO Exception.\n");
                    }
                }
            };
            t.start();
        }
    }

    public String getInput(Player pl) {
        this.setSynchronousMode();
        try {
            this.write("SynchronousInput> ");
            String str = this.in.readLine();
            if (str == null) {
                this.clientHasDisconnected = true;
                return null;
            }
            System.out.println("INPUT GOTTEN: " + str);
            return str;
        }
        catch (IOException ioe) {
            this.clientHasDisconnected = true;
            System.out.println("Oh yeppie, en \u00c1i Ou Excepxen.\n");
            return null;
        }
    }

    public String getRealTimeInput(Player pl) {
        this.setAsynchronousMode();
        if (this.inputQueue.isEmpty()) {
            return null;
        }
        String str = (String)this.inputQueue.removeFirst();
        return str;
    }

    public void waitKeyPress() {
        this.setSynchronousMode();
        this.write("[Pulse ENTER]\n");
        try {
            String str = this.in.readLine();
            System.out.println("INPUT GOTTEN (line)\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void escribirTitulo(String s) {
        this.writeTitle(s);
    }

    public void writeTitle(String s) {
    }

    public void escribirTitulo(String s, int pos) {
        this.writeTitle(s, pos);
    }

    public void writeTitle(String s, int pos) {
    }

    public void escribir(String s) {
        this.write(s);
    }

    public void write(String s) {
        if (this.out != null) {
            System.out.print("Systemoutprinting:" + s);
            this.out.print(StringMethods.textualSubstitution(s, "\n", "\n\r"));
            this.out.flush();
        }
    }

    public void loguear(String s) {
        this.gameLog.add(s);
    }

    public void forzarEntrada(String s, boolean output_enabled) {
        this.forceInput(s, output_enabled);
    }

    public void forceInput(String s, boolean output_enabled) {
        this.gameLog.addElement(s);
        this.write("\n");
        this.write(" > " + s.trim());
    }

    public void borrarPantalla() {
        this.write("Aqu\u00ed se borrar\u00eda la pantalla.\n");
    }

    public String getColorCode(String colorKey) {
        return "";
    }
}

