/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.Item;
import eu.irreality.age.Mobile;
import eu.irreality.age.StringMethods;
import eu.irreality.age.Utility;
import eu.irreality.age.World;
import eu.irreality.age.XMLtoWorldException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Weapon
extends Item {
    private static int USAGE_CORRECTOR = 100;
    String weapon_type;
    double minskill_twohand;
    double minskill_onehand;
    double maxskill;
    private String attack_damage_formula;
    private String defense_damage_formula;
    String[] attack_names_list;
    List wieldableLimbs = new Vector();
    private long attackMinimalUsage;
    private String[] attackInvolvedSkills;
    private double[] attackInvolvedSkillRelevance;
    private double attackProbabilitySteepness;
    private double attackTimeSteepness;
    private double attackStartingTime;
    private double attackRecoverTimeSteepness;
    private double attackRecoverStartingTime;
    private long defenseMinimalUsage;
    private String[] defenseInvolvedSkills;
    private double[] defenseInvolvedSkillRelevance;
    private double defenseProbabilitySteepness;
    private double defenseTimeSteepness;
    private double defenseStartingTime;
    private double defenseRecoverTimeSteepness;
    private double defenseRecoverStartingTime;

    public void addDamageBonus(int amt) {
        this.attack_damage_formula = this.attack_damage_formula + "+2";
    }

    public Weapon(World mundo, String itemfile) throws IOException, FileNotFoundException {
        this.constructItem(mundo, itemfile, true, "weapon");
    }

    public Weapon(World mundo, Node n) throws XMLtoWorldException {
        this.constructItem(mundo, n, true, "weapon");
    }

    public void readWeaponSpecifics(World mundo, Node n) throws XMLtoWorldException {
        NodeList defenseNodes;
        NodeList attackNodes;
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("Weapon node not Element");
        }
        Element e = (Element)n;
        NodeList singRefNamesNodes = e.getElementsByTagName("WieldableLimbs");
        if (singRefNamesNodes.getLength() > 0) {
            Element singRefNamesNode = (Element)singRefNamesNodes.item(0);
            NodeList reqNodes = singRefNamesNode.getElementsByTagName("Requirement");
            for (int k = 0; k < reqNodes.getLength(); ++k) {
                Element reqNode = (Element)reqNodes.item(k);
                NodeList nameNodes = reqNode.getElementsByTagName("Name");
                String curLimbNames = "";
                for (int i = 0; i < nameNodes.getLength(); ++i) {
                    Element nameNode = (Element)nameNodes.item(i);
                    Node hijo = nameNode.getFirstChild();
                    while (!(hijo instanceof Text)) {
                        hijo = hijo.getNextSibling();
                    }
                    curLimbNames = curLimbNames + hijo.getNodeValue();
                    if (i >= nameNodes.getLength() - 1) continue;
                    curLimbNames = curLimbNames + "$";
                }
                this.wieldableLimbs.add(curLimbNames);
            }
        }
        if ((attackNodes = e.getElementsByTagName("Attack")).getLength() > 0) {
            Element atProb;
            NodeList nl;
            Element attackNode = (Element)attackNodes.item(0);
            if (attackNode.hasAttribute("minUsage")) {
                try {
                    this.attackMinimalUsage = Long.valueOf(attackNode.getAttribute("minUsage"));
                }
                catch (NumberFormatException nfe) {
                    throw new XMLtoWorldException("Number format error at attackMinimalUsage");
                }
            } else {
                this.attackMinimalUsage = 0L;
            }
            NodeList nl1 = attackNode.getElementsByTagName("InvolvedSkills");
            if (nl1.getLength() > 0) {
                Element invsk = (Element)nl1.item(0);
                NodeList skillnodes = invsk.getElementsByTagName("Skill");
                this.attackInvolvedSkills = new String[skillnodes.getLength()];
                this.attackInvolvedSkillRelevance = new double[skillnodes.getLength()];
                for (int i = 0; i < skillnodes.getLength(); ++i) {
                    Element skillNode = (Element)skillnodes.item(i);
                    if (!skillNode.hasAttribute("name")) {
                        throw new XMLtoWorldException("Skill node lacking attribute name");
                    }
                    if (!skillNode.hasAttribute("relevance")) {
                        this.attackInvolvedSkillRelevance[i] = 1.0;
                    }
                    try {
                        if (skillNode.hasAttribute("relevance")) {
                            this.attackInvolvedSkillRelevance[i] = Double.valueOf(skillNode.getAttribute("relevance"));
                        }
                        this.attackInvolvedSkills[i] = skillNode.getAttribute("name");
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new XMLtoWorldException("Wrong number format for relevance attribute at weapon's attack skill node");
                    }
                }
            }
            if ((nl = attackNode.getElementsByTagName("Probability")).getLength() > 0) {
                atProb = (Element)nl.item(0);
                if (atProb.hasAttribute("steepness")) {
                    try {
                        this.attackProbabilitySteepness = Double.valueOf(atProb.getAttribute("steepness"));
                    }
                    catch (NumberFormatException nfe) {
                        throw new XMLtoWorldException("Number format error at attackProbabilitySteepness");
                    }
                } else {
                    this.attackProbabilitySteepness = 0.0;
                }
            }
            if ((nl = attackNode.getElementsByTagName("Time")).getLength() > 0) {
                atProb = (Element)nl.item(0);
                if (atProb.hasAttribute("steepness")) {
                    try {
                        this.attackTimeSteepness = Double.valueOf(atProb.getAttribute("steepness"));
                    }
                    catch (NumberFormatException nfe) {
                        throw new XMLtoWorldException("Number format error at attackTimeSteepness");
                    }
                } else {
                    this.attackTimeSteepness = 0.0;
                }
                if (atProb.hasAttribute("starting")) {
                    try {
                        this.attackStartingTime = Double.valueOf(atProb.getAttribute("starting"));
                    }
                    catch (NumberFormatException nfe) {
                        throw new XMLtoWorldException("Number format error at attackStartingTime");
                    }
                } else {
                    this.attackStartingTime = 30.0;
                }
            }
            if ((nl = attackNode.getElementsByTagName("RecoverTime")).getLength() > 0) {
                atProb = (Element)nl.item(0);
                if (atProb.hasAttribute("steepness")) {
                    try {
                        this.attackRecoverTimeSteepness = Double.valueOf(atProb.getAttribute("steepness"));
                    }
                    catch (NumberFormatException nfe) {
                        throw new XMLtoWorldException("Number format error at attackRecoverTimeSteepness");
                    }
                } else {
                    this.attackRecoverTimeSteepness = 0.0;
                }
                if (atProb.hasAttribute("starting")) {
                    try {
                        this.attackRecoverStartingTime = Double.valueOf(atProb.getAttribute("starting"));
                    }
                    catch (NumberFormatException nfe) {
                        throw new XMLtoWorldException("Number format error at attackRecoverStartingTime");
                    }
                } else {
                    this.attackRecoverStartingTime = 0.0;
                }
            }
            if ((nl = attackNode.getElementsByTagName("DamageList")).getLength() > 0) {
                Element atDam = (Element)nl.item(0);
                NodeList damageElements = atDam.getElementsByTagName("Damage");
                for (int i = 0; i < damageElements.getLength(); ++i) {
                    Element curDamageElement = (Element)damageElements.item(i);
                    if (!curDamageElement.hasAttribute("type")) {
                        throw new XMLtoWorldException("Damage element lacking type attribute");
                    }
                    if (!curDamageElement.hasAttribute("formula")) {
                        throw new XMLtoWorldException("Damage element lacking formula attribute");
                    }
                    if (this.attack_damage_formula == null) {
                        this.attack_damage_formula = "";
                    }
                    if (i > 0) {
                        this.attack_damage_formula = this.attack_damage_formula + "$";
                    }
                    this.attack_damage_formula = this.attack_damage_formula + curDamageElement.getAttribute("type");
                    this.attack_damage_formula = this.attack_damage_formula + ":";
                    this.attack_damage_formula = this.attack_damage_formula + curDamageElement.getAttribute("formula");
                }
            }
        }
        if ((defenseNodes = e.getElementsByTagName("Defense")).getLength() > 0) {
            NodeList nl;
            Element defenseNode = (Element)defenseNodes.item(0);
            if (defenseNode.hasAttribute("minUsage")) {
                try {
                    this.defenseMinimalUsage = Long.valueOf(defenseNode.getAttribute("minUsage"));
                }
                catch (NumberFormatException nfe) {
                    throw new XMLtoWorldException("Number format error at defenseMinimalUsage");
                }
            } else {
                this.defenseMinimalUsage = 0L;
            }
            NodeList nl1 = defenseNode.getElementsByTagName("InvolvedSkills");
            if (nl1.getLength() > 0) {
                Element invsk = (Element)nl1.item(0);
                NodeList skillnodes = invsk.getElementsByTagName("Skill");
                this.defenseInvolvedSkills = new String[skillnodes.getLength()];
                this.defenseInvolvedSkillRelevance = new double[skillnodes.getLength()];
                for (int i = 0; i < skillnodes.getLength(); ++i) {
                    Element skillNode = (Element)skillnodes.item(i);
                    if (!skillNode.hasAttribute("name")) {
                        throw new XMLtoWorldException("Skill node lacking attribute name");
                    }
                    if (!skillNode.hasAttribute("relevance")) {
                        this.defenseInvolvedSkillRelevance[i] = 1.0;
                    }
                    try {
                        if (skillNode.hasAttribute("relevance")) {
                            this.defenseInvolvedSkillRelevance[i] = Double.valueOf(skillNode.getAttribute("relevance"));
                        }
                        this.defenseInvolvedSkills[i] = skillNode.getAttribute("name");
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new XMLtoWorldException("Wrong number format for relevance attribute at weapon's defense skill node");
                    }
                }
            }
            if ((nl = defenseNode.getElementsByTagName("Probability")).getLength() > 0) {
                Element atProb = (Element)nl.item(0);
                if (atProb.hasAttribute("steepness")) {
                    try {
                        this.defenseProbabilitySteepness = Double.valueOf(atProb.getAttribute("steepness"));
                    }
                    catch (NumberFormatException nfe) {
                        throw new XMLtoWorldException("Number format error at defenseProbabilitySteepness");
                    }
                } else {
                    this.defenseProbabilitySteepness = 0.0;
                }
            }
            if ((nl = defenseNode.getElementsByTagName("Time")).getLength() > 0) {
                Element atProb = (Element)nl.item(0);
                if (atProb.hasAttribute("steepness")) {
                    try {
                        this.defenseTimeSteepness = Double.valueOf(atProb.getAttribute("steepness"));
                    }
                    catch (NumberFormatException nfe) {
                        throw new XMLtoWorldException("Number format error at defenseTimeSteepness");
                    }
                } else {
                    this.defenseTimeSteepness = 0.0;
                }
                if (atProb.hasAttribute("starting")) {
                    try {
                        this.defenseStartingTime = Double.valueOf(atProb.getAttribute("starting"));
                    }
                    catch (NumberFormatException nfe) {
                        throw new XMLtoWorldException("Number format error at defenseStartingTime");
                    }
                } else {
                    this.defenseStartingTime = 0.0;
                }
            }
            if ((nl = defenseNode.getElementsByTagName("RecoverTime")).getLength() > 0) {
                Element atProb = (Element)nl.item(0);
                if (atProb.hasAttribute("steepness")) {
                    try {
                        this.defenseRecoverTimeSteepness = Double.valueOf(atProb.getAttribute("steepness"));
                    }
                    catch (NumberFormatException nfe) {
                        throw new XMLtoWorldException("Number format error at defenseRecoverTimeSteepness");
                    }
                } else {
                    this.defenseRecoverTimeSteepness = 0.0;
                }
                if (atProb.hasAttribute("starting")) {
                    try {
                        this.defenseRecoverStartingTime = Double.valueOf(atProb.getAttribute("starting"));
                    }
                    catch (NumberFormatException nfe) {
                        throw new XMLtoWorldException("Number format error at defenseRecoverStartingTime");
                    }
                } else {
                    this.defenseRecoverStartingTime = 0.0;
                }
            }
            if ((nl = defenseNode.getElementsByTagName("DamageList")).getLength() > 0) {
                Element atDam = (Element)nl.item(0);
                NodeList damageElements = atDam.getElementsByTagName("Damage");
                for (int i = 0; i < damageElements.getLength(); ++i) {
                    Element curDamageElement = (Element)damageElements.item(i);
                    if (!curDamageElement.hasAttribute("type")) {
                        throw new XMLtoWorldException("Damage element lacking type attribute");
                    }
                    if (!curDamageElement.hasAttribute("formula")) {
                        throw new XMLtoWorldException("Damage element lacking formula attribute");
                    }
                    if (this.defense_damage_formula == null) {
                        this.defense_damage_formula = "";
                    }
                    if (i > 0) {
                        this.defense_damage_formula = this.defense_damage_formula + "$";
                    }
                    this.defense_damage_formula = this.defense_damage_formula + curDamageElement.getAttribute("type");
                    this.defense_damage_formula = this.defense_damage_formula + ":";
                    this.defense_damage_formula = this.defense_damage_formula + curDamageElement.getAttribute("formula");
                }
            }
        }
    }

    public Node getXMLRepresentation(Document doc) {
        Node nodoItem = super.getXMLRepresentation(doc);
        nodoItem.appendChild(this.getWeaponSpecificsXMLRepresentation(doc));
        return nodoItem;
    }

    public Node getWeaponSpecificsXMLRepresentation(Document doc) {
        Element suElemento = doc.createElement("WeaponSpecs");
        if (this.wieldableLimbs != null) {
            Element elt = doc.createElement("WieldableLimbs");
            for (int i = 0; i < this.wieldableLimbs.size(); ++i) {
                String curString = (String)this.wieldableLimbs.get(i);
                Element reqNode = doc.createElement("Requirement");
                StringTokenizer st = new StringTokenizer(curString, "$");
                while (st.hasMoreTokens()) {
                    String tok = st.nextToken();
                    Element esteNombre = doc.createElement("Name");
                    Text elNombre = doc.createTextNode(tok);
                    esteNombre.appendChild(elNombre);
                    reqNode.appendChild(esteNombre);
                }
                elt.appendChild(reqNode);
            }
            suElemento.appendChild(elt);
        }
        Element attackElement = doc.createElement("Attack");
        attackElement.setAttribute("minUsage", String.valueOf(this.attackMinimalUsage));
        Element attackSkillsElement = doc.createElement("InvolvedSkills");
        if (this.attackInvolvedSkills != null) {
            for (int i = 0; i < this.attackInvolvedSkills.length; ++i) {
                Element thisSkillElement = doc.createElement("Skill");
                thisSkillElement.setAttribute("name", this.attackInvolvedSkills[i]);
                thisSkillElement.setAttribute("relevance", String.valueOf(this.attackInvolvedSkillRelevance[i]));
                attackSkillsElement.appendChild(thisSkillElement);
            }
        }
        attackElement.appendChild(attackSkillsElement);
        Element attackProbabilityElement = doc.createElement("Probability");
        attackProbabilityElement.setAttribute("steepness", String.valueOf(this.attackProbabilitySteepness));
        attackElement.appendChild(attackProbabilityElement);
        Element attackTimeElement = doc.createElement("Time");
        attackTimeElement.setAttribute("steepness", String.valueOf(this.attackTimeSteepness));
        attackTimeElement.setAttribute("starting", String.valueOf(this.attackStartingTime));
        attackElement.appendChild(attackTimeElement);
        Element attackRecoverTimeElement = doc.createElement("RecoverTime");
        attackRecoverTimeElement.setAttribute("steepness", String.valueOf(this.attackRecoverTimeSteepness));
        attackRecoverTimeElement.setAttribute("starting", String.valueOf(this.attackRecoverStartingTime));
        attackElement.appendChild(attackRecoverTimeElement);
        Element attackDamageElement = doc.createElement("DamageList");
        if (this.attack_damage_formula != null) {
            StringTokenizer st = new StringTokenizer(this.attack_damage_formula, "$");
            while (st.hasMoreTokens()) {
                String curToken = st.nextToken();
                StringTokenizer st2 = new StringTokenizer(curToken, ":");
                String damTypeString = st2.nextToken().trim();
                String damFormulaString = st2.nextToken().trim();
                Element curDamageElement = doc.createElement("Damage");
                curDamageElement.setAttribute("type", damTypeString);
                curDamageElement.setAttribute("formula", damFormulaString);
                attackDamageElement.appendChild(curDamageElement);
            }
        }
        attackElement.appendChild(attackDamageElement);
        suElemento.appendChild(attackElement);
        Element defenseElement = doc.createElement("Defense");
        defenseElement.setAttribute("minUsage", String.valueOf(this.defenseMinimalUsage));
        Element defenseSkillsElement = doc.createElement("InvolvedSkills");
        if (this.defenseInvolvedSkills != null) {
            for (int i = 0; i < this.defenseInvolvedSkills.length; ++i) {
                Element thisSkillElement = doc.createElement("Skill");
                thisSkillElement.setAttribute("name", this.defenseInvolvedSkills[i]);
                thisSkillElement.setAttribute("relevance", String.valueOf(this.defenseInvolvedSkillRelevance[i]));
                defenseSkillsElement.appendChild(thisSkillElement);
            }
        }
        defenseElement.appendChild(defenseSkillsElement);
        Element defenseProbabilityElement = doc.createElement("Probability");
        defenseProbabilityElement.setAttribute("steepness", String.valueOf(this.defenseProbabilitySteepness));
        defenseElement.appendChild(defenseProbabilityElement);
        Element defenseTimeElement = doc.createElement("Time");
        defenseTimeElement.setAttribute("steepness", String.valueOf(this.defenseTimeSteepness));
        defenseTimeElement.setAttribute("starting", String.valueOf(this.defenseStartingTime));
        defenseElement.appendChild(defenseTimeElement);
        Element defenseRecoverTimeElement = doc.createElement("RecoverTime");
        defenseRecoverTimeElement.setAttribute("steepness", String.valueOf(this.defenseRecoverTimeSteepness));
        defenseRecoverTimeElement.setAttribute("starting", String.valueOf(this.defenseRecoverStartingTime));
        defenseElement.appendChild(defenseRecoverTimeElement);
        Element defenseDamageElement = doc.createElement("DamageList");
        if (this.defense_damage_formula != null) {
            StringTokenizer st = new StringTokenizer(this.defense_damage_formula, "$");
            while (st.hasMoreTokens()) {
                String curToken = st.nextToken();
                StringTokenizer st2 = new StringTokenizer(curToken, ":");
                String damTypeString = st2.nextToken().trim();
                String damFormulaString = st2.nextToken().trim();
                Element curDamageElement = doc.createElement("Damage");
                curDamageElement.setAttribute("type", damTypeString);
                curDamageElement.setAttribute("formula", damFormulaString);
                defenseDamageElement.appendChild(curDamageElement);
            }
        }
        defenseElement.appendChild(defenseDamageElement);
        suElemento.appendChild(defenseElement);
        return suElemento;
    }

    public void readWeaponSpecifics(World mundo, String itemfile) throws IOException, FileNotFoundException {
        FileInputStream fp = new FileInputStream(itemfile);
        BufferedReader filein = new BufferedReader(Utility.getBestInputStreamReader(fp));
        block10: for (int line = 1; line < 100; ++line) {
            String linea = filein.readLine();
            String id_linea = StringMethods.getTok(linea, 1, ' ');
            linea = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
            if (id_linea == null) continue;
            switch (Integer.valueOf(id_linea)) {
                case 50: {
                    continue block10;
                }
                case 51: {
                    this.minskill_twohand = Double.valueOf(linea);
                    continue block10;
                }
                case 52: {
                    this.minskill_onehand = Double.valueOf(linea);
                    continue block10;
                }
                case 53: {
                    this.maxskill = Double.valueOf(linea);
                    continue block10;
                }
                case 54: {
                    this.attack_damage_formula = linea;
                    continue block10;
                }
                case 55: {
                    continue block10;
                }
                case 60: {
                    continue block10;
                }
                case 61: {
                    this.wieldableLimbs = new Vector();
                    this.wieldableLimbs.add(linea);
                }
            }
        }
    }

    public int dealDamage(Mobile atacante, Mobile defensor, boolean simulated) {
        List listaDanos = this.getDamagesListFromFormula(this.attack_damage_formula, atacante);
        int danoTotal = 0;
        for (int i = 0; i < listaDanos.size(); ++i) {
            danoTotal += defensor.tryToDealDamage(i, (Integer)listaDanos.get(i), simulated);
        }
        return danoTotal;
    }

    public int dealDamageDefended(Mobile atacante, Mobile defensor, boolean simulated) {
        List listaDanosAtaque = this.getDamagesListFromFormula(this.attack_damage_formula, atacante);
        List listaDanosDefensa = this.getDamagesListFromFormula(defensor.getCurrentWeapon().defense_damage_formula, defensor);
        int danoTotal = 0;
        for (int i = 0; i < listaDanosAtaque.size(); ++i) {
            int danoAHacer = i < listaDanosDefensa.size() ? (Integer)listaDanosAtaque.get(i) - (Integer)listaDanosDefensa.get(i) : (Integer)listaDanosAtaque.get(i);
            if (danoAHacer < 0) {
                danoAHacer = 0;
            }
            danoTotal += defensor.tryToDealDamage(i, danoAHacer, simulated);
        }
        return danoTotal;
    }

    public int dealDamage(Mobile atacante, Mobile defensor, boolean simulated, Item limb) {
        System.out.println("Dealing damage with " + this + this.attack_damage_formula);
        List listaDanos = this.getDamagesListFromFormula(this.attack_damage_formula, atacante);
        System.out.println("" + listaDanos);
        return defensor.tryToDealDamage(listaDanos, simulated, limb);
    }

    public int dealDamageDefended(Mobile atacante, Mobile defensor, boolean simulated, Item limb) {
        List listaDanosAtaque = this.getDamagesListFromFormula(this.attack_damage_formula, atacante);
        List listaDanosDefensa = this.getDamagesListFromFormula(defensor.getCurrentWeapon().defense_damage_formula, defensor);
        ArrayList<Integer> listaDanosTotal = new ArrayList<Integer>();
        for (int i = 0; i < listaDanosAtaque.size(); ++i) {
            int danoAHacer = i < listaDanosDefensa.size() ? (Integer)listaDanosAtaque.get(i) - (Integer)listaDanosDefensa.get(i) : (Integer)listaDanosAtaque.get(i);
            if (danoAHacer < 0) {
                danoAHacer = 0;
            }
            listaDanosTotal.add(new Integer(danoAHacer));
        }
        return defensor.tryToDealDamage(listaDanosTotal, simulated, limb);
    }

    public List getDamagesListFromFormula(String damage_formula, Mobile atacanteODefensor) {
        ArrayList<Integer> listaDanos = new ArrayList<Integer>();
        String ourFormula = this.getDamageFromFormula(damage_formula, atacanteODefensor);
        StringTokenizer st = new StringTokenizer(ourFormula, "$");
        while (st.hasMoreTokens()) {
            String curToken = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(curToken, ":");
            int damtype = Integer.valueOf(st2.nextToken().trim());
            int damamount = Integer.valueOf(st2.nextToken().trim());
            while (listaDanos.size() <= damtype) {
                listaDanos.add(null);
            }
            listaDanos.set(damtype, new Integer(damamount));
        }
        for (int i = 0; i < listaDanos.size(); ++i) {
            if (listaDanos.get(i) != null) continue;
            listaDanos.set(i, new Integer(0));
        }
        return listaDanos;
    }

    public String getDamageFromFormula(String damage_formula, Mobile atacanteODefensor) {
        String result = "";
        if (damage_formula == null) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(damage_formula, "$");
        while (st.hasMoreTokens()) {
            String curToken = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(curToken, ":");
            result = result + st2.nextToken().trim();
            result = result + ":";
            String laformula = st2.nextToken().trim();
            StringTokenizer stFormula = new StringTokenizer(laformula, "+-", true);
            boolean sumaOResta = true;
            int elResultado = 0;
            while (stFormula.hasMoreTokens()) {
                String curFormulaToken = stFormula.nextToken().trim();
                if (curFormulaToken.equals("+")) {
                    sumaOResta = true;
                    continue;
                }
                if (curFormulaToken.equals("-")) {
                    sumaOResta = false;
                    continue;
                }
                int sumando = this.processAtomicFormula(curFormulaToken, atacanteODefensor);
                if (sumaOResta) {
                    elResultado += sumando;
                    continue;
                }
                elResultado -= sumando;
            }
            result = result + String.valueOf(elResultado);
            result = result + "$";
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - 1);
        }
        System.out.println(this.getTitle() + " drawing damage from " + damage_formula + " resulted " + result);
        return result;
    }

    private int processAtomicFormula(String formula, Mobile atacanteODefensor) {
        if (formula.endsWith("FUE") || formula.endsWith("STR") || formula.endsWith("CON") || formula.endsWith("INT") || formula.endsWith("SAB") || formula.endsWith("WIS") || formula.endsWith("DES") || formula.endsWith("DEX") || formula.endsWith("CHA") || formula.endsWith("CAR") || formula.endsWith("POD") || formula.endsWith("POW")) {
            return this.processAtomicFormula(formula.substring(0, formula.length() - 3), atacanteODefensor) * atacanteODefensor.getStat(formula.substring(formula.length() - 3, formula.length()));
        }
        if (formula.equals("")) {
            return 0;
        }
        if (StringMethods.numToks(formula, 'D') > 1) {
            Random rand = this.getRandom();
            int numDados = Integer.valueOf(StringMethods.getTok(formula, 1, 'D'));
            int cantDado = Integer.valueOf(StringMethods.getTok(formula, 2, 'D'));
            int tirada = 0;
            System.out.print("-ndados" + numDados + "-");
            for (int i = 0; i < numDados; ++i) {
                int temp = rand.nextInt();
                System.out.print("<tir" + (tirada += Math.abs(temp % cantDado) + 1) + ">");
            }
            return tirada;
        }
        return Integer.valueOf(formula);
    }

    public double getTypicalAttackTime(long usage) {
        return this.getTypicalTime(usage, this.attackStartingTime, this.attackMinimalUsage, this.attackTimeSteepness);
    }

    public double getTypicalAttackRecoverTime(long usage) {
        return this.getTypicalTime(usage, this.attackRecoverStartingTime, this.attackMinimalUsage, this.attackRecoverTimeSteepness);
    }

    public double getTypicalAttackProbability(long usage) {
        return 1.0 - this.getTypicalTime(usage, 1.0, this.attackMinimalUsage, this.attackProbabilitySteepness);
    }

    public double getTypicalDefenseTime(long usage) {
        return this.getTypicalTime(usage, this.defenseStartingTime, this.defenseMinimalUsage, this.defenseTimeSteepness);
    }

    public double getTypicalDefenseRecoverTime(long usage) {
        return this.getTypicalTime(usage, this.defenseRecoverStartingTime, this.defenseMinimalUsage, this.defenseRecoverTimeSteepness);
    }

    public double getTypicalDefenseProbability(long usage) {
        return 1.0 - this.getTypicalTime(usage, 1.0, this.defenseMinimalUsage, this.defenseProbabilitySteepness);
    }

    public double getTypicalAttackTime(Mobile m) {
        return this.getTypicalTime(this.getAttackUsage(m), this.attackStartingTime, this.attackMinimalUsage, this.attackTimeSteepness);
    }

    public double getTypicalAttackRecoverTime(Mobile m) {
        return this.getTypicalTime(this.getAttackUsage(m), this.attackRecoverStartingTime, this.attackMinimalUsage, this.attackRecoverTimeSteepness);
    }

    public double getTypicalAttackProbability(Mobile m) {
        return 1.0 - this.getTypicalTime(this.getAttackUsage(m), 1.0, this.attackMinimalUsage, this.attackProbabilitySteepness);
    }

    public double getTypicalDefenseTime(Mobile m) {
        return this.getTypicalTime(this.getDefenseUsage(m), this.defenseStartingTime, this.defenseMinimalUsage, this.defenseTimeSteepness);
    }

    public double getTypicalDefenseRecoverTime(Mobile m) {
        return this.getTypicalTime(this.getDefenseUsage(m), this.defenseRecoverStartingTime, this.defenseMinimalUsage, this.defenseRecoverTimeSteepness);
    }

    public double getTypicalDefenseProbability(Mobile m) {
        return 1.0 - this.getTypicalTime(this.getDefenseUsage(m), 1.0, this.defenseMinimalUsage, this.defenseProbabilitySteepness);
    }

    private double getTypicalTime(long usage, double starting, long minusage, double steepness) {
        if (usage < minusage) {
            return 0.0;
        }
        return starting / Math.pow(((double)usage - (double)minusage) / (double)USAGE_CORRECTOR + 1.0, Math.exp(steepness));
    }

    public long getAttackUsage(Mobile m) {
        double theUsage = 0.0;
        for (int i = 0; i < this.attackInvolvedSkills.length; ++i) {
            theUsage += this.attackInvolvedSkillRelevance[i] * (double)m.getSkill(this.attackInvolvedSkills[i]);
        }
        return (long)theUsage;
    }

    public long getDefenseUsage(Mobile m) {
        double theUsage = 0.0;
        for (int i = 0; i < this.defenseInvolvedSkills.length; ++i) {
            theUsage += this.defenseInvolvedSkillRelevance[i] * (double)m.getSkill(this.defenseInvolvedSkills[i]);
        }
        return (long)theUsage;
    }

    public void incrementAttackUsage(Mobile m) {
        for (int i = 0; i < this.attackInvolvedSkills.length; ++i) {
            if (!(m.getRandom().nextDouble() < this.attackInvolvedSkillRelevance[i])) continue;
            m.incSkill(this.attackInvolvedSkills[i]);
        }
    }

    public void incrementDefenseUsage(Mobile m) {
        for (int i = 0; i < this.defenseInvolvedSkills.length; ++i) {
            if (!(m.getRandom().nextDouble() < this.defenseInvolvedSkillRelevance[i])) continue;
            m.incSkill(this.defenseInvolvedSkills[i]);
        }
    }

    public List getLimbRequirementsList() {
        return this.wieldableLimbs;
    }

    public void copyWeaponFieldsTo(Weapon w) {
        int i;
        this.copyItemFieldsTo(w);
        w.attack_damage_formula = this.attack_damage_formula;
        w.attackMinimalUsage = this.attackMinimalUsage;
        w.attackProbabilitySteepness = this.attackProbabilitySteepness;
        w.attackRecoverStartingTime = this.attackRecoverStartingTime;
        w.attackRecoverTimeSteepness = this.attackRecoverTimeSteepness;
        w.attackStartingTime = this.attackStartingTime;
        w.attackTimeSteepness = this.attackTimeSteepness;
        w.defense_damage_formula = this.defense_damage_formula;
        w.defenseMinimalUsage = this.defenseMinimalUsage;
        w.defenseProbabilitySteepness = this.defenseProbabilitySteepness;
        w.defenseRecoverStartingTime = this.defenseRecoverStartingTime;
        w.defenseStartingTime = this.defenseStartingTime;
        w.defenseTimeSteepness = this.defenseTimeSteepness;
        w.maxskill = this.maxskill;
        w.minskill_onehand = this.minskill_onehand;
        w.minskill_twohand = this.minskill_twohand;
        w.weapon_type = this.weapon_type;
        if (this.attack_names_list != null) {
            w.attack_names_list = new String[this.attack_names_list.length];
            for (i = 0; i < w.attack_names_list.length; ++i) {
                w.attack_names_list[i] = this.attack_names_list[i];
            }
        }
        if (this.attackInvolvedSkillRelevance != null) {
            w.attackInvolvedSkillRelevance = new double[this.attackInvolvedSkillRelevance.length];
            for (i = 0; i < w.attackInvolvedSkillRelevance.length; ++i) {
                w.attackInvolvedSkillRelevance[i] = this.attackInvolvedSkillRelevance[i];
            }
        }
        if (this.attackInvolvedSkills != null) {
            w.attackInvolvedSkills = new String[this.attackInvolvedSkills.length];
            for (i = 0; i < w.attackInvolvedSkills.length; ++i) {
                w.attackInvolvedSkills[i] = this.attackInvolvedSkills[i];
            }
        }
        if (this.defenseInvolvedSkillRelevance != null) {
            w.defenseInvolvedSkillRelevance = new double[this.defenseInvolvedSkillRelevance.length];
            for (i = 0; i < w.defenseInvolvedSkillRelevance.length; ++i) {
                w.defenseInvolvedSkillRelevance[i] = this.defenseInvolvedSkillRelevance[i];
            }
        }
        if (this.defenseInvolvedSkills != null) {
            w.defenseInvolvedSkills = new String[this.defenseInvolvedSkills.length];
            for (i = 0; i < w.defenseInvolvedSkills.length; ++i) {
                w.defenseInvolvedSkills[i] = this.defenseInvolvedSkills[i];
            }
        }
        if (this.wieldableLimbs != null) {
            w.wieldableLimbs = new ArrayList();
            for (i = 0; i < this.wieldableLimbs.size(); ++i) {
                w.wieldableLimbs.add(this.wieldableLimbs.get(i));
            }
        }
    }

    public Object clone() {
        Weapon w = new Weapon();
        this.copyWeaponFieldsTo(w);
        return w;
    }

    public Weapon() {
    }
}

