/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.perf;

import com.sun.deploy.perf.PerfLabel;
import com.sun.deploy.perf.PerfRollup;
import java.io.PrintStream;
import java.util.HashMap;

public class PluginRollup
implements PerfRollup {
    private static final String JVM_INITIALIZE_JAVA = "Plug-in Java VM initialization phase";
    private static final String JVM_START_JAVA_VM = "Plug-in Java VM startup";
    private static final String JVM_RUNTIME_INIT = "invoke JavaRunTime.initEnvironment";
    private static final String JVM_CONSOLE = "Java console initialization";
    private static final String JVM_IE_JNI_REG = "register IE specific JNI methods";
    private static final String JVM_MOZILLA_JNI_REG = "register Mozilla specific JNI methods";
    private static final String ENV_VIEWER_INIT = "AppletViewer.initEnvironment";
    private static final String ENV_THREAD_GRP = "AppletViewer.initEnvironment - PluginSysUtil.getPluginThreadGroup";
    private static final String ENV_TRACE_ENV = "AppletViewer.initEnvironment - JavaRunTime.initTraceEnvironment";
    private static final String ENV_PROXY_AUTH = "AppletViewer.initEnvironment - enable proxy/web server authentication";
    private static final String ENV_PROXY_SELECT = "AppletViewer.initEnvironment - DeployProxySelector.reset";
    private static final String ENV_WIN_SYS_TRAY = "AppletViewer.initEnvironment - show update message";
    private static final String ENV_UPGRADE_CACHE = "AppletViewer.initEnvironment - upgrade cache";
    private static final String ENV_CREATE_IE_OBJ = "create browser plugin object (IE)";
    private static final String ENV_CREATE_MOZW_OBJ = "create browser plugin object (Mozilla:Windows)";
    private static final String ENV_CREATE_MOZU_OBJ = "create browser plugin object (Unix:Windows)";
    private static final String ENV_CREATE_IE_WND = "create embedded browser frame (IE)";
    private static final String ENV_CREATE_MOZW_WND = "create embedded browser frame (Mozilla:Windows)";
    private static final String ENV_CREATE_MOZU_WND = "create embedded browser frame (Mozilla:Unix)";
    private static final String ENV_CREATE_LOADER = "AppletViewer.createClassLoader";
    private static final String ENV_APPLET_INIT = "AppletViewer.initApplet";
    private static final String OVERALL_APPLET_INIT_START = "AppletViewer.initEnvironment";
    private static final String OVERALL_APPLET_INIT_END = "AppletViewer.initApplet";

    public void doRollup(PerfLabel[] perfLabelArray, PrintStream printStream) {
        if (perfLabelArray.length > 0) {
            Event event;
            EventSet eventSet = new EventSet(perfLabelArray);
            long l = perfLabelArray[perfLabelArray.length - 1].getTime() - perfLabelArray[0].getTime();
            long l2 = eventSet.getEventDelta(JVM_INITIALIZE_JAVA);
            long l3 = eventSet.getEventDelta(JVM_START_JAVA_VM);
            long l4 = eventSet.getEventDelta(JVM_RUNTIME_INIT);
            long l5 = eventSet.getEventDelta(JVM_CONSOLE);
            long l6 = 0L;
            Event event2 = null;
            event2 = eventSet.getEvent(JVM_IE_JNI_REG);
            l6 = event2 != null ? event2.getDelta() : eventSet.getEventDelta(JVM_MOZILLA_JNI_REG);
            l2 += l6;
            long l7 = eventSet.getEventDelta("AppletViewer.initEnvironment");
            long l8 = eventSet.getEventDelta(ENV_THREAD_GRP);
            long l9 = eventSet.getEventDelta(ENV_TRACE_ENV);
            long l10 = eventSet.getEventDelta(ENV_PROXY_AUTH);
            long l11 = eventSet.getEventDelta(ENV_PROXY_SELECT);
            long l12 = eventSet.getEventDelta(ENV_WIN_SYS_TRAY);
            long l13 = eventSet.getEventDelta(ENV_UPGRADE_CACHE);
            long l14 = eventSet.getEventDelta(ENV_CREATE_LOADER);
            long l15 = eventSet.getEventDelta("AppletViewer.initApplet");
            long l16 = 0L;
            long l17 = 0L;
            event2 = eventSet.getEvent(ENV_CREATE_IE_OBJ);
            if (event2 != null) {
                l16 = event2.getDelta();
                l17 = eventSet.getEventDelta(ENV_CREATE_IE_WND);
            } else {
                event2 = eventSet.getEvent(ENV_CREATE_MOZW_OBJ);
                if (event2 != null) {
                    l16 = event2.getDelta();
                    l17 = eventSet.getEventDelta(ENV_CREATE_MOZW_WND);
                } else {
                    l16 = eventSet.getEventDelta(ENV_CREATE_MOZU_OBJ);
                    l17 = eventSet.getEventDelta(ENV_CREATE_MOZU_WND);
                }
            }
            long l18 = 0L;
            event2 = eventSet.getEvent("AppletViewer.initEnvironment");
            if (event2 != null && (event = eventSet.getEvent("AppletViewer.initApplet")) != null) {
                l18 = event.getEnd().getTime() - event2.getStart().getTime();
            }
            printStream.println();
            printStream.println("Overall Plug-in startup time................... " + l + " ms");
            printStream.println("     Total time starting JVM................... " + l2 + " ms");
            printStream.println("         JVM startup........................... " + l3 + " ms");
            printStream.println("         Runtime initialization................ " + l4 + " ms");
            printStream.println("         Console initialization................ " + l5 + " ms");
            printStream.println("         Browser specific JVM initialization... " + l6 + " ms");
            printStream.println("     Total time preparing applet............... " + l18 + " ms");
            printStream.println("         Viewer initialization................. " + l7 + " ms");
            printStream.println("              get Plug-in thread group......... " + l8 + " ms");
            printStream.println("              init trace environment........... " + l9 + " ms");
            printStream.println("              enable proxy authentication...... " + l10 + " ms");
            printStream.println("              proxy selector reset............. " + l11 + " ms");
            printStream.println("              update system tray message....... " + l12 + " ms");
            printStream.println("              upgrade cache.................... " + l13 + " ms");
            printStream.println("         Create Plug-in object................. " + l16 + " ms");
            printStream.println("         Create applet window.................. " + l17 + " ms");
            printStream.println("         Create Plug-in class loader........... " + l14 + " ms");
            printStream.println("         Invoke applet.init().................. " + l15 + " ms");
        } else {
            printStream.println("Plug-in perf logging is not currently implemented for UNIX platforms.");
        }
    }

    class Event {
        String key;
        PerfLabel start;
        PerfLabel end;

        PerfLabel getStart() {
            return this.start;
        }

        PerfLabel getEnd() {
            return this.end;
        }

        void setEnd(PerfLabel perfLabel) {
            this.end = perfLabel;
        }

        long getDelta() {
            return this.end.getTime() - this.start.getTime();
        }

        Event(String string, PerfLabel perfLabel) {
            this.key = string;
            this.start = perfLabel;
            this.end = null;
        }
    }

    class EventSet {
        HashMap map = new HashMap();
        static final int TYPE_START = 0;
        static final int TYPE_END = 5;
        static final int AREA_START = 8;
        static final int AREA_END = 14;
        static final int CAT_START = 17;
        static final int CAT_END = 20;
        static final int KEY_START = 23;

        Event getEvent(String string) {
            return (Event)this.map.get(string);
        }

        long getEventDelta(String string) {
            Event event = this.getEvent(string);
            return event != null ? event.getDelta() : 0L;
        }

        EventSet(PerfLabel[] perfLabelArray) {
            for (int i = 0; i < perfLabelArray.length; ++i) {
                Event event;
                long l = perfLabelArray[i].getTime();
                String string = perfLabelArray[i].getLabel();
                String string2 = string.substring(0, 5).trim();
                String string3 = string.substring(23).trim();
                if (string2.equals("START")) {
                    this.map.put(string3, new Event(string3, perfLabelArray[i]));
                    continue;
                }
                if (!string2.equals("END") || (event = (Event)this.map.get(string3)) == null) continue;
                event.setEnd(perfLabelArray[i]);
            }
        }
    }
}

