/*
 * Decompiled with CFR 0.152.
 */
package Game.Habitaciones;

import Game.Habitaciones.SalidasIF;
import Universo.Mundo;
import auxiliares.Func;
import estancia.Estancia;
import java.awt.Color;
import objeto.ObjetoAbrible;
import parser.Orden;
import propiedades.Accion;

public class Salon
extends Estancia
implements SalidasIF {
    public Salon(String name) {
        super(name);
    }

    @Override
    public void init() {
        this.set("nombre", "sal\u00f3n");
        this.set("esOrigen", "del");
        this.set("esDestino", "al");
        this.set("visitado", false);
        this.set("disparo", false);
        this.set("haySonido", true);
    }

    @Override
    public void descripciones() {
        String s = "\n{color%red%En el sal\u00f3n.}\n";
        String s1 = "\nTienes todos los elementos del sal\u00f3n bien ubicados. Un {accion%examinar%sof\u00e1} que est\u00e1 justo en frente del {accion%examinar%mueble} principal, donde est\u00e1 la {accion%examinar%televisi\u00f3n} y el {accion%examinar%v\u00eddeo VHS} junto al cual est\u00e1 el {accion%examinar%tel\u00e9fono fijo}. En otra de las paredes la {accion%examinar%ventana} que da a la calle.";
        String s2 = "\nTienes todos los elementos del sal\u00f3n bien ubicados. Un {accion%examinar%sof\u00e1} que est\u00e1 justo en frente del {accion%examinar%mueble} principal, donde est\u00e1 la {accion%examinar%televisi\u00f3n}.Al lado de la televisi\u00f3n tambi\u00e9n est\u00e1 el {accion%examinar%tel\u00e9fono}. En otra de las paredes la {accion%examinar%ventana} que da a la calle.\nAl entrar en el sal\u00f3n notas con los pies las piezas de lo que era el v\u00eddeo VHS.";
        if (Mundo.entidad("video").getPropiedadBoolean("roto")) {
            this.setDescripcion(String.valueOf(s) + s2);
        } else {
            this.setDescripcion(String.valueOf(s) + s1);
        }
    }

    @Override
    public void salidas() {
        this.crearSalidas(this);
    }

    @Override
    public boolean antesDeSalir() {
        if (Mundo.entidad("telefono").getPropiedadBoolean("responde_primera_llamada") && !Mundo.entidad("telefono").getPropiedadBoolean("responde_segunda_llamada")) {
            this.disparo();
            return false;
        }
        this.gestSalidas(this, Estancia.getHabitacionSiguiente());
        return super.antesDeSalir();
    }

    @Override
    public void entrar() {
        if (!this.getPropiedadBoolean("visitado")) {
            Mundo.writeln("\nLlegas al sal\u00f3n lo m\u00e1s r\u00e1pido que puedes. El tel\u00e9fono sigue sonando, en el tiempo que has tardado en llegar ha parado de sonar alguna que otra vez, pero en menos de 10 segundos ha vuelto a timbrar. El sonido hace que vayas como una diana al tel\u00e9fono. ");
        } else if (Mundo.entidad("telefono").getPropiedadBoolean("sonando")) {
            Mundo.writeln("\nEl tel\u00e9fono sigue sonando, en todo este tiempo ha parado de sonar alguna que otra vez, pero en menos de 10 segundos ha vuelto a timbrar. El sonido hace que vayas como una diana al tel\u00e9fono.");
        }
        this.set("visitado", true);
        super.entrar();
    }

    public void disparo() {
        if (!this.getPropiedadBoolean("disparo")) {
            Mundo.writeColor("\nDe repente se escucha el sonido de cristales rotos y un fuerte estruendo dentro del sal\u00f3n. Te empiezan a pitar los o\u00eddos, casi no escuchas nada. Te duele la oreja derecha, te la tocas y notas la humedad de la sangre. Empiezas a dar vueltas sin rumbo, el pitido en los o\u00eddos ha conseguido desorientarte del todo.\n", Color.red);
            Mundo.writeln("\nVuelve a sonar el tel\u00e9fono...");
            Mundo.entidad("telefono").set("sonando", true);
            this.set("disparo", true);
            Mundo.entidad("ventana salon").set("rota", true);
            Mundo.getJugador().set("herido", true);
        } else {
            Mundo.writeln("Mejor no jug\u00e1rsela y responder al tel\u00e9fono...");
        }
    }

    @Override
    public Accion parseCommand(Orden orden) {
        String tele = "televisi\u00f3n television tv tele televisor";
        String sofa = "sof\u00e1 sofa sillon sill\u00f3n";
        String cristales = "cristales cristal cristale vidrios vidrio";
        if (orden.verbo().equals("oir")) {
            if (((ObjetoAbrible)Mundo.entidad("ventana salon")).estaAbierto() || Mundo.entidad("ventana salon").getPropiedadBoolean("rota")) {
                Mundo.writeln("Entra demasiado ruido de coches por la ventana, molesta demasiado.");
                return this.end();
            }
            Mundo.writeln("A trav\u00e9s de las ventanas escuchas levemente el sonido de los coches. ");
            return this.end();
        }
        if (Func.textosExactos(orden.cDyArgs(), tele)) {
            if (orden.verbo().equals("examinar")) {
                Mundo.writeln("Una televisi\u00f3n a la cual no le das mucho uso.");
                return this.end();
            }
            if (orden.verbo().equals("encender")) {
                Mundo.writeln("A estas horas no crees que pongan nada interesante.");
                return this.end();
            }
            if (orden.verbo().equals("apagar")) {
                Mundo.writeln("Est\u00e1 apagada.");
                return this.end();
            }
            if (orden.verbo().equals("coger")) {
                Mundo.writeln("No pesa demasiado, pero crees que cargar con ella no sea \u00fatil.");
                return this.end();
            }
            if (orden.verbo().equals("mover")) {
                Mundo.writeln("La mueves y la dejas en su sitio. No pasa nada.");
                return this.end();
            }
        }
        if (Func.textosExactos(orden.cDyArgs(), sofa)) {
            if (orden.verbo().equals("examinar")) {
                Mundo.writeln("Un sof\u00e1 cuyo principal uso que le das es darte el placer de una siesta.");
                return this.end();
            }
            if (orden.verbo().equals("mover")) {
                Mundo.writeln("Lo mueves y lo dejas en su sitio. No pasa nada.");
                return this.end();
            }
        }
        if (Func.textosExactos(orden.cDyArgs(), cristales)) {
            if (this.getPropiedadBoolean("disparo")) {
                if (orden.verbo().equals("examinar")) {
                    Mundo.writeln("Cristales rotos de la ventana est\u00e1n esparcidos por el suelo.");
                    return this.end();
                }
                Mundo.writeln("Mejor deja los cristales, te puedes hacer da\u00f1o.");
                return this.end();
            }
            Mundo.writeln("No s\u00e9 a qu\u00e9 cristales te refieres.");
            return this.end();
        }
        return super.parseCommand(orden);
    }
}

