/*
 * Decompiled with CFR 0.152.
 */
package Game.Objetos;

import Universo.Mundo;
import Universo.Universo;
import auxiliares.Func;
import entidad.Entidad;
import java.util.ArrayList;
import objeto.ObjetoContenedor;
import parser.Orden;
import propiedades.Accion;

public class CajaFuerte
extends ObjetoContenedor {
    public CajaFuerte(String name) {
        super(name);
        this.setVisible(false);
        this.setCerradoConLlave(true);
        this.setAbrible(true);
        this.setAbierto(false);
    }

    @Override
    public void init() {
        this.set("visible", false);
        this.set("bajoCama", true);
        this.set("enElSuelo", false);
        this.set("aux1", false);
        this.set("clave", false);
    }

    public void aparece() {
        if (!this.getPropiedadBoolean("visible")) {
            this.setEstancia(Mundo.habitacion("Compi"));
            this.set("visible", true);
        }
    }

    @Override
    public void descripcion() {
        String s = "En una de sus caras palpando encuentras una especie de teclado num\u00e9rico justo en la cara que parece una puerta de una peque\u00f1a caja de caudales\u2026.  S\u00ed, es una caja de caudales, seguramente nuestro paquete est\u00e9 dentro, ahora s\u00f3lo debes abrirla...\nEn la parte que se supone que es la compuerta de la caja s\u00f3lo notas el teclado num\u00e9rico, ninguna ranura para meter una llave. Palpando el teclado descubres que en total son 10 teclas. Est\u00e1n serigrafiadas con los n\u00fameros del 0 al 9. ";
        String s1 = "Una caja de caudales con un teclado en la puerta. El teclado num\u00e9rico, diez n\u00fameros del 0 al 9.";
        String s2 = "\n{color%red%\u00a1MIERDA!} Dentro no hay ning\u00fan paquete ni nada que se le parezca.";
        if (!this.getPropiedadBoolean("aux1")) {
            this.setDescripcion(s);
        } else {
            if (this.estaAbierto()) {
                s1 = String.valueOf(s1) + s2;
            }
            this.setDescripcion(s1);
        }
    }

    @Override
    public void post_descripcion() {
        this.set("aux1", true);
    }

    @Override
    public void nombreReferencia() {
        this.nuevoNombreDeReferencia("caja", 5);
        this.nuevoNombreDeReferencia("teclado", 1);
        this.nuevoAdjetivo("fuerte");
        this.nuevoAdjetivo("metalica");
        this.nuevoAdjetivo("met\u00e1lica");
        this.nuevoAdjetivo("caudales");
    }

    @Override
    public void nombreParaMostrar() {
        this.setNombreParaMostrar("{accion%examinar%caja}", 5);
    }

    @Override
    public Accion parseCommand(Orden command, ArrayList<Entidad> entitys) {
        String romper = "romper golpear";
        if (Func.textosExactos(command.verbo(), romper) && !this.estaAbierto()) {
            Mundo.writeln("Eso no te servir\u00e1, debes buscar la forma de abrirla.");
            return this.end();
        }
        if ((command.verbo().equals("examinar") || command.verbo().equals("tocar")) && this.getNombreActualDeReferencia().equals("teclado")) {
            Mundo.writeln("Palpando el teclado descubres que en total son 10 teclas. Est\u00e1n serigrafiadas con los n\u00fameros del 0 al 9.");
            return this.end();
        }
        if (command.verbo().equals("tocar")) {
            Universo.getMundo().forceCommandNoEco("examinar caja fuerte");
            return this.end();
        }
        if (command.verbo().equals("coger")) {
            Mundo.writeln("Pesa demasiado.");
            return this.end();
        }
        if (command.verbo().equals("abrir") && !this.estaAbierto()) {
            Mundo.writeln("Necesitar\u00edas teclear en ella la clave para abrirla. Podr\u00eda ser su fecha de nacimiento, s\u00f3lo el a\u00f1o, o la fecha completa. Tampoco tienes ni la m\u00e1s remota idea de la cantidad de n\u00fameros que son necesarios para abrir la caja. Tu \u00fanica alternativa es intentar buscar entre sus cosas a ver si encuentras algo que te ayude a averiguar la combinaci\u00f3n. \u00bfPero c\u00f3mo?, puede estar anotado en cualquier lugar delante de tus narices y no puedes verlo");
            return this.end();
        }
        if (command.verbo().equals("teclear") || command.verbo().equals("escribir") || command.verbo().equals("pulsar")) {
            if (!this.estaAbierto()) {
                if (!this.getPropiedadBoolean("clave")) {
                    Mundo.writeln("No es la clave correcta.");
                    return this.end();
                }
                if (command.cDyArgs().contains("816169")) {
                    Mundo.writeln("Tecleas la clave en la caja.... {color%yellow%\u00a1CLACK!} \u00a1BINGO! La caja se abre.");
                    this.setAbierto(true);
                    return this.end();
                }
                Mundo.writeln("Tecleas la clave en la caja fuerte... pero esta ni se inmuta.");
                return this.end();
            }
            Mundo.writeln("La caja fuerte ya est\u00e1 abierta.");
            return this.end();
        }
        if (command.verbo().equals("mover")) {
            if (!this.estaAbierto()) {
                Mundo.writeln("La mueves y suena algo m\u00e9talico y pesado dentro.");
                return this.end();
            }
            Mundo.writeln("La mueves y no pasa nada.");
            return this.end();
        }
        return super.parseCommand(command, entitys);
    }
}

