/*
 * Decompiled with CFR 0.152.
 */
package Game.Objetos;

import Universo.Mundo;
import auxiliares.Func;
import entidad.Entidad;
import java.util.ArrayList;
import objeto.Objeto;
import parser.Orden;
import propiedades.Accion;

public class Frigorifico
extends Objeto {
    public Frigorifico(String nombre) {
        super(nombre);
        this.setEstancia(Mundo.habitacion("Cocina"));
        this.setEstatico(true);
        this.setVisible(false);
    }

    @Override
    public void init() {
        this.set("abierto", false);
    }

    @Override
    public void descripcion() {
    }

    @Override
    public void nombreReferencia() {
        this.nuevoNombreDeReferencia("frigorifico", 1);
        this.nuevoNombreDeReferencia("nevera", 5);
        this.nuevoNombreDeReferencia("congelador", 1);
        this.nuevoNombreDeReferencia("heladera", 5);
        this.nuevoNombreDeReferencia("refrigerador", 1);
    }

    @Override
    public void nombreParaMostrar() {
        this.setNombreParaMostrar("{accion%examinar%frigor\u00edfico}", 1);
    }

    @Override
    public Accion parseCommand(Orden orden, ArrayList<Entidad> entidades) {
        String zonaBico = "bico Bico compa\u00f1ero";
        if (orden.verbo().equals("examinar")) {
            if (this.getPropiedadBoolean("abierto")) {
                String s = "En casa ten\u00e9is dividido el frigor\u00edfico y el congelador en estantes. Est\u00e1n los estantes de Bico y los tuyos.\n";
                String s1 = "Dentro en la zona de refrigeraci\u00f3n, en tu estante s\u00f3lo hay un {accion%examinar%San Jacobo}. Crees que es un San Jacabo... hace meses que lo metiste dentro y no lo recuerdas bien.";
                String s2 = "\nEn la zona del congelador, tu estante lo tienes vac\u00edo.";
                String s3 = "Dentro en la zona de refrigeraci\u00f3n, en el estante de Bico no hay nada.";
                String s4 = "\nEn la zona del congelador, la parte de Bico, hay {accion%examinar%cosas congeladas} que no identifico.";
                if (Func.textosExactos(orden.args(), zonaBico)) {
                    Mundo.writeln(String.valueOf(s) + s3 + s4);
                    return this.end();
                }
                Mundo.writeln(String.valueOf(s) + s1 + s2);
                return this.end();
            }
            Mundo.writeln("Tocas el frigor\u00edfico y est\u00e1 cerrado.");
            return this.end();
        }
        if (orden.verbo().equals("tocar")) {
            Mundo.writeln("El frigor\u00edfico es met\u00e1lico, est\u00e1 cerrado.");
            return this.end();
        }
        if (orden.verbo().equals("abrir")) {
            if (this.getPropiedadBoolean("abierto")) {
                Mundo.writeln("El frigor\u00edfico ya est\u00e1 abierto.");
                return this.end();
            }
            Mundo.writeln("Abres el frigor\u00edfico.");
            this.set("abierto", true);
            return this.end();
        }
        if (orden.verbo().equals("cerrar")) {
            if (!this.getPropiedadBoolean("abierto")) {
                Mundo.writeln("Ya est\u00e1 cerrado.");
                return this.end();
            }
            Mundo.writeln("Cierras el frigor\u00edfico.");
            return this.end();
        }
        if (orden.verbo().equals("meter")) {
            Mundo.writeln("No hace falta...");
            return this.end();
        }
        if (orden.verbo().equals("apagar")) {
            Mundo.writeln("Aunque el frigor\u00edfico generalmente lo ten\u00e9is medio vac\u00edo, no creo que sea muy bueno por la salud de lo poco que hay dentro.");
            return this.end();
        }
        if (orden.verbo().equals("encender")) {
            Mundo.writeln("Est\u00e1 encendido.");
            return this.end();
        }
        if (orden.verbo().equals("oler")) {
            Mundo.writeln("Huele a frigor\u00edfico vac\u00edo.");
            return this.end();
        }
        return super.parseCommand(orden, entidades);
    }
}

