/*
 * Decompiled with CFR 0.152.
 */
package Game.Objetos;

import Universo.Mundo;
import entidad.Entidad;
import java.util.ArrayList;
import objeto.ObjetoAbrible;
import parser.Orden;
import propiedades.Accion;

public class Ventana
extends ObjetoAbrible {
    public Ventana(String name) {
        super(name);
        this.setEstancia(Mundo.habitacion("Dormitorio"));
        this.setVisible(false);
        this.setAbierto(false);
        this.setEstatico(true);
    }

    @Override
    public void init() {
        this.set("primera_descripcion", true);
        this.set("aux1", false);
    }

    @Override
    public void nombreReferencia() {
        this.nuevoNombreDeReferencia("ventana", 5);
        this.nuevoNombreDeReferencia("ventanas", 6);
    }

    @Override
    public void nombreParaMostrar() {
        this.setNombreParaMostrar("{accion%examinar%ventana}", 5);
    }

    @Override
    public void descripcion() {
        String s = "Te la tuviste que poner de doble vidrio, el ruido que viene de la calle desde primeras horas de la ma\u00f1ana hasta bien entrada la noche es horrible. Justo en frente tienes la comisar\u00eda de polic\u00eda, sirenas van y vienen todo el d\u00eda como un compa\u00f1ero de piso m\u00e1s.\n";
        String s1 = "";
        if (this.estaAbierto()) {
            s1 = "A trav\u00e9s de la ventana entra el sonido de los coches de la calle.";
            if (this.getPropiedadBoolean("primera_descripcion")) {
                s1 = String.valueOf(s) + s1;
            }
            this.setDescripcion(s1);
        } else {
            s1 = "Por su tacto sabes que es madera a la que le hace falta una nueva capa de barniz. En los cristales se nota el fr\u00edo del invierno.";
            if (this.getPropiedadBoolean("primera_descripcion")) {
                s1 = String.valueOf(s) + s1;
            }
            this.setDescripcion(s1);
        }
    }

    @Override
    public void post_descripcion() {
        if (this.getPropiedadBoolean("primera_descripcion")) {
            this.set("primera_descripcion", false);
        }
    }

    @Override
    public Accion parseCommand(Orden command, ArrayList<Entidad> entitys) {
        if (command.verbo().equals("abrir") && !this.estaAbierto()) {
            Mundo.writeln("Abres la ventana y la temperatura de tu habitaci\u00f3n empieza a descender en la misma medida en que sube el volumen del molesto ruido de los coches y sirenas.");
            this.setAbierto(true);
            return this.end();
        }
        if (command.verbo().equals("cerrar") && this.estaAbierto()) {
            Mundo.writeln("La ventana cerrada est\u00e1 mejor, que descanso.");
            this.setAbierto(false);
            return this.end();
        }
        if (command.verbo().equals("ir") && this.estaAbierto()) {
            if (!Mundo.habitacion("Salon").getPropiedadBoolean("disparo")) {
                Mundo.writeln("\u00bfSuicidarme...?, no es mi intenci\u00f3n.");
                return this.end();
            }
            if (!this.getPropiedadBoolean("aux1") && !((ObjetoAbrible)Mundo.entidad("puerta")).estaAbierto()) {
                Mundo.writeln("Podr\u00edas intentar entrar en la habitaci\u00f3n de Bico por la ventana de su habitaci\u00f3n. Tu habitaci\u00f3n es contigua a la de Bico, saliendo por la ventana de tu habitaci\u00f3n y desliz\u00e1ndote por la cornisa podr\u00edas llegar a la ventana de Bico. Pero, puede que el francotirador te pegue un tiro al no saber lo que est\u00e1s haciendo. Tampoco sabes si alguien te puede estar viendo desde la calle o del edificio de enfrente, y por \u00faltimo la ventana de Bico seguramente est\u00e1 cerrada por dentro, \u00bfc\u00f3mo la abres desde fuera?. Esta posibilidad la descartas.");
                this.set("aux1", true);
                return this.end();
            }
            Mundo.writeln("Demasiado arriesgado.");
            return this.end();
        }
        if (command.verbo().equals("ir") && !this.estaAbierto()) {
            Mundo.writeln("La ventana est\u00e1 cerrada.");
            return this.end();
        }
        if (command.verbo().equals("tocar")) {
            Mundo.writeln("Notas el fr\u00edo exterior.");
            return this.end();
        }
        return super.parseCommand(command, entitys);
    }
}

