/*
 * Decompiled with CFR 0.152.
 */
package Game.Objetos;

import Universo.Mundo;
import entidad.Entidad;
import java.util.ArrayList;
import objeto.Objeto;
import parser.Orden;
import propiedades.Accion;

public class Video
extends Objeto {
    public Video(String nombre) {
        super(nombre);
        this.setVisible(false);
        this.setEstancia(Mundo.habitacion("Salon"));
        this.setEstatico(true);
    }

    @Override
    public void init() {
        this.set("roto", false);
    }

    @Override
    public void nombreReferencia() {
        this.nuevoNombreDeReferencia("video", 1);
        this.nuevoNombreDeReferencia("vhs", 1);
        this.nuevoNombreDeReferencia("videocasetera", 5);
    }

    @Override
    public void nombreParaMostrar() {
        this.setNombreParaMostrar("{accion%examinar%video}", 1);
    }

    @Override
    public void descripcion() {
        String s = "Un v\u00eddeo VHS que hace a\u00f1os que no funciona, siempre te preguntas para qu\u00e9 lo teneis, pero Bico se empe\u00f1a en conservarlo.";
        String s1 = "El v\u00eddeo VHS est\u00e1 roto con todas las piezas esparcidas por el suelo.";
        if (this.getPropiedadBoolean("roto")) {
            this.setDescripcion(s1);
        } else {
            this.setDescripcion(s);
        }
    }

    @Override
    public Accion parseCommand(Orden command, ArrayList<Entidad> entitys) {
        if (command.verbo().equals("coger")) {
            String s = "";
            s = !this.getPropiedadBoolean("roto") ? "\u00bfY qu\u00e9 hago yo cargando con un v\u00eddeo VHS?... paso." : "\u00bfPara qu\u00e9 cargar con todas esas piezas del v\u00eddeo? No hace falta.";
            Mundo.writeln(s);
            return this.end();
        }
        if (command.verbo().equals("mover")) {
            if (!this.getPropiedadBoolean("roto")) {
                Mundo.writeln("Al mover el v\u00eddeo notas que algo se mueve dentro de \u00e9l, algo roto o suelto debe haber dentro.");
            } else {
                Mundo.writeln("El v\u00eddeo est\u00e1 roto con todas las piezas esparcidas por el suelo, no hace falta que te pongas a mover todas las piezas.");
            }
            return this.end();
        }
        if (command.verbo().equals("abrir")) {
            if (!this.getPropiedadBoolean("roto")) {
                Mundo.writeln("Te har\u00eda falta un destornillador o alguna herramienta para eso, intentar encontrar donde est\u00e1n los orificios de los tornillos... muy complicado.");
            } else {
                Mundo.writeln("Ya te lo has cargado del todo...");
            }
            return this.end();
        }
        if (command.verbo().equals("romper")) {
            if (!Mundo.habitacion("Salon").getPropiedadBoolean("disparo")) {
                Mundo.writeln("Creo que Bico le tiene demasiado cari\u00f1o... mejor no.");
                return this.end();
            }
            if (!this.getPropiedadBoolean("roto")) {
                Mundo.writeln("Agarras el v\u00eddeo y con todas tus fuerzas lo lanzas contra el suelo... escuchas el ruido de como todas sus piezas se esparcen por el suelo.");
                this.set("roto", true);
                this.nuevoNombreDeReferencia("pedazos", 2);
                this.nuevoNombreDeReferencia("trozos", 2);
                this.nuevoNombreDeReferencia("pedazo", 1);
                this.nuevoNombreDeReferencia("trozo", 2);
                this.nuevoNombreDeReferencia("pieza", 5);
                this.nuevoNombreDeReferencia("piezas", 6);
            } else {
                Mundo.writeln("Ya lo has hecho.");
            }
            return this.end();
        }
        if (command.verbo().equals("apagar")) {
            Mundo.writeln("Est\u00e1 apagado. Ese v\u00eddeo hace a\u00f1os que no funciona.");
            return this.end();
        }
        if (command.verbo().equals("encender")) {
            Mundo.writeln("Hace a\u00f1os que este v\u00eddeo pas\u00f3 a mejor vida.");
            return this.end();
        }
        return super.parseCommand(command, entitys);
    }
}

