/*
 * Decompiled with CFR 0.152.
 */
package Universo;

import Universo.InventarioPersona;
import auxiliares.Debug;
import entidad.Entidad;
import objeto.Objeto;
import objeto.ObjetoContenedor;

public class Persona
extends Objeto {
    private InventarioPersona inventario = new InventarioPersona(this);
    private boolean jugador = false;

    public Persona(String name) {
        super(name);
    }

    public boolean getEsJugador() {
        return this.jugador;
    }

    public void setJugador() {
        this.jugador = true;
    }

    public InventarioPersona getInventario() {
        if (this.inventario == null) {
            System.out.println("No hay inventorio creado para " + this.getNombre());
        }
        return this.inventario;
    }

    public void anadirObjetoInventario(Objeto obj) {
        Debug.writeDebug(this, "A\u00f1adiendo a inventario del mobile: " + obj.getNombre());
        obj.setPersona(this);
        obj.setEstancia(null);
        obj.setObjeto(null);
    }

    public void eliminarObjetoDeInventario(Objeto obj) {
        obj.setPersona(null);
    }

    public void mostrarInventario() {
        this.inventario.mostrar(this);
    }

    public boolean tieneAlaVista(Entidad item) {
        return this.inventario.getInventario().contains(item);
    }

    public boolean buscarObjetoDentroDe(Entidad entidad) {
        boolean out = false;
        for (Entidad unItem : this.inventario.getInventario()) {
            if (!(unItem instanceof ObjetoContenedor)) continue;
            out = ((ObjetoContenedor)unItem).estaDentro(entidad);
        }
        return out;
    }

    public boolean tiene(Entidad item) {
        return this.tieneAlaVista(item) || this.buscarObjetoDentroDe(item);
    }

    @Override
    public String unNombre() {
        String out = "el";
        String aName = this.getNombreParaMostrar();
        if (!this.getNombrePersonal()) {
            if (!this.esMasculino()) {
                out = "la";
            }
        } else {
            out = "";
        }
        out = String.valueOf(out) + " " + aName;
        if (this.getMejorAdjetivo().length() > 0) {
            out = String.valueOf(out) + " " + this.getMejorAdjetivo();
        }
        return out.trim();
    }
}

