/*
 * Decompiled with CFR 0.152.
 */
package auxiliares;

import auxiliares.Debug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import parser.Verbos;
import propiedades.Accion;

public class Lectura {
    private String FILE_NAME;
    public static final int VERBS = 0;
    public static final int RESPONSES = 1;

    public Lectura(String FILE_NAME) {
        this.FILE_NAME = FILE_NAME;
    }

    public void leerFichero(int fileTipe) {
        BufferedReader input = null;
        File name = new File(this.FILE_NAME);
        this.FILE_NAME = name.getAbsolutePath();
        try {
            try {
                input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.FILE_NAME), Charset.forName("UTF-8")));
                String line = input.readLine();
                while (line != null) {
                    switch (fileTipe) {
                        case 0: {
                            this.loadVerbs(line);
                            break;
                        }
                        case 1: {
                            this.loadResponseTable(line);
                        }
                    }
                    line = input.readLine();
                }
            }
            catch (IOException ex) {
                System.out.println("Error abriendo archivo; " + ex.getMessage());
                try {
                    input.close();
                }
                catch (IOException ex2) {
                    System.err.println(ex2.getMessage());
                }
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
            }
        }
    }

    private void loadVerbs(String line) {
        String operacion = new String();
        Debug.writeDebug(this, " Creando verbo " + line);
        String[] words = line.split("=");
        operacion = words[0];
        words = words[1].split(",");
        switch (operacion) {
            case "v": {
                boolean irr = words[3] != "0";
                Verbos.crearVerbo(words[0], words[1], words[2].toUpperCase(), irr);
                break;
            }
            case "f": {
                Verbos.anadirFormaVerbal(words[0], words[1], words[2].toUpperCase(), words[3]);
                break;
            }
            case "u": {
                Verbos.crearVerboUnico(words[0]);
                break;
            }
            default: {
                System.out.println("-- Error al crear verbo -- " + words);
            }
        }
    }

    private void loadResponseTable(String line) {
        if (!line.startsWith("#") && line.length() > 0) {
            String[] words = line.split("=");
            Accion.setInResponseTable(words[0], words[1]);
        }
    }
}

