# title: Red Haze
# author: ruber eaglenest

### RED HAZE, English version.

CONST grey = 1
CONST red = 2
CONST yellow = 3

VAR haze  = grey
VAR deserter = 0
VAR bomb_detonated = false


-> init

=== init

~haze  = grey
~deserter = 0
~bomb_detonated = false


<em>Enough for me to die on her earth
<em>be buried in her
<em>to melt and vanish into her soil
<em>then sprout forth as a flower</em></em></em>

Fadwa Tuqan – <em>Enough for Me</em>

<h3>Red Haze</h3>
A nightmare by Ruber Eaglenest.

Planed for a couple of weeks in the month of October 2023. Written in less than four hours in Spanish for La petite mort - ECTOCOMP 2023. Translated to English for Le grand guignol.

Content warning: War scenes, lifeless corpses, blood.

+ [Continue]
    -> habitacion


	
=== habitacion ===

<h4>Hotel room</h4>

{ haze:

- grey:

The grey haze filters through the double gazing, that keeps the rain and the night darkness at bay, but they can't stop the distant sound of the explosions.

The bed is ready for the night. In front there is a TV on the wall that constantly broadcasts the news. The bathroom is to the west, and to the south is the exit door.

Above the bedside table there is an alarm clock with an LED display.

- red:

Red haze seeps through the double glazing of the window. The rain sounds heavier and more viscous, and a growing murmur rises from the depths of the city.

The bed appears dishevelled. In front of it the television emits a whitish glow.

On the bedside table is an alarm clock blinking red.

- yellow:

Morning light filters through the double curtains of the window, keeping at bay the strange yellow fog that hangs over the war-torn city.

The bed is dishevelled after a bad night's sleep. In front is a television on the wall, constantly broadcasting the news. The bathroom is to the west, and to the south is the exit door.

On the bedside table is an alarm clock with an LED display.

}

- (opts)

+ { haze == grey } [Examine window]
    The breathtaking view of this foreign city is shrouded by a grey haze that covers and drenches everything. Fleeting orange flashes illuminate the clouds and {&the echo of a detonation|the howl of a siren} can be heard in the distance.
    
+ { haze == red } [Examine window]
    -> blood

+ { haze == yellow } [Examine window]
    The view is shrouded in a thick curtain of smoke that barely gives a glimpse of the buildings. The light of dawn filters through the fog, and the fires nearby cast a yellow glow over everything. Explosions and detonations are heard nearby, and alarm sirens echo throughout the city.

+ { haze == grey} [Examine the bed]
    -> cama
    
+ { haze != grey} [Examine the bed]
    Sheets and blankets for the cold night.

+ { haze == grey } [Examine the television]
    -> tele_grey
    
+ { haze == red } [Examine the television]
    The television only shows static.

+ { haze == yellow } [Examine the television]
    -> tele_yellow

+ [Examine the clock]
        -> reloj_led

* [Go to the bathroom]
        You don't need to go to the bathroom right now.

* {haze == grey and deserter==0} [Leave the room]
        It's raining and dark outside.
        ~deserter++
* {haze == grey and deserter==1} [Leave the room]
        If you go out there, you wouldn't know where to look. The authorities have recommended that we stay in the hotel.
        ~deserter++
* {haze == grey and deserter==2} [Leave the room]
        You can't wait any longer. You go out in the cold of the night with your clothes on. Not knowing what to do or where to go, you get hopelessly lost.
        <strong>*** LOST IN THE NIGHT ***</strong>
        -> the_end
        
* {haze == red} [Leave the room]
    You fall out of bed and rush towards the exit door.
        
    From outside you hear the hiss of incoming bombs. One detonates outside and the window explodes, filling everything with water and glass. Another destroys the building next door, and then another one falls, and another. Soon there is nothing left.
    
    <strong>*** BOOM ***</strong>
	-> the_end
	
* {haze == yellow} [Leave the room]
    You leave the room in your clothes. People are running and shouting in the corridors.  You follow them. The lifts are out of order. You rush down the seemingly endless emergency stairs. When you reach reception you are pushed towards the exit. Outside, all is chaos and confusion.
        
    I must go, you think, there's nothing you can do when you're next.
    
    <strong>*** EVACUATED ***</strong>
	-> the_end

- -> opts

= blink

You open your eyes. {~You have been daydreaming.|Where are you?|When you look again, it has faded.|The dream has faded.}

+ [Look around]
    -> habitacion

-> DONE

= shake

With a great effort you shake the nightmare out of your head.

+ [Look around]
    -> habitacion

-> DONE

= unfocus

You lose {&focus|the attention}.

+ [Look around]
    -> habitacion

-> DONE



=== reloj_led ===

It is a red LED panel alarm clock. It reads <>

{ haze:

- grey: <>past eleven o'clock at night.

- red: <>{&3:33|6:66|2:07|-:--|1:99|23:23}

- yellow: <>seven o'clock in the morning.

}

-> habitacion.opts










### First branch ###

=== cama ===

Sheets and blankets for the cold night. Shouting come from the television, while the rain continues to beat on the window pane.

- (opts)

+ [Reach to touch her]
    -> reach_her

+ [Examine the television]
    -> tele_grey

+ [Look around]
    -> habitacion

- -> opts

=== reach_her ===

She's not here, but if you block out the voices echoing in your head you can almost feel her.

- (opts)
* [Touch her]
    But she's not here. She's out there, you don't know where.
* {CHOICE_COUNT() < 1} [Smell]
    The sheets still retain some of her essence.
* {CHOICE_COUNT() < 1} [Kiss her]
    She is simply not here.
    -> habitacion.blink
+ [Examine her]
    -> costado
+ [Listen to the voices]
    -> tele_grey
+ [Look around]
    -> habitacion

- -> opts

=== tele_grey ===

{The television shows a live broadcast which is all chaos and confusion.|The television loops back to the previous broadcast.} Screams of terror, people running from one side to the other, as bomb blasts shake the broadcast and the reporter tries to raise his voice above the growing din.

- (opts)
+ [Examine people]
    Unfamiliar skins and accents. Here you are the foreigner.
+ [All this pointless violence]
    -> evacuation
+ [Look away]
    -> habitacion

- -> opts

=== costado ===

You rest your eyes on her side. The murmur outside the bed quiets.
- (opts)
* [Smell]
    You close your eyes and yes, she's there.
* {CHOICE_COUNT() < 1} [Embrace her]
    -> held_each
+ [Examine her]
    You know that if you open your eyes she won't be there.
+ [Open your eyes]
    -> habitacion.blink

- -> opts

=== held_each ===

Your hand rests on her side and her body turns to you accompanied by the sound of her laughter. Her scent fills you completely. Outside the stars are shining brightly and you held her tight.
- (opts)
* [Caress her]
    You feel the soft touch of her skin under your fingertips.
+ {CHOICE_COUNT() < 1} [Say I love you]
    ->face_dissolve
+ [Kiss her]
    -> face_dissolve
+ [Open your eyes]
    -> habitacion.blink

- -> opts

=== face_dissolve ===

In silence and darkness, you held each other that night. Very close to her lips you promise that this night will last forever.

+ [Kiss her]
    You reach up to touch her face and just before touching her lips, you can't help but look into her eyes...
        
        ... And her face dissolves between your fingers. You try to hold her, to engrave that moment in your memory, but her features begins to fade. You fear that you will forget even her face, and you wonder if you will ever see her again. 
        
    The darkness deepens and a reddish glow invades the room.
    
    ~haze = red
    
-

+ [Look around]
    -> habitacion

=== evacuation ===

The broadcast switches to the scene of a hotel where police are rushing people to leave, while the presenter reports how the evacuation of the entire southern part of the city is taking place.
- (opts)
* [Examine people]
     Foreigners like you, misplaced, and caught up in a war that doesn't belong to them, rushing to flee, dragging their suitcases behind them.
+ [Lonely people, empty rooms]
    -> fosas_comunes
+ [Look away]
    -> habitacion

- -> opts

=== fosas_comunes ===

The presenter reports, dismayed, the harshness of the images that follow. A camera pans across a roadside ditch where a mass grave has been opened and dozens of corpses are piled up.
- (opts)
+ [Examine the people]
    Men, women, boys, girls and babies, all lifeless, forming endless piles rows that the camera pans across.
+ [Silent tombs]
    -> no_danger
+ [Look away]
    -> habitacion

- -> opts

=== no_danger ===

The presenter reports that he interrupts the broadcast to transmit a message from the prime minister, from the country's capital.

He says that the situation is under control, that the police and army have repelled the attack by the occupying forces, and that the people in the city have nothing to fear.

- (opts)
+ [Examine the prime minister]
    With serious features, he reads from a piece of paper in his hand. In the background is a mural with the flag of this country.
+ [But you can listen to the explosions and see the fires still alight]
    -> tele_grey
+ [Look away]
    -> habitacion

- -> opts







### The Nightmare (segunda rama) ###

=== blood ===

There's blood on the windows.

{ not bomb_detonated: In the streets hundreds of people shout your name.|In the streets hundreds of people has been silenced.}

- (opts)

* [Examine the blood]
    Red liquid that soaks everything.
+ [Examine the perople]
    -> people
+ [Shake my head]
    -> habitacion.shake
    
- -> opts

=== people ===

{not bomb_detonated: The people surrounds you; they scream and stare and point to the scene on the horizon.|Grey, charred bodies pile up in the rubble covered with grey dust and small fires here and there that never go out. Yellow haze covers the scene as far as the eye can see.}

- (opts)
+ [Examine scene]
    -> horizonte
+ [Shake my head]
    -> habitacion.shake
    
- -> opts

=== horizonte ===

{not bomb_detonated: The rivers of blood flow uphill.|The rivers have turned into steaming, orange-coloured quagmires.}

- (opts)

+ [Examine rivers]
    -> river
+ [Shake my head]
    -> habitacion.shake
    
- -> opts

=== river ===

One river reaches a lake where children are swimming and playing with boats.

{not bomb_detonated:Planes are approaching up the mountain.|A new bomb is falling towards the lake.}

- (opts)
+ [Examine lake]
    -> lake
+ [Examine the planes]
    -> plane
+ [Shake my head]
    -> habitacion.shake
    
- -> opts

=== lake ===

The liquid surronds you. You fight to rise from this river of blood.

{bomb_detonated: Smoke and flaming sparks rain down from above.}

- (opts)
+ {not bomb_detonated}[Examine children]
      Nobody seems to notice. They act as if everything is normal.
+ { bomb_detonated}[Examine children]
    -> children
+ {not bomb_detonated}[Look up]
    -> plane
+ [Shake my head]
    -> habitacion.shake
    
- -> opts

=== plane ===

A curtain of bombs fall from the black planes flying over the hillside.

One plane flies a little lower than the rest and drops a bomb.

- (opts)
+ [Examine bomb]
    -> bomb
+ [Examine plane]
    -> cabin
+ [Shake my head]
    -> habitacion.shake

- -> opts

=== bomb ===

A rather thick silver bomb. It appears to be compartmentalised.

{bomb_detonated: The bomb opens and expels dozens of fiery sparks that fall on the scene as a curtain of smoke and yellow fire.}

- (opts)
+ {not bomb_detonated} [Examine plane]
    -> cabin
+ {bomb_detonated} [Look down]
    -> children
+ [Shake my head]
    -> habitacion.shake
    
- -> opts

=== cabin ===

It is a black light aircraft. Inside the cockpit there is no one except a red flashing light. The plane appears to be remote or AI controlled.

The light clicks, and illuminates the empty cockpit with a green glow.

Below, the bomb detonates in mid air.

~bomb_detonated = true

+ [Examine bomb]
    -> bomb
+ [Shake my head]
    -> habitacion.shake


=== children ===

The yellow glow covers everything, the streets burn, the rivers evaporate, the sparks add to the people, the boats, and the children. Their features are changing, and their bodies dissolve.

~haze = yellow

+ [I am alone]

-

+ [Look what you have done]

-

What a horrible nightmare!

But even more terrible must have been what happened last night while I was watching TV. Hopefully they'll say on the news what's going on.

+ [Look around]
    -> habitacion













### The morning after (third branch) ###

=== tele_yellow ===

Television shows images of a row of lifeless bodies placed on a street sidewalk. The camera pans over the bodies so that their faces can be seen.

- (opts)

* [Search the faces]
    {&You don't see her.|She's not there.}
    -> hospital
+ [Look what you've done!]
    -> hospital
+ [Look away]
    -> habitacion

- -> opts

-> DONE


=== hospital ===

The television shows a hospital where a girl is crying looking for her mother, while a paramedic tries to comfort her without success. The girl wanders disoriented among the medical staff without stopping shouting that she wants her mother.

- (opts)

* [Search the faces]
    {&You don't see her.|She's not there.}
    -> cadena
+ [Do you see what you've begun?]
    -> cadena
+ [Look away]
    -> habitacion

- -> opts
-> DONE

=== cadena ===

The camera shows a human chain as dying victims are carried out of a bombed hospital. The majority are young boys and girls.

Smoke and dust covers everything.

- (opts)

* [Search the faces]
    {&You don't see her.|She's not there.}
    -> grey_street
+ [Now see what you've gone and done]
    -> grey_street
+ [Look away]
    -> habitacion

- -> opts
-> DONE

=== grey_street ===

The television shows a completely destroyed street. All the buildings are destroyed and the asphalt is invisible, covered in rubble and gray dust.

Here and there wander some people who stand out for their variety of colored clothing and T-shirts that contrast with the prevailing desolation. They are searching and removing the debris looking for someone, or something.

- (opts)

* [Search for her]
You don't think there's anyone left alive under the rubble.
	-> wasteland
+ [You don't realize what you're doing to me!]
    -> wasteland
+ [Look away]
    -> habitacion

- -> opts
-> DONE

=== wasteland ===

The camera shows an aerial view of the territory. The gray desolation covers everything. There is not a building left standing or a soul alive.

- (opts)

+  [But don't you see it, don't you see what you've done?]
    There is nothing you can do.
    + + [Do you see what you have done?]
	There's nothing, there's nothing you can do. Nothing you can do.
	+ + + [But don't you see it, don't you see what you've done?]
            There's nothing you can do.
            There's nothing, there's nothing you can do. Nothing you can do.
            There's nothing you can do.
	    Nothing you can do. Nothing you can do.
	    ++++  [The scene is a wasteland of rubble and grey dust.]
                 <strong>*** THERE'S NO ONE LEFT ***</strong>
                -> the_end

+ [Look away]
    -> habitacion
- -> opts
-> DONE






=== curiosidades  ===

This game is inspired, or is directly an adaptation, of the Genesis song Domino. It also has exactly the same structure as Lime Ergot by Caleb Wilson, which allowed me to write it very quickly for ECTOCOMP.

-> the_end



=== the_end ===

¿Would you like to RESTART, {haze == yellow:, read some CURIOSITIES}, or QUIT?

+ [RESTART]
    # RESTART
       -> END
+ [QUIT]
    -> END
+ {haze == yellow} [CURIOSITIES]
    -> curiosidades

-> DONE