"Vampire Gold" by Olaf Nowacki

Volume 1 - setup

The story headline is "A tiny tiny crypt crawler".
The release number is 2.
The story description is "Kill the vampire and loot all the gold coins.".
The story creation year is 2023.

Release along with cover art ("Silhouette of a woman in a cemetery at sunset."), an interpreter and the source text.

Book 1 - ignore beta-comments

After reading a command (this is the ignore beta-comments rule): 
	if the player's command matches the regular expression "^\W|\*|\+|\#": 
		say "(Noted.)"; 
		reject the player's command.



Book 2 - Equipment

Part 1 - Weapons

A weapon is a kind of thing.
A weapon has a number called dice.
A weapon has a number called mod.
A weapon has a number called rate.

Some weapons are defined by the Table of Armory.

Table of Armory
name	dice	mod	rate
a stick	1	-2	60
a dagger	1	2	60
a club	2	-1	50
a spear	2	-1	90
a sword	3	2	70

Instead of examining a weapon:
	say "The [noun] has an hitting rate of [rate of the noun]% and does [dice of the noun]D6 [if mod of the noun > -1]+[end if][mod of the noun] damage.".
	
Instead of taking a weapon:
	let w be entry 1 of the list of weapons carried by the player;
	now w is in the location;
	now the noun is carried by the player;
	now the equiped weapon is the noun;
	say "You take up the [noun]. And since you only have so many hands, you leave your previous weapon behind in hopes that the new one will be better.".

Part 2 - Armor

An armor is a kind of wearable thing.
An armor has a number called defense.

Some armors are defined by the Table of Armament

Table of Armament
name	defense
a leather shirt	10
a pair of gloves	5
a helm	10
a buckler	10
a chainmail	15

Understand "chain", "mail" as chainmail.

Instead of examining an armor:
	say "The [noun] [have] a defense value of [defense of the noun][if the noun is not worn by the player], if worn[end if].".

After wearing something:
	increase protection by defense of the noun;
	say "You put on the [noun] and immediately feel better protected.".
	
Instead of taking off something worn:
	say "That would be stupid, because you need all the protection you can get.". 
	
Part 3 - Items

The silver key is a thing.
The tiny key is a thing.

The potion is a edible thing.
Description of the potion is "A small glass vial with a reddish glittering liquid inside.".

Instead of drinking the potion:
	say "You drink the potion in one go. It tastes disgusting, but you feel better afterwards.";
	now hit points is 25;
	now the potion is nowhere.
	
Instead of eating the potion, try drinking the potion.

The tear of glass is a thing.



Book 3 - Monsters

A monster is a kind of animal.
A monster has a number called dice.
A monster has a number called mod.
A monster has a number called rate.
A monster has a number called hp.
A monster has a number called loot.
A monster has a thing called loot2.

Some monsters are defined by the Table of Creatures.

Table of Creatures
name	dice	mod	rate	hp	loot	loot2
a rat	1	-2	25	4	1	dagger
a bat	1	-1	30	5	1	gloves
a huge spider	2	-4	30	8	3	potion
a skeleton	2	1	35	11	5	buckler
a zombie	2	-3	20	14	4	silver key
an ork	3	-6	40	16	6	chainmail
a vampire	4	-8	50	25	10	tear of glass

Instead of examining a monster, say "This is a creepy and very aggressive [noun]."



Book 4 - Players Possession

The player carries the stick.
The player wears the leather shirt.
The player carries a rucksack.

Understand "sack", "backpack", "knapsack", "gold", "coins" as rucksack.

Description of the rucksack is "A plain canvas sack with two leather straps to carry it on your back. Its only purpose is to carry home all the gold coins you find and it contains exactly [gold in words] coin[s] at the moment.".

Instead of dropping the rucksack, say "Never.".
Instead of wearing the rucksack, say "You already do.".
Instead of taking off the rucksack, say "Not until you've finished here.".

Instead of searching the rucksack, say "A glance into your rucksack reveals that you have found [gold in words] gold coin[s] so far.".

Instead of examining the player, say "You're not a vampire hunter and you don't look like one, but so what?".


Book 6 - global variables

hit points is a number that varies. hit points is 25.

protection is a number that varies.

gold is a number that varies.

Equiped weapon is a weapon that varies. Equiped weapon is the stick.


Book 7 - when play begins

After printing the banner text:
	say "-----[line break]Type A to attack a creature.[line break]Type INFO for some background information on this game.".
	
When play begins:
	now the right hand status line is "[hit points] HP - [gold] gold".
	
Book 2 - New Actions

Part 1 - Crediting

Crediting is an action out of world.
Understand "who", "about", "info", "credit", "credits" as crediting.

Report crediting: say "[line break][bold type]Vampire Gold[roman type] (Release 2)[line break]A tiny crypt crawler by Olaf Nowacki. The original version of this game was a 'La Petite Mort' entry for EctoComp 2023. This slightly improved version was created in January 2024. Please send your very welcome feedback and transcripts to me at olaf.nowacki@gmail.com!".

Part 2 - Helping

Helping is an action out of world.
Understand "help" as helping.
Understand the command "aid/advice/hint/walkthrough" as "help".

Report helping: say "Thanks to David Welbourn there is a fantastic walkthrough for the first release of Vampire Gold, which will certainly help here too:[paragraph break]http://plover.net/~davidw/sol/v/vampi23.html[line break]".

	
Book 7 - attacking
	
Understand "a [something]" as attacking.
Understand "a", "attack", "break", "smash", "hit", "fight", "wreck", "crack", "destroy", "murder", "kill", "punch", "thump" as attacking.

Rule for supplying a missing noun while attacking (this is the obvious target rule):
	if a monster is in the location:
		let lom be the list of monsters in the location;
		let mo be entry 1 of lom;
		now the noun is mo;
	else:
		say "There are no monsters here." instead.
		
Book 8 - noise making

Understand the command "shout" as something new.

Making noise is an action applying to nothing.
Understand "yell" as making noise.
Understand "make noise" as making noise.
Understand the commands "shout", "scream", "holler", "roar" as "yell".

Report making noise:
	say "You're making a lot of noise. You should probably back off a bit.".

		
Volume 2 - Fighting
	
To attack by (mo - a monster):
	let damage be 0;
	repeat with n running from 1 to dice of mo:
		increase damage by a random number from 1 to 6;
	increase damage by mod of mo;
	if damage < 1:
		now damage is 0;
	if damage > 0 and a random chance of (rate of the mo - protection) in 100 succeeds:
		say "The [mo] attacks you and deals [damage] points of damage.";
		decrease hit points by damage;
	else:
		say "The [mo] attacks you, but misses.".
		
Instead of attacking a monster:
	let damage be 0;
	repeat with n running from 1 to dice of equiped weapon:
		increase damage by a random number from 1 to 6;
	increase damage by mod of equiped weapon;
	if damage < 1:
		now damage is 0;
	if damage > 0 and a random chance of rate of the equiped weapon in 100 succeeds:
		say "You attack the [noun] and inflict [damage] points of damage.";
		decrease hp of the noun by damage;
		if the the hp of the noun < 1:
			let g be 0;
			repeat with n running from 1 to loot of noun:
				increase g by a random number from 1 to 6;
			say "[line break]Your last strike killed the [noun]. It leaves behind [g] gold coins, which you immediately deposit in your rucksack.";
			increase gold by g;
			if loot2 of the noun is a thing:
				say "[line break]The [noun] also dropped a [loot2 of the noun].";
				now loot2 of the noun is in the location;
			now the noun is nowhere;
			if the vampire is nowhere:
				say "[line break]You managed to kill the vampire.[line break]You have captured [gold] gold coins. Reward enough. Go home now.";
				end the story finally;
	else:
		say "You attack the [noun], but you miss.".
		
Every turn when a monster is in the location:
	let lom be the list of monsters in the location;
	let mo be entry 1 of lom;
	attack by mo;
	if hit points < 0:
		say "[line break]You managed to loot [gold] gold coins.[line break]Trying to get more, you were killed by the [mo].";
		end the story.

	
Volume 3 - The Map

Book 1 - ELV - Entrance to the Lair of the Vampire

ELV is a room. "Tilted old steps lead down to the vampire's dwelling."
Printed name of ELV is "Entrance to the Lair of the Vampire".

The steps are a scenery thing in the ELV.
Understand "entrance", "tilted", "old" as steps.
Description of the steps is "Why stare at the old steps any longer? Overcome your fear and go down at last.".

The lair is a scenery thing in the ELV.
Understand "of/-- the/-- vampire" as lair.
Description of the lair is "You can't see the vampire's lair from up here, but it must be down there somewhere. That much is certain.".

Instead of going nowhere in the ELV, say "You have sworn to seek revenge - and gold. You'll find both down the stairs, nowhere else.".

Book 2 - CRT - Crossing Tunnels

CRT is down of ELV. "A gloomy tunnel branches at this point in three directions: north, west and east. Worn steps lead up to the surface."
Printed name of CRT is "Crossing Tunnels".

Instead of going up in the CRT, say "You have sworn not to return until the vampire is dead. And you have plundered all his gold.".

The rat is in the CRT. 

Book 3 - CHA - Small Chamber

The CHA is north of the CRT. "The northern tunnel ends in a small chamber. From here, the only way is back to the south."
Printed name of CHA is "Small Chamber"

The ork is in the CHA.

The trapdoor is a fixed in place container in the CHA.
Understand "door", "compartment" as trapdoor.
It is lockable and locked. The matching key of the trapdoor is the tiny key.

In the trapdoor is the sword.

After opening the trapdoor for the first time:
	now the printed name of the trapdoor is "compartment in the floor";
	say "When you open the trapdoor, you realize that there is only a shallow recess underneath, and in it lies a sword.".

Book 4 - CAV - Large Cave

The CAV is east of the CRT. "A large cave with exits to the west, north and southeast."
Printed name of the CAV is "Large Cave".

The bat is in the CAV.

Book 5 - NOC - Northern Cave

The NOC is north of the CAV. "This part of the cave looks like a high dome. Above you, stalactites hang from the walls. The acoustics here are extraordinary. Even quiet sounds swell to a threatening volume due to the reverberation."
Printed name of the NOC is "Northern Cave".

The tiny key is in the NOC.
Initial appearance of the tiny key is "At an unreachable height, a tiny key hangs from a thread tied to a stalactite."

Instead of taking the tiny key when the tiny key is not handled, say "You can not reach it.".

Instead of making noise in the noc when the tiny key is not handled:
	say "You make a big noise and the echo swells the noise more and more. Some stalactites detach from the ceiling and crash to the ground. Between the debris of the stalactites lies the tiny key.";
	now the tiny key is handled.

Book 6 - SEC - Spider Cave

The SEC is southeast of the CAV. "The southeastern part of the cave consists of narrow winding passages full of spider webs."
Printed name of the SEC is "Spider Cave"

The spider is in the SEC.

Book 7 - COR - Corridor

The COR is west of the CRT. "At the end of a tunnel running from east to west."
Printed name of COR is "Corridor".

The zombie is in the COR.

Book 8 - sturdy oak door

The sturdy oak door is a door. It is west of COR and east of STA.
It is lockable and locked. The matching key of the sturdy oak door is the silver key.

Book 9 - STA - Staircase

STA is a room. "A stone spiral staircase leads down."
Printed name of the STA is "Staircase".

The skeleton is in the STA.

Book 10 - LOV - Lair of the Vampire

LOV is down of STA. "A gloomy tomb. This is the lair of the vampire."
Printed name of LOV is "Lair of the Vampire".

The vampire is in the LOV.



