/*
 * Decompiled with CFR 0.152.
 */
import bsh.TargetError;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Item
extends Entity
implements Descriptible,
SupportingCode,
Nameable {
    private String itemType;
    private int idnumber;
    private int inheritsFrom;
    protected String title;
    private int isInstanceOf;
    protected Description[] descriptionList;
    protected Description[] singNames;
    protected Description[] plurNames;
    protected boolean gender;
    protected String respondToSing;
    protected String respondToPlur;
    protected int volume;
    protected int weight;
    protected String inventoryString;
    protected Inventory inventory;
    protected String partsInventoryString;
    protected Inventory partsInventory;
    protected Vector characterRefs;
    protected Vector mobRefs;
    protected String extraDescriptions;
    protected List extraDescriptionArrays = new ArrayList();
    protected List extraDescriptionNameArrays = new ArrayList();
    protected Vector onlyRestrictions;
    protected Description[] openDescriptionList = null;
    protected Description[] closeDescriptionList = null;
    protected Description[] unlockDescriptionList = null;
    protected Description[] lockDescriptionList = null;
    protected Inventory keys;
    protected boolean enabled;
    protected boolean isVirtual;
    protected boolean canGet;
    protected ObjectCode itsCode;
    private Random aleat;
    protected transient List rooms = new ArrayList();
    protected transient List mobiles = new ArrayList();
    transient boolean getDescription_bsh_call = false;

    public void addRoomReference(Room r) {
        this.rooms.add(r);
    }

    public void removeRoomReference(Room r) {
        this.rooms.remove(r);
    }

    public List getRoomReferences() {
        return this.rooms;
    }

    public void addMobileReference(Mobile m) {
        this.mobiles.add(m);
    }

    public void removeMobileReference(Mobile m) {
        this.mobiles.remove(m);
    }

    public List getMobileReferences() {
        return this.mobiles;
    }

    public Item createNewInstance(World mundo, boolean cloneContents, boolean cloneParts) {
        Item it = (Item)this.clone();
        it.inheritsFrom = 0;
        if (this.isInstanceOf == 0) {
            it.isInstanceOf = this.idnumber;
            System.out.println("1) instanceOf set to " + this.idnumber);
        } else {
            it.isInstanceOf = this.isInstanceOf;
            System.out.println("2) instanceOf set to " + this.isInstanceOf);
        }
        if (cloneContents && it.inventory != null) {
            it.inventory = it.inventory.cloneCopyingItems(mundo, cloneContents, cloneParts);
        }
        if (cloneParts && it.inventory != null) {
            it.partsInventory = it.partsInventory.cloneCopyingItems(mundo, cloneContents, cloneParts);
        }
        mundo.addItemAssigningID(it);
        return it;
    }

    public Object clone() {
        Item it = new Item();
        this.copyItemFieldsTo(it);
        return it;
    }

    public void copyItemFieldsTo(Item it) {
        int i;
        it.copyEntityFields(this);
        it.aleat = this.getRandom();
        it.canGet = this.canGet;
        it.enabled = this.enabled;
        it.extraDescriptions = this.extraDescriptions;
        it.gender = this.gender;
        it.idnumber = this.idnumber;
        it.inheritsFrom = this.inheritsFrom;
        it.inventory = this.inventory != null ? (Inventory)this.inventory.clone() : null;
        it.inventoryString = this.inventoryString;
        it.isInstanceOf = this.isInstanceOf;
        it.isVirtual = this.isVirtual;
        it.itemType = this.itemType;
        it.itsCode = this.itsCode != null ? this.itsCode.cloneIfNecessary() : null;
        it.keys = this.keys != null ? (Inventory)this.keys.clone() : null;
        it.partsInventory = this.partsInventory != null ? (Inventory)this.partsInventory.clone() : null;
        it.partsInventoryString = this.partsInventoryString;
        it.respondToPlur = this.respondToPlur;
        it.respondToSing = this.respondToSing;
        it.title = this.title;
        it.volume = this.volume;
        it.weight = this.weight;
        if (this.closeDescriptionList != null) {
            it.closeDescriptionList = new Description[this.closeDescriptionList.length];
            i = 0;
            while (i < it.closeDescriptionList.length) {
                it.closeDescriptionList[i] = (Description)this.closeDescriptionList[i].clone();
                ++i;
            }
        }
        it.descriptionList = new Description[this.descriptionList.length];
        i = 0;
        while (i < it.descriptionList.length) {
            it.descriptionList[i] = (Description)this.descriptionList[i].clone();
            ++i;
        }
        if (this.lockDescriptionList != null) {
            it.lockDescriptionList = new Description[this.lockDescriptionList.length];
            i = 0;
            while (i < it.lockDescriptionList.length) {
                it.openDescriptionList[i] = (Description)this.openDescriptionList[i].clone();
                ++i;
            }
        }
        if (this.openDescriptionList != null) {
            it.openDescriptionList = new Description[this.openDescriptionList.length];
            i = 0;
            while (i < it.lockDescriptionList.length) {
                it.unlockDescriptionList[i] = (Description)this.unlockDescriptionList[i].clone();
                ++i;
            }
        }
        if (this.unlockDescriptionList != null) {
            it.unlockDescriptionList = new Description[this.unlockDescriptionList.length];
            i = 0;
            while (i < it.lockDescriptionList.length) {
                it.lockDescriptionList[i] = (Description)this.lockDescriptionList[i].clone();
                ++i;
            }
        }
        it.singNames = new Description[this.singNames.length];
        i = 0;
        while (i < it.singNames.length) {
            it.singNames[i] = (Description)this.singNames[i].clone();
            ++i;
        }
        it.plurNames = new Description[this.plurNames.length];
        i = 0;
        while (i < it.plurNames.length) {
            it.plurNames[i] = (Description)this.plurNames[i].clone();
            ++i;
        }
    }

    public Item() {
    }

    public Item(World mundo, String itemfile) throws IOException, FileNotFoundException {
        this.constructItem(mundo, itemfile, true, "none");
    }

    public Item(World mundo, Node n) throws XMLtoWorldException {
        this.constructItem(mundo, n, true, "none");
    }

    public static Item getInstance(World mundo, String itemfile) throws FileNotFoundException, IOException {
        FileInputStream fp = new FileInputStream(itemfile);
        BufferedReader filein = new BufferedReader(Utility.getBestInputStreamReader(fp));
        String itemtype = "none";
        int line = 1;
        while (line < 100) {
            String linea = filein.readLine();
            String id_linea = StringMethods.getTok(linea, 1, ' ');
            linea = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
            try {
                if (id_linea != null && Integer.valueOf(id_linea) == 0) {
                    itemtype = linea;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++line;
        }
        Item ourNewItem = itemtype.equalsIgnoreCase("weapon") ? new Weapon(mundo, itemfile) : (itemtype.equalsIgnoreCase("wearable") ? new Wearable(mundo, itemfile) : new Item(mundo, itemfile));
        return ourNewItem;
    }

    public static Item getInstance(World mundo, Node n) throws XMLtoWorldException {
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("Item node not Element");
        }
        Element e = (Element)n;
        Item ourNewItem = !e.hasAttribute("type") ? new Item(mundo, n) : (e.getAttribute("type").equalsIgnoreCase("weapon") ? new Weapon(mundo, n) : (e.getAttribute("type").equalsIgnoreCase("wearable") ? new Wearable(mundo, n) : new Item(mundo, n)));
        return ourNewItem;
    }

    public void constructItem(World mundo, String itemfile, boolean allowInheritance, String itemtype) throws IOException, FileNotFoundException {
        FileInputStream fp = new FileInputStream(itemfile);
        BufferedReader filein = new BufferedReader(Utility.getBestInputStreamReader(fp));
        this.itemType = itemtype;
        int line = 1;
        while (line < 100) {
            String linea = filein.readLine();
            String id_linea = StringMethods.getTok(linea, 1, ' ');
            linea = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
            if (id_linea != null) {
                switch (Integer.valueOf(id_linea)) {
                    case 1: {
                        this.idnumber = Integer.valueOf(linea);
                        break;
                    }
                    case 2: {
                        this.inheritsFrom = Integer.valueOf(linea);
                        if (this.inheritsFrom >= this.idnumber || !allowInheritance) break;
                        this.constructItem(mundo, Utility.itemFile(mundo, this.inheritsFrom), true, itemtype);
                        this.constructItem(mundo, itemfile, false, itemtype);
                        return;
                    }
                    case 3: {
                        this.setNewState(Integer.valueOf(linea));
                        break;
                    }
                    case 4: {
                        this.title = linea;
                        break;
                    }
                    case 5: {
                        this.isInstanceOf = Integer.valueOf(linea);
                        if (this.isInstanceOf >= this.idnumber || !allowInheritance) break;
                        this.constructItem(mundo, Utility.itemFile(mundo, this.isInstanceOf), true, itemtype);
                        this.constructItem(mundo, itemfile, false, itemtype);
                        return;
                    }
                    case 10: {
                        this.descriptionList = Utility.loadDescriptionListFromString(linea);
                        break;
                    }
                    case 11: {
                        this.singNames = Utility.loadDescriptionListFromString(linea);
                        break;
                    }
                    case 12: {
                        this.plurNames = Utility.loadDescriptionListFromString(linea);
                        break;
                    }
                    case 13: {
                        int temp = Integer.valueOf(linea);
                        if (temp == 0) {
                            this.gender = false;
                            break;
                        }
                        this.gender = true;
                        break;
                    }
                    case 14: {
                        this.respondToSing = linea;
                        break;
                    }
                    case 15: {
                        this.respondToPlur = linea;
                        break;
                    }
                    case 16: {
                        this.weight = Integer.valueOf(linea);
                        break;
                    }
                    case 17: {
                        this.volume = Integer.valueOf(linea);
                        break;
                    }
                    case 20: {
                        this.inventoryString = linea;
                        break;
                    }
                    case 32: {
                        this.openDescriptionList = Utility.loadDescriptionListFromString(linea);
                        break;
                    }
                    case 33: {
                        this.closeDescriptionList = Utility.loadDescriptionListFromString(linea);
                        break;
                    }
                    case 34: {
                        this.unlockDescriptionList = Utility.loadDescriptionListFromString(linea);
                        break;
                    }
                    case 35: {
                        this.lockDescriptionList = Utility.loadDescriptionListFromString(linea);
                        break;
                    }
                    case 36: {
                        int nkeys = StringMethods.numToks(linea, '&');
                        this.keys = new Inventory(10000000, 1000000);
                        int i = 1;
                        while (i <= nkeys) {
                            int key_id = Integer.valueOf(StringMethods.getTok(linea, i, '&'));
                            if (key_id > this.idnumber) {
                                mundo.escribir("Warning! La ID de una llave no puede ser mayor que la del objeto que abre (" + key_id + " > " + this.idnumber + ")\n");
                            } else {
                                try {
                                    this.keys.addItem(mundo.getItem(key_id));
                                }
                                catch (Exception exc) {
                                    mundo.escribir("Excepci\u00f3n absurda (llave pesada)" + exc);
                                }
                            }
                            ++i;
                        }
                        break;
                    }
                    case 80: {
                        int intval;
                        String EVACodeString = linea;
                        boolean terminamos = false;
                        while (!terminamos) {
                            linea = filein.readLine();
                            id_linea = StringMethods.getTok(linea, 1, ' ');
                            try {
                                intval = Integer.valueOf(id_linea);
                            }
                            catch (NumberFormatException e) {
                                intval = 0;
                            }
                            if (intval == 81) {
                                terminamos = true;
                                continue;
                            }
                            EVACodeString = String.valueOf(EVACodeString) + "\n";
                            EVACodeString = String.valueOf(EVACodeString) + linea;
                        }
                        this.itsCode = new ObjectCode(EVACodeString, "EVA", mundo);
                        break;
                    }
                    case 84: {
                        int intval;
                        String bshCodeString = linea;
                        boolean terminamos = false;
                        while (!terminamos) {
                            linea = filein.readLine();
                            id_linea = StringMethods.getTok(linea, 1, ' ');
                            try {
                                intval = Integer.valueOf(id_linea);
                            }
                            catch (NumberFormatException e) {
                                intval = 0;
                            }
                            if (intval == 85) {
                                terminamos = true;
                                continue;
                            }
                            bshCodeString = String.valueOf(bshCodeString) + "\n";
                            bshCodeString = String.valueOf(bshCodeString) + linea;
                        }
                        this.itsCode = new ObjectCode(bshCodeString, "BeanShell", mundo);
                    }
                }
            }
            ++line;
        }
        if (itemtype.equalsIgnoreCase("weapon")) {
            ((Weapon)this).readWeaponSpecifics(mundo, itemfile);
        }
        if (this.getID() < 10000000) {
            this.idnumber += 30000000;
        }
    }

    public void constructItem(World mundo, Node n, boolean allowInheritance, String itemtype) throws XMLtoWorldException {
        NodeList codeNodes;
        NodeList singRefNamesNodes;
        Element descrNode;
        int i;
        NodeList descrNodes;
        Element descrListNode;
        Element e;
        block48: {
            block47: {
                if (!(n instanceof Element)) {
                    throw new XMLtoWorldException("Item node not Element");
                }
                e = (Element)n;
                this.itemType = itemtype;
                this.canGet = true;
                this.isVirtual = false;
                this.enabled = true;
                if (e.hasAttribute("extends") && !e.getAttribute("extends").equals("0") && allowInheritance) {
                    this.constructItem(mundo, mundo.getItemNode(e.getAttribute("extends")), true, itemtype);
                    this.constructItem(mundo, n, false, itemtype);
                    return;
                }
                if (e.hasAttribute("clones") && !e.getAttribute("clones").equals("0") && allowInheritance) {
                    this.constructItem(mundo, mundo.getItemNode(e.getAttribute("clones")), true, itemtype);
                    System.out.println("Overridden item gender is " + this.gender);
                    this.constructItem(mundo, n, false, itemtype);
                    System.out.println("Overridden item gender is now " + this.gender);
                    return;
                }
                if (!e.hasAttribute("name")) {
                    throw new XMLtoWorldException("Item node lacks attribute name");
                }
                if (!e.hasAttribute("volume") && allowInheritance) {
                    throw new XMLtoWorldException("Item node lacks attribute volume, id=" + e.getAttribute("id"));
                }
                if (!e.hasAttribute("weight") && allowInheritance) {
                    throw new XMLtoWorldException("Item node lacks attribute weight, id=" + e.getAttribute("id"));
                }
                if (!e.hasAttribute("gender") && allowInheritance) {
                    throw new XMLtoWorldException("Item node lacks attribute gender, id=" + e.getAttribute("id"));
                }
                try {
                    if (e.hasAttribute("id")) {
                        this.idnumber = Integer.valueOf(e.getAttribute("id"));
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new XMLtoWorldException("Bad number format at attribute id in item node");
                }
                this.title = e.getAttribute("name");
                if (!this.gender) {
                    this.gender = Boolean.valueOf(e.getAttribute("gender"));
                }
                System.out.println("Gender has been set to " + this.gender + " for " + this.title);
                try {
                    this.weight = Integer.valueOf(e.getAttribute("weight"));
                }
                catch (NumberFormatException nfe) {
                    if (!allowInheritance) break block47;
                    throw new XMLtoWorldException("Bad number format at attribute weight in item node");
                }
            }
            try {
                this.volume = Integer.valueOf(e.getAttribute("volume"));
            }
            catch (NumberFormatException nfe) {
                if (!allowInheritance) break block48;
                throw new XMLtoWorldException("Bad number format at attribute volume in item node");
            }
        }
        if (e.hasAttribute("enabled")) {
            this.enabled = Boolean.valueOf(e.getAttribute("enabled"));
        }
        if (e.hasAttribute("isVirtual")) {
            this.isVirtual = Boolean.valueOf(e.getAttribute("isVirtual"));
        }
        if (e.hasAttribute("canGet")) {
            this.canGet = Boolean.valueOf(e.getAttribute("canGet"));
        }
        this.readPropListFromXML(mundo, n);
        NodeList descrListNodes = e.getElementsByTagName("DescriptionList");
        if (descrListNodes.getLength() > 0) {
            descrListNode = (Element)descrListNodes.item(0);
            descrNodes = descrListNode.getElementsByTagName("Description");
            this.descriptionList = new Description[descrNodes.getLength()];
            i = 0;
            while (i < descrNodes.getLength()) {
                descrNode = (Element)descrNodes.item(i);
                try {
                    this.descriptionList[i] = new Description(mundo, descrNode);
                }
                catch (XMLtoWorldException xe) {
                    throw new XMLtoWorldException("Error at item description: " + xe.getMessage());
                }
                ++i;
            }
        }
        if ((descrListNodes = e.getElementsByTagName("SingularNames")).getLength() > 0) {
            descrListNode = (Element)descrListNodes.item(0);
            descrNodes = descrListNode.getElementsByTagName("Description");
            this.singNames = new Description[descrNodes.getLength()];
            i = 0;
            while (i < descrNodes.getLength()) {
                descrNode = (Element)descrNodes.item(i);
                try {
                    this.singNames[i] = new Description(mundo, descrNode);
                }
                catch (XMLtoWorldException xe) {
                    throw new XMLtoWorldException("Error at item description: " + xe.getMessage());
                }
                ++i;
            }
        }
        if ((descrListNodes = e.getElementsByTagName("PluralNames")).getLength() > 0) {
            descrListNode = (Element)descrListNodes.item(0);
            descrNodes = descrListNode.getElementsByTagName("Description");
            this.plurNames = new Description[descrNodes.getLength()];
            i = 0;
            while (i < descrNodes.getLength()) {
                descrNode = (Element)descrNodes.item(i);
                try {
                    this.plurNames[i] = new Description(mundo, descrNode);
                }
                catch (XMLtoWorldException xe) {
                    throw new XMLtoWorldException("Error at item description: " + xe.getMessage());
                }
                ++i;
            }
        }
        if ((singRefNamesNodes = e.getElementsByTagName("SingularReferenceNames")).getLength() > 0) {
            Element singRefNamesNode = (Element)singRefNamesNodes.item(0);
            NodeList nameNodes = singRefNamesNode.getElementsByTagName("Name");
            this.respondToSing = "";
            int i2 = 0;
            while (i2 < nameNodes.getLength()) {
                Element nameNode = (Element)nameNodes.item(i2);
                Node hijo = nameNode.getFirstChild();
                while (!(hijo instanceof Text)) {
                    hijo = hijo.getNextSibling();
                }
                this.respondToSing = String.valueOf(this.respondToSing) + hijo.getNodeValue();
                if (i2 < nameNodes.getLength() - 1) {
                    this.respondToSing = String.valueOf(this.respondToSing) + "$";
                }
                ++i2;
            }
        }
        this.respondToPlur = Utility.loadNameListFromXML(mundo, e, "PluralReferenceNames", true);
        List temp = Utility.loadExtraDescriptionsFromXML(mundo, e, "ExtraDescriptionList", true);
        if (temp == null || temp.size() < 2) {
            this.extraDescriptionArrays = new ArrayList();
            this.extraDescriptionNameArrays = new ArrayList();
        } else {
            this.extraDescriptionArrays = (List)temp.get(1);
            this.extraDescriptionNameArrays = (List)temp.get(0);
        }
        Description[] dl = Utility.loadDescriptionListFromXML(mundo, e, "OpenDescriptionList", true);
        if (dl != null) {
            this.openDescriptionList = dl;
        }
        if ((dl = Utility.loadDescriptionListFromXML(mundo, e, "CloseDescriptionList", true)) != null) {
            this.closeDescriptionList = dl;
        }
        if ((dl = Utility.loadDescriptionListFromXML(mundo, e, "LockDescriptionList", true)) != null) {
            this.lockDescriptionList = dl;
        }
        if ((dl = Utility.loadDescriptionListFromXML(mundo, e, "UnlockDescriptionList", true)) != null) {
            this.unlockDescriptionList = dl;
        }
        if ((codeNodes = e.getElementsByTagName("Code")).getLength() > 0) {
            try {
                this.itsCode = new ObjectCode(mundo, codeNodes.item(0));
            }
            catch (XMLtoWorldException ex) {
                throw new XMLtoWorldException("Exception at Code node: " + ex.getMessage());
            }
        }
        if (itemtype.equalsIgnoreCase("weapon")) {
            ((Weapon)this).readWeaponSpecifics(mundo, e);
        } else if (itemtype.equalsIgnoreCase("wearable")) {
            ((Wearable)this).readWearableSpecifics(mundo, e);
        }
        if (this.getID() < 10000000) {
            this.idnumber += 30000000;
        }
    }

    public int getID() {
        return this.idnumber;
    }

    public String getTitle() {
        return this.title;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public String getDescription(long comparand) {
        String desString = "";
        int i = 0;
        while (i < this.descriptionList.length) {
            if (this.descriptionList[i].matches(comparand)) {
                desString = String.valueOf(desString) + this.descriptionList[i].getText();
            }
            ++i;
        }
        if (!this.isContainer()) {
            return desString;
        }
        if (this.inventory.isEmpty()) {
            return StringMethods.textualSubstitution(StringMethods.textualSubstitution(StringMethods.textualSubstitution(desString, "lleva %INVENTORY", "no lleva nada."), "hay %INVENTORY", "no hay nada."), "%INVENTORY", "nada.");
        }
        return StringMethods.textualSubstitution(desString, "%INVENTORY", this.inventory.toString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDescription(Entity viewer) {
        if (!this.getDescription_bsh_call) {
            boolean ejecutado;
            block11: {
                ejecutado = false;
                ReturnValue retval = new ReturnValue(null);
                try {
                    try {
                        this.getDescription_bsh_call = true;
                        ejecutado = this.execCode("getDescription", new Object[]{viewer}, retval);
                    }
                    catch (TargetError te) {
                        te.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    this.getDescription_bsh_call = false;
                    throw throwable;
                }
                {
                    Object var5_9 = null;
                    this.getDescription_bsh_call = false;
                    if (retval.getRetVal() == null) break block11;
                }
                return (String)retval.getRetVal();
            }
            if (ejecutado) {
                return null;
            }
        }
        String desString = "";
        int i = 0;
        while (true) {
            if (i >= this.descriptionList.length) {
                if (this.isContainer()) break;
                return desString;
            }
            if (this.descriptionList[i].matchesConditions(this, viewer)) {
                desString = String.valueOf(desString) + this.descriptionList[i].getText();
            }
            ++i;
        }
        if (this.inventory.isEmpty()) {
            return StringMethods.textualSubstitution(StringMethods.textualSubstitution(StringMethods.textualSubstitution(desString, "lleva %INVENTORY", "no lleva nada."), "hay %INVENTORY", "no hay nada."), "%INVENTORY", "nada.");
        }
        return StringMethods.textualSubstitution(desString, "%INVENTORY", this.inventory.toString());
    }

    public String getName(boolean s_p, int comparand) {
        Description[] theList = s_p ? this.singNames : this.plurNames;
        String desString = "";
        int i = 0;
        while (i < theList.length) {
            if (theList[i].matches(comparand)) {
                desString = String.valueOf(desString) + theList[i].getText();
            }
            ++i;
        }
        return desString;
    }

    public String getName(boolean s_p, Entity viewer) {
        Description[] theList = s_p ? this.singNames : this.plurNames;
        String desString = "";
        if (theList == null) {
            return desString;
        }
        int i = 0;
        while (i < theList.length) {
            if (theList[i].matchesConditions(this, viewer)) {
                desString = String.valueOf(desString) + theList[i].getText();
            }
            ++i;
        }
        return desString;
    }

    public String getSingName(int comparand) {
        return this.getName(true, comparand);
    }

    public String getSingNameTrue(int comparand) {
        String s = this.getName(true, comparand);
        if (s != null & s.length() > 0) {
            return s;
        }
        return String.valueOf(Character.toLowerCase(this.title.charAt(0))) + this.title.substring(1);
    }

    public String getSingName(Entity viewer) {
        return this.getName(true, viewer);
    }

    public String getSingNameTrue(Entity viewer) {
        String s = this.getName(true, viewer);
        if (s != null & s.length() > 0) {
            return s;
        }
        return String.valueOf(Character.toLowerCase(this.title.charAt(0))) + this.title.substring(1);
    }

    public String getPlurName(int comparand) {
        return this.getName(false, comparand);
    }

    public String getPlurName(Entity viewer) {
        return this.getName(false, viewer);
    }

    public String getPlurNameTrue(int comparand) {
        String s = this.getName(false, comparand);
        if (s != null & s.length() > 0) {
            return s;
        }
        return String.valueOf(Character.toLowerCase(this.title.charAt(0))) + this.title.substring(1);
    }

    public String getPlurNameTrue(Entity viewer) {
        String s = this.getName(false, viewer);
        if (s != null & s.length() > 0) {
            return s;
        }
        return String.valueOf(Character.toLowerCase(this.title.charAt(0))) + this.title.substring(1);
    }

    public String constructName(int nItems, int comparand) {
        if (nItems == 1) {
            if (this.gender) {
                return "un " + this.getSingName(comparand);
            }
            return "una " + this.getSingName(comparand);
        }
        if (nItems < 10) {
            String str;
            switch (nItems) {
                case 2: {
                    str = "dos";
                    break;
                }
                case 3: {
                    str = "tres";
                    break;
                }
                case 4: {
                    str = "cuatro";
                    break;
                }
                case 5: {
                    str = "cinco";
                    break;
                }
                case 6: {
                    str = "seis";
                    break;
                }
                case 7: {
                    str = "siete";
                    break;
                }
                case 8: {
                    str = "ocho";
                    break;
                }
                default: {
                    str = "nueve";
                }
            }
            return String.valueOf(str) + " " + this.getPlurName(comparand);
        }
        return String.valueOf(nItems) + " " + this.getPlurName(comparand);
    }

    public String constructName(int nItems, Entity viewer) {
        if (nItems == 1) {
            if (this.gender) {
                return "un " + this.getSingName(viewer);
            }
            return "una " + this.getSingName(viewer);
        }
        if (nItems < 10) {
            String str;
            switch (nItems) {
                case 2: {
                    str = "dos";
                    break;
                }
                case 3: {
                    str = "tres";
                    break;
                }
                case 4: {
                    str = "cuatro";
                    break;
                }
                case 5: {
                    str = "cinco";
                    break;
                }
                case 6: {
                    str = "seis";
                    break;
                }
                case 7: {
                    str = "siete";
                    break;
                }
                case 8: {
                    str = "ocho";
                    break;
                }
                default: {
                    str = "nueve";
                }
            }
            System.out.println("CONSNAME RETT'N' " + str + " " + this.getPlurName(viewer));
            return String.valueOf(str) + " " + this.getPlurName(viewer);
        }
        return String.valueOf(nItems) + " " + this.getPlurName(viewer);
    }

    public String constructName2(int nItems, int comparand) {
        if (nItems == 1) {
            if (this.gender) {
                return "el " + this.getSingName(comparand);
            }
            return "la " + this.getSingName(comparand);
        }
        return String.valueOf(nItems) + " " + this.getPlurName(comparand);
    }

    public String constructName2(int nItems, Entity viewer) {
        if (nItems == 1) {
            if (this.gender) {
                return "el " + this.getSingName(viewer);
            }
            return "la " + this.getSingName(viewer);
        }
        return String.valueOf(nItems) + " " + this.getPlurName(viewer);
    }

    public String constructName2True(int nItems, int comparand) {
        if (nItems == 1) {
            if (this.gender) {
                return "el " + this.getSingNameTrue(comparand);
            }
            return "la " + this.getSingNameTrue(comparand);
        }
        return String.valueOf(nItems) + " " + this.getPlurNameTrue(comparand);
    }

    public String constructName2True(int nItems, Entity viewer) {
        if (nItems == 1) {
            if (this.gender) {
                return "el " + this.getSingNameTrue(viewer);
            }
            return "la " + this.getSingNameTrue(viewer);
        }
        return String.valueOf(nItems) + " " + this.getPlurNameTrue(viewer);
    }

    public String constructName2OneItem() {
        return this.constructName2True(1, this.getState());
    }

    public String constructName2OneItem(Entity viewer) {
        return this.constructName2True(1, viewer);
    }

    public String getExtraDescription(String thingieName, Entity viewer) {
        int i = 0;
        while (i < this.extraDescriptionNameArrays.size()) {
            String[] curNameArray = (String[])this.extraDescriptionNameArrays.get(i);
            Description[] curDesArray = (Description[])this.extraDescriptionArrays.get(i);
            int j = 0;
            while (j < curNameArray.length) {
                if (StringMethods.getTok(thingieName, StringMethods.numToks(thingieName, ' '), ' ').equalsIgnoreCase(curNameArray[j])) {
                    String desString = "";
                    int k = 0;
                    while (k < curDesArray.length) {
                        if (curDesArray[k].matchesConditions(this, viewer)) {
                            desString = String.valueOf(desString) + "\n";
                            desString = String.valueOf(desString) + curDesArray[k].getText();
                        }
                        ++k;
                    }
                    if (desString.length() > 0) {
                        return desString.substring(1);
                    }
                    return null;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public int matchesCommand(String commandArgs, boolean pluralOrSingular) {
        String listaDeInteres = pluralOrSingular ? this.respondToPlur : this.respondToSing;
        int nToksArg = StringMethods.numToks(commandArgs, ' ');
        int nToksList = StringMethods.numToks(listaDeInteres, '$');
        int i = 1;
        while (i <= nToksArg) {
            String currentToAnalyze = StringMethods.getToks(commandArgs, i, nToksArg, ' ');
            int j = 1;
            while (j <= nToksList) {
                if (StringMethods.getTok(listaDeInteres, j, '$').equalsIgnoreCase(currentToAnalyze)) {
                    return j;
                }
                ++j;
            }
            ++i;
        }
        return 0;
    }

    public int getInstanceOf() {
        return this.isInstanceOf;
    }

    public void setInstanceOf(int newid) {
        this.isInstanceOf = newid;
    }

    public boolean isSame(Item other) {
        System.out.print("isSame " + this + "(" + this.getTitle() + "," + this.idnumber + ", cloning " + this.getInstanceOf() + ")" + " " + other + "(" + other.getTitle() + "," + other.idnumber + ", cloning " + other.getInstanceOf() + ")? ");
        System.out.println("" + (this.idnumber % 10000000 == other.getInstanceOf() % 10000000 || this.isInstanceOf % 10000000 == other.getID() % 10000000 || this.isInstanceOf % 10000000 == other.getInstanceOf() % 10000000 && this.isInstanceOf % 10000000 != 0));
        return this.idnumber % 10000000 == other.getInstanceOf() % 10000000 || this.isInstanceOf % 10000000 == other.getID() % 10000000 || this.isInstanceOf % 10000000 == other.getInstanceOf() % 10000000 && this.isInstanceOf % 10000000 != 0;
    }

    public boolean execCode(String routine, String dataSegment) throws EVASemanticException {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, dataSegment);
        }
        return false;
    }

    public boolean isInvisible(Entity viewer) {
        return StringMethods.numToks(this.constructName(1, viewer), ' ') < 2;
    }

    public boolean execCode(String routine, Object[] args) throws TargetError {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, this, args);
        }
        return false;
    }

    public boolean execCode(String routine, Object[] args, ReturnValue retval) throws TargetError {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, this, args, retval);
        }
        return false;
    }

    public void changeState(World mundo) {
        try {
            this.execCode("event_endstate", "this: " + this.getID() + "state: " + this.getState());
        }
        catch (EVASemanticException exc) {
            mundo.escribir("EVASemanticException found at event_endstate , item number " + this.getID());
        }
    }

    public boolean getGender() {
        return this.gender;
    }

    public boolean isOpenable() {
        return this.openDescriptionList != null && this.openDescriptionList.length > 0;
    }

    public boolean isCloseable() {
        return this.closeDescriptionList != null && this.closeDescriptionList.length > 0;
    }

    public boolean isUnlockable() {
        return this.unlockDescriptionList != null && this.unlockDescriptionList.length > 0;
    }

    public boolean isLockable() {
        return this.lockDescriptionList != null && this.lockDescriptionList.length > 0;
    }

    public boolean isOpen() {
        return (0x100 & this.getState()) == 0 && !this.getPropertyValueAsBoolean("closed");
    }

    public boolean isClosed() {
        return !this.isOpen();
    }

    public boolean isUnlocked() {
        return (0x200 & this.getState()) == 0 && !this.getPropertyValueAsBoolean("locked");
    }

    public boolean isLocked() {
        return !this.isUnlocked();
    }

    public boolean unlocksWithKey(Item key) {
        if (this.keys != null) {
            int i = 0;
            while (i < this.keys.size()) {
                if (this.keys.elementAt(i).equals(key)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String abrir() {
        boolean exito = false;
        String descriptionText = "";
        if (!this.isOpenable()) {
            return "Es absurdo abrir eso.";
        }
        int i = 0;
        while (i < this.openDescriptionList.length) {
            Description des_actual = this.openDescriptionList[i];
            if (des_actual.matchesConditions(this)) {
                String elTexto = des_actual.getText();
                StringTokenizer st = new StringTokenizer(elTexto, ":");
                String firstToken = st.nextToken();
                if (firstToken.equalsIgnoreCase("SUCCESS") || firstToken.equalsIgnoreCase("EXITO")) {
                    exito = true;
                }
                elTexto = "";
                while (st.hasMoreTokens()) {
                    elTexto = String.valueOf(elTexto) + st.nextToken();
                }
                if (!elTexto.equals("")) {
                    descriptionText = String.valueOf(descriptionText) + elTexto;
                }
            }
            ++i;
        }
        if (exito) {
            this.setNewState(this.getState() & 0xFFFFFEFF);
            this.setProperty("closed", false);
            List habitaciones = this.getRoomReferences();
            int i2 = 0;
            while (i2 < habitaciones.size()) {
                Room room = (Room)habitaciones.get(i2);
                ++i2;
            }
        }
        try {
            this.execCode("onOpen", new Object[]{new Boolean(exito)});
        }
        catch (TargetError bshte) {
            return "bsh.TargetError found onOpen , item number " + this.getID() + ": " + bshte + "[description was: " + descriptionText + "]";
        }
        return descriptionText;
    }

    public String cerrar() {
        if (!this.isCloseable()) {
            return "Es absurdo cerrar eso.";
        }
        String descriptionText = "";
        boolean exito = false;
        int i = 0;
        while (i < this.closeDescriptionList.length) {
            Description des_actual = this.closeDescriptionList[i];
            if (des_actual.matchesConditions(this)) {
                String elTexto = des_actual.getText();
                StringTokenizer st = new StringTokenizer(elTexto, ":");
                String firstToken = st.nextToken();
                if (firstToken.equalsIgnoreCase("SUCCESS") || firstToken.equalsIgnoreCase("EXITO")) {
                    exito = true;
                }
                elTexto = "";
                while (st.hasMoreTokens()) {
                    elTexto = String.valueOf(elTexto) + st.nextToken();
                }
                if (!elTexto.equals("")) {
                    descriptionText = String.valueOf(descriptionText) + elTexto;
                }
            }
            ++i;
        }
        if (exito) {
            this.setNewState(this.getState() | 0x100);
            this.setProperty("closed", true);
            List habitaciones = this.getRoomReferences();
            int i2 = 0;
            while (i2 < habitaciones.size()) {
                Room room = (Room)habitaciones.get(i2);
                ++i2;
            }
        }
        try {
            this.execCode("onClose", new Object[]{new Boolean(exito)});
        }
        catch (TargetError bshte) {
            return "bsh.TargetError found onOpen , item number " + this.getID() + ": " + bshte + "[description was: " + descriptionText + "]";
        }
        return descriptionText;
    }

    public String unlock(Item key) {
        String descriptionText;
        block14: {
            block13: {
                if (!this.isUnlockable()) {
                    return "No parece que se pueda abrir eso de ese modo.";
                }
                descriptionText = "";
                if (this.unlocksWithKey(key)) break block13;
                int i = 0;
                while (i < this.unlockDescriptionList.length) {
                    Description des_actual = this.unlockDescriptionList[i];
                    String elTexto2 = "";
                    if (des_actual.matchesConditions(this)) {
                        String temp;
                        String elTexto1 = des_actual.getText();
                        StringTokenizer st = new StringTokenizer(elTexto1, ":");
                        while (st.hasMoreTokens() && !(temp = st.nextToken()).equalsIgnoreCase("FAIL") && !temp.equalsIgnoreCase("FRACASO")) {
                        }
                        elTexto2 = st.nextToken();
                    }
                    if (!elTexto2.equals("")) {
                        descriptionText = String.valueOf(descriptionText) + elTexto2;
                    }
                    ++i;
                }
                break block14;
            }
            boolean unlocked = false;
            int i = 0;
            while (i < this.unlockDescriptionList.length) {
                Description des_actual = this.unlockDescriptionList[i];
                String elTexto2 = "";
                if (des_actual.matchesConditions(this)) {
                    String elTexto1 = des_actual.getText();
                    StringTokenizer st = new StringTokenizer(elTexto1, ":");
                    String temp = null;
                    while (st.hasMoreTokens() && !(temp = st.nextToken()).equalsIgnoreCase("SUCCESS") && !temp.equalsIgnoreCase("EXITO")) {
                    }
                    if (temp.equalsIgnoreCase("SUCCESS") || temp.equalsIgnoreCase("EXITO")) {
                        elTexto2 = st.nextToken();
                        unlocked = true;
                    }
                    if (elTexto2.equals("")) {
                        StringTokenizer st2 = new StringTokenizer(elTexto1, ":");
                        String temp2 = null;
                        System.out.println("Des_actual: " + des_actual.getText());
                        StringTokenizer st3 = new StringTokenizer(elTexto1, ":");
                        System.out.println(st3.nextToken());
                        System.out.println(st3.nextToken());
                        while (st2.hasMoreTokens() && !(temp2 = st2.nextToken()).equalsIgnoreCase("FAIL") && !temp2.equalsIgnoreCase("FRACASO")) {
                            System.out.println("TOK: " + temp2);
                            System.out.println("des_actual: " + des_actual);
                        }
                        elTexto2 = st.nextToken();
                    }
                }
                if (!elTexto2.equals("")) {
                    descriptionText = String.valueOf(descriptionText) + "\n";
                    descriptionText = String.valueOf(descriptionText) + elTexto2;
                }
                ++i;
            }
            if (!unlocked) break block14;
            this.setNewState(this.getState() & 0xFFFFFDFF);
            this.setProperty("locked", false);
            List habitaciones = this.getRoomReferences();
            int i2 = 0;
            while (i2 < habitaciones.size()) {
                Room thisHabitacion = (Room)habitaciones.get(i2);
                thisHabitacion.informAction(this, null, null, "$1 se abre con llave.\n", "Te abres con llave.\n", "Abres con llave.\n", false);
                ++i2;
            }
        }
        return descriptionText;
    }

    public String lock(Item key) {
        String descriptionText;
        block14: {
            block13: {
                if (!this.isLockable()) {
                    return "No parece que se pueda cerrar eso de ese modo.";
                }
                descriptionText = "";
                if (this.unlocksWithKey(key)) break block13;
                int i = 0;
                while (i < this.lockDescriptionList.length) {
                    Description des_actual = this.lockDescriptionList[i];
                    String elTexto2 = "";
                    if (des_actual.matchesConditions(this)) {
                        String temp;
                        String elTexto1 = des_actual.getText();
                        StringTokenizer st = new StringTokenizer(elTexto1, ":");
                        while (st.hasMoreTokens() && !(temp = st.nextToken()).equalsIgnoreCase("FAIL") && !temp.equalsIgnoreCase("FRACASO")) {
                        }
                        elTexto2 = st.nextToken();
                    }
                    if (!elTexto2.equals("")) {
                        descriptionText = String.valueOf(descriptionText) + "\n";
                        descriptionText = String.valueOf(descriptionText) + elTexto2;
                    }
                    ++i;
                }
                break block14;
            }
            boolean locked = false;
            int i = 0;
            while (i < this.lockDescriptionList.length) {
                Description des_actual = this.lockDescriptionList[i];
                String elTexto2 = "";
                if (des_actual.matches(this.getState())) {
                    String elTexto1 = des_actual.getText();
                    StringTokenizer st = new StringTokenizer(elTexto1, ":");
                    String temp = null;
                    while (st.hasMoreTokens() && !(temp = st.nextToken()).equalsIgnoreCase("SUCCESS") && !temp.equalsIgnoreCase("EXITO")) {
                    }
                    if (temp.equalsIgnoreCase("SUCCESS") || temp.equalsIgnoreCase("EXITO")) {
                        elTexto2 = st.nextToken();
                        locked = true;
                    }
                    if (elTexto2.equals("")) {
                        StringTokenizer st2 = new StringTokenizer(elTexto1, ":");
                        String temp2 = null;
                        while (st2.hasMoreTokens() && !(temp2 = st2.nextToken()).equalsIgnoreCase("FAIL") && !temp2.equalsIgnoreCase("FRACASO")) {
                        }
                        elTexto2 = st2.nextToken();
                    }
                }
                if (!elTexto2.equals("")) {
                    descriptionText = String.valueOf(descriptionText) + "\n";
                    descriptionText = String.valueOf(descriptionText) + elTexto2;
                }
                ++i;
            }
            if (!locked) break block14;
            this.setNewState(this.getState() | 0x200);
            this.setProperty("locked", true);
            List habitaciones = this.getRoomReferences();
            int i2 = 0;
            while (i2 < habitaciones.size()) {
                Room thisHabitacion = (Room)habitaciones.get(i2);
                thisHabitacion.informAction(this, null, null, "$1 se cierra con llave.\n", "Te cierras con llave.\n", "Cierras con llave.\n", false);
                ++i2;
            }
        }
        return descriptionText;
    }

    public String getBestReferenceName(boolean pluralOrSingular) {
        String theList = pluralOrSingular ? this.respondToPlur : this.respondToSing;
        String tmp = StringMethods.getTok(theList, 1, '$');
        return String.valueOf(Character.toLowerCase(tmp.charAt(0))) + tmp.substring(1);
    }

    public void loadInventoryFromXML(World mundo) throws XMLtoWorldException {
        Element n = mundo.getItemNode(String.valueOf(this.getID()));
        Element e = null;
        try {
            e = n;
        }
        catch (ClassCastException cce) {
            throw new XMLtoWorldException("Item node not Element");
        }
        NodeList inventoryNodes = e.getElementsByTagName("Inventory");
        ArrayList<Node> realInventoryNodes = new ArrayList<Node>();
        ArrayList<Node> partsInventoryNodes = new ArrayList<Node>();
        int i = 0;
        while (i < inventoryNodes.getLength()) {
            if (inventoryNodes.item(i).getParentNode() == e) {
                realInventoryNodes.add(inventoryNodes.item(i));
            } else if (inventoryNodes.item(i).getParentNode() instanceof Element && ((Element)inventoryNodes.item(i).getParentNode()).getTagName().equalsIgnoreCase("parts")) {
                partsInventoryNodes.add(inventoryNodes.item(i));
            }
            ++i;
        }
        this.inventory = realInventoryNodes.size() < 1 ? null : new Inventory(mundo, (Node)realInventoryNodes.get(0));
        this.partsInventory = partsInventoryNodes.size() < 1 ? null : new Inventory(mundo, (Node)partsInventoryNodes.get(0));
    }

    public void loadInventory(World mundo) {
        int maxvol;
        int maxweight;
        if (this.inventoryString == null || this.inventoryString.equals("")) {
            this.inventory = null;
            return;
        }
        int nObjects = StringMethods.numToks(this.inventoryString, '$') - 2;
        try {
            maxweight = Integer.valueOf(StringMethods.getTok(this.inventoryString, 1, '$'));
            maxvol = Integer.valueOf(StringMethods.getTok(this.inventoryString, 2, '$'));
        }
        catch (NumberFormatException nfe) {
            this.inventory = null;
            return;
        }
        this.inventory = new Inventory(maxweight, maxvol, nObjects);
        int i = 0;
        while (i < nObjects) {
            try {
                this.inventory.addItem(mundo.getItem(StringMethods.getTok(this.inventoryString, i + 3, '$')));
            }
            catch (WeightLimitExceededException exc) {
                mundo.escribir("Item too heavy for container, ID " + this.idnumber);
            }
            catch (VolumeLimitExceededException exc2) {
                mundo.escribir("Item too big for container , ID " + this.idnumber);
            }
            ++i;
        }
    }

    public Inventory getContents() {
        return this.inventory;
    }

    public boolean isContainer() {
        return this.inventory != null;
    }

    public Inventory getParts() {
        return this.partsInventory;
    }

    public boolean isComposite() {
        return this.partsInventory != null;
    }

    public Node getXMLRepresentation(Document doc) {
        Text elNombre;
        Element esteNombre;
        String tok;
        StringTokenizer st;
        Description nuestraDescripcion;
        Description nuestraDescripcion2;
        Element listaDesc;
        Element suElemento = doc.createElement("Item");
        suElemento.setAttribute("id", String.valueOf(this.idnumber));
        suElemento.setAttribute("name", String.valueOf(this.title));
        suElemento.setAttribute("extends", String.valueOf(this.inheritsFrom));
        suElemento.setAttribute("clones", String.valueOf(this.isInstanceOf));
        suElemento.setAttribute("type", String.valueOf(this.itemType));
        suElemento.setAttribute("volume", String.valueOf(this.volume));
        suElemento.setAttribute("weight", String.valueOf(this.weight));
        suElemento.setAttribute("enabled", String.valueOf(this.enabled));
        suElemento.setAttribute("isVirtual", String.valueOf(this.isVirtual));
        suElemento.setAttribute("canGet", String.valueOf(this.canGet));
        suElemento.setAttribute("openable", String.valueOf(this.openDescriptionList != null));
        suElemento.setAttribute("closeable", String.valueOf(this.closeDescriptionList != null));
        suElemento.setAttribute("lockable", String.valueOf(this.lockDescriptionList != null));
        suElemento.setAttribute("unlockable", String.valueOf(this.unlockDescriptionList != null));
        suElemento.setAttribute("gender", String.valueOf(this.gender));
        suElemento.appendChild(this.getPropListXMLRepresentation(doc));
        suElemento.appendChild(this.getRelationshipListXMLRepresentation(doc));
        if (this.descriptionList != null) {
            listaDesc = doc.createElement("DescriptionList");
            int i = 0;
            while (i < this.descriptionList.length) {
                nuestraDescripcion2 = this.descriptionList[i];
                listaDesc.appendChild(nuestraDescripcion2.getXMLRepresentation(doc));
                ++i;
            }
            suElemento.appendChild(listaDesc);
        }
        if (this.singNames != null) {
            Element listaSing = doc.createElement("SingularNames");
            int i = 0;
            while (i < this.singNames.length) {
                nuestraDescripcion = this.singNames[i];
                listaSing.appendChild(nuestraDescripcion.getXMLRepresentation(doc));
                ++i;
            }
            suElemento.appendChild(listaSing);
        }
        if (this.plurNames != null) {
            Element listaPlur = doc.createElement("PluralNames");
            int i = 0;
            while (i < this.plurNames.length) {
                nuestraDescripcion = this.plurNames[i];
                listaPlur.appendChild(nuestraDescripcion.getXMLRepresentation(doc));
                ++i;
            }
            suElemento.appendChild(listaPlur);
        }
        if (this.respondToSing != null) {
            Element respTo = doc.createElement("SingularReferenceNames");
            st = new StringTokenizer(this.respondToSing, "$");
            while (st.hasMoreTokens()) {
                tok = st.nextToken();
                esteNombre = doc.createElement("Name");
                elNombre = doc.createTextNode(tok);
                esteNombre.appendChild(elNombre);
                respTo.appendChild(esteNombre);
            }
            suElemento.appendChild(respTo);
        }
        if (this.respondToPlur != null) {
            Element respTo = doc.createElement("PluralReferenceNames");
            st = new StringTokenizer(this.respondToPlur, "$");
            while (st.hasMoreTokens()) {
                tok = st.nextToken();
                esteNombre = doc.createElement("Name");
                elNombre = doc.createTextNode(tok);
                esteNombre.appendChild(elNombre);
                respTo.appendChild(esteNombre);
            }
            suElemento.appendChild(respTo);
        }
        if (this.inventory != null) {
            suElemento.appendChild(this.inventory.getXMLRepresentation(doc));
        }
        if (this.partsInventory != null) {
            Element partsElt = doc.createElement("Parts");
            suElemento.appendChild(partsElt);
            partsElt.appendChild(this.partsInventory.getXMLRepresentation(doc));
        }
        if (this.extraDescriptions != null) {
            Element extraDes = doc.createElement("ExtraDescriptionList");
            StringTokenizer st1 = new StringTokenizer(this.extraDescriptions, "@");
            while (st1.hasMoreTokens()) {
                String desActual = st1.nextToken();
                Element unaDescripcion = doc.createElement("ExtraDescription");
                StringTokenizer st2 = new StringTokenizer(desActual, "$");
                while (st2.hasMoreTokens()) {
                    String wordActual = st2.nextToken();
                    if (st2.hasMoreTokens()) {
                        Element comando = doc.createElement("Name");
                        Text contenido = doc.createTextNode(wordActual);
                        comando.appendChild(contenido);
                        unaDescripcion.appendChild(comando);
                        continue;
                    }
                    Text texto = doc.createTextNode(wordActual);
                    unaDescripcion.appendChild(texto);
                }
                extraDes.appendChild(unaDescripcion);
            }
            suElemento.appendChild(extraDes);
        }
        if (this.keys != null) {
            Element keysel = doc.createElement("KeyList");
            keysel.appendChild(this.keys.getXMLRepresentation(doc));
            suElemento.appendChild(keysel);
        }
        if (this.openDescriptionList != null) {
            listaDesc = doc.createElement("OpenDescriptionList");
            int i = 0;
            while (i < this.openDescriptionList.length) {
                nuestraDescripcion2 = this.openDescriptionList[i];
                listaDesc.appendChild(nuestraDescripcion2.getXMLRepresentation(doc));
                ++i;
            }
            suElemento.appendChild(listaDesc);
        }
        if (this.closeDescriptionList != null) {
            listaDesc = doc.createElement("CloseDescriptionList");
            int i = 0;
            while (i < this.closeDescriptionList.length) {
                nuestraDescripcion2 = this.closeDescriptionList[i];
                listaDesc.appendChild(nuestraDescripcion2.getXMLRepresentation(doc));
                ++i;
            }
            suElemento.appendChild(listaDesc);
        }
        if (this.lockDescriptionList != null) {
            listaDesc = doc.createElement("LockDescriptionList");
            int i = 0;
            while (i < this.lockDescriptionList.length) {
                nuestraDescripcion2 = this.lockDescriptionList[i];
                listaDesc.appendChild(nuestraDescripcion2.getXMLRepresentation(doc));
                ++i;
            }
            suElemento.appendChild(listaDesc);
        }
        if (this.unlockDescriptionList != null) {
            listaDesc = doc.createElement("UnlockDescriptionList");
            int i = 0;
            while (i < this.unlockDescriptionList.length) {
                nuestraDescripcion2 = this.unlockDescriptionList[i];
                listaDesc.appendChild(nuestraDescripcion2.getXMLRepresentation(doc));
                ++i;
            }
            suElemento.appendChild(listaDesc);
        }
        if (this.itsCode != null) {
            suElemento.appendChild(this.itsCode.getXMLRepresentation(doc));
        }
        return suElemento;
    }

    public void loadNumberGenerator(World mundo) {
        this.aleat = mundo.getRandom();
    }

    public Random getRandom() {
        return this.aleat;
    }

    public void setID(int newid) {
        this.idnumber = newid < 30000000 ? newid + 30000000 : newid;
    }

    public static Item initCorpse(Mobile m) {
        Item it = new Item();
        it.itemType = "corpse";
        it.inheritsFrom = 0;
        it.isInstanceOf = 0;
        it.title = "Cad\u00e1ver de " + m.constructName(1);
        it.descriptionList = new Description[1];
        it.descriptionList[0] = new Description("Es un cad\u00e1ver de " + m.constructName2(1) + ", que lleva %INVENTORY.", 0L, 0L);
        it.singNames = new Description[1];
        it.singNames[0] = new Description(it.title, 0L, 0L);
        it.plurNames = new Description[1];
        it.plurNames[0] = new Description("Cad\u00e1veres de " + m.constructName(2), 0L, 0L);
        it.gender = true;
        it.respondToSing = String.valueOf(it.title) + "$Cad\u00e1ver$Cadaver$Cuerpo$Muerto";
        it.respondToPlur = String.valueOf(it.title) + "$Cad\u00e1veres$Cadaveres$Cuerpos$Muertos";
        it.volume = 1000;
        it.weight = 1000;
        it.inventory = m.getInventoryForCorpse();
        if (it.inventory == null) {
            it.inventory = new Inventory(10000, 10000);
        }
        it.mobRefs = null;
        it.extraDescriptions = null;
        it.onlyRestrictions = null;
        it.openDescriptionList = null;
        it.closeDescriptionList = null;
        it.lockDescriptionList = null;
        it.unlockDescriptionList = null;
        it.keys = null;
        it.enabled = true;
        it.isVirtual = false;
        it.canGet = true;
        it.itsCode = null;
        return it;
    }

    public Inventory getFlattenedPartsInventory() {
        if (this.partsInventory == null) {
            return new Inventory(1, 1);
        }
        Inventory result = new Inventory(this.partsInventory.getWeightLimit(), this.partsInventory.getVolumeLimit());
        int i = 0;
        while (i < this.partsInventory.size()) {
            Item thisPart = this.partsInventory.elementAt(i);
            Inventory subInv = thisPart.getFlattenedPartsInventory();
            try {
                result.setVolumeLimit(result.getVolumeLimit() + subInv.getVolumeLimit());
                result.setWeightLimit(result.getWeightLimit() + subInv.getWeightLimit());
            }
            catch (Exception e) {
                System.out.println("Impossible exception thrown: " + e);
                e.printStackTrace();
            }
            int j = 0;
            while (j < subInv.size()) {
                try {
                    result.addItem(subInv.elementAt(j));
                }
                catch (Exception e) {
                    System.out.println("Impossible exception thrown: " + e);
                    e.printStackTrace();
                }
                ++j;
            }
            try {
                result.addItem(thisPart);
            }
            catch (Exception e) {
                System.out.println("Impossible exception thrown: " + e);
                e.printStackTrace();
            }
            ++i;
        }
        return result;
    }

    public void informActionAuto(Entity source, Entity target, Entity[] objects, String thirdPersonDes, boolean self_included) {
        List habitaciones = this.getRoomReferences();
        int i = 0;
        while (i < habitaciones.size()) {
            Room hab = (Room)habitaciones.get(i);
            hab.informActionAuto(source, target, objects, thirdPersonDes, self_included);
            ++i;
        }
    }

    public void informAction(Entity source, Entity target, Entity[] objects, String thirdPersonDes, String sufferDes, String execDes, boolean self_included) {
        List habitaciones = this.getRoomReferences();
        int i = 0;
        while (i < habitaciones.size()) {
            Room hab = (Room)habitaciones.get(i);
            hab.informAction(source, target, objects, thirdPersonDes, sufferDes, execDes, self_included);
            ++i;
        }
    }

    public Inventory getFlattenedInventory() {
        if (this.inventory == null) {
            return new Inventory(1, 1);
        }
        Inventory result = new Inventory(this.inventory.getWeightLimit(), this.inventory.getVolumeLimit());
        int i = 0;
        while (i < this.inventory.size()) {
            Item thisPart = this.inventory.elementAt(i);
            Inventory subInv = thisPart.getFlattenedInventory();
            try {
                result.setVolumeLimit(result.getVolumeLimit() + subInv.getVolumeLimit());
                result.setWeightLimit(result.getWeightLimit() + subInv.getWeightLimit());
            }
            catch (Exception e) {
                System.out.println("Impossible exception thrown: " + e);
                e.printStackTrace();
            }
            int j = 0;
            while (j < subInv.size()) {
                try {
                    result.addItem(subInv.elementAt(j));
                }
                catch (Exception e) {
                    System.out.println("Impossible exception thrown: " + e);
                    e.printStackTrace();
                }
                ++j;
            }
            try {
                result.addItem(thisPart);
            }
            catch (Exception e) {
                System.out.println("Impossible exception thrown: " + e);
                e.printStackTrace();
            }
            ++i;
        }
        return result;
    }
}

