;
; ===================
;  VAMPIRO (imp/esp)
; ===================
;
; misma aventura que en vampiroe.lsp, pero con mensajes (orientado a jugador)
;
; Lumpi, 2004
; para el proyecto VAMPIRO (Jaume Alcazo)
; versin para eac (LISP)
;

; mapa:
;
;     arriba: 9 10
;     abajo: 8
;     ^
;   6 5 7
;   3 2 4
;     1

; cargamos los archivos necesarios

(load "eac.fas")  ;EAC
(load "algamp.fas")  ;AMPLITUD

; estados iniciales y finales 
; ---------------------------

; 0=inventario
; A=recipiente fregadero (11)
; B=recipiente armario de la cocina (12)
; C=recipiente barril (13) -no implementado-
; D,E = estados auxiliares (14,15)
; F = fin

;                  0     1   2       3                          4              
(setq inicial '((traje) (j) nil (armario cuchillo) (crucifijo palanca)
;                5   6   7   8        9     10    A   B   C               D                         E   F
		nil nil nil (barril) nil (ataud) nil nil nil (ajos martillo llave trozo armarioab) nil nil))

;             0 1 2 3 4 5 6 7 8 9         10         A B C D E F 
(setq final '(* * * * * * * * * * (ataud j vampirom) * * * * * *))
(setq final2 '(* * * * * * * * * * * * * * * * (fin)))

; definicin de las transiciones de la aventura
; ---------------------------------------------

(setq a '(

	  ; mapeado

	  ((j 1) "n" (j 2 ("Vas al norte.")))
	  ((j 2) "n" (j 5 ("Vas al norte.")))
	  ((j 2) "s" (j 1 ("Vas al sur.")))			
	  ((j 2) "e" (j 4 ("Vas al este.")))
	  ((j 2) "o" (j 3 ("Vas al oeste.")))
	  ((j 3) "e" (j 2 ("Vas al este.")))
	  ((j 4) "o" (j 2 ("Vas al oeste.")))
	  ((j 5) "s" (j 2 ("Vas al sur.")))
	  ((j 5) "e" (j 7 ("Vas al este.")))
	  ((j 5) "o" (j 6 ("Vas al oeste.")))
	  ((j 5) "subir" (j 9 ("Subes las escaleras.")))
	  ((j 5) "bajar" (j 8 ("Bajas las escaleras.")))
	  ((j 6) "e" (j 5 ("Vas al este.")))
	  ((j 7) "o" (j 5 ("Vas al oeste.")))
	  ((j 8) "subir" (j 5 ("Subes de nuevo al pasillo.")))
	  ((j 9) "bajar" (j 5 ("Bajas de nuevo al pasillo.")))
	  ((j 9) "o" (j 10 ("Vas al oeste.")))
	  ((j 10) "e" (j 9 ("Vas al este.")))
	  
	  ; salidas incorrectas
	  
	  (() "n" (("No puedes ir por ah.")))
	  (() "s" (("No puedes ir por ah.")))
	  (() "e" (("No puedes ir por ah.")))
	  (() "o" (("No puedes ir por ah.")))
	  (() "subir" (("No puedes ir por ah.")))
	  (() "bajar" (("No puedes ir por ah.")))

	  ; xte (examnate)
	  
	  (() "xte" (("Tan buen aspecto como siempre.")))

	  ; xyzzy

	  (() "xyzzy" (("Viejos recuerdos acuden a tu mente...")))

	  ; i = inventario
	  (() "i" (("Tienes: " 0)))
 
	  ; acciones (slo da mensajes)
          ; ---------------------------

	  ; objetos "cogibles" (hay que repetir)
	  ((j cuchillo) "ex cuchillo" (("Un simple cuchillo de cocina. Pincha.")))
	  ((j crucifijo) "ex crucifijo" (("Es un pequeo crucifijo plateado. Es uno de los cuatro elementos que nos"
					  "servirn para derrotar al vampiro.")))
	  ((j palanca) "ex palanca" (("Es una palanca de acero toledano. Sirve para forzar cosas.")))
	  ((j trozo) "ex trozo" (("Un trozo de madera, rectangular y alargado.")))
	  ((j llave) "ex llave" (("Esta pequea llavecita tiene la pinta de abrir un armario o algo as.")))
	  ((j ajos) "ex ajos" (("Es una ristra entera de ajos que expelen un olor un tanto asqueroso. Es uno de"
				"los cuatro elementos que me servirn para derrotar al vampiro.")))
	  ((j martillo) "ex martillo" (("Un martillo grande. Es uno de los elementos que me permitirn acabar con el"
					"vampiro.")))
	  ((j estaca) "ex estaca" (("Un cacho de madera rectangular y alargado, uno de sus extremos est afilado"
				    "cuidadosamente.")))
	  ((j traje) "ex traje" (("Es un traje barato comprado en las rebajas.")))
	  ((cuchillo 0) "ex cuchillo" (("Un simple cuchillo de cocina. Pincha.")))
	  ((crucifijo 0) "ex crucifijo" (("Es un pequeo crucifijo plateado. Es uno de los cuatro elementos que nos"
					  "servirn para derrotar al vampiro.")))
	  ((palanca 0) "ex palanca" (("Es una palanca de acero toledano. Sirve para forzar cosas.")))
	  ((trozo 0) "ex trozo" (("Un trozo de madera, rectangular y alargado.")))
	  ((llave 0) "ex llave" (("Esta pequea llavecita tiene la pinta de abrir un armario o algo as.")))
	  ((ajos 0) "ex ajos" (("Es una ristra entera de ajos que expelen un olor un tanto asqueroso. Es uno de"
				"los cuatro elementos que me servirn para derrotar al vampiro.")))
	  ((martillo 0) "ex martillo" (("Un martillo grande. Es uno de los elementos que me permitirn acabar con el"
					"vampiro.")))
	  ((estaca 0) "ex estaca" (("Un cacho de madera rectangular y alargado, uno de sus extremos est afilado"
				    "cuidadosamente.")))
	  ((traje 0) "ex traje" (("Es un traje barato comprado en las rebajas.")))
	  
	  ; todas las localidades
	  (() "ex suelo" (("El suelo es de piedras y est muy fro.")))
	  (() "ex techo" (("El techo es muy alto y es de piedras.")))

	  ; localidad 1	
	  ((j 1) "m" (("Ests en el vestbulo del castillo. El ambiente es muy hmedo y fro. Ests en"
		       "un pasillo que se extiende hacia el norte. Al sur queda la puerta de entrada al"
		       "castillo." 1)))
	  (() "ex suelo" (("El suelo es de piedras y est muy fro.")))
	  ((j 1) "ex pasillo" (("Es el pasillo principal, se extiende hacia el norte.")))
	  ((j 1) "ex puerta" (("Es muy grande y est cerrada. No la vas a poder abrir.")))
          ((j 1) "abrir puerta" (("Te he dicho que no la puedes abrir, Meln!")))
	  ; localidad 2
	  ((j 2) "m" (("Te encuentras en medio del pasillo principal de este piso. Al oeste est la"
		       "cocina y al este la biblioteca. El pasillo sigue hacia el norte." 2)))
	  ; localidad 3
	  ((j 3) "m" (("Ests en la cocina del castillo. Esto est lleno de cacerolas y de cacharros"
		       "para cocinar. Hay un horno, un fregadero y un armario pequeo." 3)))
	  ((j 3) "ex cacerola" (("Simples cacerolaqs y cacharros de cocina.")))
	  ((j 3) "ex horno" (("Un simple horno, no tiene ninguna importancia.")))
	  ((j 3) "ex fregadero" (("Es un fregadero de piedra." "Tiene: " 11)))
	  ((j 3 armario 3 armarioab 14) "ex armario" (("Est cerrado con llave.")))
	  ((j 3 armarioab 15) "abrir armario" (armarioab 3 armario 15 ("Abres el armario.")))
	  ((j 3 armarioab 3) "cerrar armario" (armarioab 15 armario 3 ("Cierras el armario.")))
	  ((j 3 armario 3) "abrir armario" (("Est cerrado con llave.")))
	  ; localidad 4
	  ((j 4) "m" (("Te hallas en la biblioteca del castillo. Obviamente est llena de libros"
		       "pero desgraciadamente no tienes tiempo para leerlos." 4)))
	  ((j 4) "ex libros" (("Montones de libros, pero no tengo tiempo para leer ahora.")))
	  ((j 4) "coger libros" (("No quiero cargar con los libros, no hay tiempo para leerlos.")))
	  ; localidad 5
	  ((j 5) "m" (("Te hallas en el final del pasillo. Delante de t ves unas escaleras que suben"
		       "y otras que bajan. Al oeste est el dormitorio y al este la sala de estar." 5)))
	  ((j 5) "ex escaleras" (("Unas polvorientas escaleras. Unas suben y otras bajan.")))
	  ; localidad 6
	  ((j 6) "m" (("Ests en un dormitorio no muy grande ni tampoco muy pequeo. Es bastanate"
		       "austero. Slo hay una cama y un armario." 6)))
	  ((j 6) "ex cama" (("Est cubierta de sbanas.")))
	  ((j 6) "abrir armario" (("Est cerrado con llave.")))
	  ((j 6) "abrir armario con llave" (("No encaja.")))
	  ((j 6) "ex armario" (("Tiene unas letras marcadas con un cuchillo.")))
	  ((j 6) "ex letras" (("XYZZY")))
	  ; localidad 7
	  ((j 7) "m" (("Es la sala ms acogedora de todo el castillo. En la chimenea los ltimos"
		       "restos de algn fuego chisporrotean alegremente. Hay una mesa grande con"
		       "una silla al lado. De la pared cuelgan bastantes trofeos de caza y"
		       "adornos varios" 7)))
	  ((j 7) "ex chimenea" (("Es una chimena hecha de ladrillos y muy elegante.")))
	  ((j 7) "ex trofeos" (("Insignificantes trofeos.")))
	  ((j 7) "ex adornos" (("Adornan.")))
	  ((j 7) "ex silla" (("Una cmoda silla.")))
	  ((j 7) "ex mesa" (("Una mesa de caoba, bastante grande.")))
	  ; localidad 8
	  ((j 8) "m" (("En este pequeo stano hace mucho calor, sientes una sensacin de"
		       "recogimiento. Est todo muy sucio. Hay un barril aqu, tambin hay unas"
		       "escaleras que suben." 8)))
	  ((j barril) "ex barril" (("Est cerrado.")))
	  ((j barril) "abrir barril" (("Necesitas algo para abrirlo.")))
	  ((j barrilab) "cerrar barril" (("No quieres.")))
	  ((j 8) "ex letras" (("Pone: ^No tengo ganas de implementar este recipiente!^")))
	  ; localidad 9
	  ((j 9) "m" (("Ests en el piso superior del castillo. Aqu hace an ms fro que abajo."
		       "Detrs de t estn las escaleras que bajan y hacia el oeste est la"
		       "habitacin del vampiro." 9)))
	  ((j 9) "ex escaleras" (("Conducen al piso inferior.")))
	  ; localidad 10
	  ((j 10) "m" (("Ests en una habitacin desnuda. nicamente hay un altar en el centro. Encima"
			"del altar puedes ver un atad." 10)))
	  ((j 10) "ex altar" (("Es un altar de dura piedra. Encima de ste est el atad.")))
	  ((j 10) "ex atad" (("Una sencilla caja de pino.")))
	   
	  
	  ; coger y dejar

	  ((j cuchillo) "coger cuchillo" (cuchillo 0 ("Coges el cuchillo.")))
	  ((j crucifijo) "coger crucifijo" (crucifijo 0 ("Coges el crucifijo.")))	 
	  ((j palanca) "coger palanca" (palanca 0 ("Coges la palanca.")))
	  ((j traje) "coger traje" (traje 0 ("Coges el traje.")))
	  ((j trozo) "coger trozo" (trozo 0 ("Coges el trozo de madera.")))
	  ((j llave) "coger llave" (llave 0 ("Coges la llave.")))
          ((j ajos) "coger ajos" (ajos 0 ("Coges la ristra de ajos.")))
	  ((j martillo) "coger martillo" (martillo 0 ("Coges el martillo.")))
	  ((j estaca) "coger estaca" (ajos 0 ("Coges la estaca.")))
	  ((cuchillo 0) "dejar cuchillo" (cuchillo j ("Dejas el cuchillo.")))
	  ((crucifijo 0) "dejar crucifijo" (crucifijo j ("Dejas el crucifijo.")))
	  ((palanca 0) "dejar palanca" (palanca j ("Dejas la palanca.")))
	  ((traje 0) "dejar traje" (traje j ("Dejas el traje.")))
	  ((j trozo) "dejar trozo" (trozo j ("Dejas el trozo de madera.")))
	  ((j llave) "dejar llave" (llave j ("Dejas la llave.")))
          ((j ajos) "dejar ajos" (ajos j ("Dejas la ristra de ajos.")))
	  ((j martillo) "dejar martillo" (martillo j ("Dejas el martillo.")))
	  ((j estaca) "dejar estaca" (martillo j ("Dejas la estaca.")))

	  ; recipiente fregadero (red-herring)

	  ((j 3 cuchillo 0) "meter cuchillo en fregadero" (cuchillo 11
								    ("Metes el cuchillo dentro del fregadero.")))
	  ((j 3 crucifijo 0) "meter crucifijo en fregadero" (crucifijo 11
								       ("Metes el crucifijo dentro del fregadero.")))
	  ((j 3 palanca 0) "meter palanca en fregadero" (palanca 11
								 ("Metes la palanca dentro del fregadero.")))
	  ((j 3 trozo 0) "meter trozo en fregadero" (trozo 11
							   ("Metes el trozo de madera dentro del fregadero.")))
          ((j 3 llave 0) "meter llave en fregadero" (llave 11
							   ("Metes la llave dentro del fregadero.")))
	  ((j 3 ajos 0) "meter ajos en fregadero" (ajos 11
							("Metes la ristra de ajos dentro del fregadero.")))
	  ((j 3 martillo 0) "meter martillo en fregadero" (martillo 11
								    ("Metes la ristra de ajos dentro del fregadero.")))
	  ((j 3 estaca 0) "meter estaca en fregadero" (estaca 11
							      ("Metes la estaca dentro del fregadero.")))
	  ((j 3 cuchillo 11) "sacar cuchillo de fregadero" (cuchillo 0
								     ("Coges el cuchillo.")))
	  ((j 3 crucifijo 11) "sacar crucifijo de fregadero" (crucifijo 0
									("Coges el crucifijo plateado.")))
	  ((j 3 palanca 11) "sacar palanca de fregadero" (palanca 0
								  ("Coges la palanca.")))
	  ((j 3 trozo 11) "sacar trozo de fregadero" (trozo 0
							    ("Coges el trozo de madera.")))
	  ((j 3 llave 11) "sacar llave de fregadero" (llave 0
							    ("Coges la llave.")))
	  ((j 3 ajos 11) "sacar ajos de fregadero" (ajos 0
							 ("Coges la ristra de ajos.")))
	  ((j 3 martillo 11) "sacar ajos de fregadero" (martillo 0
								 ("Coges la ristra de ajos.")))
	  ((j 3 estaca 11) "sacar estaca de fregadero" (estaca 0
							     ("Coges la estaca.")))

	  ; recipiente armario de cocina			       

	  ((j 3 armarioab 3 cuchillo 0) "meter cuchillo en armario" (cuchillo 12
								    ("Metes el cuchillo dentro del armario.")))
	  ((j 3 armarioab 3 crucifijo 0) "meter crucifijo en armario" (crucifijo 12
								       ("Metes el crucifijo dentro del armario.")))
	  ((j 3 armarioab 3 palanca 0) "meter palanca en armario" (palanca 12
								 ("Metes la palanca dentro del armario.")))
	  ((j 3 armarioab 3 trozo 0) "meter trozo en armario" (trozo 12
							   ("Metes el trozo de madera dentro del armario.")))
          ((j 3 armarioab 3 llave 0) "meter llave en armario" (llave 12
							   ("Metes la llave dentro del armario.")))
	  ((j 3 armarioab 3 ajos 0) "meter ajos en armario" (ajos 12
							("Metes la ristra de ajos dentro del armario.")))
	  ((j 3 armarioab 3 martillo 0) "meter martillo en armario" (martillo 12
								      ("Metes la ristra de ajos dentro del armario.")))
	  ((j 3 armarioab 3 estaca 0) "meter estaca en armario" (estaca 12
									("Metes la estaca dentro del armario.")))
	  ((j 3 armarioab 3 cuchillo 12) "sacar cuchillo de armario" (cuchillo 0
									       ("Coges el cuchillo.")))
	  ((j 3 armarioab 3 crucifijo 12) "sacar crucifijo de armario" (crucifijo 0
										  ("Coges el crucifijo plateado.")))
	  ((j 3 armarioab 3 palanca 12) "sacar palanca de armario" (palanca 0
									    ("Coges la palanca.")))
	  ((j 3 armarioab 3 trozo 12) "sacar trozo de armario" (trozo 0
								      ("Coges el trozo de madera.")))
	  ((j 3 armarioab 3 llave 12) "sacar llave de armario" (llave 0
								      ("Coges la llave.")))
	  ((j 3 armarioab 3 ajos 12) "sacar ajos de armario" (ajos 0
								   ("Coges la ristra de ajos.")))
	  ((j 3 armarioab 3 martillo 12) "sacar ajos de armario" (martillo 0
									   ("Coges la ristra de ajos.")))
	  ((j 3 armarioab 3 estaca 12) "sacar estaca de armario" (estaca 0
									 ("Coges la estaca.")))

	  ; objetos invisibles

	  ((j 3 armarioab 3 ajos 14) "ex armario" (ajos 3
	    	("Al examinarlo se te cae al suelo una ristra de ajos que estaba en su interior.")))
	  ((j 3 armarioab 3) "ex armario" (("Tiene:" 12)))
	  ((j 6 llave 14) "ex sabanas" (llave 6 ("Entre ellas encuentras una pequea llavecita.")))
	  ((j 6) "ex sabanas" (("Sbanas corrientes y molientes."))) ; accin-texto
	  ((j 7 trozo 14) "ex fuego" (trozo 7 ("Entre los restos del fuego encuentras un trozo de madera.")))
	  ((j 7) "ex fuego" (("Son los restos de algn fuego reciente.")))
	  ((j 8 barrilab 8 martillo 14) "ex barril" (martillo 8 ("En el barril ves un martillo.")))
	  ((j 8 barrilab 8) "ex barril" (("Ves unas letras escritas con pintura roja sobre el barril.")))
	  
	  ; objetos con metamorfosis

	  ((cuchillo 0 trozo 0) "afilar trozo con cuchillo" (estaca 0 trozo 15
		 ("Afilas la madera con el cuchillo y obtienes una estaca!")))
	  ((j 8 barril 8 palanca 0) "abrir barril con palanca" (barril 14 barrilab 8
                 ("-Clack!- Haciendo palanca logras abrir el barril.")))
	  ((j 3 armario 3 llave 0) "abrir armario con llave" (armarioab 3 armario 14 ("Abres el armario.")))	  
	  
	  ; el final

	  ((j 10 estaca 0 martillo 0 crucifijo 0 ajos 0) "abrir ataud" (vampirom 10
		 ("Abres el ataud. Dentro contemplas la horrible cara del vampiro. Protegido por"
		  "los ajos y el crucifijo empiezas tu horrible tarea. Le clavas la estaca en el"
		  "pecho y de un terrible golpe de martillo la hundes en lo ms profundo de su ser."
		  "Con un grito de agona se deshace en polvo y t acabas tu misin aqu."
		  ""
		  "Por ahora..."
		  ""
		  "          Finis.")))
	  ((j 10) "abrir ataud" (("Necesito cuatro cosas antes de poner fin a la vida del vampiro. A saber: un"
				  "un crucifijo, una ristra de ajos, una estaca afilada y un martillo.")))
	  (() "fin" (fin 16))))

; si queremos jugar, (jugar #'humano) o (jugar #'read)

(defun jugar (j1 &optional (lc a) (l inicial) &key (ef (list final final2)))
; (verestado l)
  (cond ((final? ef l) (values))
	(t (jugar j1 lc (transitar (funcall j1) lc l)))))

; entorno del jugador

(defun humano ()
  (format t "~%> ")
  (read-line))

; entorno del jugador (un poco ms trabajado que el anterior)

(defun humano2 (&optional (lc a))
  (let ((ord (block a (format t "~%> ") (read-line))))
    (cond ((member ord (acciones lc) :test #'equalp) ord)
	  (t (block b (princ "No entiendo eso.") (humano2))))))

; funcin vampiro
; ejemplo:
;   (vampiro) => listo para jugar!

(defun vampiro (&optional (lc a) (l inicial))
  (terpri)
  (princ "-Memorias de reXXe-") (terpri)
  (princ "Versin en eac (LISP) del juego VAMPIRO (original de Aventuras ALCAZO),") (terpri)
  (princ "implementada por Lumpi (2004).") (terpri)
  (terpri)
  (princ "Muchas gracias por jugar.") (terpri)
  (terpri)
  (terpri)
  (terpri)
  (princ "Despiertas aturdido. Despus de unos segundos te incorporas en el fro suelo de") (terpri)
  (princ "piedra y ves que ests en un castillo. Ahora recuerdas! Eres reXXe y tu misin") (terpri)
  (princ "es la de matar al vampiro. TIENES que matar al vampiro que vive en la parte") (terpri)
  (princ "superior del castillo...") (terpri)
  (terpri)
  (terpri)
  (transitar "m" lc l 0 t)
  (jugar #'humano2))

;
; IA
; --

; (load "algamp.lsp")

; a = cjto. de acciones definidas
; juego = estado inicial
; final = estado final

; funcin acciones
; devuelve las acciones que la mquina puede utilizar ("n", "s", etc.)

(defun acciones (lc &optional (l nil))
  (cond ((null lc) l)
	(t (if (member (orden (car lc)) l :test #'equal) (acciones (cdr lc) l)
	     (acciones (cdr lc) (cons (orden (car lc)) l))))))

; funcin posibles
; posibles acciones que puede llevar a cabo (devuelve estado)

(defun posibles (acciones lc l)
  (cond ((null acciones) nil)
	(t (if (equal l (transitar (car acciones) lc l 0 nil)) (posibles (cdr acciones) lc l)
	     (cons (transitar (car acciones) lc l 0 nil) (posibles (cdr acciones) lc l))))))

; funcin posibles2
; posibles acciones que puede llevar a cabo (devuelve accin)

(defun posibles2 (acciones lc l)
  (cond ((null acciones) nil)
	(t (if (equal l (transitar (car acciones) lc l 0 nil)) (posibles2 (cdr acciones) lc l)
	     (cons (car acciones) (posibles2 (cdr acciones) lc l))))))

; funcin cumplef
; ejemplo:
;   (cumplef '(* (0 1)) '((5 6) (0 1))) => T

(defun cumplef (l l2)
  (cond ((null l) t)
	((equal '* (car l)) (cumplef (cdr l) (cdr l2)))
	((equal (car l) (car l2)) (cumplef (cdr l) (cdr l2)))
	(t nil)))

; funcion final?
; mira si algunos de los estados de lef se cumple

(defun final? (lef l2)
  (cond ((null lef) nil)
	(t (or (cumplef (car lef) l2) (final? (cdr lef) l2)))))

(defun hacer (&key (ini inicial) (fin (list final)) (acc (acciones a)) (traza nil))
  (amplitud ini :finalp #'(lambda (l) (final? fin l))
	    :hijos #'(lambda (l) (values (posibles acc a l) (posibles2 acc a l))) :eqestado #'equalp
	    :traza traza))

; lo resolver?
; --------------

; funciones orientadas a facilitar las cosas al usuario (y a m)

(defun leerlista (cadena e)
  (let ((l nil)
	(c nil))
    (princ cadena)
    (loop (setq c (string (read)))
	  (cond ((equal c "!") (return l))
		((equal c "-") (return e))
		(t (setq l (insord (intern c) l)))))))

(defun situar (e n l)
  (cond ((= n 0) (cons e l))
	(t (cons (car l) (situar e (1- n) (cdr l))))))

(defun fabestado (ll lp)
  (let ((a 0)
	(l ll))
    (dolist (e lp)
      (setq l (situar (leerlista e (elemento ll a)) a l))
      (setq a (1+ a)))
    l))

(defun tini ()
  (terpri)
  (fabestado inicial
		   '("i: " "loc.1: " "loc.2: " "loc.3: " "loc.4: " "loc.5: "
		     "loc.6: " "loc.7: " "loc.8: " "loc.9: " "loc.10: "
		     "rec.fregadero: " "rec.armario: ")))

(defun tfinal ()
  (terpri)
  (princ "Escriba ! para terminar, y - para ignorar.") (terpri)
  (terpri)
  (list (fabestado '(* * * * * * * * * * * * * *)
		   '("inventario: " "loc.1: " "loc.2: " "loc.3: " "loc.4: " "loc.5: "
		     "loc.6: " "loc.7: " "loc.8: " "loc.9: " "loc.10: "
		     "rec.fregadero: " "rec.armario: "))))

(defun incluir (&optional (l nil))
  (if (null l) (block a (terpri) (princ "Escriba ! para terminar") (terpri)))
  (let ((c (read-line)))
    (cond ((equal c "!") l)
	  (t (incluir (cons c l))))))

; ================
;  MEN PRINCIPAL
; ================

(defun menu (&optional (ini inicial) (fin (list final)) (acc (acciones a)))
  (let ((c nil))
    (terpri)
    (princ "1. Jugar") (terpri)
    (princ "2. Buscar solucin de manera automtica") (terpri)
    (princ "3. Salir") (terpri)
    (terpri)
    (setq c (read))
    (cond ((eql c 1) (vampiro) (menu))
	  ((eql c 2) (ia) (menu))
	  ((eql c 3) (terpri) (terpri) (values))
	  (t (ia ini fin)))))

; funcin ia
; te preguntan los estados (inicial y final), y el ordenador tratar de resolver la aventura

(defun ia (&optional (ini inicial) (fin (list final)) (acc (acciones a)))
  (let ((c nil))
    (terpri)
    (princ "1. Especificar estado inicial") (terpri)
    (princ "2. Especificar estado final") (terpri)
    (princ "3. Especificar conjunto de acciones") (terpri)
    (princ "4. Buscar solucin a partir del estado inicial") (terpri)
    (princ "5. Volver") (terpri)
    (terpri)
    (setq c (read))
    (cond ((eql c 1) (ia (tini) fin acc))
	  ((eql c 2) (ia ini (tfinal) acc))
	  ((eql c 3) (ia ini fin (macc)))
	  ((eql c 4) (time (block a (terpri) (prin1 (hacer :ini ini :fin fin :acc acc)) (terpri))) (terpri)
	                            (ia ini fin acc))
	  ((eql c 5) (values))
	  (t (ia ini fin)))))

(defun macc ()
  (let ((c nil))
    (terpri)
    (princ "1. Incluir todas las acciones") (terpri)
    (princ "2. Escribir manualmente el conjunto de acciones") (terpri)
    (terpri)
    (setq c (read))
    (cond ((eql c 1) (acciones a))
	  ((eql c 2) (incluir)))))

(menu)