/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.swingui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.zmpp.media.InformMetadata;
import org.zmpp.media.Resources;
import org.zmpp.media.StoryMetadata;
import org.zmpp.swingui.PictureLabel;

public class GameInfoDialog
extends JDialog {
    private static final int STD_WIDTH = 400;
    private static final long serialVersionUID = 1L;

    public GameInfoDialog(JFrame jFrame, Resources resources) {
        super((Frame)jFrame, "About " + resources.getMetadata().getStoryInfo().getTitle());
        this.getContentPane().add(this.createInfoPanel(resources));
        this.getContentPane().add((Component)this.createButtonPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    private JPanel createPicturePanel(Resources resources, int n) {
        JPanel jPanel = new JPanel();
        if (n > 0) {
            BufferedImage bufferedImage = resources.getImages().getResource(n);
            PictureLabel pictureLabel = new PictureLabel(bufferedImage);
            pictureLabel.setPreferredSize(new Dimension(400, 400));
            jPanel.add(pictureLabel);
        }
        return jPanel;
    }

    private JComponent createInfoPanel(Resources resources) {
        Serializable serializable;
        Serializable serializable2;
        StoryMetadata storyMetadata = resources.getMetadata().getStoryInfo();
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        Box box2 = box;
        int n = this.getCoverartNum(resources);
        if (n > 0 && resources.getImages().getNumResources() > 0) {
            serializable2 = Box.createHorizontalBox();
            ((Container)serializable2).add(this.createPicturePanel(resources, n));
            ((Container)serializable2).add(box);
            box2 = serializable2;
        }
        box.setAlignmentX(0.0f);
        box.setPreferredSize(new Dimension(400, 400));
        serializable2 = new ArrayList();
        serializable2.add(new JLabel(storyMetadata.getTitle()));
        if (storyMetadata.getHeadline() != null) {
            serializable2.add(new JLabel(storyMetadata.getHeadline()));
        }
        serializable2.add(new JLabel(storyMetadata.getAuthor() + " (" + storyMetadata.getYear() + ")"));
        Object object = serializable2.iterator();
        while (object.hasNext()) {
            serializable = (JLabel)object.next();
            box.add((Component)serializable);
            serializable.setAlignmentX(0.0f);
            serializable.setFont(serializable.getFont().deriveFont(1));
        }
        box.add(Box.createVerticalStrut(6));
        object = new JTextArea(storyMetadata.getDescription());
        ((JTextArea)object).setLineWrap(true);
        ((JTextArea)object).setWrapStyleWord(true);
        ((JTextComponent)object).setEditable(false);
        serializable = new Insets(3, 3, 3, 3);
        ((JTextComponent)object).setMargin((Insets)serializable);
        ((JTextArea)object).setFont(((JLabel)serializable2.get(0)).getFont().deriveFont(0));
        JScrollPane jScrollPane = new JScrollPane((Component)object);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setPreferredSize(new Dimension(400, 200));
        jScrollPane.setAlignmentX(0.0f);
        box.add(jScrollPane);
        return box2;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton("Ok");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameInfoDialog.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(jButton);
        jPanel.add(jButton);
        return jPanel;
    }

    private int getCoverartNum(Resources resources) {
        int n = resources.getCoverArtNum();
        InformMetadata informMetadata = resources.getMetadata();
        if (n <= 0) {
            n = informMetadata.getStoryInfo().getCoverPicture();
        }
        return n;
    }
}

