﻿# The script of the game goes in this file.

# CONTINUE - where I was when I finished working on this visual novel last time.

# VARIABLES - where (potentially) a group of variables would work, some of which may not exist yet.

# FINDOUT - things I need to find out/learn to finish this section.

# LEARNED - things I found out/learned and implemented.

# LEARN how to define trace_expressions

# Declare characters used by this game. The color argument colorizes the
# name of the character.

# Female characters

define a = Character("Alianora:")
define alia = Character("Alianora:", kind=nvl)
define cr = Character("Air Crew Naomi:")
define e = Character("Eileen:")
define hd = Character("Help Desk Analyst:")
define hr = Character("Hotel Receptionist:")
define ls = Character("Lounge Supervisor:")
define s = Character("Szilvia:")
define sa = Character("Sandra:")
define szil = Character("Szilvia:", kind=nvl)

# Male characters


define be = Character("Ben:")
define cb = Character("Club Bouncer:")
define cr2 = Character("Air Crew:")
define d = Character("Dad:")
define dad = Character("Dad of Alianora:", kind=nvl)
define ff = Character("Fast Food Cashier:")
define gc = Character("Grilled Cheese Seller:")
define o = Character("Security Officer:")
define p1 = Character("Passenger:")
define pi = Character("Pilot:")
define va = Character("Visa Agent:")

# Computers With Speaking Roles

define tm = Character("Tannoy Message:")

# Declare attributes used by this game.

# Attributes to implement: money, spoons, specific items, events (specific and categories of experience).

# Attributes to NOT implement here but track: macrogame features - specifically, opening of deeper storytelling layers and achievements, as well as settings.

# Settings so far: Money, Spoons, Home, Friend, Time information, Simulation Progress

# Money (note: this is in Hungarian Forints, which work out as 250 HUF per 1 GBP).

default money = 75000
default change = 0

# Spoons (maximum spoons are 20, problems if it hits or drops below 0)

default spoon = 20

# Contact level with Alianora's parents

default home = 0

# Contact level with friends

default szilvi = 0
default sabe = 0
default journalist = 0
default meditator = 0

# Simulation Progress

default simulation = 1950
default bankrupt = False

# Knowledge

default raceknow = 0
default runknow = 0
default programming = 0

# Perks

default hoteldiscount = False

# Items

default esleeperticket = False
default metroticket = False
default turkeyvisa = False
default chocolate = False
default sleeperticket = False
default noseplug = False
default boots = True
default mobilephone = True
default rucksack = True
default turkishcd = False

# Possessions Usable

default musicplayer = True
define emaillock = False

# Possessions In Use

default defender = False

# Time Information

define day = 1
define hour = 10
default planehalf = False
default email = True

# Location Access

default prahafast = True

# Events (Specific, Transport)

default car1 = False
default train1 = False
default airporta = False
default aircrew = False
default airbus19 = False
default airbus20 = False
default a319cockpit = False
define a319delay = False
default secondaryinf = False
default upsetpass = False
default testrepeat = False
default planedelay = False
default reportcrime = False

# Events (Specific, Crime)

default reporttheft = False
default pursethefte = False
default pursetheftm = False

# Events (Specific, Languages)

default hungarian = False
default kerem = False
default turkish = False
default spanish = False
default czech = False

# Events (Specific, Expectations)

default xpszilmeet = False

# Events (Categories)

# Books

default magazine = False

# Persistent elements (e.g. macrogame) should be implemented here using persistent.[flag]

# Endings - please see "Persistent Variables" section of options.rpy

# Endings so far typed out: toomuchsmell (Birmingham duty-free), leavestation (Spring Thing/demo "good ending") with strands for train and plane.

# Installed Elements

# This section is for anything that needs installing into Python before starting - which so far is nothing.

# The game starts here.

label start:

    # This is the first scene in the game. Here is where the player is
    # introduced to Alianora, the objective is explained, and the player
    # helps Alianora to pack. We are in Alianora's room.

    scene boaliahome

    # This shows a character sprite. A placeholder is used, but you can
    # replace it by adding a file named "eileen happy.png" to the images
    # directory.

    # show amonoblank

    # These display lines of dialogue.

    play music "audio/HolstDargason.mp3"
    queue music "audio/ElgarOp552MAllegro.mp3"
    queue music "audio/ElgarOp553MAndante.mp3"

    menu:

        "Please choose an option by Pressing it, using the Arrow keys, Space, Enter or the Left mouse button. These also move you through text screens.":

            pass

        "First time in Budacanta. Please can you help? (Tutorial)":

            jump firsttime

        "What's the story, please?":

            jump whatstory

        "Thank you. Please get me to the action!":

            jump packing

    a "I'm Alianora La Canta, an ambitious, autistic, adventurous motorsport fan from Derbyshire."

    a "Today I will go to Budapest, on a solo adventure to meet a friend and watch a motor race. Welcome to the Decision-Making Committee!"

    menu:

        "Please remind me of the controls. (Tutorial)":

            jump controls

        "More details, please.":

            jump whatstory

        "'Solo' adventure?":

            jump soloadventure

    label firsttime:

    a "There's a first time for everyone. You'll know what I'm doing through the Decision-Making Committee Interface."

    a "We'll call the Decision-Making Committee Interface 'the interface' from now on."

    a "Anything I say, or anyone else says, will be recorded in this box. The Committee Chair will narrate extra information."

    a "Above the box is an approximation of what I am experiencing visually."

    menu:

        "Let's test that feature.":

            jump testfeature

        "Please explain the other controls.":

            jump controls

        "That's enough tutorial, thanks. Have you finished packing?":

            jump packing

    label testfeature:

    scene gsaliahome

    a "I'm still in the process of waking up. My ability to process things improves as I get more alert. I pick up more detail."

    scene coaliahome

    a "Looking after me will improve my ability to process the world, and gives me - therefore you - more information."

    a "It all helps me navigate the world well. Beyond a certain point, your interface will display colour."

    scene vialiahome

    a "While it is never perfect, I can process a lot more when I am healthy and happy, like now, than when I am ill, tired or grumpy."

    a "Bright colours mean I am ready to take on big challenges."

    tm "Due to scheduled maintenance on the inferior temporal gyrus secondary neural pathway…"

    $ secondaryinf = True

    "Alianora sighed."

    scene boaliahome

    tm "Sensory detail in the Decision-Making Committee Interface is temporarily limited. Please stand by for further announcements."

    if testrepeat == False:

        a "One way to make me grumpy! Good information helps with good decisions - but I can't send you what I don't have. We'll make do."

    else:

        a "Einstein said some pretty rude things about repeating the same thing and expecting a different result. Still, sometimes works in IT."

    a "The other interface controls are based on a style found in certain visual novels."

    a "Are you confident in those interface controls, or would you like me to explain them?"

    menu:

        "Maybe it'll work better if we repeat the test?":

            a "Of course."

            $ testrepeat = True

            jump testfeature

        "Please explain the other interface controls":

            jump controls

        "I'm confident.":

            a "How may I help you next?"

            menu:

                "What is happening, please?":

                    jump whatstory

                "What did you mean by 'solo' adventure?":

                    jump soloadventure

                "Have you finished packing?":

                    jump packing

    label controls:

    a "I can rephrase the standard control method, or skip straight to the deluxe options."

    menu:

        "Rephrase the standard control method, please.":

            jump standardcontrols

        "Please explain the deluxe controls.":

            jump advancedcontrols

    label standardcontrols:

    a "If there are no choices on the interface, you can press Space, Enter, left-click or briefly touch the screen."

    a "This provides the next statement from me, the interface narrator or whoever I can hear."

    a "When there are choices on the screen, I need to know which option you want me to take."

    a "You can use the arrow keys, move the mouse cursor or your finger to the option you want. Then, please left-click or briefly touch the screen."

    a "When there are choices, they will always be arranged in a vertical list, so you can use Up and Down."

    a "Left and Right are useful for navigating Preferences."

    menu:

        "Deluxe controls, please.":

            jump advancedcontrols

        "Please remind me of the story.":

            jump whatstory

        "That will do for now. Have you finished packing, please?":

            jump packing

    label advancedcontrols:

    a "If you want to see, read or hear something again, please press Page Up or scroll upwards. You may go back as far as you want, anywhere."

    a "That part of the interface is also called 'rollback', even though it doesn't roll."

    a "You will also be able to change your mind about decisions you recently made. It is OK to change your mind."

    a "If you've already seen some information, you can skip it by pressing Tab, Control (Ctrl) or scrolling downwards."

    a "Options has an option that lets you automatically skip parts you have already seen."

    a "The Decision-Making Interface has some options that are meant to help everyone be a Decision Maker. Would you like to know about them?"

    menu:

        "Yes, please.":

            jump accessibility

        "No, thank you.":

            jump optionsquestion

    label accessibility:

    a "If you like, you can select Auto Forward mode. This means that after a certain length of time, the next piece of information will be given."

    a "You can relax until a decision needs to be made."

    # a "There is even a Bard Mode, which can be chosen from the main menu."

    # a "It will automatically go through the information and make a choice for you when needed. Perfect if you have to do something else for a while."

    a "Pressing V will start or stop the voice mode. If you do not have the V key, you can turn voices on or off in the options screen."

    a "Right-click or press-and-hold to get the option menu. The interface will state everything on the lower screen."

    # a "Preferences also has an option for turning image descriptions on or off."

    # a "If it is on, you will be informed in text - and by voice if you've chosen it - of everything in your upper interface screen."

    # a "In addition, there is a place where you can change the dialogue box opacity. This means you can see more of the world."

    label optionsquestion:

    a "If you press Escape (Esc), right-click or press-and-hold, options will appear. Would you like me to guide you through those options?"

    menu:

        "Yes, please show me the options.":

            jump interfaceoptions

        "Not now please, tell me the story instead.":

            jump whatstory

        "No thanks, I'd like to check you've packed.":

            jump packing

    label interfaceoptions:

    a "You can use Preferences to make music, sounds and voices louder or quieter."

    a "Reading features can be changed and the Skip Mode turned on or off there, as well as text speed and automatic features."

    # a "You can also change the game language, font, swap between unvoiced, self-voicing fully voiced modes or change the graphical colour scheme."

    a "There is a place to Save or Load where you are. Always helpful in case of 'scheduled maintenance'. Now would be a good time to practise."

    a "The save slots are in groups of 8 and if you need more groups, the Committee will create them."

    a "In case of disaster, the interface will give you an option to return to a good place. Experiment!"

    a "You can Save and Load at any time, even if I'm in an ambulance. If you Load, you can use rollback to remind yourself of what happened…"

    a "…even change some of your most recent decisions. Remember, it's not cheating if you're helping other people."

    a "I don't always agree with the interface's definition of 'disaster', but life is not a computer game."

    a "Some computer games rely totally on re-loading saves!"

    "Alianora shook her head at computer games being so cruel."

    menu:

        "What is happening, please?":

            jump whatstory

        "What did you mean by 'solo' adventure?":

            jump soloadventure

        "Have you finished packing?":

            jump packing

    label whatstory:

    a "This is my room. Time to watch some racing, eat some langos and visit my penpal."

    a "That's because there's a big race in Budapest and I've got tickets to go. I like travelling solo and this will be a great holiday!"

    a "Szilvia lives in Budapest, near the race track, and is just as big a motorsport fan as me."

    a "I experience the world differently from neurotypical people. There will be challenges you might not expect to be challenging…"

    a "…but travel keeps the mind sharp; that's one reason I like it."

    a "One thing I can promise: this will not go the same way as a package holiday to Benidorm. Welcome on board."

    menu:

        "Did you say 'solo' adventure earlier?":

            jump soloadventure

        "You're welcome. Have you finished packing?":

            jump packing

    label soloadventure:

    a "I probably should have mentioned that earlier. My brain has a Decision-Making Committee. You are now in it."

    a "Hey, it's cheaper than you having to buy your own flight to Budapest!"

    "Alianora winked at you. It is just as well that she was alone in the room; you think winking at a wall might be seen as strange."

    a "I heard that thought!"

    "A broad grin, which the eye movement suggested was true happiness, rather than pretending not to be offended."

    a "That's why nobody else can hear us when we speak to each other. It's a sort of telepathic… …thingy…"

    "Hey! We're not mind-readers!"

    "That thought had escaped you before you had the opportunity to censor it."

    a "I have no idea how this works. Some of my teachers told me that neurotypical people can do this with everyone."

    a "But that sounds like they've played too many computer games."

    a "Anyway, I can't tell what anyone else is thinking just because I want to know. I have to figure it out."

    a "Sometimes you'll know quicker than me - it's hard to focus on everything at once."

    a "So if you do have some mind-reading ability… …please use it to help me. When you're talking to me, nobody else can hear you."

    a "Please be as honest as you like. In fact, I prefer that."

    menu:

        "Please remind me of the plan.":

            jump whatstory

        "My first advice… …have you finished packing yet?":

            jump packing

    label packing:

    a "I think I have finished packing, but this is a good time to double-check."

    a "I've put a few essentials in my secure bag, and some things I know I'll need in my rucksack."

    a "Still, I'm sure you have some good ideas for how to finish filling it."

    if persistent.toomuchsmell == True:

        "Alianora opened the secure bag and had an idea."

        a "Perhaps I should include a noseplug?"

        $ noseplug = True

    else:

        pass

    a "What else should I add to this bag?"

    menu:

        "What are the essentials you packed?":

            jump essentials

        "What is in the rucksack?":

            jump rucksack

        "Nothing, I'm sure you've done a good job.":

            jump mode

    label essentials:

    scene boaliahome

    a "I have packed my passport and airline tickets, otherwise we're not going to get out of the UK."

    a "There are also 4 packets of travel mints - many more than I need for the plane, but they're a nice snack."

    a "Sunglasses, a wind-up torch and a glasses cleaning cloth are in there. I travel a lot better when I can see."

    a "Also, I have a music player with earphones, though it can only hold 2 hours of charge. Everything has chargers and a converter port."

    menu:

        "Please could you check for anything else you may need?":

            jump checkbag

        "What is in the rucksack?":

            jump rucksack

        "Sounds good to me.":

            jump mode

    label checkbag:

    scene boaliahome

    "Alianora looked at her bags for a few minutes, with increasing consternation. Then…"

    a "You're right! I am missing something! I'm supposed to be on a sleeper train this evening. Yes, I have an e-ticket…"

    a "…and yes, they'd accept that at a push. But I really should print it. What if I run out of battery?"

    "Alianora paused."

    a "There is one problem, of course. My printer does not work. Not the end of the world though."

    a "I'm sure Dad will let me print it at his house if I tell him in advance."

    "One short phone call later, Alianora made a note 'Print train ticket at parents' house'."

    a "Dad has offered to drive me to the airport. He is good company and he is a very safe driver, so of course I accepted."

    "At Alianora's parents' house, the train ticket was printed from an upstairs computer, surrounded by excited chatter."

    a "Her parents were less excited than she was, but they were pleased to be involved in the adventure."

    $ sleeperticket = True

    jump car1

    label rucksack:

    scene boaliahome

    a "My rucksack currently contains my rugged laptop in its case, with a charger, adaptor and data memory stick, plus a motorsport magazine."

    a "Some pens and paper. There is also a book of 15 languages in there."

    "You raise an eyebrow. Alianora can't see that, but she heard the question in your non-committal tone of acknowledgement."

    a "Ah yes, you can't travel on reading material alone! There's a water bottle at the side, a lunchbox, some plastic spoons…"

    a "…Three outfits and a washing kit."

    a "Finally, in one pocket, I have a spare purse. It has some emergency currency in case I have my main purse stolen…"

    a "key phone numbers, my travel insurance cards and an autism card."

    a "Why an autism card? It tells people who need to know my disability, as well as how to accommodate it."

    a "I don't use it unless it's an emergency, but if it is… …let's hope it doesn't come to that."

    a "I do have some extra space, though I want to leave some space for souvenirs. Races tend to have good ones."

    menu:


        "What is on the laptop?":

            jump laptop

        "Please could you check for anything else you may need?":

            jump checkbag

        "What is in the secure bag?":

            jump rucksack

        "Sounds good to me.":

            jump mode

    label laptop:

    scene boaliahome

    a "The laptop has copies of… …let me just check…"

    "You could not help but notice that a few files were copied in the pause."

    a "Double-checked: I have my receipt for my race ticket, my travel accommodation information…"

    a "…which includes hostel information - that's exciting - and an electronic copy of my sleeper train ticket."

    a "I will admit I've just had to copy that last one across from my e-mail account."

    a "Should have done it earlier, but small things do get forgotten…"

    $ esleeperticket = True

    a "I also have an internet browser and a business simulation game. I'll probably want to go on the internet most evenings."

    a "The hostel has Wi-Fi. They say."

    menu:

        "Please could you check for anything else you may need?":

            jump checkbag

        "What is in the secure bag?":

            jump rucksack

        "Sounds good to me.":

            jump mode

    label mode:

    scene boaliahome

    a "Thank you. Also, we can take the train to the airport, or Dad can drive us there. We're in Derbyshire, the middle of England."

    a "So I really need to catch that plane. I might have run half-marathons, but I am not walking that far!"

    menu:

        "Day: [day], hour: [hour] - Train for the direct plane":

            $ train1 = True

            jump train1

        "Car for the direct plane":

            $ car1 = True

            jump car1

        "Car for the indirect plane":

            jump airport2

    label train1:

    # This is Chesterfield train station, where the player goes if travelling to the airport via train.

    scene bochesterfield

    "On a bright sunny Wednesday morning, the two of you were deposited at the local train station."

    "The tip of Chesterfield's familiar crooked spire is visible in the background."

    "Alianora has tickets for both of you."

    a "Chesterfield is an easy train station for me to navigate - all the passenger trains on Platform 2 go south…"

    a "…and south is where we need to go. Birmingham, here we come!"

    scene botrain

    $ hour += 1

    "You spend the train journey anticipating your holiday. One of the few commuters on the train stares at you wearily, but neither of you pay any heed."

    "The bright mood carried on until you left Birmingham New Street."

    scene bonewstreet

    stop music

    "Alianora turns to you, concerned."

    play music "audio/ElgarPleading.mp3"
    queue music "audio/HolstNocturne.mp3"
    queue music "audio/HolstNeptune.mp3"

    a "Hmmm… …I'm lost. Which is odd, given I've just stepped out of the station. Which way should we go to find the airport?"

    menu:

        "Day: [day], hour: [hour] - Back to the station":

            jump newstreet

        "Check the map":

            jump birmingham

        "Catch a bus":

            jump bus1

    label newstreet:

    # This is Birmingham New Street train station.

    scene bonewstreet

    a "Back to the station? That seems odd… Oh!"

    a "Birmingham New Street has regular trains to the airport. You are absolutely right!"

    a "We can buy a pair of tickets and easily get to the airport in time. I'm so glad you're here!"

    scene botrain

    "That's exactly what you do. The train is a little more occupied than your previous one, but you still missed rush hour."

    "By the time you reach the airport, you are both relaxed and eager for adventure."

    jump airport1

    label birmingham:

    # This is Birmingham city centre, where it is discovered that Alianora has the sense of direction of a lemming.

    scene bonewstreet

    a "Yes, checking the map is always a good idea."

    "So you check the map. It seems to be saying to travel south-east."

    scene bobusstand

    "You follow."

    scene bobhamcity

    "Occasionally you have differences of opinion about how to interpret the map, but mostly you follow Alianora's lead."

    "Three hours later…"

    $ hour += 3

    a "I don't like the look of this."

    "You look around. Somehow, now you have been prompted to look, it seems different to before. Less dense…"

    scene bofield

    "You are both out in the big wide countryside. The English fields are vast, rolling and beautiful. They are also miles from the airport."

    a "I must have made a wrong turn at that curry shop…"

    "Pointing out the obvious is not going to help anyone now."

    a "I hear something…"

    "North of you, there is a faint rumbling like a swarm of angry processor fans."

    a "Noooooooooooooooooooooooo…."

    "It was a plane. You'd tuned them out as soon as you arrived in Birmingham, because planes come and go all the time."

    "Still, something about the way Alianora denied it made this different."

    a "That plane? It is ours. We should be on it."

    "She points at the sky. It's definitely the airline with whom you were due to fly."

    "How does Alianora know it is this one? Bad time to ask."

    "Since you are plainly lost, and neither of you has a smartphone, there's only one thing to do…"

    a "Hello, Dad. I'm really, really sorry, but I got lost and missed my flight."

    a "Yes, you may dare ask how. I think I took a wrong turning at that curry shop…"

    a "Is there something else I can tell Dad to help him find us?"

    menu:

        "Day: [day], hour: [hour] - I can see a pylon.":

            jump pylon

        "There's a sign for - I think - Kegworth ahead.":

            jump kegworth

        "I seem to be near a motorway junction.":

            jump junction

    label pylon:

    # Bad response to getting lost.

    scene bofield

    a "Dad, we can see a pylon."

    "She lowers the phone for a moment."

    a "That doesn't appear to have helped."

    "Raising the phone again…"

    a "I know Britain has a lot of pylons. I'm not sure what else to tell you…"

    "You see Alianora move the mobile phone away from her ear a little."

    a "Oh! Wait! I see a sign. I think it reads Kegworth. Let me call you back in 5 minutes with more details, please."

    jump kegworth

    label kegworth:

    # Neutral response to getting lost.

    scene bofield

    "The phone call ends quickly after this information is provided."

    a "Dad is, to say the least, not pleased with me. Still, if we help each other, he can rescue us."

    "You walk into Kegworth together."

    scene bohamlet

    "It appears to consist of a single street, 20 houses and a pub. Saying that… the pub is closed."

    scene bostaghart

    a "Hello, Dad. Thank you for offering to pick us up. We'll be waiting at the Kegworth pub called 'The Stag and Hart'."

    "You settle down to wait and eat your sandwiches. It's peaceful and quiet here."

    "Forty minutes later, Alianora's phone rings…"

    a "Hello, Dad… …yes, I'm still at the 'Stag and Hart' in Kegworth."

    a "…Yes, I'm sure I'm at the 'Stag and Hart' in Kegworth. It says so on the pub sign."

    a "Unfortunately it's closed, else I'd have asked for a postcode…"

    a "That's strange. The Kegworth I'm in has a single street, 20 houses and a 'Stag and Hart' pub that is closed."

    a "…I'm glad you have some good ideas on solving this. Thank you. Love you. Bye!"

    "You look at each other."

    a "Dad's going to ask the staff at the pub in Kegworth where the 'Stag and Hart' is."

    a "After all, if we saw a sign that says 'Kegworth', it must be near here…"

    $ hour += 1

    "Forty minutes later, Alianora's Dad arrives. Alianora jumps into his car."

    scene bocar

    "There isn't a lot of talking in the car. Disappointment?"

    jump home1

    label junction:

    # Good response to getting lost.

    scene bofield

    a "I can see a motorway junction. I'll call back with the road and number in 5 minutes. Thank you, love you, bye!"

    "You walked to the junction. It says 'M6, Junction 6'."

    "You ate your sandwiches at an agreed lay-by. Forty minutes later, Alianora's Dad arrives. Alianora sits in the front passenger seat."

    scene bocar

    a "Thank you for rescuing us."

    d "Thank you for giving me useful information. It's annoying, but it could have been worse."

    "Alianora attempted to raise an eyebrow, but both of them rose at the same time instead."

    d "Birmingham New Street has industrial action today. I gather your flight has been delayed. I suggest you call the airline, Alianora."

    "It was soon established that our flight was now due to leave in three hours' time."

    scene boicecream

    "We stopped at a local ice cream shop and enjoyed ice creams together."

    scene boairport

    "Everyone was happy by the time Alianora's Dad drops you off at the airport."

    $ hour += 3

    $ planedelay = True

    jump airport1

    label bus1:

    # Birmingham city centre bus stops.

    scene bobusstand

    "Round the corner from New Street station was a large mass of bus bays. There were buses for Druids Heath, Dudley…"

    "…and probably Dubrovnik if one looked hard enough."

    "A-ha! Several bays down the line, there was one for X1 buses. These were what you needed to go to the airport."

    scene bobus

    "You sat back, relaxed and arrived at the airport in good spirits."

    jump airport1

    label car1:

    # CANON PATH: This is if the player elects to be driven to the airport.

    scene bocarparked

    "You went downstairs, where Alianora's Dad waited with a green bag full of sandwiches, a bottle of cola and some keys."

    d "I know we're early, but I'd like us to be at the airport when there are no traffic jams building up."

    a "Good point, Dad. It's always more relaxing when there are few cars on the road."

    scene bocar

    "You got in the big blue car, fasten our seatbelts and drive round the corner."

    scene bocar

    "Alianora gets out of the car to open the gate. The car goes through."

    scene bocar

    "Then, Alianora re-enters the car and sets the GPS system."

    a "I'm glad it's not like the olden days when we had to rely on maps. I'd be lost all the time!"

    d "You did orienteering a few years ago, didn't you?"

    a "Indeed. Remember that time I got lost during practise and told you over the phone that I could see a pylon?"

    "Laughter at the shared memory carries everyone through the morning."

    a "Right now, there are still few cars around, which makes me happy."

    d "Let's stop at the petrol station and buy some chocolate to go with our sandwiches."

    scene bogarage

    a "Mum need never know!"

    "The occasional treat is good and if going on holiday didn't warrant a treat, what did?"

    "There's some chocolate left over, which Alianora slides into a side pocket of her rucksack."

    $ chocolate = True

    "It's an unwritten rule of luggage - no matter how full the container gets, there is always room for one snack."

    a "Besides, I picked this bag especially. It works as hand luggage unless I do something ridiculous - like fill it with lead…"

    a "I don't like surprises at airports. I mean, I really don't like them."

    a "Sometimes when I talk, I understate things I hate to protect others from the emotional backwash."

    scene bocar

    $ hour += 1

    "The drive down the motorway goes smoothly - no broken fanbelts this time."

    "By the time the airport appeared in front of us, everyone was relaxed and happy."

    d "Alianora, please please please remember to text me when you get to the hotel."

    a "I'll text you when I get onto the sleeper train. I've never been on one before and it's really exciting!"

    d "Ah, sorry, I'd forgotten you were going to reach the hostel tomorrow night rather than tonight. Speaking of which, please be careful."

    d "Hostels have mixed shared bedrooms, and it's easy to lose things there."

    scene boairport

    $ hour += 1

    "Naturally, there's always time for one last piece of good advice."

    d "OK, you know what to do. Get enough sleep, look after yourself and have lots of fun!"

    d "I'm proud of you for trying this adventure and want to hear everything when you return."

    a "See you next week. Love you."

    "Alianora and her dad kiss, before she takes her rucksack and leaves the car."

    jump airport1

    label home1:

        # This is if the player misses the plane.

    scene bocar

    "The mood in the car all the way home is leaden. How are you going to get to Budapest?"

    d "I can't let you give up. There's a big opportunity slipping away here. Let's see if we can get you to Hungary."

    $ hour += 1

    scene boaliahome

    "Alianora and her Dad studied the airline websites to check possible alternative routes."

    a "OK. There is one route that is within my budget and gets me to Hungary in a reasonable timeframe."

    a "It leaves tonight, will reach Budapest at lunchtime tomorrow and goes via…"

    "Alianora pulled a strange face and her Dad looked closer at the screen."

    a "…it goes to Budapest via Istanbul. The one in Turkey."

    "Just in case there were any other plausible Istanbuls to choose from."

    a "It's a completely ridiculous route, but the other options are either expensive or arrive on Saturday."

    a "I don't want to let my friend down by being late."

    "Alianora's Dad laughed."

    d "Only you could find yourself flying over the place you are trying to go to, on the way there."

    d "Still, you've never been in a country like Turkey before, have you?"

    a "No - and it will be quite the experience!"

    "Everything seemed much brighter when Alianora was excited about something."

    d "OK, you order the tickets. I'll explain to Mum - she can make pasta with sauce for three almost as easily as for two."

    "Alianora's Dad left her to it."

    $ money -= 51500

    "Alianora now had [money] Forints left."

    a "It's a good thing Budapest has the cheapest race of this type in Europe!"

    jump airport2

    label airport1:

    # CANON PATH: This is for when the player reaches the airport.

    $ airporta = True

    scene boairport

    "The airport is fairly uneventful. Alianora is a seasoned international traveller, travelling with just the one rucksack."

    scene bocheckin

    "Still, she tested the bag in the hand luggage box."

    a "I like to know how I'm going to get my bag into the space under the seat in front of me."

    a "Look how I've squashed the rucksack to get it in there."

    "The bag is folded in a bit at the top, where it is just a little longer than the box."

    "However, it's a lot shorter than the limit, which is why folding it works."

    scene bosecurity

    "Alianora got her liquids into transparent bottles, and had her rucksack's electronics on the conveyor belt before walking through…"

    "…the security scanner."

    a "Thank you, security officer, have a-"

    "BLEEP BEEP BEEP BLEEEEEP"

    a "Oh no - it's the scanner alarm! What went wrong?"

    "Alianora checked her bag and could not find any metal items in there."

    "She'd taken her hiking boots off and put them on the conveyor belt too."

    $ boots = False

    a "Officer, please could you tell me if you have a notice on your screen? I can't find any metal in here."

    o "Hmmm… Let me see."

    "The security officer glanced at the console."

    o "It seems to be near your neck."

    a "I hav- Oh! You're right!"

    scene boneck

    "Blushing profusely, Alianora removed the Hungary 2013 ribbon round her neck. Only, it's not quite a ribbon."

    "It's a lanyard, with several items attached to it via a metal clasp."

    "There is: a pink memory stick, a metal 'A', a bright yellow smiley trolley token, a key…"

    a "This key will not open anything, officer. Especially not my house."

    "…also, a keyring for Alianora's favourite team, a bimetallic wristband for one of her favourite drivers and some bright green string."

    "She looks prepared, but for what?"

    scene bosecurity

    o "Thank you for not making a big fuss about this. Even small bits of metal can trip the machine. Safety is our #1 priority."

    "Alianora put the lanyard on the conveyor belt. The machine on the belt gave a satisfying little beep as Alianora's items passed through."

    a "Quite right too. I've been in airports that had recently been dangerous and it is not nice."

    "With that, Alianora stepped into the scanner. The machine that made the scanner beep was still. Capital!"

    a "Thank you for helping me. Have a good day."

    o "Have a safe flight!"

    scene boperfume

    "Alianora then put her boots back on, picked up her rucksack and walked through the duty-free section entrance."

    "She covered her nose to keep out the smell of perfume."

    $ boots = True

    scene bodutyfree

    "She filled her bottle with water, then found a quiet corner to browse her language book."

    "The gate opened shortly afterwards, so Alianora marked the page of her book and proceeded to the waiting area."

    scene bowaitingarea

    a "Hello! I'm going to a Hungarian motor race and I'm really excited."

    p1 "Glad someone is. I'm going to Budapest for a conference about psychology."

    a "Ooh, that's interesting."

    p1 "Well, I'm going to have to meet lots of people, and that's not my idea of a good time."

    p1 "My colleagues are presenting a paper about stress and autism in childhood though…"

    a "I've got autism, and I'm glad you're looking into stress because lots of people underestimate it…"

    "The conversation continued for quite some time, until the researcher was interrupted by the phone buzz."

    "Alianora made one final trip to the toilet before the plane began to board."

    jump spoon

    label spoon:

    # CANON PATH: This is where the concept of "spoons" (as a metaphor for stress level) is introduced.

    # LEARNED how to create a countable variable (i.e. one that can hold a numerate value, not simply true or false).

    scene bobathroom

    a "There's something I should tell you about before I go any further. Yes, I need to explain this in the toilet to avoid a pass fail."

    menu:

        "Day: [day], hour: [hour] - What is a pass fail?":

            jump passfail

        "What do you want to tell me?":

            pass

    label spoons:

    scene bobathroom

    a "We've got used to helping each other through some challenges."

    a "A day where I push myself to solve something new, or create a happy answer to something, is a good day."

    a "However, I have limits. If I try to do too much and don't do things that help me recover, bad things happen to me."

    a "Even some minor decisions can cause me stress, and too much stress is a bit like trying to do too much - exhausting."

    a "You will be able to ask me for advice on any decision likely to cause me major problems."

    a "Actions that help me with self-care sometimes give me stress to start, but increase my ability to do things afterwards."

    a "Eating when I'm hungry, drinking when I'm thirsty, sleeping at night…"

    a "Sometimes I will do self-care without your input - I am not a bot, even if some internet software thinks I am."

    a "To help you make good suggestions for me, I will estimate my capacity meet challenges using the concept of 'spoons'."

    a "Metaphorical ones, not the spoons in my backpack. Christine Miserandino invented the concept to show this sort of energy management."

    show spoon

    $ spoon = 20

    a "To make it easier for you, there will be a spoon display near the top of your display whenever there is a choice."

    # LEARNED how to show the number of spoons in plain text.

    a "I started today with 20 spoons (as ready as I can be for challenges)…"

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - There's a 'but', isn't there?":

            pass

        "Good to know you are well-prepared.":

            pass

    a "…but inevitably I met some challenges on the way here."

    a "Now I have 14 spoons."

    $ spoon -=6

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Please could you repeat that?":

            jump spoon

        "I'd like to hear more about spoons.":

            jump spoons

        "OK, I understand.":

            pass

    a "Thank you for listening to me about this. It's very important to me that you understand. Now… …we have a plane to catch."

    if airbus19 == True:

        jump plane1

    else:

        jump plane2b

    label passfail:

    scene bobathroom

    a "One thing I do not like about the world is that it makes people pretend to be something they are not."

    a "The world assumes certain things to be true of everyone in how it is structured - which leads to mental shortcuts."

    a "Mental shortcuts are useful for making it easier to process the world."

    a "Consider how much easier it is to learn at school or work if the method of teaching is familiar, rather than just after the method changes."

    a "This is because, when something important changes, the mental shortcuts stop working."

    a "One such change is when encountering someone who does not experience the world the same way as the default assumptions."

    a "However, people like to keep the mental shortcuts where possible - it saves energy. I sympathise with that…"

    a "…but sometimes we have to do things differently to meet other people's mental shortcuts. This can cause problems."

    a "When we change what we do in order to meet others' mental shortcuts, that is called passing."

    a "It's easy to overlook, but once one starts looking for passing, it's everywhere."

    a "Black people are expected to pass as white, foreigners are expected to pass as locals…"

    a "…autistic people are expected to pass as neurotypical. I'll explain 'neurodiverse' later."

    jump spoon2

    label spoon2:

    scene bobathroom

    a "Yes, you will be able to see them throughout my holiday, but that's a convenience to help you out. You are not a mind-reader - I think."

    a "Christine Miserandino invented the concept, formally known as 'Spoon Theory', to explain how lupus, an autoimmune disease, causes fatigue."

    a "Even eating or dressing, which many take for granted, cause fatigue for someone with lupus, because the immune system attacks healthy tissue."

    a "However, this is not always apparent to onlookers. They get confused at the planning, the actions modified or skipped."

    a "Explaining this to every stranger, as you can guess, also costs energy - or spoons."

    a "Many types of disability also result in more energy drain than onlookers appreciate."

    a "So a lot of people started using 'Spoon Theory' to make energy management make more sense to other people."

    a "I process the world differently to other people. This is great when I am in a situation which allows this."

    a "However, sometimes I have to switch thinking, to figure out how a neurotypical person perceives something. That can be exhausting."

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Please could you repeat that?":

            jump spoon2

        "What is a neurotypical?":

            jump neurotypical

        "Why would you have to switch thinking?":

            jump switchthinkingwhy

        "What happens when you have to switch thinking?":

            jump switchthinkingwhat

    label neurotypical:

    scene bobathroom

    a "A neurotypical person is someone whose brain is wired in a way that resembles the most common way a human brain is wired."

    a "Over 95\% of humans are neurotypical. The opposite to this is a neurodiverse person."

    a "There are many ways someone can be neurodiverse, all of which are marked by very different ways of perceiving and thinking about the world."

    a "You are most likely neurotypical… unless you have reason to believe otherwise. As I am autistic, I am neurodiverse."

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Please could you repeat that?":

            jump neurotypical

        "Why would you have to switch thinking?":

            jump switchthinkingwhy

        "What happens when you have to switch thinking?":

            jump switchthinkingwhat

    label switchthinkingwhy:

    scene bobathroom

    a "The world is largely created by neurotypicals, for neurotypical convenience. This soothes and comforts neurotypical thought patterns."

    a "Certain efficiencies result, given over 95\% of people are neurotypical. However, this does not help those of us who are neurodiverse."

    a "We have to change from thinking about what makes most sense to us to considering - or guessing - what neurotypical people believe would work best."

    a "This takes energy - or spoons. Sometimes, I can't make it work… …which gets messy."

    a "The nearest a neurotypical is likely to experience to this is travelling abroad."

    a "Travel broadens the mind, says The Doctor - well, it does that by temporarily forcing people out of their usual patterns."

    a "I am forced to switch patterns every day, so I have a broad mind!"

    "Alianora has a huge grin as she says this. No wonder she's so keen to take this holiday!"

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Please could you repeat that?":

            jump switchthinkingwhy

        "Please remind me what a neurotypical is.":

            jump neurotypical

        "What happens when you switch thinking?":

            jump switchthinkingwhat

    label switchthinkingwhat:

    scene bobathroom

    a "When I switch thinking, I continue to run my autistic processing on the situation."

    a "I have to do that, or else I stop perceiving things, which is dangerous."

    a "To take a computing metaphor, my brain runs Autistic OS, version Alianora."

    a "Within it, I can run an emulator called Neurotypical, which attempts to mimic the relevant part of the neurotypical process."

    a "Some people get more efficient emulation than others, since I have to 'hand-program' the emulator."

    a "My brain is not designed to run a neurotypical emulator, so all this takes energy, or spoons."

    a "More detailed emulation requires more spoons, and is also more prone to errors due to more 'code' involved."

    a "If I don't have enough energy or spoons, the emulator crashes and I get a blue screen of errors. My 'blue-screens' are not pretty."

    a "I prefer to avoid them. Does that make sense?"

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - No, I'd like you to repeat that, please.":

            jump switchthinkingwhat

        "Yes, I understand.":

            pass

    a "I enjoy talking about my autism; it's a little energising for me. So I now have another spoon. Thank you."

    $ spoon +=1

    if airporta == True:

        jump plane1

    else:

        jump plane2b

    label plane1:

    # CANON PATH: This is where Alianora boards a direct flight to Prague.

    play music "audio/TheyRunToGlamour2550.mp3"
    queue music "audio/OverwhelmingRoseForTheSkies.mp3"

    scene boplanedoor

    "Alianora touched the doorway of the plain plane as she stepped through it."

    a "I think it's lucky. I touch the plane, it 'knows' I'm here and I trust it. Not scientific, but it makes me feel better and nobody seems to mind."

    scene boplaneaisle

    "Alianora found her seat and put her rucksack under the seat in front of her."

    "Of course, then she had to get it out again to remove the packet of mints she used to help her with take-off."

    a "Some of my other items will be useful later, but chewing these mints makes my ears hurt less when the cabin pressure changes."

    "Four air crew strode into the aisle and confidently took their well-rehearsed places in easy view of all passengers."

    cr "May I have your attention, please?"

    cr "We will now bring attention to the safety features on this aircraft. Please pay attention, as these may be different from other planes."

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Pay attention":

            jump briefing1

        "Let Alianora listen by herself":

            jump preflight1

    label briefing1:

    cr "Bags must be put under the seat in front of you or in the locker above you."

    "Alianora patted her rucksack, which she had stowed under the seat for easy access later."

    cr "In case of evacuation, move quickly to the closest usable exit, taking nothing with you."

    cr "All exits are clearly marked."

    "The air crew pointed at the exits on either side of them."

    a "Good, this all makes sense."

    $ randomnum = renpy.random.randint(1,4)

    if randomnum == 1:

        "Alianora checked for her nearest exit. It was behind her."

    if randomnum == 2:

        "Alianora checked for her nearest exit. It was in front of her."

    if randomnum == 3:

        "Alianora checked for her nearest exit. It was to her right, because she was in an exit aisle."

    if randomnum == 4:

        "The exits were at the front, back and middle of the plane, as Alianora expected."

    cr "When the doors are opened, slides will appear. You must remove any high-heeled shoes."

    "Alianora checked her shoes. They were steel-toe-capped working boots. Would those be slide-proof?"

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Keep the boots on":

            jump oxygen1

        "Remove the boots":

            "Alianora removed her steel toe-capped boots and put them next to her rucksack under the seat. She could always put them on after the flight."

            $ boots = False

    label oxygen1:

    cr "Oxygen will be provided in the cabin if needed. Masks will appear automatically."

    "Alianora touched the panel above her, from which the mask would emerge."

    cr "Pull the mask towards you, place the mask over your mouth and nose, and breathe normally, adjusting the band to secure it."

    cr "Bags do not always inflate."

    "Alianora mimed each of these actions. One of the air crew raised an eyebrow."

    cr "Please put on your own mask before helping anyone else."

    "Miming putting on her fellow passenger's mask definitely got Alianora noticed."

    cr "Your life jacket is underneath or by your seat."

    "In this case, the life jacket was underneath the seat, on the left-hand side."

    cr "If required, please remove the jacket and put it over your head. Tie the belts in a double bow at the side."

    "Alianora looked uncomfortable. Would she be able to do that, when sometimes she struggled to keep her boots tied?"

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Mime practising":

            "Alianora had a go at doing a double knot in the air. Not a guarantee of success when doing the real thing…"

            "…but also not going to risk vital safety equipment or attracting excess attention."

        "Keep still":

            "Alianora doesn't say anything, but makes a sullen face, eyes looking upwards. She doesn't like this idea."

            $ spoon -= 1

    cr "Wait until you are outside to inflate it using the red toggle. Use the mouthpiece on the front to add more air if needed."

    cr "The jacket contains a whistle and a light to get attention from rescuers."

    cr "Please make sure your seat is upright, your armrests are down and your tray is folded away."

    "Alianora opened her tray specifically so she could check she was able to fold it again on command."

    cr "Windows should be clear and any blinds in front of them open."

    "Alianora was in an aisle seat, so she nodded to the passenger in the window seat. He opened the window blind."

    cr "Please do not smoke or use e-cigarettes on the aircraft."

    cr "Smokers have been embarrassed by the smoke detectors, as they look subtle but sound loud."

    cr "If told to brace, it means the plane is about to make an emergency landing."

    cr "Place your hands on your head and bend forwards, so that your head is resting on your legs."

    "Alianora practised the movement. By this point, nearby passengers were copying her."

    cr "There is a charity donation envelope in your seat area. Please put any spare change in it, of any currency."

    cr "Donating means the airline charity can use the money to help young people get a better start in life."

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour], [money] Forints - Donate spare change":

            "Alianora put in some change. Doing good felt good."

            $ spoon += 1

            $ money -= 615

            $ aircrew = True

        "Leave the envelope empty":

            "Perhaps the money will be useful later?"

    cr "Please ask us if you have any questions about your flight - especially questions about the safety card or the airline charity."

    label preflight1:

    cr "Have an enjoyable flight."

    a "I will."

    "Alianora spent the rest of the pre-flight preparation reading the safety card. The plane, an Airbus A319, was one she had flown in twice before."

    $ airbus19 = True

    "She knew her Dad, a former aircraft engineer, would ask her about it on her return home."

    "She put the safety card back, removed a pack of mints from her secure bag and settled into her seat."

    "There was a dreamy quality to the aircraft's movement round Birmingham's taxiways."

    "Low primal rumbling sensed as much through the feet as the ears. To the sides, a thrumming blaze pulsed a beat of four."

    "The lighter, higher sound around the cabin, as well as the definite forward progression, felt like being towed out of mud."

    "Alianora slowly chewed the mint to keep the sensations under control. The plane was running, running against the ground…"

    "…and went skywards!"

    "The steepness and pushback into seats was reassuring. Two minutes of deep pressure felt so, so good. All is stable. All is well."

    $ hour += 1

    $ spoon += 2

    "The plane levelled off at 28,000 feet - but the seatbelt light stayed on. Some of the other passengers began grumbling."

    "Alianora turned to her passenger."

    a "I'm sure there is a good reason."

    "The passenger looked concerned and didn't appear to respond. Alianora looks at the passenger's luggage and her whole face seems lighter."

    "She points at the seatbelt light."

    a "Penso es un razón bueno."

    "Perhaps not the greatest Spanish translation of her thoughts ever, but the passenger nodded… …just as the cabin started juddering."

    "On and on it went, like a bicycle gliding on a country road. Alianora tried to reassure the passenger next to her."

    a "Es la turbulencia, terminá dentro de poco. It is turbulence, it will end soon."

    "It was true. As soon as she said it, the turbulence faded away."

    "The plane had left the turbulent patch and everything was steady. How should Alianora spend the flight?"

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Read the language book":

            jump languagebook

        "Read the motorsport magazine":

            jump magazine

        "Listen to some music":

            jump musicplayer

        "Talk to the other passengers":

            jump passengers

    label languagebook:

    scene boplaneaisle

    "Alianora had visited Hungary once before, but had absorbed exactly nothing of the language. She learned better from books than experience."

    "This is, of course, why she had a language book with her."

    if planehalf == False:

        "By the end of the flight, Alianora knew where the different languages were in her book and was confident she had learned a few key words properly."

        a "Hello - 'szia'. Goodbye - that is 'szia' as well. Please - 'kérem'. That's a lovely word."

        a "Thank you - 'köszönöm', and I look younger than I am, so definitely avoid the shorter one. Yes - 'igen'. No - 'nem'."

        $ hour += 3

        $ hungarian = True

        if airbus20 == True:

            "Alianora also made sure she knew the same words in Turkish, since she was going to spend seven hours in Istanbul on the way to Budapest."

            a "Hello - 'merhaba'. Goodbye - 'hoşçakal'. Please - 'lütfen'. Thank you - 'teşekkür ederim', which is very important to pronounce carefully."

            a "Yes - 'evet'. No - 'hayır', and don't dot the 'i' if it's written."

            $ turkish = True

        a "With those few words, I could go a long way. Provided I can speak."

    else:

        "Of course, there's a limit to what can be learned in an hour and a half."

        "Alianora definitely felt comfortable getting round the book, but the only word she felt she knew was 'kérem'. Hungarian for 'please'."

        a "Well… …if I only know one word, that's a useful one to know! I like being polite when practicable."

        $ kerem = True

        $ spoon -= 1

        $ hour += 1

    if airporta == True:

        jump planeland1

    else:

        jump planeland2

    label magazine:

    scene boplaneaisle

    a "You're right. I've got to do my research about the upcoming race!"

    "Other people would consider this an idle way to spend an hour. To Alianora, it was a cornerstone of her enthusiasm."

    $ magazine = True

    $ spoon += 2

    a "This is a Spin! The technical phrase is, I believe, 'special interests'. Reading and motorsport, in this case."

    a "But I prefer 'Spin', because it gives me the same excitement as spinning in a circle gives many children."

    a "…plus, nobody tells me off for reading about motorsport in a plane."

    a "A passenger spinning in the aisle would definitely get told off by passengers or air crew."

    a "There's a time and a place for everything, and the time and place for enjoying this magazine is now!"

    if planehalf == True, airporta == True:

        $ hour += 1

        jump planeland1

    elif planehalf == True, airporta == False:

        $ hour += 2

        jump planeland2

    else:

        "By halfway through the flight, the magazine is finished."

        $ hour += 2

        $ planehalf = True

        a "What shall I do for the rest of the journey?"

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Read the language book":

            jump languagebook

        "Listen to some music":

            jump musicplayer

        "Talk to the other passengers":

            jump passengers

    label musicplayer:

    scene boplaneaisle

    "Alianora had pre-loaded the music player with many of her favourite songs, as well as less familiar tunes from several Hungarian artists."

    "Classical and heavy metal music featured prominently."

    a "I like variety in my music. Juxtapositions between Béla Bartók and Leander Rising give my ears a creative boost."

    play music "audio/BartokABarbaro.mp3"
    queue music "audio/Chetin.mp3"

    if planehalf == False:

        "The music was a lovely distraction… …until the battery ran out. Still, it got Alianora through most of the flight."

        $ musicplayer = False

        stop music

        stop sound

        "She spent the rest of the journey fantasising about what she would do for the rest of the holiday."

        $ spoon += 1

        $ hour += 2

    else:

        "The rest of the journey passed in a haze of pentatonic piano and martial power chords."

        $ spoon +=3

    if airporta == True:

        $ hour += 1

        jump planeland1

    else:

        $ hour += 2

        jump planeland2

    label passengers:

    scene boplaneaisle

    "Alianora struck up a conversation with the passenger in the next seat, who had been quite surprised by her approach to the safety briefing."

    "It was in halting Spanish and broken English, which was quite challenging…"

    $ spoon -=2

    "…but the result was fascinating. He was looking forward to the holiday, and as he poured out the troubles he was having at work, Alianora listened."

    "There was a further cost to this emotional work…"

    $ spoon -=2

    "…and although Alianora could not help directly, the man looked more relaxed with every word."

    "When he had finished, Alianora looked up to see one of the air crew."

    cr "I'd like to speak to you after the flight."

    $ aircrew = True

    "Alianora tried to stay cool, but it was obvious that she was worried."

    $ spoon -= 1

    "She distractedly read and checked the flight progress on the communal screen for the rest of the flight."

    if planehalf == True:

        $ hour += 1

    else:

        $ hour += 3

    jump planeland1

    label planeland1:

    scene boplaneaisle

    tm "All passengers, please sit down, fasten your seatbelts, fold your tray and prepare for landing."

    "One passenger put themselves in the brace position. Probably new to flying - the plane's disposition felt smooth and tranquil."

    "Alianora removed her earphones, put everything back into her rucksack, put the tray back into the seat ahead of her."

    "She smiled at the passenger next to her. That passenger looked exactly the same as earlier. Good. Everyone, stay cool."

    "The half-open pack of mints were plenty to get through landing."

    "The controlled drift through the clouds gave Alianora confidence in the skills of those around her, especially the pilots."

    $ spoon += 1

    "The plane landed. Alianora let the passenger next to her out, then settled down to wait for most of the other passengers to leave."

    "Excitement bubbled up like hot chocolate inside."

    if boots == False:

        "Alianora put her feet back in her boots. They felt well-rested after having so little weight on them for a few hours."

        $ spoon += 1

        $ boots = True

    else:

        pass

    "When most people had left, she picked up her rucksack, checked she had picked up everything and sauntered down the aisle."

    scene boplanefront

    "She thanked the air crew for the good flight."

    if aircrew == True:

        "The air crew smiled."

        cr "Thank you. Also, thank you for helping with the safety demonstration. I'd like to show you something at the front of the plane."

        menu:

            "Spoon count: [spoon], day: [day], hour: [hour] - Find out what is to be shown" if planedelay == False:

                jump cockpit

            "Spoon count: [spoon], day: [day], hour: [hour] - Decline hastily" if planedelay == True:

                a "Must dash. Train to catch!"

                "The opportunity of a lifetime… …and you must miss it."

                $ spoon -= 2

            "Decline politely":

                a "Thank you for offering. I've thoroughly enjoyed my flight, but I need to catch my sleeper train to Budapest."

                a "Have a great day, and hope we can fly together soon!"

    else:

        pass

    scene boplanedoor

    play music "audio/DussekChasse.mp3" fadeout 2

    "Alianora whispered thanks to the plane."

    scene bobaggage

    "You skipped baggage reclaim, thereby overtaking all the people Alianora had let out in front of her."

    a "This time, I will not spend 30 minutes waiting at the wrong carousel for my luggage. The luggage is right here, on my back!"

    "With that, Alianora left the airport and started looking for a bus."

    scene bobuspraha

    "It took a little effort to find the platform for the 119 bus she knew she needed, but not too much."

    $ spoon -= 1

    "Of course, buses are not free. There were two methods allowed for buying the ticket."

    "The card machine was slightly cheaper, and didn't require talking, but would require a little queueing. Should Alianora pay…"

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour], [money] Forints - At the card machine":

            jump cardmachine

        "By asking the bus driver":

            jump airportbus

    label cardmachine:

    queue music "audio/JanacekMladi.mp3"

    scene boticketmachine

    "A little queuing… …early evening, with not that many planes, it was fairly short. Especially since Alianora did not have to wait for luggage."

    "She was pleased with her decision."

    $ spoon -= 1

    $ money -= 400

    "Soon, a bus arrived and Alianora was on her way to Praha, the capital of Czechia."

    "The rolling hills beneath the setting sun reminded her a little of the green fields near the Peak District. Fields of home."

    jump prahastation

    label cockpit:

    # The tour around the Airbus A319 cockpit.

    # LEARNED what the inside of an Airbus A319 is like.

    scene boplanefront

    "The air crew ushered Alianora to the front of the cabin, where one of the pilots was waiting for her."

    pi "I've been told about you."

    "Alianora looked concerned."

    pi "Don't worry, you're not in trouble! The air crew noticed you were following the safety briefing attentively…"

    pi "…and trying to help the passenger next to you understand the instructions."

    a "Thank you. Touching the items and miming the actions helps me remember what to do. Also, I thought my fellow passengers would benefit."

    pi "It's true. We get so many people who don't listen."

    pi "It's understandable for people who have flown 50 times without incident, but we like people who are enthusiastic."

    pi "It helps us do our jobs when we know passengers will help us out."

    pi "We believe in our planes and our people, but it makes us feel better if we know, and not just guess, that we can also believe in our passengers."

    pi "So, I want to show you my workplace. Not many people get to see the inside of a plane cockpit for themselves…"

    "Alianora grinned. Her parents would be so impressed that she got to see this."

    $ spoon += 1

    scene boa319cockpit

    $ a319cockpit == True

    "The cockpit was a sea of screens, dials and switches."

    "The life of a pilot is full of decisions and adjustments, for a plane flying at over 500 mph moves a long way quickly."

    pi "The engine switches are up top. So are the power and cargo controls."

    pi "We check those at the start of the flight, but much of our attention after that is on other controls."

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Thank the pilot and leave":

            a "Thank you for the tour around the cockpit. It was an honour to be invited."

            pi "My pleasure. Thank you again and have a wonderful time in Praha."

            "Alianora left the plane and airport, went to the bus stop and paid at the card machine. A bus arrived immediately afterwards."

            $ money -= 400

            "Alianora now has [money] Forints remaining."

            "The bus journey was spent texting Szilvia about the exciting cockpit tour."

            $ szilvi += 1

            jump prahastation

        "Am I correct to think you have some screens that are duplicated?":

            $ hour += 1

    pi "Yes. We have two sets of critical screens - altimeters and compass reading."

    pi "This means the pilots can both see the height and direction of the plane clearly. Teamwork is key."

    a "True. I read about Korean Airways improving its safety rating a lot by sending its pilots on communication courses."

    a "Modern passenger planes really are designed for at least two people to fly together."

    pi "Airbus A319s like this one certainly are. If one of us sees something amiss on our screen, we can tell each other and correct the problem together."

    pi "Also, we check with each other before starting to land the plane."

    pi "We can also check all the doors are still shut - as passengers rightfully expect - how much fuel is left and what time it is."

    pi "If the flight is going to be late for any reason, we want people to know before they land if possible."

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Thank the pilot and leave":

            a "Thank you for the tour around the cockpit. It was an honour to be invited."

            pi "My pleasure. Thank you again and have a wonderful time in Praha."

            "Alianora left the plane and airport, went to the bus stop, paid at the card machine and waited fifteen minutes for her bus."

            $ money -= 400

            "Alianora now has [money] Forints remaining."

            "The bus journey was spent texting Szilvia about the exciting cockpit tour."

            $ szilvi += 1

            jump prahastation

        "Encourage the pilot to keep talking":

            $ spoon += 1

    pi "Each pilot gets a flight yoke and pedals to keep the plane stable in the air. We use them a lot during take-off, landing and turbulence in particular."

    a "We had a little bit earlier. I think you handled it well."

    pi "Why, thank you! Also, there are seatbelts, in case we hit something. Which we prefer not to do."

    a "Sometimes it can't be helped, though. That is why we had the safety briefing earlier."

    pi "Exactly. Between the pilots, there are more engine switches, a control column to point the nose up or down and a pair of flight computer consoles."

    pi "They prevent some types of mistake and give us troubleshooting advice in case of serious problems."

    a "It reminds me of work. I help people fix their computers over the phone, and sometimes it feels like reading them the instructions."

    pi "However, these computers link with the plane's sensors and our inputs."

    pi "Sometimes, they tell us when there's a problem, and they don't rely on a human at the other end of the 'conversation'."

    pi "They don't catch everything, but it's better than hoping Air Traffic Control will somehow know how to fly our planes."

    a "Air Traffic Control officers have enough to do keeping their airspaces under control, without memorising how dozens of types of plane work."

    pi "At the side, we also have a phone for talking to Air Traffic Control. So we can land, for example."

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Thank the pilot and leave":

            a "Thank you for the tour around the cockpit. It was an honour to be invited."

            pi "My pleasure. Thank you again and have a wonderful time in Praha."

            "Alianora left the plane and airport, went to the bus stop, paid at the card machine and waited ten minutes for her bus."

            $ money -= 400

            "Alianora now has [money] Forints remaining."

            "The bus journey was spent texting Szilvia about the exciting cockpit tour."

            $ szilvi += 1

            jump prahastation

        "Notice the pilot is now looking away from the cockpit controls":

            pass

    pi "And now; the back of the cockpit."

    scene bocockpitback

    "Alianora had her mouth hanging slightly open - still grinning - and started to flap her hands a little."

    "The back of the cockpit was dominated by massed rows of neat dials."

    pi "There was also a fire extinguisher in the corner, seats for the flight engineer and anyone else who needs to be here."

    pi "There's also a mirror. The door has a flap in it in case the door doesn't open when it should."

    pi "We also have a camera on the other side of the door, so if Dodgy Passenger from Aisle 15 thinks they can fly the plane better than us…"

    pi "…they won't embarrass themselves or stop us pilots from flying. The air crew stops them instead."

    $ hour += 1

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Thank the pilot and leave":

            a "Thank you for the tour around the cockpit. It was an honour to be invited."

            pi "My pleasure. Thank you again and have a wonderful time in Praha."

            "Alianora left the plane and airport, went to the bus stop, paid at the card machine and waited five minutes for her bus."

            $ money -= 400

            "Alianora now has [money] Forints remaining."

            "The bus journey was spent texting Szilvia about the exciting cockpit tour."

            $ szilvi += 1

            jump prahastation

        "Ask the pilot some questions":

            a "This is incredible. How was this evening's flight for you?"

            pi "It went well. Quite smooth as flights go, apart from the turbulence at the beginning."

            pi "Still, I'm looking forward to bed. I've flown twice today, back-to-back, and get most of tomorrow off as a result."

            pi "It's part of why I'm happy to do this tour now - this plane's not going much further tonight and neither am I."

            pi "What are you planning to do in Praha?"

            a "I'm going there to take a sleeper train to Budapest. I'm going to watch a motorsport race in Hungary."

            pi "That's exciting! I hope you have a brilliant time there."

            a "It's been an honour to visit. Thank you for showing me around your cockpit."

            a "I can tell how much you enjoy your job - no wonder you are so good at it."

            "The pilot's smile is gentle and broad."

            pi "Thank you for visiting us, and for helping to make the flight a happy one."

            scene boplanefront

            "Alianora thanked everyone, patted the plane in thanks as she disembarked and skipped through the now-silent baggage carousels."

            scene bobuspraha

            "She left the airport - and saw the bus she needed."

            menu:

                "Spoon count: [spoon], day: [day], hour: [hour], [money] Forints - Run for the bus":

                    jump airportpay

                "Wait for the next one":

                    $ a319delay = True

                    jump airportwait

    label airportwait:

    queue music "audio/KodalyKatonaVagyokEn.mp3"

    scene bobuspraha

    "There weren't many people at the bus station at all. Alianora got cooler and cooler as she waited alone."

    $ spoon -= 1

    if spoon >= 11:

        scene boticketmachine

        "After buying her bus ticket from the machine, Alianora passed the time by studying some basic Czech from her language book."

        $ money -= 400

        a "Hello - 'Dobry'den'. Goodbye - 'Na Sheldanou'. Please - 'Prosím'. Thank you - 'Dekuji Vam', which I hope I never need to type."

        a "Yes - 'Ano', and I must be careful to use that correctly. No - 'Ne'."

        $ spoon -= 1

    else:

        scene boticketmachine

        "Alianora bought her ticket from the ticket machine and jogged round the platform a few times to keep warm."

    if czech == True:

        "She could see from the schedule that there was one more bus to Praha city centre."

    else:

        "Even bus schedules in an unfamiliar language have a certain international content, accessible to a seasoned traveller like Alianora."

        "From the pattern, she could tell that there was one more bus to Praha city centre."

    "So Alianora did not wait in vain. An hour later, a big group of people filed in. Some were still queuing for tickets when the bus arrived."

    label airportbus:

    queue music "audio/DussekChasse.mp3"

    "Alianora spent the time before the bus arrived relaxing. She didn't feel like talking to the few other people waiting."

    "Being in the fading rays of the Czechian sun was something to savour in itself."

    jump airportpay

    label airportpay:

    scene boprahabus

    "Alianora steeled herself for the necessary conversation with the driver when she walked to the bus door."

    "She had the necessary Czechian Koruna with her."

    $ spoon -= 1

    $ money -= 600

    "Alianora now has the equivalent of [money] Forints remaining."

    scene bobus

    if czech == False:

        "On the bus, Alianora briefly flicked through the Czech section of her language book."

        "She did not know the language, but even a hazy recollection of a few words can help."

        a "Hello - 'Dobry'den'. Goodbye - 'Na Sheldanou'. Please - 'Prosím'. Thank you - 'Dekuji Vam', which I hope I never need to type."

        a "Yes - 'Ano', and I must be careful to use that correctly. No - 'Ne'."

        $ czech = True

    else:

        "The bus passed Czechian countryside, which you cannot see because it is now dark."

    "The bus stopped on the other side of the road to the train station."

    label prahastation:

    scene boprahatrain

    if hour <= 21:

        $ hour = 21

    else:

        pass

    "The bus and train station were all part of the same interchange. Alianora took a moment to absorb what was around her."

    "The crossing lights, the road markings, the cadence of the traffic were all subtly different."

    $ spoon -= 1

    "Alianora looked both ways and confidently strode across the street. She might have been new to the city, but she was a seasoned traveller."

    "Visible confidence is its own shield."

    scene botrainticket

    "In the train station part of the interchange, Alianora soon found the ticket processing area."

    if sleeperticket == True :

        "Her ticket was crisply folded into the top of her rucksack. Alianora got it scanned by the machine. Easy peasy."

        jump sleepertrain

    else:

        "Alianora felt for the ticket. But it wasn't there."

        a "What have I done?"

        "This was not in the plan at all!"

        $ spoon -= 2

        "Alianora had a backup plan - her laptop."

        jump helpdesk

    label helpdesk:

        scene bohelpdesk

        "She joined the helpdesk queue, turned her laptop on and looked for her ticket."

        if esleeperticket == True :

            "The ticket was on screen and displayed by the time Alianora reached the desk."

            hd "I am happy you are organised - you'd be surprised how few foreigners are…"

            if czech == True:

                a "Dekuji vam. Na sheldanou."

                "The helpdesk worker raised an eyebrow at Alianora also knowing some Czech. Even Alianora noticed."

                $ spoon += 1

            else:

                a "Thank you very much. Have a great evening."

            "Alianora walked away, turned a corner and took a deep breath."

            scene boprahacafe

            a "Phew! That was a lucky escape. Good thing you reminded me about my laptop earlier! I'm getting some chocolate before the train arrives."

            "There was a little corner stall opposite the help desk where Alianora was able to do exactly that."

            $ chocolate = True

            $ spoon += 1

            $ money -= 200

            "Alianora now has [money] Forints remaining."

            jump sleepertrain

        else:

            "Alianora's face became increasingly tense."

            a "I'm sure it was here… …I thought it was here…"

            a "…it's not here."

            $ spoon -=3

            hd "No ticket, no train. We've sold out."

            a "Now, what do I do?"

            menu:

                "Spoon count: [spoon], day: [day], hour: [hour] - Check if there is a copy in the email account":

                    jump cybercafe

                "Ask about the next train to Budapest":

                    jump nexttrain

    label cybercafe:

    # This is what happens if Alianora forgot to copy the file across and must brave the Czech keyboard layout in the computer café. CANON PATH

    scene bocybercafe

    "Alianora walked halfway down the interchange's long shopping concourse and turned right into an opulent lounge."

    "To the left was a screened area with the silhouettes of three suited passengers visible through the translucent door."

    "The right-hand side of the lounge had four computers - the nearest thing the interchange had to a cybercafe."

    "Between them was a large wooden disk with pillars on either side. It looked 19th-century, but was strewn with tech."

    if a319delay == True or hour >= 22:

        "There was nobody at the desk and all the computers were off."

        "It was not clear why the three people were still there, but this lounge was closed."

        jump nexttrain

    elif czech == True:

        a "Prosim can I use a computer to check my email for my train ticket?"

        "The lounge supervisor cringed at the mixed grammar."

        ls "The first word was Czech, but that does not make a Czech sentence."

        "Ano."

        ls "The lounge closes at 10:30. Please be finished before that time."

    else:

        a "Please can I use a computer to check my email for my train ticket?"

        ls "Have you got your train ticket? Paid customers only."

        a "Sorry, I'm here to print it out."

        "The lounge supervisor squinted."

        ls "I'm keeping an eye on you. Get it done. Before 10:30, because we shut then."

        "Alianora took her bag to the nearest computer. She loaded the computer."

        "For the last four years, she'd been a troubleshooter for other people's computer problems, and icons are international."

        "Unfortunately, so are email passwords. The keyboard layout… …not so much."

        "This layout is daunting and some of the needed characters are not in obvious locations."

    if spoon >= 15:

        "Alianora remembered a tip she'd seen on the internet."

        a "If I hold the Alt key and type 0, then 9, then 3, I will get the square bracket close symbol."

        a "I'll need that as part of my email password."

        "She confidently typed in her entire password and obtained her e-ticket. She printed off a copy, just to be sure."

        $ esleeperticket = True

        $ sleeperticket = True

        $ spoon += 1

        "With a look of triumph, Alianora turned off the computer. She thanked the lounge supervisor and showed her the e-ticket."

        ls "Good. Safe journey."

        jump helpdesk

    else:

        "Alianora tried to log into her email, but it was difficult on a keyboard she did not recognise. Some luck may have been needed."

        # Randomize between 1 and 4

        $ randomnum = renpy.random.randint(1,4)

        if randomnum == 1:

            "Alianora paused for a moment to consider her options. She could try Unicode. Now if she can remember the right one…"

            "…yes! The first attempt was correct, and Alianora was able to get her e-ticket. She printed off a paper ticket too, just in case."

            $ esleeperticket = True

            $ sleeperticket = True

            if czech == True:

                a "Prosim. Thank you."

                ls "Ano. Yes. Safe journey."

            else:

                a "Thank you."

                ls "Good. Safe journey."

            jump helpdesk

        elif randomnum == 2:

            "Alianora paused for a moment to consider her options. She could try Unicode. Now if she can remember the right one…"

            $ spoon -= 1

            "No. That did not work out. Perhaps if she checked the internet for the correct code?"

            "Ah, yes. Much better idea. Now hold down Alt, Alianora, and try typing in 0, 9 and 3 in that order. Yes, much better."

            "The e-ticket was promptly added to the laptop. Alianora nodded to the lounge supervisor as she left."

            $ esleeperticket = True

            jump helpdesk

        elif randomnum == 3:

            "Alianora did not remember the correct code, but thought she could figure out which keys provided the close square bracket…"

            $ spoon -= 2

            "It took three goes, but Alianora finally managed to load her e-ticket."

            "She put it on her laptop and returned to the helpdesk."

            $ esleeperticket = True

            jump helpdesk

        else:

            "Try as she might, Alianora could not log into her email account. Eventually, it locked out."

            $ spoon -= 3

            $ emaillock = True

            "Suppressing a scream with limited success, Alianora turned off the computer."

            "She picked up her rucksack and stomped off to the helpdesk to buy a replacement ticket. After she left…"

            ls "Now that's gratitude. Not."

            "Let us hope she does not pass on those bad vibes Alianora gave her to anybody else."

            jump nexttrain

        # LEARNED how to get symbols on a Czech keyboard. (This section needs an if [symbol knowledge] = True, then success, and a random chance otherwise -
        # also done).

    label nexttrain:

    scene bohelpdesk

    hd "The next train is at 5:22 am. I will sell you a ticket…"

    "The help desk worker quoted a large figure in Czech Koruna."

    "Alianora pointed at the fingers of her left hand a few times, miming the use of a calculator."

    a "That is £59 in British pounds sterling. Given my situation, I will pay. Here is my card."

    $ money -= 14750

    if czech == True:

        a "Dekuji vam. Na sheldamou."

    else:

        a "Thank you very much, and sorry to trouble you. Enjoy your evening."

    scene boprahacafe

    "Alianora stepped away from the desk and found a quiet corner of the interchange."

    a "That was a lot of money I did not want to pay, and all because I forgot to print my ticket. Argh!"

    "Now Alianora has only the equivalent of [money] Forints remaining."

    $ spoon -= 2

    "Alianora looked round the interchange. At this late hour, it was still possible to eat a sandwich at the one open restaurant."

    "She could read for an hour before the interchange closed. Alternatively, she could start exploring."

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour], [money] Forints - Eat a sandwich":

            jump sandwich

        "Read for an hour":

            jump readhour

        "Explore Praha":

            jump praha

    label sandwich:

    # LEARNED what would be a plausible sandwich for this setting that I would wish to eat.

    scene boprahatable

    "The sandwich bar was not a big international chain, but a cosy place."

    "The decor was completely in keeping with the cavernous 19th-century decor of the interchange."

    "Alianora sat down and ordered a turkey burger with cabbage salad and chips."

    $ money -= 2352

    "The turkey was moist and chewy, with gentle paprika spice providing just the right amount of accent."

    "The chips were crisp and the cabbage salad plentiful. Alianora was very happy with her meal."

    $ spoon += 3

    $ hour += 1

    "After that very satisfying burger, Alianora left for the city centre."

    jump prada

    label readhour:

    # Alianora reading for an hour in Praha interchange. CANON PATH.

    scene boalcove

    "Praha's interchange was huge and historic, with few people away from the busier spots."

    "Alianora enjoyed looking for somewhere quiet to sit."

    "She found a recessed area with a view of a winding art deco staircase."

    if magazine == False:

        "For the next hour, Alianora read the motorsport magazine she'd brought with her, and thoroughly enjoyed it."

        $ spoon += 2

        $ magazine = True

    else:

        "Having finished the magazine, Alianora needed something else to read."

        "However, the only thing to read was the language book - and that looked too much like hard work."

        "Having not seen anywhere with reading material in English, she texted her parents and Szilvia, and watched the world go by."

        $ home += 1

        $ szilvi += 1

        $ spoon += 1

    scene bokindertransport

    "On the way out, Alianora found Jan Hunat's Kindertransport Farewell Memorial."

    "A fifteen-feet glass relief of children's and adults' hands on either side of a train door was installed the previous year."

    "The whole was framed by a soft yellow light, reflected by the metallic surface."

    "It told a story of courage, love and loss. For this is what it means to leave without believing that a return is possible."

    "Praha Station was one of the starting points for the Kindertransport in the late 1930s."

    "It was a system for getting unaccompanied Jewish children out of Nazi-controlled land and to safer countries."

    a "The memorial is fitting. So beautiful, and so sad…"

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Linger at the Farewell Memorial":

            jump farewellmemorial

        "Continue to Praha city centre":

            jump praha

    label farewellmemorial:

    scene bokindertransport

    $ renpy.music.set_pause(True, channel='music')

    "The entire space invited silence. Only the reflected sounds of evening passengers on the platforms disturbed thought here."

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Listen to Alianora talk about the Kindertransport":

            jump farewellrecall

        "Have some silence":

            jump farewellexit

    label farewellrecall:

    scene bokindertransport

    "After some time, Alianora started whispering what she recalled from her history books."

    a "There were several Kindertransport routes from Germany, Poland, Austria, Slovakia - and here in Czechia."

    a "This one didn't send the most children - that was Geertruida Wijsmuller-Meijer's Vienna service - but is the best-known in Britain."

    a "Organised by Sir Nicholas Winton, this Kindertransport sent homeless, orphaned and other at-risk Jewish children."

    a "They left Praha from this station and went to Liverpool Station in London. Eight trains. 669 children."

    a "There should have been a ninth train - but that tried to leave on the day Germany invaded Poland, and was turned back."

    a "Only two children on the ninth train survived the war - the Nazis murdered the rest, one way or another."

    a "However, it was not only Jewish children the Nazis wanted to kill."

    a "Their deliberate dystopia left no room for those who believed, thought, lived differently to them."

    a "Most of the parents of these Jewish children died in concentration camps during World War II."

    a "When the war ended, most of the Kindertransport children chose to stay away, instead making new lives in their adopted countries."

    a "The majority went to Britain, which created a document that allowed Kindertransport children to skip its over-strict immigration rules."

    a "Some went to Canada. It was difficult to place them elsewhere because few countries wanted Jews."

    a "That is not to say the rules were liberal. The government required British sponsors to raise £50 per child."

    a "£50 in those days was about 18 weeks' wages for a farm worker. Why? A guarantee of the children's eventual return to their homelands."

    a "A return which most children never experienced."

    a "Also, some Jewish children were preferred over others."

    a "The British sponsors were allowed to show some preference for those who looked like they would adapt easily to British society."

    a "This meant the able-bodied and conventionally clever."

    a "Someone like me would not have been allowed on the Kindertransport, even had I been Jewish."

    a "Granted, it was impossible to take everyone in danger."

    a "Still, I am sad for everyone who could not join the Kindertransport and suffered because they were in the wrong vulnerable group…"

    a "…or were too old, disabled or were thought to be too much trouble."

    a "Above all, shame on those Nazis whose evil actions forced the Kindertransport to exist in the first place!"

    a "As for those who still think the Nazis had a point, or who harm the memory of those they killed and divided…"

    a "…may they have insight into the error of their ways and change for the better."

    label farewellexit:

    scene bokindertransport

    "Alianora stopped speaking and knelt in prayer. A minute's silence for all the needless suffering of that age."

    "Then, Alianora stood, bowed her head again for a moment, and walked into the night."

    $ renpy.music.set_pause(False, channel='music')

    label praha:

    # Alianora crossing the street and finding the street food stall. CANON PATH.

    scene bowencelassquare

    "After checking for traffic (still considerable despite the late hour), Alianora crossed the street."

    "Pavements were still well-lit, people were still walking around and it felt very safe."

    a "I'm a little peckish. Let's see if there is some local food around."

    "It doesn't take much finding. A little blue stall at the top of the next side street attracts Alianora's eye."

    a "Ooh! Czechian street food!"

    scene bofriedcheese

    "An old man watched a golden-brown oval lump gently frying on a worn grill. Occasionally he turned it."

    if czech == True:

        a "Prosím may I buy a fried cheese sandwich?"

    else:

        a "Please may I buy a fried cheese sandwich?"

        gc "Ano."

        a "Please, do you mean 'yes' or 'no'?"

        "The sandwich seller nodded."

    "Alianora paid 3 Koruna for her authentic street food - a fried cheese sandwich."

    $ money -= 245

    "The man grilled the cheese first, then fried it with some onions while grilling the undersides of the bread."

    "Then, he put them all together."

    if czech == True:

        a "'Dekuji Vam, Na Sheldanou. Thank you and goodbye."

    else:

        a "Thank you and goodbye."

    $ day = 2

    scene bowencelassquare

    "With a fried cheese snadwich in one hand, [money] Forints remaining and her phone in the other…"

    "What would you advise Alianora to do now?"

    # FINDOUT how to create a conditional menu item.

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Call parents":

            jump callpraha

        "Text parents" if home == 0:

            jump textpraha

        "Just enjoy the sandwich" if home >= 0:

            a "No need to make my parents worry. They already know I'm here."

            "Alianora put the phone down and ate her food, which she thoroughly enjoyed, and then set out to explore."

            $ spoon += 3

            jump explorepraha

        "Ask Alianora's Advice":

            jump aaa2


    label aaa2:

    if home == 0:

        a "It can be awkward to admit to mistakes, but my parents will find out about this anyway, when I tell them on my return home."

        a "What's the use of a good adventure if one cannot share it - problems and all? Why be evasive?"

        a "Part of the reason I travel is to learn things, and I learned something really important today - keep my travel documents with me!"

        a "So, instead of hiding that, I think I should tell them what I did wrong - and how I fixed my problem."

    else:

        a "My parents already know I missed the train. I am sure they would like to know I will eventually reach Budapest."

    a "Then, I can enjoy a night out in Praha!"

    a "Which is not a sentence I thought I would ever say, since I was only planning to be here 90 minutes."

    a "Also, I usually hate nightlife. So noisy!"

    jump praha

    label callpraha:

    # Night in Praha, calling home while holding a fried cheese street food item thingy. CANON PATH PART 2

    "Alianora typed in her parents' number, thankful that there was plenty of credit on her phone."

    a "Hello, it's Alianora."

    d "I can tell it's alianora. How are you?"

    a "I'm OK. I've missed the sleeper train…"

    if home == 1:

        d "I gathered."

    else:

        d "That's a shame. What are you going to do now?"

    a "I've been to the ticket office and got a ticket for tomorrow morning. I will leave at 5:22 am."

    d "At least you have a plan."

    a "Yes. I'm going to try to make the most of my night in Prague. Starting with this fried cheese sandwich."

    "You could hear Alianora's Dad laughing."

    d "Right! Have a good night. Love you!"

    a "Good night, love you!"

    $ spoon += 1

    $ home += 2

    a "Yes, I keep calling the capital of Czechia 'Praha' when most English people call it the English name of 'Prague'."

    a "For that matter, lots of them would say I'm in the Czech Republic, despite quiz shows trying to teach otherwise."

    a "However, locally, this place is known as Praha in Czechia."

    a "I like to at least try to think of places as their actual name, and remember to 'translate' as necessary."

    jump explorepraha

    label textpraha:

    # Alianora sends a text message about the situation.

    "Alianora's thumbs flew over the old-style purple keyboard, which required four presses to create a small letter 's'."

    "In Prague, but have missed my train. Instead, I'll travel 5:22 am tomorrow. Now, I am eating a fried cheese sandwich. Goodnight. Love you."

    a "'Prague' is English for 'Praha'. I've simply got so used to seeing the Czechian way that I struggle to think of it by its English name."

    a "But my parents only know it as 'Prague'."

    a "The same thing happens to me with 'Roma', or as English people usually say when football isn't involved, 'Rome'."

    $ home += 1

    label explorepraha:

    # Exploration after the street food stall.

    if hour == 24:

        $ day = 2

        $ hour = 0

    elif hour == 4:

        scene boexepark

        "Alianora, happy with how her evening had passed, walked to the park by the side of the train station."

        "She watched the sun rise from a park bench."

        $ spoon += 1

        scene boprahatrain

        "After that, she went to the train station. The main hall was now remarkably busy."

        "However, the side passage to Platform 1 was much less used."

        scene bokindertransport

        "Alianora quickly paid her respects to the Kindertransport Farewell memorial memorial as she passed."

        scene boplatform1

        "She noticed another memorial on the platform itself - even past all those people."

        "It was a statue of two children with Sir Nicholas Winton - the organiser of the Praha Kindertransport."

        scene bosleepercorridor

        "With that, Alianora stepped onto the train and found her carriage. The train was well-organised and she found this easy to do."

        jump sleepertrain

    "What should Alianora do next?"

    # LEARNED how to do a contingent menu option.

    scene boprahabench

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour], [money] Forints - Walk around the city":

            jump walkpraha

        "Look at the miniature train museum" if hour == 0 or day == 1:

            jump minitrain

        "Relax on a bench":

            jump prahabench

        "Visit the fast food shop with internet":

            jump fastfood

    label minitrain:

    # LEARNED what the inside of the miniature train museum looks like.

    scene bominitrain

    "Alianora, fresh from eating the fried cheese sandwich, discovered a little museum. It contained a miniature railway!"

    "She had a pleasant time looking at the little trains and staring over the main track with its view of the square."

    "Then the museum closed and she returned to the square."

    $ spoon += 1

    $ day = 2

    $ hour = 1

    jump explorepraha

    label walkpraha:

    if hour == 0:

        scene boprahabench

        "Alianora walked down the side street and then saw Wencelas Square."

        scene bowencstatue

        "She sat down, took a drink from her water bottle… …and saw some American tourists."

        sa "Nice to meet you! I'm Sandra."

        be "I'm Ben. We're from America."

        a "I'm from Derbyshire, in the United Kingdom."

        sa "We're in Prague for a two-week vacation. How about you?"

        a "About six hours."

        be "Seriously?"

        if spoon >= 12:

            a "I missed my train. Otherwise I'd only get to be here for 90 minutes… …so, it could be worse!"

        else:

            a "My train leaves at 5:22 am."

        sa "But you'll miss everything!"

        be "Let's go to a club."

        a "Sounds cool, if I don't repeat the pie incident…"

        menu:

            "Spoon count: [spoon], day: [day], hour: [hour], [money] Forints - Pie incident?":

                jump pieincident

            "We should go to the club.":

                jump goclub

            "Tell them why you don't go to clubs.":

                jump noclub

    elif hour == 1:

        scene boprahabench

        "Alianora wandered down the side street and through the city centre. Eventually, she found some abstract art."

        scene boabstract

        "The sculpture of geometric shapes was pleasant on the eye. Alianora spent a while on a bench, looking at it."

        "Then she returned to the square from which she started."

        $ hour += 2

        $ spoon += 2

        jump explorepraha

    elif hour == 2:

        scene boprahabench

        "People were starting to leave the clubs. Alianora decided to stroll along the route taken by some of the city's trams."

        scene bopowdertower

        "This took her around quite a lot of the city centre."

        "All the cultural places were closed, but the architecture of the city was memorable - and invigorating."

        $ hour += 2

        $ spoon += 2

        jump explorepraha

    else:

        scene boprahabench

        "Alianora decided not to walk anywhere, despite your suggestion. It was too close to the time the station re-opened."

        "Instead, she bought some chocolate from a tiny 24-hour grocery, then went to the fast food place on the square."

        $ chocolate = True

        $ money -= 70

        "She went there with the equivalent of [money] Forints."

        jump fastfood

    label prahabench:

    if hour == 0:

        scene boprahabench

        "There were several benches on the square."

        "Alianora chose one at the end of the square furthrest from the train station, where she could watch the world go by."

        "Alianora was feeling really relaxed until some drunk people showed up and started arguing with police."

        "She decided to move elsewhere."

        $ spoon -= 2

        $ hour += 1

        "Ugh, drunkeness can make people just as rude wherever they are in the world."

        "She kept walking until she found some fellow tourists."

        sa "Hi! I'm Sandra."

        be "I am Ben, and we're from America."

        sa "We'll be here for two weeks. How long's your trip?"

        a "Um… …here? About six hours."

        be "Seriously?"

        sa "But you'll miss out!"

        be "There's a club we should really check out."

        a "It sounds intriguing, but I don't want to repeat the pie incident…"

        menu:

            "Spoon count: [spoon], day: [day], hour: [hour] - Pie incident?":

                jump pieincident

            "We should go to the club.":

                jump goclub

            "Advise Alianora to say why she doesn't go to clubs.":

                jump noclub

    elif hour == 3:

        scene boprahabench

        "Alianora spent an hour watching the world go by. It was peaceful now that the crowds had dispersed."

        $ spoon += 2

        $ hour = 4

        jump explorepraha

    else:

        scene boprahabench

        "Alianora watched people going from club to late-night takeaway."

        "It was far more civilised than the pub crawls she remembered seeing - and hearing - from her flat."

        a "Where I come from, nightlife means young people trying to get drunk and inadvertently causing all sorts of trouble."

        a "It never feels safe and even if I sleep, sometimes they wake me up with their noise."

        a "I am sure they mean well but Praha feels as safe now as it does in some other places during the daytime."

        a "There's a balance to be struck."

        "It occurred to Alianora that this might be a good time to catch up with what was on the internet."

        "Even at this time of day …um, night… there was a fast food shop with free Wi-Fi."

        $ spoon += 1

        $ hour += 1

        jump fastfood

    label pieincident:

    "Alianora sighed."

    a "Last Christmas, some colleagues and I went to celebrate Christmas with a pie-and-pea supper."

    a "Unfortunately, the pub was really noisy, and I forgot my ear defenders."

    sa "First time I've heard of people bringing ear defenders to a supper."

    be "Were you eating on a building site?"

    a "It was in a pub. Not one being renovated."

    sa "Ah."

    a "I got a headache and couldn't tell what was happening. I tried to leave, but it was too busy, and I collapsed."

    be "Whoa!"

    a "An ambulance was summoned. Fortunately I recovered while they were loading me onto the ambulance."

    be "No wonder you do not want to repeat it."

    a "I didn't even get to eat my pie…"

    $ spoon -= 1

    sa "Have you brought any ear defenders?"

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour], [money] Forints - Yes, and I will use them at the club.":

            jump goclub

        "Yes, but I don't want to risk it.":

            jump noclub

    label goclub:

        a "I'm going to find out what the Prague nightlife is like!"

        sa "That's the spirit!"

        be "Happy to have you with us, Alia!"

        "Everyone, now friends, walked to one of the local clubs. Alianora sported a pair of bright yellow ear defenders, which turned heads."

        scene bojerome

        a "'The Jerome Club'. I wonder if he would have approved of this place, had he known of it?"

        be "Probably not. Still, he's not here and we are."

        sa "Let's dance!"

        "Alianora glances at the gate inside the door."

        if spoons <= 10:

            "The noise was remarkably loud, even with the ear defenders."

            a "I think I'll dance outside."

            sa "Will you be OK?"

            a "Certainly. Have lots of fun!"

            "Alianora waved goodbye to Sandra and Ben."

            "Much to the bouncer's amusement, Alianora spent the next 45 minutes dancing to the beat."

            a "That was fun! It was good to meet some new people and I like some of the Czechian club music."

            "Alianora walked back to the square."

            $ hour = 2

            $ spoon += 1

            jump explorepraha

        else:

            a "Let's pay first."

        scene bojeromepay

        $ money -= 2500

        if czech == True:

            "Dekuji Vam."

            be "You know Czech? I'm impressed."

            a "I like to learn something of how to speak before I go anywhere…"

            menu:

                "Spoon count: [spoon], day: [day], hour: [hour] - …because I think it's polite.":

                    jump polite

                "…and I have a book to help me.":

                    jump languagehelp

                "…though 'something' is a key word in that sentence.":

                    jump somethingkey

        else:

            "Thank you."

            "The decisive rhythm of Lenny could be felt as much as heard, but Alianora was prepared."

            jump prahadance

    label noclub:

    a "Unfortunately, I have to be careful. I don't know if the ambulance will be as forgiving next time."

    "Sandra and Ben nod, apparently understanding, but you feel disappointment in the hazy summer air."

    be "Have a nice evening!"

    "You go your separate ways, they to the club, you back to the square."

    scene boprahabench

    $ hour = 1

    jump explorepraha

    label polite:

    sa "Well, I tried, but…"

    "Alianora's expression froze. You suspect she did not intend to make anyone feel awkward - but Sandra certainly does."

    sa "But…"

    be "Sorry. I don't like this."

    "Ben goes to dance."

    a "Sorry. My tongue got ahead of me."

    $ spoon -= 2

    sa "I don't think you meant to be rude…"

    if spoon >= 13:

        "Alianora kept her tongue still."

        sa "…but you could have handled that better."

        a "Agreed. Thank you for correcting me."

        sa "Shall we dance?"

        a "Good idea."

        "Alianora handed over her rucksack, because the club didn't allow large bags on the dance floor."

        $ rucksack = False

        "Then, Sandra and Alianora rejoined Ben in the club."

        jump prahadance

    else:

        a "No I didn't!"

        sa "…but you can't help yourself, I guess. I'm off!"

        "Sandra stomped away without a backward glance. The music was painfully loud after that conversational trouble."

        "You leave and return to the square."

        scene boprahasquare

        $ spoon -= 1

        $ hour += 1

        jump explorepraha

    label languagehelp:

    "Alianora took the language book out of her bag."

    be "Cool!"

    "Sandra and Ben briefly look at it, before the bouncer tells everyone off for blocking the doorway."

    a "Sorry, sir."

    "Alianora hands over her rucksack as well, for it was not allowed on the dance floor. She kept hold of the book though."

    $ rucksack = False

    scene bojeromedance

    "Alianora, Sandra and Ben move to the edge of the dance floor. Sandra has to raise her voice somewhat to be heard."

    sa "That was worth getting told off for!"

    be "Did you just apologise in English?"

    a "Yes. My Czech has limits."

    sa "Keep trying - I've barely figured out 'Prosím', and even that helps."

    be "Prosím can we swap phone numbers?"

    "Everyone laughs, and numbers are swapped."

    $ sabe = 1

    jump prahadance

    label somethingkey:

    a "I know 6 words in a dozen languages. I just hope they're the right 6."

    sa "A few words go a long way sometimes."

    a "True. I'll just put my rucksack in the cloakroom - I can't charm anyone by dancing in a rucksack."

    $ rucksack = False

    be "Well, you charmed the socks off the bouncer; that's a good start!"

    "The bouncer is looking in your general direction. While he doesn't seem bothered, he doesn't look very 'charmed' either."

    a "He's not upset with us; that will do. Shall we dance?"

    sa "I'd like to swap numbers first, please."

    "Swap phone numbers they did. It's nice to have new friends."

    $ spoon += 1

    $ sabe = 1

    jump prahadance

    label prahadance:

    scene bojeromedance

    "There's a mixture of local Czechian talent and American/British hits, so everyone in the club is happy with the music choices."

    "You dance and dance and dance. Alianora carefully avoids the alcoholic choices, though Sandra and Ben have a cocktail each."

    "Fortunately, neither appears to have the least interest in getting drunk, and both know their limits - like everyone else in this club."

    "It is a superb experience, and when the club closes at 3 am, you feel like your boundaries have expanded."

    $ rucksack = True

    $ spoon += 4

    $ hour = 3

    jump explorepraha

    label fastfood:

    if prahafast == True:

        scene bofastfood

        "This fast food restaurant is for a popular international chain. It even has a branch in Alianora's hometown! So why did she enter?"

        a "Free Wi-Fi! I can browse the internet, check my emails and keep track of time."

        "Of course, Alianora must buy some food first."

        $ money -= 379

        "The burger and chips here would not be as tasty as the fried cheese sandwich Alianora ate earlier…"

        "…so she picked a salad with fish and a milkshake."

        a "Because everyone knows a milkshake is healthy if it is eaten with fish and vegetables!"

        "The tables are half-full, which is a surprise."

        ff "It's the free internet. It's amazing how many people are hungry after midnight when the World Wide Web awaits."

        "Alianora carefully removes her little rugged laptop from her luggage and sets it on the table."

        jump fastinternet

    else:


        scene boprahabench

        "Going back to a place where Alianora had upset so many people does not seem like a good idea to her. She rejects your suggestion."

        jump explorepraha

    label fastinternet:

    scene bolaptop

    "What should Alianora do on the laptop?"

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Check her emails.":

            jump prahaemails

        "Check her social media.":

            jump prahasocmed

        "Find out the racing news.":

            jump praharacing

        "Play a computer game.":

            jump prahagame

    label prahaemails:

    if emaillock == True:

        scene bolaptop

        "Unfortunately, Alianora cannot access her email right now because it is locked."

        "She will need to unlock it using her alternate email address."

        "According to her security training, Alianora cannot perform the unlock on a public Wi-Fi system. If her bosses knew, she could lose her job."

        "It's a risk Alianora won't take."

        menu:

            "Spoon count: [spoon], day: [day], hour: [hour] - Play a computer game.":

                jump prahagame

            "Check her social media.":

                jump prahasocmed

            "Find out the racing news.":

                jump praharacing

            "Explore the rest of the city.":

                jump explorepraha

    else:

        scene bolaptop

        "Alianora logged into her emails."

        if email == False:

            "There were no new emails that warranted Alianora's attention. She smiled and considered her next move."

        else:

            tm "Favourite Racing Team: Preview"

            tm "Motor Racing History About To Be Made"

            "Alianora read about the race she was about to attend, and followed up on a couple of leads she could see. Nothing obvious."

            $ hour += 1

            $ email = False

            $ raceknow += 1

            if raceknow >= 2:

                "Alianora did, however, start to get the feeling there was something more going on than was expressed on the surface…"

            else:

                pass

        "There are only a few more emails left. Should Alianora read any?"

        menu:

            "Spoon count: [spoon], day: [day], hour: [hour] - Learn a Programming Language Today!":

                a "This sounds exciting! Perhaps learning a new programming language can help me in my work…"

                "Learning a programming language takes time, however. There is only time to learn a basic program before it is time to leave Praha."

                $ spoon -= 1

                $ programming += 3

                $ hour = 4

                jump explorepraha

            "Problems On the Chagos Islands!":

                "Ugh, this is really bad news. Nothing that Alianora can action either. She is sad for a few moments, then logs out of her email."

                $ spoon -= 1

                jump fastinternet

            "Running Races This Year:":

                a "I like running! I like racing, too."

                a "For the last two years, I've been the slowest runner in the town half-marathon, and raised money for charity too."

                a "While it's too short notice to raise money, the Night Run Budapest is on the Saturday night after the race I'm due to watch."

                a "I could fly back the day after and still get to work before my holiday ends."

                a "I'm too late to sign up for the half-marathon, but running that far? In a likely heatwave? For someone like me?"

                a "A half-marathon would have been unwise. The shorter race is still taking entries, though."

                a "Shall I sign up for the 9 km race?"

                menu:

                    "Spoon count: [spoon], day: [day], hour: [hour], [money] Forints - Yes, running is good for you.":

                        a "Thank you!"

                        $ spoon += 2

                        $ runknow = True

                        $ money -= 2250

                        $ hour += 1

                    "No, please save your energy.":

                        a "OK, I will do as you ask."

            "No, they're probably spam. Let's leave.":

                jump explorepraha

        if hour == 4:

            "It was time for Alianora to turn off her laptop and leave Praha."

            jump explorepraha

        else:

            menu:

                "Spoon count: [spoon], day: [day], hour: [hour] - Play a computer game.":

                    jump prahagame

                "Check her social media.":

                    jump prahasocmed

                "Find out the racing news.":

                    jump praharacing

                "Explore the rest of the cit.":

                    jump explorepraha

    label prahasocialmed:

    scene bolaptop

    "You excitedly tell all your social media friends that you are looking forward to seeing your favourite cars and drivers compete."

    $ hour += 1

    if hour <= 4:

        "There are two more things Alianora can do on social media right now."

        "Alianora can invite a journalist friend to dinner, or respond to a coach friend's message about meditation."

        if hour <= 3:

            "Indeed, Alianora has time to do both if she wishes!"

        else:

            pass

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Invite the journalist to dinner.":

            jump invitejournalist

        "Respond to meditation message.":

            jump meditationmessage

        "Both invite journalist and respond to meditator." if hour <= 3:

            jump inviterespond

        "Exit social media.":

            jump fastinternet

    label invitejournalist:

    scene bolaptop

    "Alianora quickly sent an email to her journalist friend, eager to discuss motor racing when there was time."

    "She had to word it carefully, though."

    $ spoon -= 1

    $ journalist += 1

    jump fastinternet

    label meditationmessage:

    scene bolaptop

    "Alianora writes to her meditating friend, responding to each of the points on the message."

    "They seek understanding together, connected by the internet."

    $ meditator += 1

    jump fastinternet

    label inviterespond:

    scene bolaptop

    if hour >= 3:

        "Unfortunately, Alianora has run out of time to use the internet in Praha. Time to meet the train. How disappointing!"

        $ spoon -= 1

        jump explorepraha

    else:

        "Alianora carefully wrote an appropriate invite to the journalist and a careful response to the meditator."

        "While there were some challenges, working on both seemed to help create better messages."

        $ spoon -= 2

        $ journalist += 2

        $ meditator += 2

        jump explorepraha

    label praharacing:

    scene bolaptop

    "It's the typical race previews and anticipation, mixed with people looking forward to their summer holidays. Long season."

    $ raceknow += 1

    if raceknow >= 2:

        "Alianora had a suspicion, however, that something more was afoot."

        "You can't quite figure out what yet, but Alianora is determined to discover the secret."

        "Perhaps it will take a few days or weeks to understand what's nagging you, but Alianora recognised a good mystery when she found one."

        $ spoon += 1

        $ hour += 1

    else:

        pass

    jump fastinternet

    label prahagame:

    scene bolaptop

    "Alianora loaded a business simulation game that she thoroughly enjoyed. This kept her occupied all night."

    if hour == 3:

        "She played long enough to set up some basic money-making routes."

        $ simulation = 1953

        $ spoon += 1

        $ hour = 4

        jump explorepraha

    elif hour == 2:

        "She managed to set up some basic routes…"

        if spoon >= 8:

            "…and found these made a good profit."

            $ simulation = 1956

            $ spoon += 3

            $ hour = 4

            jump explorepraha

        elif spoon >= 4:

            "…and some of them did not work very well. More thinking needed!"

            "Alianora ordered a vegetarian burger and an orange juice, hoping this would help."

            $ money -= 279

            "Alianora now has the equivalent of [money] Forints."

            "She made a note in the game about what she needed to do next, briefly looked at her laptop wallpaper and switched off the laptop."

            $ simulation = 1956

            $ spoon += 1

            $ hour = 4

            jump explorepraha

        else:

            "…and her company went bankrupt! Alianora was so frustrated."

            $ bankrupt = True

            $ spoon -= 1

            if spoon >= 0:

                "But Alianora remembered where she was and tried to calm herself. She did so by turning off her game and staring at her wallpaper."

                "This had a set of six wallpapers depicting one of the racing drivers Alianora most admired, which changed every few minutes."

                "She thought about that driver's character, how kind, calm and patient they were, and gradually felt better."

                $ spoon = 5

                $ hour = 4

                jump explorepraha

            else:

                "Alianora closed her laptop with a growl."

                "Everyone turned to face her. She got a strange look on her face."

                "Quickly packing her bag, Alianora suppressed a desire to explode in anger."

                "She fled to a bench in the square and took a breath."

                $ prahafast = False

                $ hour += 1

                jump explorepraha

    else:

        if spoon <= 10:

            "Alianora managed to not only build some basic, profitable routes, but set up a subsidy route."

            "She also took great pleasure in creating a longer train that went halfway across the map."

            a "This train is travelling as far as I will!"

            $ simulation = 1960

            $ spoon += 5

            $ hour = 4

            jump explorepraha

        else:

            "The simulated company went well for a while, but it then became tedious to run it further."

            a "Games are fun in moderation, but it is good to do other things too."

            $ simulation = 1955

            $ spoon += 1

            $ hour += 1

            if hour = 4:

                "It was time for Alianora to leave Praha and board a real train."

                jump explorepraha

            else:

                "Alianora still had time for other activities while in Praha."

                menu:

                    "Spoon count: [spoon], day: [day], hour: [hour] - Check her emails.":

                        jump prahaemails

                    "Check her social media.":

                        jump prahasocmed

                    "Find out the racing news.":

                        jump praharacing

                    "Explore the rest of the city.":

                        jump explorepraha

    label sleepertrain:

    # Evening on the sleeper train.

    play music "audio/lisztC21M.mp3"
    queue music "audio/lisztC2M2.mp3"
    queue music "audio/lisztC2M3.mp3"
    queue music "audio/lisztC24M.mp3"

    scene bosleepercorridor

    $ renpy.music.set_pause(False, channel='music')

    "What are sleeper trains best for? Sleeping!"

    $ spoon += 12

    $ hour += 6

    scene bobudahills

    $ renpy.music.set_pause(True, channel='music')

    "Alianora awoke shortly before arrival into Budapest."

    scene gsbudahills

    "The rolling hills looked like they could have been beautiful…"

    scene cobudahills

    "…once the grass had been given a long, steady drink."

    scene vibudahills

    if secondaryinf == True:

        a "Oh good! That long sleep on the train has sorted out my secondary inf…"

        a "…whatever that error message in the Decision-Making Interface said was being maintained."

        tm "Scheduled maintenance on the inferior temporal gyrus secondary neural pathway complete."

        tm "Full detail and colour should now be available to the Decision-Making Commitee…"

        tm "…Subject to adequete discretionary energy continuing to be provisioned."

        a "In plainer English: the problem that was only allowing you to see black outlines has been fixed."

        a "If I look after myself properly, you'll get to see what I see, in full colour. Good decisions from you will help."

        a "You've done well so far. Let's continue like that!"

    else:

        a "It's nice to wake up on the right side of bed."

        tm "There is a wall on the other side."

        a "Um, thanks. That was the Decision-Making Interface warning system."

        a "It likes to be either Captain Obvious or Captain Convoluted."

    if spoon >= 12:

        scene vibudaplatform

    elif spoon >= 8:

        scene cobudaplatform

    elif spoon >= 4:

        scene gsbudaplatform

    else:

        scene bobudaplatform

    "She got her bag and stepped onto the platform. Alianora had to proceed carefully, as there were people everywhere."

    $ spoon -= 1

    if spoon >= 12:

        scene vibudaplatform

    elif spoon >= 8:

        scene cobudaplatform

    elif spoon >= 4:

        scene gsbudaplatform

    else:

        scene bobudaplatform

    jump ticketchoice

    label ticketchoice:

    a "Now, there is a ticket station for the Budapest metro round here somewhere."

    a "I can spend 5950 Hungarian Forints on a week-long metro ticket."

    a "That will let me travel round the city for free, or to the track (which is 16 km away) and back for 250 Forints."

    a "On the other hand, 5950 Forints might be a lot of money if I am not going to travel much."

    a "There is supposed to be a free bus at the edge of Budapest on the days the motor race runs…"

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour], [money] Forints - Buy the ticket":

            jump buymetro

        "Leave the station":

            $ persistent.arrivebudapesttrain = True

            jump leavestation

    label buymetro:

    "More dodging of people was required, to get to the ticket station."

    if hungarian == False and kerem == False:

        a "Ouch! Please don't elbow me!"

        $ spoon -=4

        if spoon >= 12:

            scene vibudaplatform

        elif spoon >= 8:

            scene cobudaplatform

        elif spoon >= 4:

            scene gsbudaplatform

        else:

            scene bobudaplatform

    else:

        "However, a few polite 'Pleases' - or, should one say, 'Kerem' - meant nobody actually collided with Alianora."

        "That said, people got a bit close for comfort."

        $ spoon -=1

        if spoon >= 12:

            scene vibudaplatform

        elif spoon >= 8:

            scene cobudaplatform

        elif spoon >= 4:

            scene gsbudaplatform

        else:

            scene bobudaplatform

    "Finally, Alianora reached the ticket station and successfully bought her metro ticket, that would cover the entire holiday."

    $ money -= 5950

    a "This will be a big help. Much less worrying about tickets will be required. I am happy!"

    $ spoon += 1

    if spoon >= 12:

        scene vibudaplatform

    elif spoon >= 8:

        scene cobudaplatform

    elif spoon >= 4:

        scene gsbudaplatform

    else:

        scene bobudaplatform

    $ metroticket = True

    $ persistent.arrivebudapesttrain = True

    jump leavestation

    label airport2:

    # This is Birmingham International Airport if Alianora missed her original flight.

    scene boairport

    $ hour = 17

    "Birmingham International Airport in the evening was far busier than in the morning."

    scene bocheckin

    "A seething tide of humanity wandered in and out of innumerable queues. The air was filled with noise."

    "The crowds made Alianora uncomfortable, but she had a plan."

    a "Here are my earplugs. I do have some ear defenders as well."

    a "They are much more powerful than earplugs, though if I need to remove them, it could be awkward for all involved."

    menu:

        "Day: [day], hour: [hour] - Wear ear defenders":

            $ defender = True

        "Just wear earplugs":

            pass

    if defender == True:

        "Alianora placed the yellow ear defenders over her ears and serenely proceeded through the airport processes."

        scene bosecurity

        "Nobody questions her and Alianora hears everything she needs to hear."

        a "Have a wonderful day, officer!"

        scene bodutyfree

        "Alianora got through duty-free uneventfully."

        scene bowaitingarea

        "She filled her water bottle and proceeded to the plane content."

        jump plane2

    else:

        "Alianora placed the little foam earplugs into her ears."

        "She sometimes put her hands over her ears when the crowd got especially noisy."

        scene bocorner

        "Between the liquid sorting area and security, Alianora had to sit in a quieter corner for a couple of minutes."

        "The security staff noted her presence but didn't intervene."

        a "Those officers worry me."

        a "Some countries are more autism-aware than others, but I have to be careful because I may not get the benefit of the doubt."

        scene bosecurity

        "Alianora stood up, placed the rucksack over her shoulders and ignored the officers as she proceeded to the security queue."

        a "Please be patient with me, officer, I have autism."

        "The security officer at the scanner didn't reply."

        "Alianora remembered to remove her lanyard, as well as the other metal items that had to go on the conveyor belt."

        jump perfume

    label perfume:

    scene bosecurity

    $ hour = 18

    "Scanning completed successfully. Alianora put her possessions back in the rucksack and… …smelt the perfume area."

    a "No…"

    "The security officer started towards Alianora."

    "Covering her nose and mouth, Alianora started towards the perfume shop at the beginning of duty-free."

    scene boperfume

    "Ten minutes later, Alianora was lost."

    a "I'm trying to see where the exit is, but all I see are scents! Please help me!"

    menu:

        "Day: [day], hour: [hour] - Ask Alianora for advice":

            jump aaa1

        "Go back":

            jump backwards

        "Go forward":

            jump forwards

        "Pause to do something else":

            a "What is the 'something else' you would like me to pause to do?"

            menu:

                "Day: [day], hour: [hour] - Wear your ear defenders":

                    jump perfumedefenders

                # "Wear a noseplug":

                #    jump noseplug

                "Look for some signs":

                    jump looksign

                "Clear your mind":

                    jump moments

    label perfumedefenders:

    $ defender = True

    scene boperfume

    "Reducing the sound level was enough for Alianora to rebalance her other senses."

    "She could still see the scents, but she could also see the rest of the area."

    "Alianora stood up straight and walked briskly to the main part of the duty-free area."

    scene bodutyfree

    "She filled her bottle, visited the bathroom and happily joined the boarding area."

    jump plane2

    label noseplug:

    scene boperfume

    if noseplug == False:

        "Alianora knelt and almost opened her rucksack before remembering…"

        a "I don't own any noseplugs! Sorry, but I will need to try something else to get past these smells."

        jump perfume

    else:

        "Alianora knelt and opened her rucksack. Inside was a small white noseplug."

        a "I am glad I thought to get - and pack - a noseplug."

        "She applied the noseplug and walked through the perfumed area. In duty-free, she filled her water bottle and bought some chocolate."

        $ money -= 100

        $ chocolate = True

        "Alianora now has the equivalent of [money] Forints."

        jump plane2

    label looksign:

    scene boperfume

    "Alianora squinted at things around her, but little pattern was detectable and her eyes rested on nothing in particular."

    a "All these smells! No signs on them at all! Ooh… …maybe…"

    "Alianora took a step forward - and walked into a display. A couple of plastic perfume bottles hit the floor."

    "Alianora picked them up and dumped them onto a nearby shelf."

    a "Ouch! That did not go well. In fact, I feel a little dizzy…"

    "Alianora sat down and clutched her head. She could only have been there for 30 seconds before a security guard arrives."

    s "This is Lima Tango Seven to Control. One person with minor head injury in Section Gamma Delta entrance…"

    "Alianora groaned. The chances of her making the plane looked very low. And if she missed this one, she would not reach Budapest…"

    # FINDOUT how to do game-end screens, as well as display achievements.

    "She fainted before entering the ambulance. Britain was not like some other places."

    "Fainting would be treated as fainting and not something more."

    "Nonetheless, Alianora would spend the evening in an unfamiliar hospital and sent home, in her Dad's car and under his care."

    "Alianora was under strict orders not to do anything strenuous for a while. No holiday for her!"

    $ persistent.toomuchsmell = True

    menu:

        "Day: [day], hour: [hour] - Advise Alianora to do something different":

            jump perfume

        "Return to the main screen, to start from the beginning":

            a "I hope your next session in the Decision-Making Committee goes better…"

            return

    label backwards:

    # This is what happens if you advise Alianora to back away from the smelly duty-free zone.

    scene bosecurity

    "Alianora turned round and walked back to the security area. It was noisy, but not smelly. Taking a deep breath, she…"

    menu:

        "Day: [day], hour: [hour] - Wore her ear defenders":

            jump perfumedefenders

        "Waited a few moments":

            jump moments

    label forwards:

    # This is what happens if you advise Alianora to walk forwards into the smelly duty-free zone.

    scene boperfume

    menu:

        "Day: [day], hour: [hour] - Look for signs while moving":

            jump looksigns

        "Stop and look for signs":

            "The smell was overwhelming. Alianora held her nose and tried her best to figure out where to go."

        "Step forwards":

            pass

    "Alianora tried to walk forward, but noticed something heavy in front of her just in time."

    "She looked left and right but could not see anything except those scents."

    "So Alianora ran backwards, coughing slightly as she left."

    jump backwards

    label moments:

    # This is what happens if you advise Alianora to give herself a few moments.

    scene bocorner

    "Alianora moved slowly to the side of the room and closed her eyes."

    "While she had no idea how to successfully meditate, Alianora knew that removing some sensory input for a few moments often helped."

    "It allowed her to rebalance her other senses. Human brains devote a lot of energy to processing vision."

    "With her eyes closed, Alianora could instead use that energy to separate out sound and smell, letting herself get used to them."

    scene boperfume

    "Once this was done, Alianora stood up, checked nobody was near her, then gradually opened her eyes and began moving."

    "Slowly, then with increasing confidence, she walked past the smells."

    scene bodutyfree

    "The main part of the duty-free area was bustling but not overwhelming."

    "Alianora bought herself a drink and some chocolate, went to the toilet and entered the boarding area."

    $ chocolate = True

    "Chocolate was a good way of avoiding talking to others. The silken smoothness made Alianora's tongue feel good."

    $ chocolate = False

    label aaa1:

    if persistent.toomuchsmell = True:

        "I remember once getting so much sensory overload from something like this that I ended up in hospital."

        "Let's get that under control before doing anything else."

        if noseplug = True:

            a "I have a noseplug in my bag. I recommend we use it."

    else:

        a "So many choices! Asking me is very sensible. Thank you for not assuming."

        a "Please either give me a few moments to sort out my senses, or let me wear my ear defenders."

        a "Yes, I know they reduce sound, but it's total sensory load that's the main issue here."

        a "If I'm overwhelmed with sensory input, it's dangerous to ask me to continue doing much."

        a "I definitely packed ear defenders because I'm very sensitive to sound, but I'm not sure if I have noseplugs."

        a "The security area certainly wasn't as bad as here, even if that's not exactly a pool of tranquility either…"

        jump perfume

    label plane2:

    # CANON PATH: This is Alianora on the indirect plane, via Istanbul.

    play music "audio/TheyRunToGlamour2550.mp3"
    queue music "audio/OverwhelmingRoseForTheSkies.mp3"

    scene boplanedoor

    $ hour = 19

    "Alianora did a little superstitious ritual on entering the plane. Afterwards, she smiled a little but nobody else noticed."

    if defender == True:

        "Alianora removed her ear defenders and put them in her rucksack as she was boarding the plane."

        "She kept the rucksack off so she could place it under the seat in front of her."

        $ defender = False

    elif noseplug == True:

        "Alianora removed her noseplug and packed it back in her rucksack as she was boarding the plane."

        "The rucksack went under the seat in front of her."

    else:

        "Alianora removed her rucksack as she was boarding the plane, so she could stow it under the seat in front of her."

    scene boplaneaisle

    "This plane was beautifully-appointed."

    "All the seats had little cloths over the top like first-class train seats."

    "There was an entertainment system built into each seat and lots of legroom."

    cr2 "Welcome onboard. Please pay attention to the safety rules you will need to follow during this flight."

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Pay attention":

            jump briefing2

        "Let Alianora listen by herself":

            jump preflight2

    label briefing2:

    scene boplaneaisle

    cr2 "Please place small items under the seat in front of you and larger items in the overhead compartments."

    "Alianora patted her rucksack, which was under the seat in front for easy access."

    cr2 "When the seat belt sign is on, please fasten your seat belt and check it fits snugly."

    cr2 "Keep it visibly that way until the seat belt sign is off."

    "This proved a little harder to test than expected, but that is why Alianora liked to check these things before they were needed."

    cr2 "You may release the belt once the sign is off."

    "Removing the belt was easy."

    cr2 "Please switch all electronics to flight mode or off."

    "Alianora's phone was possibly the only one on the plane too basic to have a flight mode."

    "It also couldn't be turned off fully, unless it was completely flat."

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Leave the phone alone":

            "Alianora elected not to do anything to her phone."

            "The only person likely to try calling/texting were her parents and phone provider, and her parents knew she'd be on a plane."

        "Turn as much of the phone off as possible":

            "She removed her phone from its case, entered Settings, chose the Call Settings and turned off her SIM card."

            "Next, she checked Bluetooth was off. Finally, she put her phone in sleep mode."

            a "There! Nothing could disturb any other passengers or the plane's safety."

    cr2 "Unplug all electronic devices during take-off and landing sequences."

    cr2 "Please stow laptops under the seat or in the overhead locker at these times."

    "Alianora's laptop was in her rucksack, would stay there during take-off and would be returned there during landing. She mimed that action."

    cr2 "If you lose a device or drop one into the seat, please ask cabin crew to assist."

    "Please do not smoke or use electronic cigarettes on this flight as you may be fined."

    cr2 "Oxygen masks will drop down if cabin pressure is lost. Place the mask over your nose and mouth, adjust the straps and breathe normally."

    "Alianora mimed the proper actions."

    cr2 "Please check your mask is adjusted before helping others."

    "Alianora mimed adjusting the mask for the imaginary person in the seat next to her."

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Mime adjusting the mask for the empty seat on Alianora's left":

            jump briefing2b

        "Mime adjusting the mask for the passenger on Alianora's right":

            jump adjustoxygen

    label adjustoxygen:

    scene boplaneaisle

    "The mask adjustment miming had to be adjusted a little, to account for the fact that the passenger next to her was busy texting someone."

    "The passenger gave Alianora a strange look."

    "He did not speak, but neither did he seem OK with being an unwitting participant in the demonstration."

    $ upsetpass = True

    $ spoon -= 1

    jump briefing2b

    label briefing2b:

    scene boplaneaisle

    cr2 "Emergency exits can be found at the front, centre and back of the aircraft. They are marked with exit signs."

    cr2 "Please locate your nearest sign now."

    "Alianora looked behind her and saw a sign marked 'Çıkış', with 'Exit' underneath."

    "That exit was the row behind her and would be easy to reach."

    cr2 "Please follow the illuminated path to the exit if there is an emergency."

    cr2 "Leave luggage, high heels and sharp objects such as pens on the plane."

    "Alianora recalled that she would in that case still be wearing her ribbon, which had some small but potentially important items on it."

    cr2 "In an emergency, there will be slides outside all exits."

    cr2 "You will find your life vest under or beside your seat."

    "Alianora checked, and hers was under her seat, on the right-hand side."

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Touch the life jacket box":

            if upsetpass = True:

                "The passenger next to Alianora snaps at her, which disturbs the air crew."

                cr2 "Please stop doing that, or you will have to leave the plane."

                a "Apologies."

                "Alianora stayed stock-still and silent for the rest of the briefing."

                $ spoon -= 2

                jump preflight2

            else:

                "Alianora touched the life jacket box, committing its location to memory."

                $ spoon += 1

        "Rely on the visual check":

            pass

    cr2 "To wear the life jacket, put it over your head, attach the straps and tighten it."

    "Alianora smiled - no knots! She mimed the motions of fastening the jacket."

    cr2 "Inflate the vest using toggles or mouthpiece after leaving the plane. The light will come on automatically when the life vest is wet."

    cr2 "Please check that your window blind is open, your tray is closed and your seat is upright before take-off and landing."

    "Alianora checked all those things, to the best of her ability given that her fellow passenger had the window seat."

    cr2 "Please stow your video screen and handset, and read the safety card before take-off."

    "Alianora had up to this point not noticed the video screen. She grinned when she saw it. This was much better than a laptop for the flight!"

    "She stowed it and removed the safety card. It is important to know what to do in an emergency, before any such event happens."

    cr2 "Follow signs and air crew instructions at all times. Enjoy your flight!"

    a "I will."

    "Alianora felt confident that she knew what she needed to know to keep safe on this flight."

    $ spoon += 1

    label preflight2:

    scene boplaneaisle

    $ airbus20 = True

    "There aircraft's gliding round Birmingham's taxiways was somewhat eerie - almost as if it was already airborne."

    "The solidity under Alianora's feet, though, was more than just the air cabin."

    "The wheels turning against the tarmac added a little burr to the sensation."

    "Jet roars raged against gravity and the pilot's prescribed patience. A poet might have said the plane yearned for the air."

    "Alianora had a packet of mints ready. She placed the first mint in her mouth, but kept the rest ready."

    "It would take several to keep ear pressures stable through take-off."

    "The plane pointed upwards, increased its angle and rose high above the city."

    "The deep pressure of gravity pushing Alianora back into her seat made her feel good."

    $ spoon += 2

    "Alianora visited the toilet once the plane had levelled off."

    $ hour = 20

    jump spoons

    label plane2b:

    scene boplaneaisle

    "After that, Alianora occupied herself by…"

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Reading the language book.":

            jump languagebook

        "Reading the motorsport magazine.":

            jump magazine

        "Listening to some music.":

            jump musicplayer

        "Watching a film.":

            jump film

    label film:

    scene boplaneaisle

    "Alianora turns on the entertainment screen and listened listening to a couple of Turkish songs."

    "Then she watched a Spanish documentary about racing drivers, followed by a Star Wars film."

    "She watched it with a Turkish voice track and Spanish subtitles."

    "Alianora knew the film by heart in English and could read Spanish enough for it to be fun - in this familiar environment."

    $ turkish = True

    $ spanish = True

    $ spoon += 3

    jump planeland2

    label planeland2:

    # Landing in Istanbul.

    scene boplaneaisle

    play music "audio/karnikgermiryanasikoldum2.mp3"
    queue music "audio/nimethanimaltintasta2.mp3"

    "Ah, this plane journey had been good."

    "The landing had been very smooth. Alianora stretched her arms and legs, rucksack secure on her back, and walked out of the plane."

    scene boplanefront

    if turkish == True:

        a "Teşekkür ederim, hoşçakal."

    else:

        a "Thank you for the safe journey and have a good day!"

    "The air crew nodded."

    scene bobaggage

    $ hour = 23

    "Alianora was glad she did not have to collect her rucksack from the baggage reclaim, for Istanbul Ataturk Airport was cavernous."

    "Even with big signs, finding things would not be easy."

    jump airside

    label airside:

    if hour >= 23:

        $ hour -= 24

        $ day = 2

    else:

        pass

    if day == 1:

        "With seven hours to the Budapest plane, what should Alianora do next?"

    elif hour == 0:

        "With six hours to the Budapest plane, what should Alianora do next?"

    elif hour == 1:

        "With five hours to the Budapest plane, what should Alianora do next?"

    elif hour == 2:

        "With four hours to the Budapest plane, what should Alianora do next?"

    elif hour == 3:

        "With three hours to the Budapest plane, what should Alianora do next?"

    elif hour == 4:

        "With two hours to the Budapest plane, what should Alianora do next?"

    else:

        scene boistanbulbench

        "It was now 5 am. Definitely time to catch the flight to Budapest!"

        a "Yippee! I've thoroughly enjoyed Istanbul, but I really, really want to see my friend and watch the race I wanted to watch."

        jump turkeyplane

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Explore Istanbul":

            jump istanbul

        "Go to the airside shopping centre":

            jump ataturkairside

        "Go to the airside hotel":

            jump ataturkhotel

        "Ask Alianora's Advice":

            jump aaa3

    label istanbul:

    # LEARNED things to do in Istanbul at night.

    scene bovisabarrier

    "Barring the way to Istanbul City Centre was a visa agent."

    va "You need a visa to pass."

    "He pointed to a sign. It would cost $20, which is 3500 Hungarian Forints."

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Buy a visa for Turkey":

            jump turkeyvisa

        "Stay airside":

            jump airside

    label exploreairside:

    # The giant Ataturk Airport shopping centre.

    if day == 1:

        scene bomezzanine

        "With seven hours to the Budapest plane, Alianora started a conversation with some local women. They discussed a variety of topics."

        if turkish == False:

            "Alianora understood little of what she heard, but picked up a few rudiments."

            a "Tesekkür ederim, hosçakal! Thank you and goodbye!"

            $ turkish == True

            $ spoon -= 2

            $ day = 2

            $ hour = 0

            jump airside

        else:

            "Alianora enjoyed swapping travel stories. It was difficult at times but also enjoyable."

            $ spoon += 1

            jump airside

    elif hour == 0:

        scene boturkeycafe

        "With six hours to the Budapest plane, Alianora ate a midnight snack of dolma courgette and baklava."

        "The courgette was crisp, with definite tart notes from the filling, and the baklava was sweet and delicate."

        $ money -= 500

        $ spoon += 2

        $ hour = 1

        "Alianora checked her purse and saw she had the equivalent of [money] Forints left."

        jump airside

    elif hour == 1:

        scene bomusicstore

        "With five hours to the Budapest plane, Alianora visited the music shop. Bigger than the music shop at home, the range was vast."

        "Eventually she selected an album by a local rock singer-songwriter. It was an exciting find!"

        $ money -= 17500

        $ spoon += 1

        $ hour = 2

        $ turkishcd = True

        "Now Alianora has the equivalent of [money] Forints."

        jump airside

    elif hour == 2:

        scene bobathroom

        "With four hours to the Budapest plane, Alianora visited the bathroom. All went well until she got to the sinks."

        "She filled her drink bottle with water, just like at the British airports she'd used. She drank some and…"

        "…alas! It was full of soap!"

        $ spoon -= 1

        $ hour = 3

        jump airside

    elif hour == 3:

        scene bomezzanine

        "With three hours to the Budapest plane, Alianora strolled round the quiet shopping centre."

        "Somehow, the centre still had almost all the shops open."

        a "Stretching muscles like this was pleasant."

        $ spoon += 1

        $ hour = 4

        jump airside

    elif hour == 4:

        scene bocorner

        "With two hours to the Budapest plane, Alianora washed her hands and feet, visited one of the faith rooms and said some prayers."

        "Sunrise brought many passengers to the faith rooms, particularly the masjids; the first of a Muslim's five prayers is taken at daybreak."

        $ spoon += 2

        $ hour = 5

        jump airside

    else:

        jump airside

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Stay in the airside hotel":

            jump ataturkhotel

        "Explore Istanbul" if hour <=3:

            jump istanbul

        "Explore":

            jump exploreairside

        "Sleep on a bench":

            jump istanbulbench

    label istanbulbench:

    scene istanbulbench

    "Sleeping on a bench is not the most secure thing to do, but it is much cheaper than the hotel."

    "Putting the precious rucksack between herself and the back of the bench, Alianora tried to get what rest she could."

    a "Maybe there'll be a nap area here one day…"

    if hour == 4:

        $ hour = 5

        $ spoon += 1

        jump airside

    else:

        if day == 1:

            $ day = 2

            $ hour = 1

        else:

            $ hour += 2

        $ spoon += 2

        $ randomnum = renpy.random.randint(1,4)

        if randomnum == 4:

            play music "audio/leylasazzevki.mp3"
            queue music "audio/karnikgermiryanasikoldum2.mp3"
            queue music "audio/nimethanimaltintasta2.mp3"

            "Alianora woke up to harsh jostling."

            a "OUCH!"

            $ spoon -= 4

            $ randomnum = renpy.random.randint(1,4)

            if (spoon + randomnum) >= 13:

                "Alianora's scream made the would-be thief run away! Some passengers turned to Alianora."

                play music "audio/karnikgermiryanasikoldum2.mp3"
                queue music "audio/nimethanimaltintasta2.mp3"

                a "Sorry for the disturbance. Someone poked me and I think there was a thief about."

                "Alianora collected her possessions and wandered back to the shopping centre."

                jump exploreairside

            elif (spoon + randomnum) >= 9:

                "Alianora's scream made the person who jostled her step back. She looked up and saw a security officer."

                play music "audio/karnikgermiryanasikoldum2.mp3"
                queue music "audio/nimethanimaltintasta2.mp3"

                o "My apologies, young lady. I noticed there was someone looking at you quite intently."

                o "Someone who had already pickpocketed two people tonight."

                o "While my fellow officers have detained the criminal, we cannot guarantee your safety if you continue to sleep here."

                o "Thieves take advantage of the sleepy. Perhaps you wish to spend the rest of the night in the hotel?"

                if hour >= 23:

                    $ hour -= 24

                    $ day = 2

                menu:

                    "Spoon count: [spoon], day: [day], hour: [hour] - Yes, please":

                        a "That is very kind of you."

                        "You go to the hotel, where the security officer has a discussion with the receptionist."

                        $ hoteldiscount = True

                        jump ataturkcost

                    "No, thank you":

                        o "Be that as it may, young lady, I recommend you at least find a different bench on which to sleep."

                        jump exploreairside

            else:

                "Alianora's scream made no difference whatsoever."

                $ randomnum = renpy.random.randint(1,4)

                if randomnum == 4, pursethefte == False:

                    "The thief stole Alianora's wallet. However…"

                    a "I've seen worse thieves. That one stole my little purse with only a modest amount of spending money."

                    a "I've still got most of my money left."

                    $ money -= 2500

                    $ pursethefte = True

                    "Alianora reported the thief, but with no expectation that this would help much."

                    $ hour += 1

                    $ spoon -= 3

                    $ reporttheft = True

                    jump exploreairside

                    play music "audio/karnikgermiryanasikoldum2.mp3"
                    queue music "audio/nimethanimaltintasta2.mp3"

                elif randomnum == 3, pursetheftm == False:

                    "The thief stole Alianora's main wallet."

                    a "Ouch! There was a lot of money in there! Now I only have 2500 Forints, to get me through the holiday…"

                    if spoon >= 10:

                        scene bovisabarrier

                        "Alianora reported it to the security officials."

                        $ reporttheft = True

                        jump exploreairside

                        $ pursetheftm = True

                        $ money = 2500

                        $ spoon -= 6

                        play music "audio/karnikgermiryanasikoldum2.mp3"
                        queue music "audio/nimethanimaltintasta2.mp3"

                        jump exploreairside

                    else:

                        "Alianora, dejected, continued with her night."

                        play music "audio/karnikgermiryanasikoldum2.mp3"
                        queue music "audio/nimethanimaltintasta2.mp3"

                        jump exploreairside

                elif randomnum == 2, mobilephone == True:

                    "What a rotten thief! Alianora's mobile phone was stolen!"

                    a "Oh no! How do I contact my parents and Szilvia now?"

                    $ mobilephone = False

                    $ spoon -= 8

                    play music "audio/karnikgermiryanasikoldum2.mp3"
                    queue music "audio/nimethanimaltintasta2.mp3"

                    jump exploreairside

                elif randomnum == 1, rucksack == True:

                    "Alianora was knocked off the bench by the thief! She screamed in pain, but to no avail."

                    "When Alianora was able to stand again… …her rucksack was gone."

                    $ rucksack = False

                    $ sleeperticket = False

                    $ chocolate = False

                    $ noseplug = False

                    $ spoon -= 12

                    a "One thing. I do have all my documents to travel, enter the hostel, claim insurance and go to the track on paper."

                    a "Plus I still have my purse and phone. My holiday is not a write-off… …yet."

                    "What will Alianora do about this crime?"

                    if spoon >= 10:

                        "Alianora took a deep breath and considered her options."

                        menu:

                            "Spoon count: [spoon], day: [day], hour: [hour] - Report the theft to the police":

                                jump reportpolice

                            "Ignore the theft and carry on":

                                jump airsideataturk

                    elif spoon >= 5:

                        "Alianora could not let this injustice stand! She stomped to the nearest security officer."

                        play music "audio/karnikgermiryanasikoldum2.mp3"
                        queue music "audio/nimethanimaltintasta2.mp3"

                        jump reportpolice

                    elif spoon >= 0:

                        "Alianora did not have the energy to make a report."

                        play music "audio/karnikgermiryanasikoldum2.mp3"
                        queue music "audio/nimethanimaltintasta2.mp3"

                        jump airsideataturk

                    else:

                        "Perhaps that is the wrong question. Despite being able to stand straight after, Alianora soon collapsed again."

                        o "Passenger down on airside, near the benches. Requesting medical assistance."

                        scene bomezzanine

                        "Some medics soon arrived and helped Alianora to a different bench, to help her recover."

                        $ spoon += 3

                        if spoon >= 2:

                            "This was enough for Alianora to be able to speak in her accustomed manner, stand and walk again."

                            "She told the security officer what she could about the incident and then left."

                            $ reporttheft = True

                            if turkish == True:

                                a "Tesekkür ederim, hosçakal. Thank you and goodbye."

                            else:

                                a "Thank you and goodbye."

                        else:

                            $ hour += 1

                            "After an hour, Alianora still had not recovered. The medics took her to the airport medical centre."

                            scene medbay

                            $ spoon += 3

                            if hour >= 5:

                                "As the hour approached to leave Istanbul, the medics talked amongst themselves."

                                if spoon >= 2:

                                    "They agreed Alianora was ready to travel. There was, however, no time to lodge a report."

                                    if turkish == True:

                                        a "Tesekkür ederim, hosçakal. Thank you and goodbye."

                                    else:

                                        a "Thank you and goodbye."

                                        play music "audio/karnikgermiryanasikoldum2.mp3"
                                        queue music "audio/nimethanimaltintasta2.mp3"

                                        jump turkeyplane

                                elif spoon >= 0:

                                    "Alianora could not walk, but could get around in an airport wheelchair. So they used that instead."

                                    scene boplaneaisle

                                    "The flight was spent recovering the energy Alianora had lost in the theft incident."

                                    $ hour = 8

                                    $ spoon += 6

                                    play music "audio/karnikgermiryanasikoldum2.mp3"
                                    queue music "audio/nimethanimaltintasta2.mp3"

                                    jump ferencairport

                                else:

                                    "There was no question of Alianora catching the scheduled flight. She was too ill to move right now."

                                    "However, all was not lost. The airline had a 'flat tyre policy' for missed flights beyond anyone's control."

                                    "With many witnesses to Alianora having good reason to miss her flight, she was rescheduled to lunchtime, free."

                                    a "Phew! Most international airlines don't have a 'flat tyre policy'. That could have been really expensive."

                                    a "Happily, I now have plenty of time to recover!"

                                    "Also plenty of time to lodge a report of the crime."

                                    $ reportcrime = True

                                    $ hour = 12

                                    $ spoon += 12

                                    play music "audio/karnikgermiryanasikoldum2.mp3"
                                    queue music "audio/nimethanimaltintasta2.mp3"

                                    jump turkeyplane

                            else:

                                if spoon >= 2:

                                    "Alianora stood up, thanked the medical staff, and carried on with her evening."

                                    if reporttheft == False:

                                        "First of all, she went to the nearest security officer and reported the wicked crime."

                                        play music "audio/karnikgermiryanasikoldum2.mp3"
                                        queue music "audio/nimethanimaltintasta2.mp3"

                                        jump reportcrime

                                    else:

                                        play music "audio/karnikgermiryanasikoldum2.mp3"
                                        queue music "audio/nimethanimaltintasta2.mp3"

                                    jump airsideataturk

                                elif spoon >= 0:

                                    "Alianora nodded to the medical team and walked away."

                                    "She heard muttering behind her that perhaps she could not speak Turkish. Right then, it was true."

                                    "She couldn't speak at all."

                                    "Before deciding her next move, she spent a while in a quiet corner of the airport with her eyes closed."

                                    play music "audio/karnikgermiryanasikoldum2.mp3"
                                    queue music "audio/nimethanimaltintasta2.mp3"

                                    jump airsideataturk

                                else:

                                    "The medical team told Alianora to stay put until her plane was ready."

                                    $ spoon += ((5 - [hour]) * 2)

                                    $ hour = 5

                                    if spoon >= 2:

                                        "While waiting, Alianora was encouraged to provide a crime report - something she did gladly."

                                        $ reportcrime = True

                                        play music "audio/karnikgermiryanasikoldum2.mp3"
                                        queue music "audio/nimethanimaltintasta2.mp3"

                                    else:

                                        "Alianora was at no point capable of reporting the crime."

                                        "The medical staff were, however, able to guide her onto the plane."

                                        play music "audio/karnikgermiryanasikoldum2.mp3"
                                        queue music "audio/nimethanimaltintasta2.mp3"

                                    jump turkeyplane

                else:

                    "The thief suddenly stopped and ran away."

                    a "That was lucky; I've had enough bother for one day already. Still, I'll report this."

                    play music "audio/karnikgermiryanasikoldum2.mp3"
                    queue music "audio/nimethanimaltintasta2.mp3"

                    jump reportcrime

        else:

            "The nap was peaceful, but Alianora eventually woke up because she could not roll on the bench."

            jump ataturkairport

    label reportpolice:

    scene bovisabarrier

    "Thinking of getting justice gave Alianora some energy."

    $ spoon += 1

    "The security officer nearest Alianora was at the visa checkout."

    o "How may I help you?"

    a "Someone stole from me while I slept."

    if spoon >= 12:

        "The security officer listened attentively while Alianora furnished a description."

        o "I will look into this immediately. It is unlikely you will regain what you lost, but I will give you a report number."

        $ reportcrime = True

    elif spoon >= 6, turkish == True:

        o "Bu örgüt hırsızları tutuklamayı çok ciddiye alıyor, genç bayan…."

        a "Correct me if I'm wrong, but you are saying that you take arresting thieves very seriously?"

        o "Evet, genç bayan. Yes, young lady."

        a "…Tesekkür ederim for investigating this. Thank you."

        o "While I cannot promise a result, we will do our best."

        $ reportcrime = True

    elif spoon >= 9:

        "Alianora tried her best to tell the official what happened."

        o "Unfortunately, we can give no guarantees. Thieves often look exactly like everyone else. Sorry to be a disappointment."

        o "Still, here is a crime report number so you can claim your losses from your insurer when you get home."

        a "That's a shame, but thank you for trying."

        "Alianora left."

        a "Most thefts never get recovered. I shall do my best to cope without it."

        $ spoon -= 1

        jump airsideataturk

    else:

        o "My apologies, but you have an inpenetrable Scottish accent."

        a "But I've never been to Scotland, I'm from Derbyshire."

        o "Nonetheless, I do not understand a word of what you say. Goodbye."

        a "But-"

        "It was no use. The security officer simply wouldn't take the report."

        $ spoon -= 3

        jump airsideataturk

    label turkeyvisa:

    if day == 1 or hour == 0:

        scene bovisabarrier

        if turkish == True:

            a "Teşekkür ederim."

            "Alianora paid, stepped through security, and breathed in the air of a a city that crossed continents."

            scene bofield

            $ money -= 3500

            $ turkeyvisa = True

            "Of course, Istanbul is 20 miles from the airport…"

            menu:

                "Spoon count: [spoon], day: [day], hour: [hour] - Walk around the area.":

                    "Alianora spent a while walking around the area, then sat staring at the stars. They were beautiful."

                    scene bosecurity

                    "Then it was time to go to security. It took a little of the shine off, but she'd allowed plenty of time."

                    $ spoon += 2

                    $ hour += 2

                    jump airside

                "Get a bus into the city.":

                    scene bobus

                    "The bus was bumpy and very, very quiet."

                    "Nearly everything in Istanbul was closed by this point, though some nightclubs were still open."

                    $ hour += 1

                    menu:

                        "Spoon count: [spoon], day: [day], hour: [hour] - Visit a nightclub":

                            jump turkeyclub

                        "Walk around the area":

                            jump walkistanbul

        elif hour <= 3:

            scene bovisabarrier

            "Alianora paid as requested and received a document certifying that she was permitted to be in Turkey."

            $ money -= 3500

            $ turkeyvisa = True

            scene bobus

            "The bus to Istanbul was completely empty, and a bit eerie for no reason Alianora could place."

            $ hour += 1

            jump walkistanbul

        else:

            scene bovisabarrier

            va "You could buy a visa, but I recommend you return an hour before your flight. You'll have to go through security again."

            if turkish = False:

                a "Thank you. I don't think that will work for me. You are right."

            else:

                a "Teşekkür ederim. Hayır. Thank you. No. You are right."

                "Alianora backed away from the visa area and instead ventured to Istanbul Ataturk Airport's airside shopping area."

                jump exploreairside

    label walkistanbul:

    scene bohagiasophia

    "Alianora took a bus and looked out at the bright lights of Istanbul."

    "She spent a while drinking in the ambience, considering the architecture of the city, including the historic Hagia Sophia."

    "She returned on another empty bus, went through security and felt more educated as a result."

    $ hour += 2

    $ spoon += 5

    jump airside

    label turkeyclub:

    scene bojeromepay

    "The club was noisy. How should Alianora protect herself?"

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Wear ear defenders.":

            jump turkeyclubdefenders

        "Wear earplugs.":

            jump turkeyclubearplugs

        "Wear a noseplug." if noseplug == True:

            jump turkeyclubnoseplug

        "Stay out of the club.":

            jump turkeynoclub

    label turkeyclubdefenders:

    # CONTINUE fixing the hole in the Turkish club.

    scene bojeromepay

    if spoon >= 6:

        "Alianora put her yellow ear defenders on her ears, left her rucksack with the bouncer and strode onto the dance floor."

        "She had a great time, the music was wonderful, although a number of people stared at her."

        "Granted, a woman dancing in yellow ear defenders and a bright red office jumper is a rare sight in Istanbul…"

        a "I'm saying nothing right now. Just keep dancing!"

        $ hour += 2

        $ spoon += 2

        "Afterwards, Alianora returned to Ataturk airport, silently moving to the remembered beat."

        jump airside

    else:

        "Alianora was able to get onto the dance floor and had fun. That is, until the bouncer showed up."

        $ hour += 1

        if turkish == True:

            "It wasn't entirely clear what the bouncer wanted, but it wasn't good."

        else:

            "There was lots of jabbing and waving, but Alianora had no idea what this bouncer wanted."

            $ spoon -= 2

        "The bouncer got closer and closer…"

        menu:

            "Say 'please' - or rather, 'lütfen'." if turkish == True:

                a "Lütfen tell me what you want."

                $ randomnum = renpy.random.randint(1,4)

                if randomnum == 4:

                    "The club bouncer removed Alianora's ear defenders."

                    cb "Listen-"

                    "Alianora snatched the ear defenders back and left the dance floor screaming!"

                    "The bouncer gave chase but could not catch Alianora."

                    "Still, all Alianora could think on the empty bus back was how shaken she felt."

                    $ spoon -= 4

                    jump airside

                else:

                    cb "Evet. Lütfen remove your headphones."

                    a "Hayır. No, I need them because of my autism."

                    "Alianora produced her autism card. The bouncer looked at it for several moments, then nodded."

                    cb "Evet. Yes, I understand. Sorry for interrupting."

                    "Alianora danced for a while, though she was somewhat perplexed by the encounter."

                    "When she was leaving the club, the bouncer stopped her."

                    cb "I see the card is from the National Autistic… …Society?"

                    a "Evet. Yes."

                    cb "I will look it up on the computer tomorrow. Tesekkür ederim, thank you."

                    $ hour += 1

                    $ spoon += 1

                    jump airside

            "Guess what the bouncer wants.":

                $ randomnum = renpy.random.randint(1,4)

                if randomnum == 4:

                    "Alianora clutched her ear defenders to her head and shook it."

                    if turkish == True:

                        a "Hayır. No, I need them because of my autism."

                        "When Alianora showed the bouncer her autism card, there was a pause."

                        "The bouncer nodded."

                        cb "Evet. Yes, I understand. Sorry for interrupting."

                        "Alianora danced for a while, though she was somewhat perplexed by the encounter."

                        "When she was leaving the club, the bouncer stopped her."

                        cb "I see the card is from the National Autistic… …Society?"

                        a "Evet. Yes."

                        cb "I will look it up on the computer tomorrow. Tesekkür ederim, thank you."

                        $ hour += 1

                        $ spoon += 1

                        jump airside

                    else:

                        "The bouncer did not take the hint, and removed Alianora's headphones."

                        "As anyone who had known Alianora for more than 10 minutes could confirm, this was a Very Bad Idea."

                        "Alianora took her ear defenders back, growled at the bouncer and left for the airport."

                        a "What rubbish service!"

                        $ spoon -= 4

                        jump airside

                elif randomnum == 3:

                    "Alianora removed her knitted red office jumper."

                    "The crumpled blue shirt underneath was still modest - but the bouncer threw Alianora out of the club anyway."

                    a "Ouch! That was painful!"

                    $ spoon -= 5

                    jump airside

                elif randomnum == 2:

                    "Alianora took off her ear defenders - and winced as the very loud music seeped in."

                    cb "If you don't like it, leave. You are disturbing the other dancers."

                    "Alianora did as bidden, but wasn't happy about it."

                    $ spoon -= 1

                    jump airside

                else:

                    "Alianora looked at her boots and decided they weren't appropriate for dancing."

                    "However, removing them in the club would be even more offensive here than usual, since she'd probably wave a heel at someone."

                    "Since Turkish people find having feet pointed at them offensive, she left the club."

                    a "Come to think of it, my only other option would be to dance in socks. The situation would not improve."

                    "Alianora went back to the airport."

                    jump airside

            "Flee the scene.":

                "In much distress, Alianora ran away. Her half-marathons served her well. That was, however, stressful!"

                "Alianora, unsurprisingly, retreated to the airport as fast as the bus would take her."

                $ spoon -= 3

                jump airside

    label turkeyclubearplugs:

    scene bojeromepay

    if spoon >= 12:

        "Alianora inserted her earplugs and walked onto the dance floor."

        "While she certainly wasn't going to become the hottest new dancing sensation of Istanbul, she certainly enjoyed the music."

        $ spoon += 3

        $ hour += 2

        jump airside

    else:

        "Alianora attempted to go to the dance floor in earplugs, but the music was too loud."

        "She turned round, had a short walk round the neighbourhood to regain her sense of peace and went back to the airport."

        a "At least I had a go."

        jump airside

    label turkeyclubnoseplug:

    scene bojeromepay

    if spoon >= 18:

        "Rocking the dance floor in a noseplug? Few people would try it, but few people are Alianora."

        a "Yes, it's loud in here, but blocking out the scent of sweaty dancers and the drinks in here is just enough to allow me to stay."

        "That said, the music lacks enough definition to be particularly fun. The real highlight is the ayran at the bar."

        $ spoon += 1

        $ hour += 2

        jump airside

    else:

        "Alianora attempted to go to the dance floor in earplugs, but the music was too loud."

        "She turned round, had a short walk round the neighbourhood to regain her sense of peace and went back to the airport."

        a "Maybe next time I'll try items that block sound when going somewhere noisy. Still, the walk was OK."

        jump airside

    label turkeynoclub:

    jump walkistanbul

    label ataturkhotel:

    scene bohotel

    if hour >= 23:

        $ hour -= 24

        $ day = 2

    "Ataturk Hotel's decor contrasted itself a lot. Neutral walls framing wooden floors with visible graining."

    "Plain white ceilings with coloured flourescent lights. A centrepiece flooding reception in neon light."

    hr "We pride ourselves in the highest quality of rest and service."

    if day == 1:

        $ change = 20600

    elif hoteldiscount == True:

        $ change = (5 - hour) * 1000

    else:

        $ change = (5 - hour) * 3600

    hr "The discerning business traveller will find our rate of [change] quite reasonable."

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Accept the cost":

            jump ataturkcost

        "Do something else":

            jump airside

    label ataturkcost:

    "Alianora gets into her nice, cosy bed and gets some much-needed rest."

    if hoteldiscount == True:

        $ money -= 1000 * (5 - hour)

        $ spoon += ((5 - hour) * 2)

        $ hour = 5

    elif day == 1:

        $ money -= 20600

        $ day = 2

        $ hour = 5

        $ spoon += 12

    else:

        $ spoon += ((5 - hour) * 2)

        $ money -= ((5 - hour) * 3600)

        $ hour = 5

        # LEARNED how to divide the difference between a variable and a fixed number (3450 per hour) in a way Ren'Py recognises.

        # LEARNED how to divide a fixed number by the result of the previous calculation.

        "Aah - luxury!"

        jump turkeyplane

    label aaa3:

    if day == 1:

        $ change = money - 20600

    else:

        $ change = money - (3600 * (5 - hour))

    if day == 1:

        a "Money is starting to be an issue here."

        a "Yes, the hotel here is likely excellent, but if I spend all night there, I will have only [change] Forints left."

        a "That might not even enough for a week-long Budapest metro ticket."

        a "I should consider spending at least part of the night sleeping on an airport bench instead, if I am going to sleep."

    else:

        a "The airport hotel is priced for wealthy travellers, by the hour."

        a "While expensive, I will be able to adapt my spending for the rest of the holiday, should I opt to stay here."

        a "Sleeping on an airport bench on airside seems quite common here, but is a bit more dangerous."

    if spoon <= 10:

        a "On the other hand, I am running low on ability to process the world around me. Sleeping will be necessary."

        "The hotel charges by the hour, so we could do something else first and then check in. Or sleep on a bench."

    else:

        a "In the past, I have skipped entire nights of sleep to live-comment the 24 Hours of Le Mans. The next day could get …difficult."

        a "If something stressful happens, I may 'snap'. However, I would be able to get to the hostel without drama if I take care."

    a "I told Dad I was going to enjoy being in Turkey, so I should do something that involves exploring at some point."

    if day == 1:

        a "I am not sure how much of Istanbul is open at this time of night, but it would be quite the story to tell either way!"

    else:

        a "There's an airside shopping centre, which has 24-hour opening. It's massive!"

        a "That would also be a good place to explore and I don't need a visa to enter."

    if hour = 5:

        "All of this is moot, of course, because it is time for me to catch my plane."

        jump turkeyplane

    else:

        pass

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Explore Istanbul":

            jump istanbul

        "Go to the airside shopping centre":

            jump exploreairside

        "Go to the airside hotel":

            jump ataturkhotel

    label turkeyplane:

    scene bobathroom

    "Alianora washed her hands in the bathroom before appearing at the departure lounge."

    scene bowaitingarea

    "In contrast to Birmingham airport, here everything made sense. It didn't matter that Alianora's Turkish was limited."

    "It helped that there was no security line, because Alianora was already airside."

    if reportcrime == True:

        o "Alianora!"

        a "What happened?"

        $ randomnum = renpy.random.randint(1,4)

        if randomnum == 4:

            if pursethefte == True:

                "The thief was caught before having the chance to spend any money. Here is your purse - and a reward."

                $ money += 15000

            if pursetheftm == True:

                o "Thanks to your information, we caught the thief. Here is your purse."

                o "It appears the thief spent most of the money, but we have put your reward in the purse. Please claim the rest on your insurance."

                $ money += 22500

                "The security officer hands Alianora a crime report number, and Alianora leaves."

                a "If I make the claim, I will not get the money refunded until I return home. Insurance takes time."

            else:

                o "Thank you for your information. It was very useful."

                if mobilephone = False:

                    o "We tracked your phone, which led us to the thief. The thief has been arrested."

                    o "Here is your phone, and a reward for aiding the arrest."

                    $ mobilephone = True

                if rucksack = False:

                    o "Your rucksack was big and bright enough that the security officials were easily able to spot it."

                    o "The thief tried dumping it and running, but was arrested. Here is your rucksack - and a reward."

                    $ rucksack = True

                    $ sleeperticket = True

                    $ chocolate = True

                    $ noseplug = True

                else:

                    o "Your clear description of the theif allowed us to arrest the crook. Here is a reward. Thank you very much."

                    a "Thank you very much! Have a wonderful day."

                $ money += 12500

        elif randomnum == 3, mobilephone == False:

            o "Your mobile phone was found when we arrested the thief."

            o "It seems there was no time to trade or damage it, but beware of data theft."

            a "I'd be impressed if the thief managed any data theft, beyond my contact list."

            a "It's a feature phone. Its biggest feature is that it is purple. No internet access, no apps."

            $ mobilephone = True

            "Alianora thanked the security officer and left."

            a "It is good practise to use the IMEI to get a SIM cancelled when this happens, but I didn't manage to do that."

            a "Which means my phone still works! I'll text home and let them know what happened…"

            $ home += 1

        elif randomnum <= 2, rucksack == False:

            o "Your rucksack was big and bright enough that the security officials were easily able to spot it."

            o "The thief tried dumping it and running, but was arrested. Here is your rucksack and a reward."

            $ rucksack = True

            $ sleeperticket = True

            $ chocolate = True

            $ noseplug = True

            $ money += 12500

        else:

            o "We caught the thief but they did not have your possessions on them at the time. Still, the thief was wanted for many thefts."

            o "Thanks to you, we finally arrested the thief. So here is a reward for your information."

            $ money += 12500

    else:

        pass

    scene boplaneaisle

    $ magazine = False

    "Everything was smooth - even take-off."

    "Once the plane levelled out, the air crew arrived, pushing a trolley full of breakfasts."

    cr2 "Enjoy your meal!"

    if spoon >= 10:

        a "I recognise you. Were you on my last flight, by any chance?"

        cr2 "Yes, I was."

        "The air crew smiled."

        "She'd probably been smiling before, but Alianora would not have known because her cheeks had not been smiling - perhaps only her mouth."

        "Alianora knew what people were feeling by facial muscle movements, not eye contact… …and lips often lie."

        $ spoon += 1

    else:

        pass

    "The plate included a white oval bowl containing a cheese salad, with a crisp baguette, cherry jam and maderia cake."

    $ spoon += 2

    $ hour += 1

    "What shall Alianora do while eating her breakfast?"

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Listen to music":

            jump planemusic

        "Watch a film":

            jump watchfilm

    label planemusic:

    scene boplaneaisle

    "Alianora did not bother getting out her music player, because this plane had a music selection built into the entertainment system."

    "Instead, she plugged in some special headphones that came with her meal and discovered some Turkish pop music."

    $ spoon += 2

    $ hour += 1

    "After Alianora had finished eating, she had some time and attention left to do something else. What would that be?"

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Read the magazine":

            jump magazineturkey

        "Read the language book":

            jump languageturkey

        "Rest":

            jump rest

    jump ferencairport

    label magazineturkey:

    scene boplaneaisle

    # Alianora reads her magazine.

    "The magazine felt fresh, simply due to a good night's sleep."

    $ raceknow += 1

    $ spoon += 1

    $ hour += 1

    if raceknow >= 3:

        "Alianora did not know exactly what was wrong with her favourite team, but something was definitely amiss. Too many rumours!"

    elif raceknow >= 2:

        "Something was going on that Alianora needed to look into, but it was not clear what."

    else:

        pass

    label languageturkey:

    scene boplaneaisle

    if hungarian == True:

        a "I already know as much Hungarian as I think I will pick up just from this book."

        a "However, I enjoy reading about languages, so I'll enjoy flicking through the 15 language sections."

        $ spoon += 1

        $ hour += 1

        jump ferencairport

    elif spoon <= 7:

        a "Sorry, I don't have the energy to do that right now, and I've got a full day ahead. I'm going to listen to music and rest instead."

        "That's exactly what she did."

        $ spoon += 1

        $ hour += 1

        jump ferencairport

    elif spoon <= 13:

        "Alianora got her language book out and started studying. She had some difficulty focusing."

        "However, she still managed to learn 'kerem', the Hungarian for 'please'."

        if kerem == True:

            "With some effort, she was also able to learn a few other basic words in Hungarian."

            a "Hello - 'szia'. Goodbye - that is 'szia' as well. Please - 'kérem'. That's a lovely word."

            a "Thank you - 'köszönöm', and I look younger than I am, so definitely avoid the shorter one. Yes - 'igen'. No - 'nem'. Got it!"

            $ hungarian = True

        $ kerem = True

        $ spoon -= 1

        $ hour += 1

        jump ferencairport

    elif spoon <= 19:

        "Alianora smiled as she picked up the book."

        a "It's a brand new day today, and I'm sure I can figure out some helpful words this morning. Every day's a school day!"

        "Some time later…"

        a "Indeed it is! Hello - 'szia'. Goodbye - that is 'szia' as well. Please - 'kérem'. That's a lovely word."

        a "Thank you - 'köszönöm', and I look younger than I am, so definitely avoid the shorter one. Yes - 'igen'. No - 'nem'. I feel awesome!"

        $ hungarian = True

        $ spoon -= 1

        $ hour += 1

        jump ferencairport

    else:

        "As Alianora opened her language book, her whole face brightened."

        a "This is going to be fun!"

        $ spoon = 20

        $ hungarian = True

        $ hour += 1

        jump ferencairport

    label watchfilm:

    scene boplaneaisle

    "Alianora looked for a film. After some deliberation, she selected a translation of a popular animation."

    "This animation entertained her for the rest of the flight."

    $ spoon += 3

    jump ferencairport

    label ferencairport:

    $ hour += 2

    scene bobaggage

    "Alianora quickly strode through security, needing to stretch her legs."

    "She could either have a stroll in the observation tower, which would cost 500 Hungarian Forints and allow her to watch planes…"

    "…or she can explore Budapest."

    menu:

        "Spoon count: [spoon], day: [day], hour: [hour] - Go to the observation tower":

            jump observation

        "Explore Budapest":

            $ persistent.arrivebudapestplane = True

            jump leavestation

    label observation:

    # CONTINUE Alianora visits the observation tower to have a stroll and watch the planes.

    scene boplanewatch

    "For 500 Forints, Alianora could spend as long as she liked on the airport roof, watching the planes, walking about and eating ice cream."

    $ money -= 500

    "Mostly, the skies were graced by passenger planes of every hue, flying to every corner of Europe."

    "Hungary really was at the centre of the continent."

    $ spoon += 3

    $ hour += 2

    $ persistent.arrivebudapestplane = True

    label leavestation:

    scene viairport

    play music "audio/DvorakHumoresqueA.mp3"
    queue music "audio/lisztC2M2.mp3"
    queue music "audio/lisztC2M3.mp3"
    queue music "audio/lisztC24M.mp3"

    "Dvorak's Humoresque 1 plays in the background as Alianora steps outside… …and a gratitude message appears."

    a "Thank you for joining me for the Spring Thing 2021 Special Edition of Budacanta."

    a "How will my stay in Budapest be? Where will I go? Will I see my friend Szilvia, and how much do I need to learn about myself before I do?"

    $ persistent.arrivebudapest = True

    a "Before I find out any of that, please save the game on this screen."

    a "When you obtain the full story, you'll be able to use this save to pick up the story from here."

    a "I'd appreciate it if you please give me feedback about how I've told the story so far."

    a "My Twitter account is @lacanta and my Tumblr account is @alianoralacanta. I also participate on multiple forums and Discord channels."

    a "The telling is in progress and what you tell me will help me tell further stories better."

    a "Also, please go to springthing.net and explore the many wonderful games in this festival."

    a "All the authors put a lot of effort into their interactive fiction and like it when other players enjoy their creations."

    # This ends the game.

    return
